/*
 * Decompiled with CFR 0.152.
 */
package impChess;

import impChess.Offset;
import impChess.character;
import impChess.gameSquare;
import impChess.impChess;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class gameBoard {
    private int boardSize;
    private int squareSize;
    private gameSquare[][] board;
    private Color squareColor;
    private impChess game;
    private float fLeft;
    private float fTop;
    private float fWidth;
    private float fHeight;

    public gameBoard() {
    }

    public gameBoard(int n, impChess impChess2) {
        this.boardSize = n;
        this.game = impChess2;
        this.board = new gameSquare[n][n];
        float f = 100.0f;
        for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                this.board[i][j] = new gameSquare(i, j, this.game.getBoardColor((i + j) % 2 + 1), 0.0f, this);
            }
        }
    }

    public void placeCharacter(int n, int n2, character character2) {
        this.board[n - 1][n2 - 1].setCharacter(character2);
    }

    public int getBoardSize() {
        return this.boardSize;
    }

    public void setSquareSize(int n) {
        this.squareSize = n;
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public String getOrientation() {
        return this.game.getOrientation();
    }

    public void flipOrientation() {
        this.game.flipOrientation();
    }

    public int getLeft() {
        return (int)this.fLeft;
    }

    public int getTop() {
        return (int)this.fTop;
    }

    public int getWidth() {
        return (int)this.fWidth;
    }

    public int getHeight() {
        return (int)this.fHeight;
    }

    public boolean isSquare(int n, int n2) {
        return n > 0 && n <= this.boardSize && n2 > 0 && n2 <= this.boardSize;
    }

    public boolean isOccupied(int n, int n2) {
        return this.board[n][n2].isOccupied();
    }

    public gameSquare squareAt(gameSquare gameSquare2, Offset offset) {
        gameSquare gameSquare3 = null;
        int n = gameSquare2.getRow();
        int n2 = gameSquare2.getCol();
        int n3 = offset.getColOffset();
        int n4 = offset.getRowOffset();
        int n5 = n + n4;
        int n6 = n2 + n3;
        if (n5 >= 0 && n5 < this.boardSize && n6 >= 0 && n6 < this.boardSize) {
            gameSquare3 = this.board[n5][n6];
        }
        return gameSquare3;
    }

    public gameSquare getSquare(int n, int n2) {
        gameSquare gameSquare2 = null;
        if (n > 0 && n <= this.boardSize && n2 > 0 && n2 <= this.boardSize) {
            gameSquare2 = this.board[n - 1][n2 - 1];
        }
        return gameSquare2;
    }

    public boolean locatedIn(Dimension dimension) {
        boolean bl = false;
        int n = dimension.width;
        int n2 = dimension.height;
        if ((float)n >= this.fLeft && (float)n < this.fLeft + this.fWidth && (float)n2 >= this.fTop && (float)n2 < this.fTop + this.fHeight) {
            bl = true;
        }
        return bl;
    }

    public gameSquare inGameSquare(Dimension dimension) {
        gameSquare gameSquare2 = null;
        for (int i = 0; i < this.getBoardSize(); ++i) {
            for (int j = 0; j < this.getBoardSize(); ++j) {
                if (!this.board[i][j].locatedIn(dimension)) continue;
                gameSquare2 = this.board[i][j];
            }
        }
        return gameSquare2;
    }

    public int getConstraint() {
        int n = this.getWidth();
        if (n > this.getHeight()) {
            n = this.getHeight();
        }
        return n;
    }

    public int getRowLoc(int n, String string) {
        int n2 = 0;
        int n3 = this.getConstraint() / this.getBoardSize();
        int n4 = (this.getHeight() - this.getBoardSize() * n3) / 2;
        n2 = string == "Gold" ? (this.getBoardSize() + 1 - n) * n3 : (n - 1) * n3;
        return n2 + this.getTop() + n4;
    }

    public int getColLoc(int n, String string) {
        int n2 = 0;
        int n3 = this.getConstraint() / this.getBoardSize();
        int n4 = (this.getWidth() - this.getBoardSize() * n3) / 2;
        n2 = string == "Gold" ? (this.getBoardSize() + 1 - n) * n3 : (n - 1) * n3;
        return n2 + this.getLeft() + n4;
    }

    public Dimension getLocation(int n, int n2, String string) {
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = new Dimension();
        int n5 = this.getConstraint() / this.getBoardSize();
        int n6 = (this.getWidth() - this.getBoardSize() * n5) / 2;
        int n7 = (this.getHeight() - this.getBoardSize() * n5) / 2;
        if (string == "Gold") {
            n3 = (this.getBoardSize() - n) * n5;
            n4 = (n2 - 1) * n5;
        } else {
            n3 = (n - 1) * n5;
            n4 = (this.getBoardSize() - n2) * n5;
        }
        dimension.setSize(n4 + this.getLeft() + n6, n3 + this.getTop() + n7);
        return dimension;
    }

    private void calculateSquareSize() {
        int n = 502;
        this.squareSize = n / this.getBoardSize() - 2;
    }

    private void calculateBoard() {
        float f = 0.0f;
        this.fLeft = this.game.getAdjustedLeft();
        this.fTop = this.game.getAdjustedTop();
        this.fWidth = (float)this.game.getAdjustedRight() - (float)this.game.getAdjustedLeft();
        this.fHeight = (float)this.game.getAdjustedBottom() - (float)this.game.getAdjustedTop();
        f = this.fWidth;
        if (this.fHeight < this.fWidth) {
            f = this.fHeight;
        }
        this.squareSize = (int)f / this.boardSize;
    }

    public void highlight(gameSquare[] gameSquareArray, Color color) {
        for (int i = 0; i < gameSquareArray.length; ++i) {
            gameSquareArray[i].changeColor(color);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.calculateBoard();
        for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                this.board[i][j].paint(graphics2D);
            }
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.game.getAdjustedLeft(), this.game.getAdjustedTop(), (float)this.game.getAdjustedRight() - (float)this.game.getAdjustedLeft(), (float)this.game.getAdjustedBottom() - (float)this.game.getAdjustedTop());
        graphics2D.setColor(Color.lightGray);
        graphics2D.draw(float_);
    }
}

