/*
Authors: David Nishimoto 
Website: http://www.listensoftware.com
Program: BreakOut
Email: davepamn@relia.net
*/

#include "stdafx.h"
#include "MainFrm.h"
#include "3DFont.h"

#include "3DFontDoc.h"
#include "3DFontView.h"
#include "help.h"

#include <time.h>
#include <math.h>
#include <MMSYSTEM.H>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BOOL gameOver=FALSE;
BOOL pause=FALSE;
#define PI 3.142
#define TRUE 1
#define FALSE 0
#define glRGB(x, y, z)	glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)
#define GRID_SIZE 300
#define dRadToDeg(x) (((float)x)*57.29577951308f)
#define EXPLOSION_SIZE 50
#define NUMBER_OF_MISSILES 50
#define EMPTY_TYPE 0
#define MUSHROOM_TYPE 1
#define OBJECT_LIST_SIZE 40
#define MINE_LIST_SIZE 20
#define RIGHT_DIRECTION 1
#define LEFT_DIRECTION 2
#define FORWARD_DIRECTION 3
#define LEFT 1
#define RIGHT 2
#define CENTER 3
#define TORUS_TYPE 1
#define SPHERE_TYPE 2


typedef struct Engine{
	GLfloat x,y,z;
	GLfloat m_displacement;
	long m_time_out;
	GLint angle;
	GLfloat m_radians;
	long m_cpu_clicks;
	clock_t m_movement_interval;
	long m_hit;
	BOOL m_sleep;
	GLint mTurretAngle;
	BOOL mActiveFlag;
}Engine;

Engine EnemyEngine[1];


typedef struct OBJECT_STRUCT{
	GLint m_id;
	GLfloat m_x;
	GLfloat m_y;
	GLfloat m_z;
	GLfloat m_t;
	GLfloat m_Vox;
	GLfloat m_Voy;
	GLfloat m_Vo;
	GLfloat m_Xo;
	GLfloat m_Yo;
	GLint m_value;
	GLint m_hit;
	GLint m_direction;
	GLfloat m_radians;
	BOOL m_available_flag;
	//BOOL m_active_flag;
} OBJECT_STRUCT_TYPE;

OBJECT_STRUCT_TYPE enemyMissile[NUMBER_OF_MISSILES];
OBJECT_STRUCT_TYPE breakOutMissile[NUMBER_OF_MISSILES];
OBJECT_STRUCT_TYPE objMushRoomList[OBJECT_LIST_SIZE];
OBJECT_STRUCT_TYPE objMineList[MINE_LIST_SIZE];

typedef struct BreakOut{
	GLfloat M_TORSO_ANGLE;
	GLfloat M_ARM_ANGLE;
	GLfloat m_radians;
	GLfloat m_xPos;
	GLfloat m_yPos;
	GLfloat m_zPos;
	GLfloat m_velocity;
	long m_score;
	GLint m_shield;
	GLint m_hit;
	int m_swing;
}BreakOut;

BreakOut objBreakOut;
long m_subtotal_score;
int mLevel;


typedef double MATRIX4X4 [4][4];
typedef double MATRIX4X1 [4][1];
typedef double MATRIX1X4 [1][4];

typedef struct VECTOR_STRUCT
{
	GLfloat m_x;
	GLfloat m_y;
	GLfloat m_z;
} VECTOR_STRUCT_TYPE;

typedef struct explosion{
	GLfloat x;
	GLfloat y;
	GLfloat z;
	GLfloat scale_x;
	GLfloat scale_y;
	GLfloat scale_z;
	long m_cpu_seconds;
	long m_shield;
	BOOL m_available_flag;
	//BOOL m_active_flag;
	GLint type;
}EXPLOSION_TYPE;

EXPLOSION_TYPE objExplosion[EXPLOSION_SIZE];

int vMap[10][10];
int mLives=3;

typedef struct position{
	GLfloat x;
	GLfloat y;
	GLfloat z;
}POSITION_TYPE;

long banner_current_time;

long ellaspedTimeOut(Engine *objEngine);
void setTimeOut(Engine *objEngine);
void cone(GLfloat radius,GLfloat height);
void cylinder(GLfloat radius,GLfloat height);
void box(GLfloat w,GLfloat h,GLfloat d);
void brassMaterial();
void goldMaterial();
void bronzeMaterial();
void chromeMaterial();
void copperMaterial();
void silverMaterial();
void pewterMaterial();
void blackPlasticMaterial();
void setDiffuseMaterialColor(GLfloat red, GLfloat green, GLfloat blue,GLfloat alpha);
void setAmbientMaterialColor(GLfloat red, GLfloat green, GLfloat blue,GLfloat alpha);
void setSpecularMaterialColor(GLfloat red, GLfloat green, GLfloat blue,GLfloat alpha);
void setMaterialShininess(GLfloat shininess);
void sphere(GLfloat radius);

double Matrix4X1_1X4(MATRIX4X1 *matrix1, MATRIX1X4 *matrix2);
void Matrix4X1_4X4(MATRIX4X1 *result, MATRIX4X1 *matrix1, MATRIX4X4 *matrix2);
void Matrix1X4_4X4(MATRIX1X4 *result, MATRIX1X4 *matrix1, MATRIX4X4 *matrix2);
VECTOR_STRUCT_TYPE* rotate(GLfloat angle,GLfloat ux,GLfloat uy,GLfloat uz, VECTOR_STRUCT_TYPE *vector);

void calcNormal(GLfloat v[3][3], GLfloat out[3]);
void calcNormal2(VECTOR_STRUCT_TYPE *vertex1, VECTOR_STRUCT_TYPE *vertex2,VECTOR_STRUCT_TYPE *vertex3,GLfloat out[3]);
void reduceToUnit(GLfloat vector[3]);
void torus(GLfloat innerRadius,	GLfloat outerRadius);


void drawMechRobotMissiles();
void fireMechRobotMissile(GLfloat Yaw,GLfloat Pitch,GLfloat Vo);
int checkMechRobotHit(GLfloat x,GLfloat y,GLfloat z);
void mechRobotEngine();
void centerMechRobot();
POSITION_TYPE* moveMechRobot(GLdouble dStep);
void drawMechRobotCanopy();
void drawMechRobotRightArm ();
void drawMechRobotLeftArm ();
void drawMechRobotTorso ();
void buildMechRobotCanopy (void);
void buildMechRobotTorso (void);

void empty();
void BreakOut();
void tetrahedron();
void icosahedron();
int getAvailableMissile();
int getAvailableExplosion();
int getAvailableEnemyMissile();
void hyperboloid();
int checkMushRoomCollision(GLfloat object_x,GLfloat object_y,GLfloat object_z);
int checkBreakOutHit(GLfloat x,GLfloat y,GLfloat z);

void drawEnemyBody();
void drawEnemyLeftArm();
void drawEnemyRightArm();
void drawEnemyArm();
void drawClamp();
void drawBase();
void Enemy();
void Enemy_engine();
void drawEnemy();
void drawExplosion();
void moveEnemy();
void moveEnemyEngine(int direction);
void fireEnemyMissile();
void drawEnemyMissiles();
int checkEnemyHit(GLfloat x,GLfloat y,GLfloat z);
void toroidal_spiral();

void drawMine();
void generateMines();
void drawMineObjectList();
int getMineObject();
int checkMineHit(GLfloat x,GLfloat y, GLfloat z);
void point_sphere(GLfloat radius);
void checkEnemyCollision();
int getAvailableBreakOutMissile();
void missileObject();
void mushRoom();
int checkMushRoomHit(GLfloat missile_x,GLfloat missile_y,GLfloat missile_z);
void buildMushRoomObject();
int getMushRoomObject();
void generateMushRoom(GLfloat x,GLfloat y,GLfloat z);



/////////////////////////////////////////////////////////////////////////////
// CMy3DFontView

IMPLEMENT_DYNCREATE(CMy3DFontView, CView)

BEGIN_MESSAGE_MAP(CMy3DFontView, CView)
	//{{AFX_MSG_MAP(CMy3DFontView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_FILE_PAUSE, OnFilePause)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_RESUME, OnFileResume)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard printing commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy3DFontView construction/destruction

CMy3DFontView::CMy3DFontView()
{
	int i;

	// TODO: add construction code here
	srand( (unsigned)time(NULL) );
	startGame();
	buildSceneGraph();

	objBreakOut.m_radians=0.0f;
	objBreakOut.m_velocity=5.0f;
	objBreakOut.m_xPos=-50.0f;
	objBreakOut.m_yPos=0.0f;
	objBreakOut.m_zPos=-20.0f;
	objBreakOut.m_score=0;
	objBreakOut.m_hit=0;
	objBreakOut.m_swing=CENTER;

	for(i=0; i<NUMBER_OF_MISSILES; i++)
	{
		enemyMissile[i].m_available_flag=TRUE;
		//enemyMissile[i].m_active_flag=FALSE;
		breakOutMissile[i].m_available_flag=TRUE;
		//breakOutMissile[i].m_active_flag=FALSE;
	}

	for (i=0; i<MINE_LIST_SIZE; i++)
	{
		//objMushRoomList[i].m_active_flag=FALSE;
		objMineList[i].m_available_flag=TRUE;
		//objMineList[i].m_active_flag=FALSE;
	}

	for(i=0; i<OBJECT_LIST_SIZE; i++)
	{
		objMushRoomList[i].m_available_flag=TRUE;
	}

	mushRoom_configuration();

	for(i=0; i<EXPLOSION_SIZE; i++)
	{
		objExplosion[i].x=0.0f;
		objExplosion[i].y=0.0f;
		objExplosion[i].z=0.0f;
		objExplosion[i].scale_x=2.0f;
		objExplosion[i].scale_y=2.0f;
		objExplosion[i].scale_z=2.0f;
		objExplosion[i].m_cpu_seconds=0;
		objExplosion[i].m_available_flag=TRUE;
		//objExplosion[i].m_active_flag=FALSE;
	}

	EnemyEngine[0].x=0.0f;
	EnemyEngine[0].y=0.0f;
	EnemyEngine[0].z=-50.0f;
	EnemyEngine[0].m_displacement=1.0f;
	EnemyEngine[0].m_radians=1.57f;
	EnemyEngine[0].m_sleep=FALSE;

	PlaySound ("bluecoll.wav", NULL, SND_FILENAME | SND_ASYNC |SND_LOOP) ;

	mLevel=0;
}

CMy3DFontView::~CMy3DFontView()
{

	PlaySound("", NULL, SND_PURGE | SND_NODEFAULT);

	cleanSceneGraph(root);

}
BOOL CMy3DFontView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMy3DFontView drawing

void CMy3DFontView::OnDraw(CDC* pDC)
{
	CMy3DFontDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
	CPalette* oldPalette;

    //Set logic palette
	oldPalette = m_pDC->SelectPalette(&m_Palette, FALSE);
	m_pDC->RealizePalette();
	
	wglMakeCurrent(m_pDC->GetSafeHdc(), m_hRC);
	//DrawGLFont();
	drawWithOpenGL();
	SwapBuffers(m_pDC->GetSafeHdc());
    wglMakeCurrent(m_pDC->GetSafeHdc(), NULL);
	m_pDC->SelectPalette(oldPalette, FALSE);
}
void CMy3DFontView::drawWithOpenGL()
{
	CMainFrame* pFrame; 
	char scorePhrase[200];
	static GLfloat swing_angle=0.0f;
	GLfloat swing_displacement;

	glShadeModel(GL_SMOOTH);
	glEnable(GL_DEPTH_TEST);
	
	//clear color buffer
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	//set light model
	setLighting();
	setBlending();

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();


	if(objBreakOut.m_swing==LEFT)
	{
		if (swing_angle>-0.9f)
			swing_angle-= 0.1f;
	}
	else if(objBreakOut.m_swing==RIGHT)
	{
		if(swing_angle<0.9f)
			swing_angle+=0.1f;
	}
	else
	{
		if (swing_angle<-0.1f)
			swing_angle+= 0.1f;
		else if(swing_angle>0.1f)
			swing_angle-= 0.1f;
		else
			swing_angle=0.0f;
	}

	if (swing_angle>0.0f || swing_angle<0.0f)
	{
		swing_displacement=(GLfloat) (40.0f*(GLfloat)abs(swing_angle));
	}
	else
	{
		swing_displacement=0.0f;
	}

			  gluLookAt(
			  objBreakOut.m_xPos-((swing_displacement+30.0f)*(GLfloat)cos(objBreakOut.m_radians+swing_angle)+camera.m_x), 
			  objBreakOut.m_yPos+camera.m_y, 
			  objBreakOut.m_zPos+((swing_displacement+30.0f)*(GLfloat)sin(objBreakOut.m_radians+swing_angle)), 
			  objBreakOut.m_xPos+(100.0f*(GLfloat)cos(objBreakOut.m_radians)+camera.m_z), 
			  objBreakOut.m_yPos-20, 
			  objBreakOut.m_zPos-(100.0f*(GLfloat)sin(objBreakOut.m_radians)), 
			  0.0f, 
			  1.0f, 
			  0.0f  
			  );

			  /*
	  gluLookAt(
	  objBreakOut.m_xPos-(30.0f*(GLfloat)cos(objBreakOut.m_radians)+camera.m_x), 
	  objBreakOut.m_yPos+camera.m_y, 
	  objBreakOut.m_zPos+(30.0f*(GLfloat)sin(objBreakOut.m_radians)), 
	  objBreakOut.m_xPos+(100.0f*(GLfloat)cos(objBreakOut.m_radians)+camera.m_z), 
	  objBreakOut.m_yPos-50, 
	  objBreakOut.m_zPos-(100.0f*(GLfloat)sin(objBreakOut.m_radians)), 
	  0.0f, 
	  1.0f, 
	  0.0f  
	  );
		*/

	if ((clock()-banner_current_time)<10000)
	{
		glPushMatrix();
			glTranslatef(20.0f, 12.0f,0.0f);
			glRotatef(-90.0f,0.0f,1.0f,0.0f);
			glRotatef(90.0f,1.0f,0.0f,0.0f);
			m_FontX.GLDrawText();
		glPopMatrix();
	}

	VERIFY( pFrame = (CMainFrame*)GetParentFrame() ); 

	if (mLives<=0)
	{
		gameOver=TRUE;
	}
	else
	{

		if(m_subtotal_score>500)
		{
			mLives+=3;
			m_subtotal_score=0;
			mLevel++;
		}

		sprintf(scorePhrase,"(space)fire (1-5) camera (Score)%i (Lives) %i",objBreakOut.m_score,mLives);
	}

	if(gameOver)
	{
		sprintf(scorePhrase,"Game Over Score %i",objBreakOut.m_score);
		pFrame->SetWindowText(scorePhrase); 
	}
	else
	{
		pFrame->SetWindowText(scorePhrase); 
	}

	traverseSceneGraph(root);

	glPushMatrix();
		glTranslatef(0.0f,-10.0f,0.0f);
		drawGrid();
	glPopMatrix();
	
	if(getMushRoomObjectCount(MUSHROOM_TYPE)>0)
	{
		drawMushRoomObjectList();
	}
	else
	{
		mushRoom_configuration();
		buildMushRoomObject();
		drawMushRoomObjectList();
	}

	drawExplosion();

}
void CMy3DFontView::setLighting()
{
  GLfloat light0pos[4]=     {0.7071f, 40.0f, 5.0f, 1.0f};
  GLfloat light0ambient[4]= {0.3f, 0.3f, 0.3f, 1.0f};
  GLfloat light0diffuse[4]= {0.6f, 0.6f, 0.6f, 1.0f};
  GLfloat light0specular[4]={0.8f, 0.8f, 0.8f, 1.0f};
  GLfloat lmodel_ambient[]= {0.5f,0.5f,0.5f,1.0f};

  glLightModelfv(GL_LIGHT_MODEL_AMBIENT,lmodel_ambient);

  //glDisable(GL_DITHER);
  glShadeModel(GL_SMOOTH);
  
  glLightfv(GL_LIGHT0, GL_POSITION, light0pos);
  glLightfv(GL_LIGHT0, GL_AMBIENT, light0ambient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, light0diffuse);
  glLightfv(GL_LIGHT0, GL_SPECULAR, light0specular);
  
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
}
void CMy3DFontView::setBlending()
{
	glEnable(GL_BLEND);
	/*GL_SRC_ALPHA = Source color multiplied by source alpha
	  GL_ONE_MINUS_SRC_ALPHA =  Destination color is multiplied by 1,1,1,1 - source color)
	*/
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

}

/////////////////////////////////////////////////////////////////////////////
// CMy3DFontView diagnostics

#ifdef _DEBUG
void CMy3DFontView::AssertValid() const
{
	CView::AssertValid();
}

void CMy3DFontView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMy3DFontDoc* CMy3DFontView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMy3DFontDoc)));
	return (CMy3DFontDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMy3DFontView message handlers

int CMy3DFontView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	PIXELFORMATDESCRIPTOR pfd =
	{
		sizeof(PIXELFORMATDESCRIPTOR),
		1,
		PFD_DRAW_TO_WINDOW|
		PFD_SUPPORT_OPENGL|
		PFD_DOUBLEBUFFER,  
		PFD_TYPE_RGBA,
		24,
		0,0,0,0,0,0,
        0,0,0,0,0,0,0,
		32,
		0,0,
		PFD_MAIN_PLANE,
		0,
		0,0,0
	};
     
    m_pDC = new CClientDC(this);
	int pixelFormat =
		ChoosePixelFormat(m_pDC->GetSafeHdc(), &pfd);
	BOOL success = 
		SetPixelFormat(m_pDC->GetSafeHdc(), pixelFormat, &pfd);

	DescribePixelFormat(m_pDC->GetSafeHdc(), pixelFormat,
		  sizeof(pfd), &pfd);

	if(pfd.dwFlags & PFD_NEED_PALETTE)
         InitPalette();

	m_hRC = wglCreateContext(m_pDC->GetSafeHdc());

	m_FontX.SetXOffset(0.0f);
	m_FontX.SetYOffset(0.1f);
	m_FontX.SetXScale(6.4f);
	m_FontX.SetYScale(6.3f);
	m_FontX.SetZScale(3.8f);
	m_FontX.SetXRotate(-90.0f);
	m_FontX.SetYRotate(0.0f);
	m_FontX.SetZRotate(0.0f);

	InitFontColor();

	wglMakeCurrent(m_pDC->m_hDC,m_hRC);
	m_FontX.CreateFont(m_pDC, "Arial Black");
	m_FontX.SetText("GL BreakOut");

	wglMakeCurrent(NULL,NULL);

	setSpeed();

	return 0;
}

void CMy3DFontView::OnDestroy() 
{
	CView::OnDestroy();
	
	// TODO: Add your message handler code here
	wglDeleteContext(m_hRC);
    m_Palette.DeleteObject();
	ReleaseDC(m_pDC);
}

void CMy3DFontView::OnSize(UINT nType, int cx, int cy) 
{
	GLdouble aspect;
	CView::OnSize(nType, cx, cy);

	if (cy==0)
		aspect = (GLdouble)cx;
	else
		aspect = (GLdouble)cx/(GLdouble)cy;

    CClientDC clientDC(this);
	wglMakeCurrent(clientDC.m_hDC, m_hRC);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//glFrustum(-1.0, 1.0, -1.0, 1.0, 2.0, 7.0);
	//glViewport(0, 0, cx, cy);

	setPerspectiveWindow(60,aspect,5,4000);
	setViewport(0,0,cx,cy);
	
	wglMakeCurrent(NULL, NULL);
}


void CMy3DFontView::InitPalette(void)
{
	PIXELFORMATDESCRIPTOR pfd;  // Pixel Format Descriptor         
	LOGPALETTE *pPal;			// Pointer to memory for logical palette
	int PixelFormat;			// Pixel format index
    int paletteSize;            // Number of entries in palette 
	BYTE RedMask;               // Range for each color entry (7,7,and 3)
	BYTE GreenMask;
	BYTE BlueMask;
    HDC hDC = GetDC()->GetSafeHdc();  //the context device 								

	// Get the pixel format index and retrieve the pixel format description
    PixelFormat = GetPixelFormat(hDC);
    DescribePixelFormat(hDC, PixelFormat, sizeof(PIXELFORMATDESCRIPTOR), &pfd);
    
	
	// Check whether the pixel format and the pixel type
	if (!(pfd.dwFlags & PFD_NEED_PALETTE ||
	  pfd.iPixelType == PFD_TYPE_COLORINDEX))
	    return;

	// Get the number of entries in palette. 256 colors for 8 bits 
    paletteSize = 1 << pfd.cColorBits;
    
	// Allocate for the logical palette
	pPal = (LOGPALETTE*)
	malloc(sizeof(LOGPALETTE) + paletteSize * sizeof(PALETTEENTRY));
    
	
	// Fill the logical palette header information 
	pPal->palVersion = 0x300;            //support Windows3.0
    pPal->palNumEntries = paletteSize;   //number of colors entries

    // Set the 1st entries of logical palette with the current system palette 
    (void) GetSystemPaletteEntries(hDC, 0, paletteSize, &pPal->palPalEntry[0]);

	//Set the RGB mask
	RedMask = (1 << pfd.cRedBits) - 1;
	GreenMask = (1 << pfd.cGreenBits) - 1;
	BlueMask = (1 << pfd.cBlueBits) - 1;

	//Set all entries of the logical palette 
    for (int i=0; i<paletteSize; ++i) 
	{
	    pPal->palPalEntry[i].peRed =
		    (((i >> pfd.cRedShift) & RedMask) * 255) / RedMask;
	    pPal->palPalEntry[i].peGreen =
		    (((i >> pfd.cGreenShift) & GreenMask) * 255) / GreenMask;
	    pPal->palPalEntry[i].peBlue =
		    (((i >> pfd.cBlueShift) & BlueMask) * 255) / BlueMask;
	    pPal->palPalEntry[i].peFlags = 0;
    }

	//Create the palette
    m_Palette.CreatePalette(pPal);

	//Free the memory allocated for the logical palette 
    free(pPal);
}


void CMy3DFontView::DrawGLFont(void)
{
	glShadeModel(GL_SMOOTH);
	glEnable(GL_DEPTH_TEST);
	
	//clear color buffer
	glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	//set light model
	glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    //glTranslatef(-3.0f, -5.0f, -0.0f);

    m_FontX.GLDrawText();

	glFlush();

}


void CMy3DFontView::InitFontColor()
{
	float fv[4];


	fv[0] = 0.1f;
	fv[1] = 0.1f;
	fv[2] = 0.1f;
	fv[3] = 0.1f;
	m_FontX.SetEmission(fv);

	fv[0] = 0.9f;
	fv[1] = 0.9f;
	fv[2] = 0.9f;
	fv[3] = 1.0f;
	m_FontX.SetSpecular(fv);

	fv[0] = 0.1f;
	fv[1] = 0.1f;
	fv[2] = 1.0f;
	fv[3] = 1.0f;
	m_FontX.SetAmbient(fv);

	fv[0] = 0.1f;
	fv[1] = 0.1f;
	fv[2] = 0.1f;
	fv[3] = 1.0f;
	m_FontX.SetDiffuse(fv);

	m_FontX.SetShininess(0.1f);
	
}


void CMy3DFontView::setPerspectiveWindow(GLdouble fovy, GLdouble aspect,GLdouble zNear,GLdouble zFar)
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(fovy, aspect,zNear,  zFar);
}
void CMy3DFontView::setViewport(GLint iX, GLint iY, GLsizei iWidth, GLsizei iHeight)
{
	glViewport(iX,iY,iWidth,iHeight);
}
void CMy3DFontView::setDepthBuffer()
{
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LESS);
  glEnable(GL_CULL_FACE);
  glCullFace(GL_BACK);
  glFrontFace(GL_CCW);
}
void CMy3DFontView::startGame()
{
	gameOver = FALSE;
	objBreakOut.m_score=0;
	m_subtotal_score=0;
	mLives=3;
	mLevel=0;
	
	camera.m_radians=(float)1.57;
	camera.m_x=0.0f;;
	camera.m_y=4.0f;
	camera.m_z=0.0f;
	banner_current_time=clock();
}


void CMy3DFontView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	if(pause)
	{
		KillTimer(1);
	}
	else
	{
		setSpeed();
	}

	Invalidate(FALSE);

	CView::OnTimer(nIDEvent);
}

void CMy3DFontView::BreakOutLeft()
{
	objBreakOut.m_radians +=(GLfloat) PI/25.0f; 
	if(objBreakOut.m_radians > (2.0*PI))		// Keep in bounds
		objBreakOut.m_radians = 0.0f;

}
void CMy3DFontView::BreakOutRight(void)
{
	objBreakOut.m_radians -= (GLfloat) PI/25.0f; 
	if (objBreakOut.m_radians <0.0f)		// Keep in bounds
	   objBreakOut.m_radians = (GLfloat)(2.0f*PI);
}

void CMy3DFontView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	static clock_t current_clicks=clock();

	// TODO: Add your message handler code here and/or call default
		//left
		if (nChar==37)
		{
			BreakOutLeft();
		}
		//right
		else if(nChar==39)
		{
			BreakOutRight();
		}
		//up
		else if(nChar==38)
		{
			if (objBreakOut.m_velocity<6)
				objBreakOut.m_velocity+=1;
		}
		//down
		else if(nChar==40)
		{
			if (objBreakOut.m_velocity>-6)
				objBreakOut.m_velocity-=1;
		}
		//fire
		else if(nChar==32)
		{
			if((clock()-current_clicks)>300)
			{
				fireMechRobotMissile(dRadToDeg(objBreakOut.m_radians+((float)PI/2.0f))+180.0f,0.0f,1.0f);
				current_clicks=clock();
			}
		}
		//1
		else if(nChar==49)
		{
			objBreakOut.m_swing=LEFT;
		}
			//2
		else if(nChar==50)
		{
			objBreakOut.m_swing=CENTER;
		}
			//3
		else if(nChar==51)
		{
			objBreakOut.m_swing=RIGHT;
		}
			//4
		else if(nChar==52)
		{
			camera.m_y++;
		}
			//5
		else if(nChar==53)
		{
			camera.m_y--;
		}
			//6
		else if(nChar==54)
		{
		}
			//7
		else if(nChar==55)
		{
		}
			//8
		else if (nChar==56)
		{
			
		}

	//Invalidate(FALSE);
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}
void CMy3DFontView::drawGrid()
{
 int i;
 int j;

 GLfloat x;
 GLfloat z;
 GLfloat wall_x1,wall_x2;
 GLfloat wall_z1,wall_z2;
 GLfloat cellsize;
 int color;

cellsize=(GLfloat) ((GRID_SIZE*2)/10);

  glPushAttrib(GL_LIGHTING);
  glDisable(GL_LIGHTING);

    z = (GLfloat) -GRID_SIZE;
	for(i=0; i<=9; i++)
	{
        x = (GLfloat) -GRID_SIZE;

		for(j=0; j<=9; j++)
		{
				wall_x1=x-(cellsize/2);
				wall_x2=x+(cellsize/2);
				wall_z1=z+(cellsize/2);
				wall_z2=z-(cellsize/2);

				color=rand()%5;
				switch(color)
				{
					case 0:
						glRGB(255/2,0,0);
						break;
					case 1:
						glRGB(0,255/2,0);
						break;
					case 2:
						glRGB(0,0,255/2);
						break;
					case 3:
						glRGB(255/2,255/2,0);
						break;
					case 4:
						glRGB(0,255/2,255/2);
						break;
					case 5:
						glRGB(255,0,255);
						break;
				}

				glPushMatrix();
					glBegin(GL_LINE_LOOP);
					//glBegin(GL_POLYGON);
						glNormal3f(0.0f,1.0f,0.0f);
						glVertex3f(wall_x1,5.0f,wall_z1);
						glVertex3f(wall_x2,5.0f,wall_z1);
						glVertex3f(wall_x2,5.0f,wall_z2);
						glVertex3f(wall_x1,5.0f,wall_z2);
					glEnd();
				glPopMatrix();

	        x = x + cellsize;
		}
        z = z + cellsize;
	}    
  glPopAttrib();
  glEnable(GL_LIGHTING);
}

void CMy3DFontView::OnFilePause() 
{
	// TODO: Add your command handler code here
	pause=TRUE;
}
void CMy3DFontView::setSpeed()
{
	SetTimer(1,100,0);
}

void CMy3DFontView::OnFileNew() 
{
	// TODO: Add your command handler code here
	startGame();
}

void CMy3DFontView::OnFileResume() 
{
	// TODO: Add your command handler code here

		pause=FALSE;
		setSpeed();
}
void CMy3DFontView::traverseSceneGraph(treenode *root)
{
	if(root==NULL)
		return;
	//count++;
	//printf("PushMatrix %d\n",count);
	//printf("%s\n",root->node_key);
	glPushMatrix();
		//glMultMatrix(root->m);
		root->f();
		if (root->engine!=NULL)
		{
			root->engine();
		}
		if(root->child!=NULL)
		{
			traverseSceneGraph(root->child);
		}
	//count--;
	//printf("PopMatrix %d\n",count);

	glPopMatrix();
	
	if(root->sibling!=NULL)
			traverseSceneGraph(root->sibling);
}
treenode* CMy3DFontView::node(char *node_key)
{
	treenode *retNode;

	retNode=(treenode *) malloc (sizeof(treenode));
	retNode->child=NULL;
	retNode->sibling=NULL;
	retNode->engine=NULL;
	retNode->most_recent_child=NULL;
	strcpy(retNode->node_key,node_key);

	return(retNode);

}
void CMy3DFontView::addChild(treenode *parentNode, treenode *childNode)
{
	/*
	Observations
	1) addChild rules:
	a) A parent has only one child
	b) If another child is associated to the parent it becomes a sibling of the parents first child.  That child becomes the parent's most_recent_child.  Any additional children are associated to the parent's most_recent_child sibling link.
	c) The parents first child sibling link is traverse to find all remaining children.  This is the key for the algorithm to work correctly.
	*/

	treenode *most_recent_child;
	//walk down the tree from the topmost child
	//connect the sibling link from the most recent child
	most_recent_child=parentNode->most_recent_child;
	
	strcpy(childNode->parent_key,parentNode->node_key);

	if (most_recent_child!=NULL)
	{
		most_recent_child->sibling=childNode;
		parentNode->most_recent_child=childNode;
	}
	//first child
	else
	{
		parentNode->child=childNode;
		parentNode->most_recent_child=childNode;
	}
}
void CMy3DFontView::cleanSceneGraph(treenode *root)
{
	if(root->child!=NULL)
		cleanSceneGraph(root->child);
	
	if(root->sibling!=NULL)
		cleanSceneGraph(root->sibling);

	free(root);
}
void CMy3DFontView::buildSceneGraph()
{
	treenode *objEnemy, *objEnemyBody;
	treenode *objBreakOutNode, *objTorsoNode,*objCanopyNode,*objLeftArmNode,*objRightArmNode;

	objBreakOut.m_velocity=1.0f;
	objBreakOut.m_radians=0.0f;
	objBreakOut.m_xPos=0.0f;
	objBreakOut.m_yPos=10.0f;
	objBreakOut.m_zPos=0.0f;

	root=node("root");
	root->f=BreakOut;

	//MechRobot
	objBreakOutNode=node("MechRobot");
	objBreakOutNode->f=centerMechRobot;
	objBreakOutNode->engine=mechRobotEngine;
	addChild(root,objBreakOutNode);

	objTorsoNode=node("Torso");
	objTorsoNode->f=drawMechRobotTorso;
	addChild(objBreakOutNode,objTorsoNode);

	objCanopyNode=node("Canopy");
	objCanopyNode->f=drawMechRobotCanopy;
	addChild(objTorsoNode,objCanopyNode);

	objLeftArmNode=node("Left Arm");
	objLeftArmNode->f=drawMechRobotLeftArm;
	addChild(objTorsoNode,objLeftArmNode);

	objRightArmNode=node("Right Arm");
	objRightArmNode->f=drawMechRobotRightArm;
	addChild(objTorsoNode,objRightArmNode);
	
	//Enemy
	objEnemy=node("Enemy");
	objEnemy->f=Enemy;
	objEnemy->engine=Enemy_engine;
	addChild(root,objEnemy);

	objEnemyBody=node("Enemy Body");
	objEnemyBody->f=drawEnemy;
	objEnemyBody->engine=NULL;
	addChild(objEnemy,objEnemyBody);
}
void buildMechRobotCanopy (void)
{

	glPolygonMode(GL_FRONT,GL_FILL);
	/*right window*/
   glBegin(GL_POLYGON);
     
	glNormal3f(0.0f,0.83f,0.55f);

	 glVertex3f(-1.0f,4.0f,0.0f);

	 glVertex3f(-3.0f,3.0f,1.5f);

	 glVertex3f(-3.0f,2.0f,3.0f);

	 glVertex3f(4.0f,2.0f,3.0f);

	 glVertex3f(2.0f,4.0f,0.0f);
   glEnd();
   
   /*left window*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,0.83f,-0.55f);
     glVertex3f(2.0f,4.0f,0.0f);
     glVertex3f(4.0f,2.0f,-3.0f);
     glVertex3f(-3.0f,2.0f,-3.0f);
     glVertex3f(-3.0f,3.0f,-1.5f);
     glVertex3f(-1.0f,4.0f,0.0f);
   glEnd();
   
   /*bottom window*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,-1.0f,0.0f);
     glVertex3f(4.0f,2.0f,3.0f);
     glVertex3f(4.0f,2.0f,-3.0f);
     glVertex3f(-3.0f,2.0f,-3.0f);
     glVertex3f(-3.0f,2.0f,3.0f);
   glEnd();

   /*back wall*/
   glBegin(GL_POLYGON);
     glNormal3f(-1.0f,0.0f,0.0f);
     glVertex3f(-3.0f,3.0f,1.5f);
     glVertex3f(-3.0f,3.0f,-1.5f);
     glVertex3f(-3.0f,2.0f,-3.0f);
     glVertex3f(-3.0f,2.0f,3.0f);
   glEnd();

   /*front window*/
   glBegin(GL_TRIANGLES);
     glNormal3f(0.71f,0.71f,0.0f);
     glVertex3f(2.0f,4.0f,0.0f);
     glVertex3f(4.0f,2.0f,3.0f);
     glVertex3f(4.0f,2.0f,-3.0f);
   glEnd();

   /*back window*/
   glBegin(GL_TRIANGLES);
     glNormal3f(-0.45f,0.89f,0.0f);
     glVertex3f(-1.0f,4.0f,0.0f);
     glVertex3f(-3.0f,3.0f,-1.5f);
     glVertex3f(-3.0f,3.0f,1.5f);
   glEnd();
}
void buildMechRobotTorso (void)
{
	glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
     
	/*right top body*/
	glBegin(GL_POLYGON);
		glNormal3f(0.0f,0.71f,0.71f);
		glVertex3f(-3.0f,2.0f,3.0f);
		glVertex3f(-3.0f,1.0f,4.0f);
		glVertex3f(3.0f,1.0f,4.0f);
		glVertex3f(4.0f,2.0f,3.0f);
	glEnd();
   
   /*right bottom body*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,-0.71f,0.71f);
     glVertex3f(-3.0f,1.0f,4.0f);
     glVertex3f(-3.0f,0.0f,3.0f);
     glVertex3f(5.0f,0.0f,3.0f);
     glVertex3f(3.0f,1.0f,4.0f);
   glEnd();

   /*left top body*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,0.71f,-0.71f);
     glVertex3f(-3.0f,2.0f,-3.0f);
     glVertex3f(4.0f,2.0f,-3.0f);
     glVertex3f(3.0f,1.0f,-4.0f);
     glVertex3f(-3.0f,1.0f,-4.0f);
   glEnd();

   /*left bottom body*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,-0.71f,-0.71f);
     glVertex3f(-3.0f,1.0f,-4.0f);
     glVertex3f(3.0f,1.0f,-4.0f);
     glVertex3f(5.0f,0.0f,-3.0f);
     glVertex3f(-3.0f,0.0f,-3.0f);
   glEnd();

   /* right front top */
   glBegin(GL_TRIANGLES);
     glNormal3f(0.41f,0.41f,0.82f);
     glVertex3f(4.0f,2.0f,3.0f);
	 glVertex3f(3.0f,1.0f,4.0f);
	 glVertex3f(7.0f,1.0f,2.0f);
	 //glVertex3f(7.0f,1.0f,2.0f);
     //glVertex3f(7.0f,1.0f,-2.0f);
     //glVertex3f(4.0f,2.0f,-3.0f);
   glEnd();

   /*right front bottom*/
   glBegin(GL_TRIANGLES);
     glNormal3f(0.45f,0.0f,0.89f);
     glVertex3f(3.0f,1.0f,4.0f);
     glVertex3f(5.0f,0.0f,3.0f);
     glVertex3f(7.0f,1.0f,2.0f);
   glEnd();

   /*left front top*/
   glBegin(GL_TRIANGLES);
     glNormal3f(0.41f,0.41f,-0.82f);
     glVertex3f(4.0f,2.0f,-3.0f);
     glVertex3f(7.0f,1.0f,-2.0f);
     glVertex3f(3.0f,1.0f,-4.0f);
   glEnd();

   /*left front bottom*/
   glBegin(GL_TRIANGLES);
     glNormal3f(0.45f,0.0f,-0.89f);
     glVertex3f(5.0f,0.0f,-3.0f);
     glVertex3f(3.0f,1.0f,-4.0f);
     glVertex3f(7.0f,1.0f,-2.0f);
   glEnd();

   /*front top*/
   glBegin(GL_POLYGON);
     glNormal3f(0.32f,0.95f,0.0f);
     glVertex3f(4.0f,2.0f,3.0f);
     glVertex3f(7.0f,1.0f,2.0f);
     glVertex3f(7.0f,1.0f,-2.0f);
     glVertex3f(4.0f,2.0f,-3.0f);
   glEnd();

   /*front bottom*/
   glBegin(GL_POLYGON);
     glNormal3f(0.45f,0.89f,0.0f);
     glVertex3f(5.0f,0.0f,3.0f);
     glVertex3f(5.0f,0.0f,-3.0f);
     glVertex3f(7.0f,1.0f,-2.0f);
     glVertex3f(7.0f,1.0f,2.0f);
   glEnd();
   
   /*back*/
   glBegin(GL_POLYGON);
     glNormal3f(1.0f,0.0f,0.0f);
     glVertex3f(-3.0f,2.0f,3.0f);
     glVertex3f(-3.0f,1.0f,4.0f);
     glVertex3f(-3.0f,0.0f,3.0f);
     glVertex3f(-3.0f,0.0f,-3.0f);
     glVertex3f(-3.0f,1.0f,-4.0f);
     glVertex3f(-3.0f,2.0f,-3.0f);
   glEnd();

   /*top*/
   glBegin(GL_POLYGON);
     glNormal3f(-0.27f,0.96f,0.0f);
     glVertex3f(-3.0f,2.0f,3.0f);
     glVertex3f(4.0f,2.0f,3.0f);
     glVertex3f(4.0f,2.0f,-3.0f);
     glVertex3f(-3.0f,2.0f,-3.0f);
   glEnd();

   /*bottom*/
   glBegin(GL_POLYGON);  
     glNormal3f(0.0f,-1.0f,0.0f);
     glVertex3f(-3.0f,0.0f,-3.0f);
	 glVertex3f(5.0f,0.0f,-3.0f);
     glVertex3f(5.0f,0.0f,3.0f);
	 glVertex3f(-3.0f,0.0f,3.0f);
   glEnd();
   
   /*top back right*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,0.71f,0.71f);
     glVertex3f(-5.0f,4.0f,3.0f);
     glVertex3f(-5.0f,3.0f,4.0f);
     glVertex3f(-3.0f,3.0f,4.0f);
     glVertex3f(-3.0f,4.0f,3.0f);
   glEnd();
   
   /*top back left*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,0.71f,-0.71f);
     glVertex3f(-3.0f,4.0f,-3.0f);
     glVertex3f(-3.0f,3.0f,-4.0f);
     glVertex3f(-5.0f,3.0f,-4.0f);
     glVertex3f(-5.0f,4.0f,-3.0f);
   glEnd();

   /*top back*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,1.0f,0.0f);
     glVertex3f(-5.0f,4.0f,3.0f);
     glVertex3f(-3.0f,4.0f,3.0f);
     glVertex3f(-3.0f,4.0f,-3.0f);
     glVertex3f(-5.0f,4.0f,-3.0f);
   glEnd();

   /*bottom back*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,-1.0f,0.0f);
     glVertex3f(-5.0f,0.0f,3.0f);
     glVertex3f(-5.0f,0.0f,-3.0f);
     glVertex3f(-3.0f,0.0f,-3.0f);
     glVertex3f(-3.0f,0.0f,3.0f);
   glEnd();

   /*bottom right back*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,-0.71f,0.71f);
     glVertex3f(-5.0f,1.0f,4.0f);
     glVertex3f(-5.0f,0.0f,3.0f);
     glVertex3f(-3.0f,0.0f,3.0f);
     glVertex3f(-3.0f,1.0f,4.0f);
   glEnd();

   /*bottom left back*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,-0.71f,-0.71f);
     glVertex3f(-5.0f,1.0f,-4.0f);
     glVertex3f(-3.0f,1.0f,-4.0f);
     glVertex3f(-3.0f,0.0f,-3.0f);
     glVertex3f(-5.0f,0.0f,-3.0f);
   glEnd();

   /*right back*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,0.0f,1.0f);
     glVertex3f(-5.0f,3.0f,4.0f);
     glVertex3f(-5.0f,1.0f,4.0f);
     glVertex3f(-3.0f,1.0f,4.0f);
     glVertex3f(-3.0f,3.0f,4.0f);
   glEnd();

   /*left back*/
   glBegin(GL_POLYGON);
     glNormal3f(0.0f,0.0f,-1.0f);
     glVertex3f(-5.0f,3.0f,-4.0f);
     glVertex3f(-3.0f,3.0f,-4.0f);
     glVertex3f(-3.0f,1.0f,-4.0f);
     glVertex3f(-5.0f,1.0f,-4.0f);
   glEnd();

   /*back back*/
   glBegin(GL_POLYGON);
     glNormal3f(-1.0f,0.0f,0.0f);
     glVertex3f(-5.0f,4.0f,3.0f);
     glVertex3f(-5.0f,4.0f,-3.0f);
     glVertex3f(-5.0f,3.0f,-4.0f);
     glVertex3f(-5.0f,1.0f,-4.0f);
     glVertex3f(-5.0f,0.0f,-3.0f);
     glVertex3f(-5.0f,0.0f,3.0f);
     glVertex3f(-5.0f,1.0f,4.0f);
     glVertex3f(-5.0f,3.0f,4.0f);
   glEnd();

   /*back front*/
   glBegin(GL_POLYGON);
     glNormal3f(1.0f,0.0f,0.0f);
     glVertex3f(-3.0f,4.0f,3.0f);
     glVertex3f(-3.0f,3.0f,4.0f);
     glVertex3f(-3.0f,1.0f,4.0f);
     glVertex3f(-3.0f,0.0f,3.0f);
     glVertex3f(-3.0f,0.0f,-3.0f);
     glVertex3f(-3.0f,1.0f,-4.0f);
     glVertex3f(-3.0f,3.0f,-4.0f);
     glVertex3f(-3.0f,4.0f,-3.0f);
   glEnd();
   
}
void drawMechRobotTorso ()
{
	glRotatef(objBreakOut.M_TORSO_ANGLE,0.0f,1.0f,0.0f);
}
void drawMechRobotLeftArm ()
{
   GLUquadricObj *obj = gluNewQuadric();
   gluQuadricDrawStyle(obj,GLU_FILL);
   gluQuadricNormals(obj,GLU_SMOOTH);
   gluQuadricOrientation(obj,GLU_OUTSIDE);

	/*left side = 1; right side = 0;*/

   goldMaterial();
	//Reduce size by 50 percent
	glScalef(0.5f,0.5f,0.5f);

   /*draw the arm*/
   glPushMatrix();


		glTranslatef(-4.0f,1.75f,-6.0f);
		glRotatef(135.0f,1.0f,0.0f,0.0f);

		gluCylinder(obj,0.5f,0.5f,4.0f,10,1);
   
   glPopMatrix();
   
   /*draw the shoulder*/
   glPushMatrix();
   
		glTranslatef(-4.0f,2.0f,-5.0f);

		glTranslatef(0.0f,0.0f,-1.0f);
		gluCylinder(obj,1.0f,1.0f,2.0f,10,1);

		glRotatef(180.0f,1.0f,0.0f,0.0f);

		gluDisk(obj,0,1.0f,100,1);   
   
   glPopMatrix();
   
   /*draw the cannon*/
   glPushMatrix();
   
		glTranslatef(-5.0f,0.0f,-8.0f);

		glRotatef(90.0f,0.0f,1.0f,0.0f);
		glRotatef((GLfloat) objBreakOut.M_ARM_ANGLE,1.0f,0.0f,0.0f);
		glPushMatrix();
			glTranslatef(0.0f,0.0f,2.0f);
			gluDisk(obj,0.0f,1.0f,10,1);
		glPopMatrix();
		glPushMatrix();
			glRotatef(180.0f,1.0f,0.0f,0.0f);
			gluDisk(obj,0.0f,1.0f,10,1);
		glPopMatrix();
		gluCylinder(obj,1.0f,1.0f,2.0f,10,1);
		gluCylinder(obj,0.5f,0.5f,8.0f,10,1);
   glPopMatrix();
   gluDeleteQuadric(obj);
}

void drawMechRobotRightArm ()
{
   GLUquadricObj *obj = gluNewQuadric();
   gluQuadricDrawStyle(obj,GLU_FILL);
   gluQuadricNormals(obj,GLU_SMOOTH);
   gluQuadricOrientation(obj,GLU_OUTSIDE);

	/*left side = 1; right side = 0;*/

   goldMaterial();
	//Reduce size by 50 percent
	glScalef(0.5f,0.5f,0.5f);

   /*draw the arm*/
   glPushMatrix();


	   glTranslatef(-4.0f,1.75f,6.0f);
	   glRotatef(45.0f,1.0f,0.0f,0.0f);

	   gluCylinder(obj,0.5f,0.5f,4.0f,10,1);
   
   glPopMatrix();
   
	/*draw the shoulder*/
	glPushMatrix();

		glTranslatef(-4.0f,2.0f,5.0f);

		glTranslatef(0.0f,0.0f,-1.0f);
		gluCylinder(obj,1.0f,1.0f,2.0f,10,1);

		glTranslatef(0.0f,0.0f,2.0f);

		gluDisk(obj,0,1.0f,100,1);   

	glPopMatrix();

		/*draw the cannon*/
	glPushMatrix();

		glTranslatef(-5.0f,0.0f,8.0f);

		glRotatef(90.0f,0.0f,1.0f,0.0f);
		glRotatef((GLfloat)objBreakOut.M_ARM_ANGLE,1.0f,0.0f,0.0f);
		glPushMatrix();
			glTranslatef(0.0f,0.0f,2.0f);
			gluDisk(obj,0.0f,1.0f,10,1);
			glPopMatrix();
			glPushMatrix();
			glRotatef(180.0f,1.0f,0.0f,0.0f);
			gluDisk(obj,0.0f,1.0f,10,1);
		glPopMatrix();
		gluCylinder(obj,1.0f,1.0f,2.0f,10,1);
		gluCylinder(obj,0.5f,0.5f,8.0f,10,1);

   glPopMatrix();
   gluDeleteQuadric(obj);
}

void drawMechRobotCanopy()
{
	goldMaterial();

	//Reduce size by 50 percent
	glScalef(0.5f,0.5f,0.5f);

	buildMechRobotTorso();
	buildMechRobotCanopy();
}
POSITION_TYPE* moveMechRobot(GLdouble dStep)
{
	POSITION_TYPE *myPosition;
	GLdouble xDelta,zDelta;
	GLfloat light0pos[4];

	xDelta = dStep*cos(objBreakOut.m_radians);
	zDelta = -dStep*sin(objBreakOut.m_radians);

	myPosition= (POSITION_TYPE *) malloc (sizeof(POSITION_TYPE));

	myPosition->x=objBreakOut.m_xPos + (float)xDelta;
	myPosition->z=objBreakOut.m_zPos + (float)zDelta;

	if(objBreakOut.m_xPos > GRID_SIZE)
		myPosition->x = (float) GRID_SIZE;

	if(objBreakOut.m_xPos < -GRID_SIZE)
		myPosition->x = (float) -GRID_SIZE;
	
	if(objBreakOut.m_zPos > GRID_SIZE)
	   myPosition->z = (float) GRID_SIZE;

	if(objBreakOut.m_zPos < -GRID_SIZE)
	   myPosition->z = (float) -GRID_SIZE;


	light0pos[0]=objBreakOut.m_xPos;
	light0pos[1]=10.0f;
	light0pos[2]=objBreakOut.m_zPos;
	light0pos[3]=1.0f;

	glLightfv(GL_LIGHT0, GL_POSITION, light0pos);

	return(myPosition);
}

void centerMechRobot()
{
	drawMechRobotMissiles();
	drawExplosion();
}
void mechRobotEngine()
{
   POSITION_TYPE *myPosition;
	GLfloat old_x,old_y,old_z;
	GLfloat x2,y2,z2;
	GLfloat distance;

	old_x=objBreakOut.m_xPos;
	old_y=objBreakOut.m_yPos;
	old_z=objBreakOut.m_zPos;

	//Moves the robot into space
	myPosition=moveMechRobot(objBreakOut.m_velocity);

	objBreakOut.m_xPos=myPosition->x;
	objBreakOut.m_zPos=myPosition->z;
	free(myPosition);


   	if(checkMushRoomCollision(objBreakOut.m_xPos,objBreakOut.m_yPos,objBreakOut.m_zPos)==1)
	{	
		objBreakOut.m_xPos=old_x;
		objBreakOut.m_zPos=old_z;
	}


	x2=EnemyEngine[0].x;
	y2=EnemyEngine[0].y;
	z2=EnemyEngine[0].z;

	distance=(GLfloat) sqrt((objBreakOut.m_xPos-x2)*(objBreakOut.m_xPos-x2)+(objBreakOut.m_yPos-y2)*(objBreakOut.m_yPos-y2)+(objBreakOut.m_zPos-z2)*(objBreakOut.m_zPos-z2));

	if(distance<10)
	{
		objBreakOut.m_xPos=old_x;
		objBreakOut.m_zPos=old_z;
	}

	glTranslatef(objBreakOut.m_xPos,objBreakOut.m_yPos,objBreakOut.m_zPos);
	glRotatef(dRadToDeg(objBreakOut.m_radians+((float)PI/2.0f))-90, 0.0f, 1.0f, 0.0f);
}
int checkMechRobotHit(GLfloat x,GLfloat y,GLfloat z)
{
int retval;
GLfloat mechRobot_x,mechRobot_y,mechRobot_z;
GLfloat vector_x,vector_y,vector_z;
GLfloat distance;
int index;

	retval=0;

	mechRobot_x=objBreakOut.m_xPos;
	mechRobot_y=objBreakOut.m_yPos;
	mechRobot_z=objBreakOut.m_zPos;

	vector_x=mechRobot_x-x;
	vector_y=0.0f;
	vector_z=mechRobot_z-z;

	distance=(GLfloat) sqrt(vector_x*vector_x+vector_y*vector_y+vector_z*vector_z);

	if(distance<=10)
	{

		index=getAvailableExplosion();
		if(index>-1)
		{
			objExplosion[index].x=x;
			objExplosion[index].y=y;
			objExplosion[index].z=z;
			objExplosion[index].m_cpu_seconds=clock();
		}


		//sound("hit.wav");
		retval=1;

		return(retval);
	}

	return(retval);
}

void fireMechRobotMissile(GLfloat Yaw,GLfloat Pitch,GLfloat Vo)
{
	GLint i;

	i=getAvailableBreakOutMissile();

	if(i>-1)
	{
		breakOutMissile[i].m_x=objBreakOut.m_xPos;
		breakOutMissile[i].m_y=objBreakOut.m_yPos;
		breakOutMissile[i].m_z=objBreakOut.m_zPos;
		breakOutMissile[i].m_Vo=15.0f;
		breakOutMissile[i].m_radians=objBreakOut.m_radians;
		breakOutMissile[i].m_available_flag=FALSE;
		//breakOutMissile[i].m_active_flag=TRUE;
	}
}
void drawMechRobotMissiles()
{
	GLint i=0;
	GLfloat x,z;
	GLfloat distance;
	GLint retVal;

	for(i=0; i<NUMBER_OF_MISSILES; i++)
	{
		if(breakOutMissile[i].m_available_flag==FALSE)
		{

			x=(GLfloat) ((breakOutMissile[i].m_Vo)*cos(breakOutMissile[i].m_radians));
			z=(GLfloat) (-(breakOutMissile[i].m_Vo)*sin(breakOutMissile[i].m_radians));

			breakOutMissile[i].m_x += x;
			breakOutMissile[i].m_z += z;

			retVal=checkMineHit(breakOutMissile[i].m_x,5.0f,breakOutMissile[i].m_z);
				
			if (retVal==1)
			{
					breakOutMissile[i].m_available_flag=TRUE;
					generateMushRoom(breakOutMissile[i].m_x,1.0f,breakOutMissile[i].m_z);
					//breakOutMissile[i].m_active_flag=FALSE;
			}
			else
			{
				retVal=checkMushRoomHit(breakOutMissile[i].m_x,5.0f,breakOutMissile[i].m_z);
				if (retVal==1)
				{
						breakOutMissile[i].m_available_flag=TRUE;
						//breakOutMissile[i].m_active_flag=FALSE;
						continue;
				}
			}

			retVal=checkEnemyHit(breakOutMissile[i].m_x,5.0f,breakOutMissile[i].m_z);
			if (retVal==1)
			{
					breakOutMissile[i].m_available_flag=TRUE;
					//breakOutMissile[i].m_active_flag=FALSE;
					objBreakOut.m_hit++;
			}

			glPushMatrix();
				glTranslatef(breakOutMissile[i].m_x,breakOutMissile[i].m_y,breakOutMissile[i].m_z);
				glScalef(0.5f,0.5f,0.5f);

				glPushMatrix();
					glRotatef(dRadToDeg(breakOutMissile[i].m_radians),0.0f,1.0f,0.0f);
					glTranslatef(0.0f,3.0f,-7.5f);
					missileObject();
				glPopMatrix();

				glPushMatrix();
					glRotatef(dRadToDeg(breakOutMissile[i].m_radians),0.0f,1.0f,0.0f);
					//Reduce size by 50 percent
					glTranslatef(0.0f,3.0f,7.5f);
					missileObject();
				glPopMatrix();

				//Sphere(5,10,10);
			glPopMatrix();

			x=objBreakOut.m_xPos-breakOutMissile[i].m_x;
			z=objBreakOut.m_zPos-breakOutMissile[i].m_z;

			distance=(GLfloat) sqrt(x*x+breakOutMissile[i].m_y*breakOutMissile[i].m_y+z*z);
			if (distance>400)
			{
				breakOutMissile[i].m_available_flag=TRUE;
				//breakOutMissile[i].m_active_flag=FALSE;
			}
		}
	}

	if(objBreakOut.m_hit>=1)
	{
		objBreakOut.m_hit=0;
		EnemyEngine[0].x=(GLfloat) (rand()%300);
		EnemyEngine[0].z=(GLfloat) (rand()%300);
		EnemyEngine[0].m_radians=1.57f;
		EnemyEngine[0].m_cpu_clicks=clock();
		EnemyEngine[0].m_sleep=TRUE;
		objBreakOut.m_score+=30;
		m_subtotal_score+=30;
	}



}


void cylinder(GLfloat radius,GLfloat height)
{
GLUquadricObj *obj = gluNewQuadric();
gluQuadricDrawStyle(obj,GLU_FILL);
gluQuadricNormals(obj,GLU_SMOOTH);
gluQuadricOrientation(obj,GLU_OUTSIDE);
gluQuadricTexture(obj, GL_TRUE);

/*Base Cylinder*/
glPushMatrix();
	/* Rotate about the X axis */
	glRotatef(90.0f,1.0f,0.0f,0.0f);
	/* qobj = quadric object
	baseRadius
	topRadius
	height,
	slices (Subdivisions around the Z axis)
	stacks (Subdivisions around the Z axis)
	*/
	gluCylinder(obj,radius,radius,height,10,1);
glPopMatrix(); 
/* Lid*/
glPushMatrix(); 
	glRotatef(-90.0f,1.0f,0.0f,0.0f);
	/* qobj = quadric object
	innerRadius = Inner radius of the disk
	outerRadius = Outer radius of the disk
	slices = number of subdivisions around the Z axis
	loops = number of concentric rings about the origin
	*/
	gluDisk(obj,0.0f,radius,10,2);
glPopMatrix();
	/*Bottom*/
glPushMatrix(); 
	glTranslatef(0.0f,-height,0.0f);
	glRotatef(90.0f,1.0f,0.0f,0.0f);
	/* qobj = quadric object
	innerRadius = Inner radius of the disk
	outerRadius = Outer radius of the disk
	slices = number of subdivisions around the Z axis
	loops = number of concentric rings about the origin
	*/
	gluDisk(obj,0.0f,radius,10,2);
glPopMatrix();

gluDeleteQuadric(obj);
}
void cone(GLfloat radius,GLfloat height)
{
GLUquadricObj *obj = gluNewQuadric();
gluQuadricDrawStyle(obj,GLU_FILL);
gluQuadricNormals(obj,GLU_SMOOTH);
gluQuadricOrientation(obj,GLU_OUTSIDE);
gluQuadricTexture(obj, GL_TRUE);

/*Base Cylinder*/
glPushMatrix();
	/* Rotate about the X axis */
	glRotatef(90.0f,1.0f,0.0f,0.0f);
	/* qobj = quadric object
	baseRadius
	topRadius
	height,
	slices (Subdivisions around the Z axis)
	stacks (Subdivisions around the Z axis)
	*/
	gluCylinder(obj,0,radius,height,10,1);
glPopMatrix(); 

/*Bottom*/
glPushMatrix(); 
	glTranslatef(0.0f,-height,0.0f);
	glRotatef(90.0f,1.0f,0.0f,0.0f);
	/* qobj = quadric object
	innerRadius = Inner radius of the disk
	outerRadius = Outer radius of the disk
	slices = number of subdivisions around the Z axis
	loops = number of concentric rings about the origin
	*/
	gluDisk(obj,0.0f,radius,10,2);
glPopMatrix();
gluDeleteQuadric(obj);
}
void box(GLfloat w,GLfloat h,GLfloat d)
{
	glBegin(GL_POLYGON);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(1.0f*w,	1.0f*h,	1.0f*d);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(-1.0f*w,	1.0f*h,	1.0f*d);
		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(-1.0f*w,	-1.0f*h,	1.0f*d);
		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(1.0f*w,	-1.0f*h,	1.0f*d);
	glEnd();

	glBegin(GL_POLYGON);
		glNormal3f(0.0f,0.0f,-1.0f);
		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(1.0f*w,	1.0f*h,	-1.0f*d);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(1.0f*w,	-1.0f*h,	-1.0f*d);
		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(-1.0f*w,	-1.0f*h,	-1.0f*d);
		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(-1.0f*w,	1.0f*h,	-1.0f*d);
	glEnd();

	glBegin(GL_POLYGON);
		glNormal3f(-1.0f,0.0f,0.0f);
		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(-1.0f*w,	1.0f*h,	1.0f*d);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(-1.0f*w,	1.0f*h,	-1.0f*d);
		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(-1.0f*w,	-1.0f*h,	-1.0f*d);
		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(-1.0f*w,	-1.0f*h,	1.0f*d);
	glEnd();

	glBegin(GL_POLYGON);
		glNormal3f(1.0f,0.0f,0.0f);
		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(1.0f*w,	1.0f*h,	1.0f*d);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(1.0f*w,	-1.0f*h,	1.0f*d);
		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(1.0f*w,	-1.0f*h,	-1.0f*d);
		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(1.0f*w,	1.0f*h,	-1.0f*d);
	glEnd();

	glBegin(GL_POLYGON);
		glNormal3f(0.0f,1.0f,0.0f);
		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(-1.0f*w,	1.0f*h,	-1.0f*d);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(-1.0f*w,	1.0f*h,	1.0f*d);
		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(1.0f*w,	1.0f*h,	1.0f*d);
		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(1.0f*w,	1.0f*h,	-1.0f*d);
	glEnd();

	glBegin(GL_POLYGON);
		glNormal3f(0.0f,-1.0f,0.0f);
		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(-1.0f*w,	-1.0f*h,	-1.0f*d);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(1.0f*w,	-1.0f*h,	-1.0f*d);
		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(1.0f*w,	-1.0f*h,	1.0f*d);
		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(-1.0f*w,	-1.0f*h,	1.0f*d);
	glEnd();

}
void brassMaterial()
{
	  setAmbientMaterialColor(0.329412f,0.223529f,0.027451f,1.0f);
	  setDiffuseMaterialColor(0.780392f,0.568627f,0.113725f,1.0f);
	  setSpecularMaterialColor(0.992157f,0.941176f,0.807843f,1.0f);
      setMaterialShininess(27.8974f);
}
void pewterMaterial()
{
	setAmbientMaterialColor(0.10588f,0.058824f,0.113725f,1.0f);
	setDiffuseMaterialColor(0.427451f,0.470588f,0.541176f,1.0f);
	setSpecularMaterialColor(0.3333f,0.3333f,0.521569f,1.0f);
	setMaterialShininess(9.84615f);
}
void blackPlasticMaterial()
{
	setAmbientMaterialColor(0.0f,0.0f,0.0f,1.0f);
	setDiffuseMaterialColor(0.01f,0.01f,0.01f,1.0f);
	setSpecularMaterialColor(0.50f,0.50f,0.50f,1.0f);
	//setMaterialShininess(32);
	setMaterialShininess(64.0f);
}
void goldMaterial()
{
	setAmbientMaterialColor(0.24725f,0.1995f,0.0745f,1.0f);
	setDiffuseMaterialColor(0.75164f,0.60648f,0.22648f,1.0f);
	setSpecularMaterialColor(0.628281f,0.555802f,0.366065f,1.0f);
	setMaterialShininess(100.0f);
}
void bronzeMaterial()
{
	setAmbientMaterialColor(0.2125f,0.1275f,0.054f,1.0f);
	setDiffuseMaterialColor(0.714f,0.4284f,0.18144f,1.0f);
	setSpecularMaterialColor(0.393548f,0.271906f,0.166721f,1.0f);
	setMaterialShininess(25.6f);
}
void chromeMaterial()
{
	setAmbientMaterialColor(0.25f,0.25f,0.25f,1.0f);
	setDiffuseMaterialColor(0.4f,0.4f,0.4f,1.0f);
	setSpecularMaterialColor(0.774597f,0.774597f,0.774597f,1.0f);
	setMaterialShininess(76.8f);
}
void copperMaterial()
{
	setAmbientMaterialColor(0.19125f,0.0735f,0.0225f,1.0f);
	setDiffuseMaterialColor(0.7038f,0.27048f,0.0828f,1.0f);
	setSpecularMaterialColor(0.256777f,0.137622f,0.086014f,1.0f);
	setMaterialShininess(12.8f);
}
void silverMaterial()
{
	setAmbientMaterialColor(0.19125f,0.19225f,0.19225f,1.0f);
	setDiffuseMaterialColor(0.50754f,0.50754f,0.50754f,1.0f);
	setSpecularMaterialColor(0.508273f,0.508273f,0.508273f,1.0f);
	setMaterialShininess(51.2f);
}
void setDiffuseMaterialColor(GLfloat red, GLfloat green, GLfloat blue,GLfloat alpha)
{
	GLfloat diff[4];
	diff[0]=red;
	diff[1]=green;
	diff[2]=blue;
	diff[3]=alpha;
	glMaterialfv(GL_FRONT, GL_DIFFUSE,diff); 

}
void setAmbientMaterialColor(GLfloat red, GLfloat green, GLfloat blue,GLfloat alpha)
{
	GLfloat amb[4];
	amb[0]=red;
	amb[1]=green;
	amb[2]=blue;
	amb[3]=alpha;
	glMaterialfv(GL_FRONT, GL_AMBIENT,amb); 

}
void setSpecularMaterialColor(GLfloat red, GLfloat green, GLfloat blue,GLfloat alpha)
{
	GLfloat spec[4];
	spec[0]=red;
	spec[1]=green;
	spec[2]=blue;
	spec[3]=alpha;
	glMaterialfv(GL_FRONT, GL_SPECULAR,spec); 

}
void setMaterialShininess(GLfloat shininess)
{
	glMateriali(GL_FRONT, GL_SHININESS, (GLint) shininess);
}
void sphere(GLfloat radius)
{
	GLUquadricObj *obj = gluNewQuadric();
	gluQuadricDrawStyle(obj,GLU_FILL);
	gluQuadricNormals(obj,GLU_SMOOTH);
	gluQuadricOrientation(obj,GLU_OUTSIDE);
	gluQuadricTexture(obj, GL_TRUE);

	gluSphere(obj, radius, 8, 8);
	gluDeleteQuadric(obj);
}

void point_sphere(GLfloat radius)
{
	GLUquadricObj *obj = gluNewQuadric();
	gluQuadricDrawStyle(obj,GLU_POINT);
	//gluQuadricDrawStyle(obj,GLU_FILL);
	//gluQuadricNormals(obj,GLU_SMOOTH);
	//gluQuadricOrientation(obj,GLU_OUTSIDE);
	//gluQuadricTexture(obj, GL_TRUE);

	gluSphere(obj, radius, 8, 8);
	gluDeleteQuadric(obj);
}

VECTOR_STRUCT_TYPE* rotate(GLfloat angle,GLfloat ux,GLfloat uy,GLfloat uz, VECTOR_STRUCT_TYPE *vector)
{
MATRIX4X4 Mt;
MATRIX1X4 Mp;
MATRIX1X4 Mr;

float sinTheta;
float cosTheta;
VECTOR_STRUCT_TYPE *ret_vector;

ret_vector= (VECTOR_STRUCT_TYPE *) malloc (sizeof(VECTOR_STRUCT_TYPE));

sinTheta=(float)sin(angle/180.0f*3.142);
cosTheta=(float)cos(angle/180.0f*3.142);

Mt[0][0]= cosTheta+(1-cosTheta)*pow(ux,2);
Mt[0][1]= (1-cosTheta)*uy*ux-sinTheta*uz; 
Mt[0][2]= (1-cosTheta)*uz*ux+sinTheta*uy;
Mt[0][3]= 0.0f;  

Mt[1][0]= (1-cosTheta)*ux*uy+sinTheta*uz;
Mt[1][1]= cosTheta+(1-cosTheta)*pow(uy,2);
Mt[1][2]= (1-cosTheta)*uz*uy-sinTheta*ux;
Mt[1][3]= 0.0f; 

Mt[2][0]= (1-cosTheta)*ux*uz-sinTheta*uy;
Mt[2][1]= (1-cosTheta)*uy*uz+sinTheta*ux;
Mt[2][2]= cosTheta+(1-cosTheta)*pow(uz,2);
Mt[2][3]= 0.0f;

Mt[3][0]=0;
Mt[3][1]=0;
Mt[3][2]=0;
Mt[3][3]=1;

Mp[0][0]=vector->m_x;
Mp[0][1]=vector->m_y;
Mp[0][2]=vector->m_z;
Mp[0][3]=1;


Matrix1X4_4X4(&Mr,&Mp,&Mt); 

ret_vector->m_x=(float)Mr[0][0];
ret_vector->m_y=(float)Mr[0][1];
ret_vector->m_z=(float)Mr[0][2];
return(ret_vector);

}

double Matrix4X1_1X4(MATRIX4X1 *matrix1, MATRIX1X4 *matrix2)
{
register int k;
double result=0.0;
	for (k = 0 ; k < 4 ; k++)
		result += (*matrix1)[k][0] * (*matrix2)[0][k];
	return(result);
}
void Matrix4X1_4X4(MATRIX4X1 *result, MATRIX4X1 *matrix1, MATRIX4X4 *matrix2)
{
register int i, k;
MATRIX4X1 temp_matrix;
	for (i = 0 ; i < 4 ; i++)
	{
	temp_matrix[i][0] = 0.0;
		for (k = 0 ; k < 4 ; k++)
		{
			temp_matrix[i][0] += (*matrix1)[k][0] * (*matrix2)[i][k];
		}
	}
	for (i = 0 ; i < 4 ; i++)
		(*result)[i][0] = temp_matrix[i][0];
}
void Matrix1X4_4X4(MATRIX1X4 *result, MATRIX1X4 *matrix1, MATRIX4X4 *matrix2)
{
register int i, k;
MATRIX4X1 temp_matrix;
	for (i = 0 ; i < 4 ; i++)
	{
		temp_matrix[i][0] = 0.0;
			for (k = 0 ; k < 4 ; k++)
			{
				temp_matrix[i][0] += (*matrix1)[0][k] * (*matrix2)[i][k];
			}
	}
	for (i = 0 ; i < 4 ; i++)
		(*result)[0][i] = temp_matrix[i][0];
}
int getAvailableExplosion()
{
	int i;
	for(i=0; i<EXPLOSION_SIZE; i++)
	{
		if (objExplosion[i].m_available_flag==TRUE)
			//objExplosion[i].m_active_flag=TRUE;
			objExplosion[i].m_available_flag=FALSE;
			return(i);
	}
	return(-1);

}
void torus(GLfloat innerRadius,	GLfloat outerRadius)
{
	GLfloat vertexes[4][3];
	GLfloat normal[3];
	GLfloat x;
	GLfloat y;
	GLfloat z;
	GLfloat phi;
	GLfloat theta;
	GLfloat CosPhi;
	GLfloat SinPhi;
	GLfloat SinTheta;
	GLfloat CosTheta;

	for(phi=0.0f; phi <= 360.0f; phi+=20.0f)
	{
		for(theta=0.0f; theta<=360.0f; theta+=20.0f)
		{
		CosPhi=(GLfloat)cos(phi/180.0*3.142);
		SinPhi=(GLfloat)sin(phi/180.0*3.142);
		CosTheta=(GLfloat)cos(theta/180.0*3.142);
		SinTheta=(GLfloat)sin(theta/180.0*3.142);
		/*Vertex 1*/
		x= CosTheta * (CosPhi * innerRadius+outerRadius);
		y= SinTheta * (CosPhi * innerRadius+outerRadius);
		z= (SinPhi) * innerRadius;
		vertexes[0][0]=x;
		vertexes[0][1]=y;
		vertexes[0][2]=z;
		/*Vertex 2*/
		CosPhi=(GLfloat)cos(phi/180.0*3.142);
		SinPhi=(GLfloat)sin(phi/180.0*3.142);
		CosTheta=(GLfloat)cos((theta+20)/180.0*3.142);
		SinTheta=(GLfloat)sin((theta+20)/180.0*3.142);
		x= CosTheta * (CosPhi * innerRadius+outerRadius);
		y= SinTheta * (CosPhi * innerRadius+outerRadius);
		z= (SinPhi) * innerRadius;
		vertexes[1][0]=x;
		vertexes[1][1]=y;
		vertexes[1][2]=z;
		/*Vertex 3*/
		CosPhi=(GLfloat)cos((phi+20)/180.0*3.142);
		SinPhi=(GLfloat)sin((phi+20)/180.0*3.142);
		CosTheta=(GLfloat)cos((theta+20)/180.0*3.142);
		SinTheta=(GLfloat)sin((theta+20)/180.0*3.142);
		x= CosTheta * (CosPhi * innerRadius+outerRadius);
		y= SinTheta * (CosPhi * innerRadius+outerRadius);
		z= (SinPhi) * innerRadius;
		vertexes[2][0]=x;
		vertexes[2][1]=y;
		vertexes[2][2]=z;
		/*Vertex 4*/
		CosPhi=(GLfloat)cos((phi+20)/180.0*3.142);
		SinPhi=(GLfloat)sin((phi+20)/180.0*3.142);
		CosTheta=(GLfloat)cos((theta)/180.0*3.142);
		SinTheta=(GLfloat)sin((theta)/180.0*3.142);
		x= CosTheta * (CosPhi * innerRadius+outerRadius);
		y= SinTheta * (CosPhi * innerRadius+outerRadius);
		z= (SinPhi) * innerRadius;
		vertexes[3][0]=x;
		vertexes[3][1]=y;
		vertexes[3][2]=z;
		calcNormal(vertexes,normal);
		glBegin(GL_POLYGON);
			glNormal3f(normal[0],normal[1],normal[2]);
			glVertex3f(vertexes[0][0],vertexes[0][1],vertexes[0][2]);
			glVertex3f(vertexes[1][0],vertexes[1][1],vertexes[1][2]);
			glVertex3f(vertexes[2][0],vertexes[2][1],vertexes[2][2]);
			glVertex3f(vertexes[3][0],vertexes[3][1],vertexes[3][2]);
		glEnd();
		}
	}
}

void reduceToUnit(GLfloat vector[3])
{
float length;
length = (float)sqrt((vector[0]*vector[0]) + 
(vector[1]*vector[1]) +
(vector[2]*vector[2]));
if(length == 0.0f)
	length = 1.0f;
	vector[0] /= length;
	vector[1] /= length;
	vector[2] /= length;
}
void calcNormal2(VECTOR_STRUCT_TYPE *vertex1, VECTOR_STRUCT_TYPE *vertex2,VECTOR_STRUCT_TYPE *vertex3,GLfloat out[3])
{
float v1[3],v2[3];
static const int x = 0;
static const int y = 1;
static const int z = 2;
v1[x] = vertex1->m_x - vertex2->m_x;
v1[y] = vertex1->m_y - vertex2->m_y;
v1[z] = vertex1->m_z - vertex2->m_z;
v2[x] = vertex2->m_x - vertex3->m_x;
v2[y] = vertex2->m_y - vertex3->m_y;
v2[z] = vertex2->m_z - vertex3->m_z;
/*Cross Product*/
out[x] = v1[y]*v2[z] - v1[z]*v2[y];
out[y] = v1[z]*v2[x] - v1[x]*v2[z];
out[z] = v1[x]*v2[y] - v1[y]*v2[x];
reduceToUnit(out);

}
void calcNormal(GLfloat v[3][3], GLfloat out[3])
{
float v1[3],v2[3];
static const int x = 0;
static const int y = 1;
static const int z = 2;
v1[x] = v[0][x] - v[1][x];
v1[y] = v[0][y] - v[1][y];
v1[z] = v[0][z] - v[1][z];
v2[x] = v[1][x] - v[2][x];
v2[y] = v[1][y] - v[2][y];
v2[z] = v[1][z] - v[2][z];
/*Cross Product*/
out[x] = v1[y]*v2[z] - v1[z]*v2[y];
out[y] = v1[z]*v2[x] - v1[x]*v2[z];
out[z] = v1[x]*v2[y] - v1[y]*v2[x];
reduceToUnit(out);
}

void CMy3DFontView::OnAppAbout() 
{
	// TODO: Add your command handler code here

	CHelp dlg;

	KillTimer(1);
	
	int response=dlg.DoModal();

	if(response==IDOK)
	{
		setSpeed();
	}
	Invalidate();
}
void generateMines()
{
	int retval;
	static long current_time=clock();

	if ((clock()-current_time)>1000)
	{
		current_time=clock();
		retval=getMineObject();
		
		if(retval>-1)
		{
			objMineList[retval].m_available_flag=FALSE;
			//objMineList[retval].m_active_flag=TRUE;
			objMineList[retval].m_x=(GLfloat) GRID_SIZE;
			objMineList[retval].m_y=0.0f;
			objMineList[retval].m_z=(GLfloat) -GRID_SIZE;
			objMineList[retval].m_direction=RIGHT_DIRECTION;
		}
	}

}

int checkMineHit(GLfloat x,GLfloat y,GLfloat z)
{
int i;
int retval;
GLfloat mine_x,mine_y,mine_z;
GLfloat vector_x,vector_y,vector_z;
GLfloat distance;
int index;

	retval=0;

	for(i=0; i<MINE_LIST_SIZE; i++)
	{
		mine_x=objMineList[i].m_x;
		mine_y=objMineList[i].m_y;
		mine_z=objMineList[i].m_z;
	
		vector_x=mine_x-x;
		vector_y=mine_y-y;
		vector_z=mine_z-z;

		distance=(GLfloat) sqrt(vector_x*vector_x+vector_y*vector_y+vector_z*vector_z);

		if(distance<=20)
		{
			//objMineList[i].m_active_flag=FALSE;
			objMineList[i].m_available_flag=TRUE;

			objBreakOut.m_score+=10;
			m_subtotal_score+=10;

			index=getAvailableExplosion();
			if(index>-1)
			{
				objExplosion[index].x=mine_x;
				objExplosion[index].y=mine_y;
				objExplosion[index].z=mine_z;
				objExplosion[index].m_cpu_seconds=clock();
				objExplosion[index].type=SPHERE_TYPE;
			}

			//sound("hit.wav");
 			retval=1;
			return(retval);
		}
	}
	return(retval);
}

void BreakOut()
{
	generateMines();
	drawMineObjectList();
}
void empty()
{
}
void icosahedron()
{
	GLfloat normal[3];
	VECTOR_STRUCT_TYPE vertex[12];
	GLfloat t;

	setAmbientMaterialColor(0.0f,0.0f,0.5f,1.0f);
	setDiffuseMaterialColor(0.0f,0.0f,0.8f,1.0f);

	t=(float) sqrt((float)(5)-1)/2;

	/*Icoshedron*/
	vertex[0].m_x=0.0f;
	vertex[0].m_y=1.0f;
	vertex[0].m_z=t;

	vertex[1].m_x=0.0f;
	vertex[1].m_y=1.0f;
	vertex[1].m_z=-t;

	vertex[2].m_x=1.0f;
	vertex[2].m_y=t;
	vertex[2].m_z=0.0f;

	vertex[3].m_x=1.0f;
	vertex[3].m_y=-t;
	vertex[3].m_z=0.0f;

	vertex[4].m_x=0.0f;
	vertex[4].m_y=-1.0f;
	vertex[4].m_z=-t;

	vertex[5].m_x=0.0f;
	vertex[5].m_y=-1.0f;
	vertex[5].m_z=t;

	vertex[6].m_x=t;
	vertex[6].m_y=0.0f;
	vertex[6].m_z=1.0f;

	vertex[7].m_x=-t;
	vertex[7].m_y=0.0f;
	vertex[7].m_z=1.0f;

	vertex[8].m_x=t;
	vertex[8].m_y=0.0f;
	vertex[8].m_z=-1.0f;

	vertex[9].m_x=-t;
	vertex[9].m_y=0.0f;
	vertex[9].m_z=-1.0f;

	vertex[10].m_x=-1.0f;
	vertex[10].m_y=t;
	vertex[10].m_z=0.0f;

	vertex[11].m_x=-1.0f;
	vertex[11].m_y=-t;
	vertex[11].m_z=0.0f;

	/*Face 0 - 6,2,0*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[1],&vertex[2],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[6].m_x,vertex[6].m_y,vertex[6].m_z);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
	glEnd();

	/*Face 1 - 2,6,3*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[3],&vertex[2],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
		glVertex3f(vertex[6].m_x,vertex[6].m_y,vertex[6].m_z);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
	glEnd();

	/*Face 2 - 5,3,6*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[1],&vertex[3],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[5].m_x,vertex[5].m_y,vertex[5].m_z);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
		glVertex3f(vertex[6].m_x,vertex[6].m_y,vertex[6].m_z);
	glEnd();

	/*Face 3 - 5,6,7*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[5].m_x,vertex[5].m_y,vertex[5].m_z);
		glVertex3f(vertex[6].m_x,vertex[6].m_y,vertex[6].m_z);
		glVertex3f(vertex[7].m_x,vertex[7].m_y,vertex[7].m_z);
	glEnd();

	/*Face 4 - 0,7,6*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
		glVertex3f(vertex[7].m_x,vertex[7].m_y,vertex[7].m_z);
		glVertex3f(vertex[6].m_x,vertex[6].m_y,vertex[6].m_z);
	glEnd();


	/*Face 5 - 3,8,2*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
		glVertex3f(vertex[8].m_x,vertex[8].m_y,vertex[8].m_z);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
	glEnd();

	/*Face 6 - 2,8,1*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
		glVertex3f(vertex[8].m_x,vertex[8].m_y,vertex[8].m_z);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
	glEnd();


	/*Face 7 - 1,0,2*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
	glEnd();

	/*Face 8 - 0,1,10*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
		glVertex3f(vertex[10].m_x,vertex[10].m_y,vertex[10].m_z);
	glEnd();

		/*Face 9 - 9,10,1*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[9].m_x,vertex[9].m_y,vertex[9].m_z);
		glVertex3f(vertex[10].m_x,vertex[10].m_y,vertex[10].m_z);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
	glEnd();

		/*Face 10 - 9,1,8*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[9].m_x,vertex[9].m_y,vertex[9].m_z);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
		glVertex3f(vertex[8].m_x,vertex[8].m_y,vertex[8].m_z);
	glEnd();

		/*Face 11 - 8,3,4*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[8].m_x,vertex[8].m_y,vertex[8].m_z);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
		glVertex3f(vertex[4].m_x,vertex[4].m_y,vertex[4].m_z);
	glEnd();

		/*Face 12 - 3,5,4*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
		glVertex3f(vertex[5].m_x,vertex[5].m_y,vertex[5].m_z);
		glVertex3f(vertex[4].m_x,vertex[4].m_y,vertex[4].m_z);
	glEnd();

			/*Face 13 - 4,5,11*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[4].m_x,vertex[4].m_y,vertex[4].m_z);
		glVertex3f(vertex[5].m_x,vertex[5].m_y,vertex[5].m_z);
		glVertex3f(vertex[11].m_x,vertex[11].m_y,vertex[11].m_z);
	glEnd();

			/*Face 14 - 7,10,11*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[7].m_x,vertex[7].m_y,vertex[7].m_z);
		glVertex3f(vertex[10].m_x,vertex[10].m_y,vertex[10].m_z);
		glVertex3f(vertex[11].m_x,vertex[11].m_y,vertex[11].m_z);
	glEnd();

	/*Face 15 - 10,7,0*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[10].m_x,vertex[10].m_y,vertex[10].m_z);
		glVertex3f(vertex[7].m_x,vertex[7].m_y,vertex[7].m_z);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
	glEnd();

	/*Face 16 - 11,9,4*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[11].m_x,vertex[11].m_y,vertex[11].m_z);
		glVertex3f(vertex[9].m_x,vertex[9].m_y,vertex[9].m_z);
		glVertex3f(vertex[4].m_x,vertex[4].m_y,vertex[4].m_z);
	glEnd();

	/*Face 17 - 8,4,9*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[8].m_x,vertex[8].m_y,vertex[8].m_z);
		glVertex3f(vertex[4].m_x,vertex[4].m_y,vertex[4].m_z);
		glVertex3f(vertex[9].m_x,vertex[9].m_y,vertex[9].m_z);
	glEnd();

	/*Face 18 - 7,11,5*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[7].m_x,vertex[7].m_y,vertex[7].m_z);
		glVertex3f(vertex[11].m_x,vertex[11].m_y,vertex[11].m_z);
		glVertex3f(vertex[5].m_x,vertex[5].m_y,vertex[5].m_z);
	glEnd();
	
	/*Face 19 - 10,9,11*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[10].m_x,vertex[10].m_y,vertex[10].m_z);
		glVertex3f(vertex[9].m_x,vertex[9].m_y,vertex[9].m_z);
		glVertex3f(vertex[11].m_x,vertex[11].m_y,vertex[11].m_z);
	glEnd();

}
void tetrahedron()
{
	GLfloat normal[3];
	VECTOR_STRUCT_TYPE vertex[12];

	/*Tetrahedron*/
	vertex[0].m_x=1.0f;
	vertex[0].m_y=1.0f;
	vertex[0].m_z=1.0f;

	vertex[1].m_x=1.0f;
	vertex[1].m_y=-1.0f;
	vertex[1].m_z=-1.0f;

	vertex[2].m_x=-1.0f;
	vertex[2].m_y=-1.0f;
	vertex[2].m_z=1.0f;

	vertex[3].m_x=-1.0f;
	vertex[3].m_y=1.0f;
	vertex[3].m_z=-1.0f;

	/*Face 0 - 1,2,3*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[1],&vertex[2],&vertex[3],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
	glEnd();

	/*Face 1 - 0,3,2*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[3],&vertex[2],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
	glEnd();

	/*Face 2 - 0,1,3*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[1],&vertex[3],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
		glVertex3f(vertex[3].m_x,vertex[3].m_y,vertex[3].m_z);
	glEnd();

	/*Face 3 - 0,2,1*/
	glBegin(GL_POLYGON);
		calcNormal2(&vertex[0],&vertex[2],&vertex[1],normal);
		glNormal3f(normal[0],normal[1],normal[2]);
		glVertex3f(vertex[0].m_x,vertex[0].m_y,vertex[0].m_z);
		glVertex3f(vertex[2].m_x,vertex[2].m_y,vertex[2].m_z);
		glVertex3f(vertex[1].m_x,vertex[1].m_y,vertex[1].m_z);
	glEnd();
}
int getAvailableMissile()
{
	int i;
	for(i=0; i<NUMBER_OF_MISSILES; i++)
	{
		if (breakOutMissile[i].m_available_flag==TRUE)
		{
			return(i);
		}
	}
	return(-1);
}

void hyperboloid()
{
	GLfloat vertexes[4][3];
	GLfloat normal[3];
	GLfloat x;
	GLfloat y;
	GLfloat z;
	GLfloat phi;
	GLfloat theta;
	GLfloat v,u;
	GLfloat r;
	GLfloat h;

	r=1.0f;
	h=2.0f;

	for(phi=-180.0f; phi <= 180.0f; phi+=40.0f)
	{
		for(theta=-270.0f; theta<=90.0f; theta+=20.0f)
		{
		v=(phi/180.0f*3.142f);
		u=(theta/180.0f*3.142f);
		/*Vertex 1*/
		x= (GLfloat) (r*(1/cos(v))*cos(u));
		y= (GLfloat) (r*(1/cos(v))*sin(u));
		z= (GLfloat) (h*tan(v));
		vertexes[0][0]=x;
		vertexes[0][1]=y;
		vertexes[0][2]=z;
		/*Vertex 2*/
		v=(phi/180.0f*3.142f);
		u=((theta+20.0f)/180.0f*3.142f);

		x= (GLfloat) (r*(1/cos(v))*cos(u));
		y= (GLfloat) (r*(1/cos(v))*sin(u));
		z= (GLfloat) (h*tan(v));

		vertexes[1][0]=x;
		vertexes[1][1]=y;
		vertexes[1][2]=z;
		/*Vertex 3*/
		v=((phi+20.0f)/180.0f*3.142f);
		u=((theta+20.0f)/180.0f*3.142f);

		x= (GLfloat) (r*(1/cos(v))*cos(u));
		y= (GLfloat) (r*(1/cos(v))*sin(u));
		z= (GLfloat) (h*tan(v));

		vertexes[2][0]=x;
		vertexes[2][1]=y;
		vertexes[2][2]=z;
		/*Vertex 4*/
		v=((phi+20.0f)/180.0f*3.142f);
		u=((theta)/180.0f*3.142f);

		x= (GLfloat) (r*(1/cos(v))*cos(u));
		y= (GLfloat) (r*(1/cos(v))*sin(u));
		z= (GLfloat) (h*tan(v));

		vertexes[3][0]=x;
		vertexes[3][1]=y;
		vertexes[3][2]=z;
		calcNormal(vertexes,normal);

		glBegin(GL_POLYGON);
			glNormal3f(normal[0],normal[1],normal[2]);
			glVertex3f(vertexes[0][0],vertexes[0][1],vertexes[0][2]);
			glVertex3f(vertexes[1][0],vertexes[1][1],vertexes[1][2]);
			glVertex3f(vertexes[2][0],vertexes[2][1],vertexes[2][2]);
			glVertex3f(vertexes[3][0],vertexes[3][1],vertexes[3][2]);
		glEnd();
		}
	}
}
void buildMushRoomObject()
{
 int i;
 int j;
 int index;

 GLfloat x;
 GLfloat z;

    z = -45.0f;
	for(i=0; i<=9; i++)
	{
        x = -45.0f;

		for(j=0; j<=9; j++)
		{
			if(vMap[i][j] == MUSHROOM_TYPE)
			{
				index=getMushRoomObject();
				objMushRoomList[index].m_available_flag=FALSE;
				//objMushRoomList[index].m_active_flag=TRUE;
				objMushRoomList[index].m_x=x;
				objMushRoomList[index].m_y=1.5f;
				objMushRoomList[index].m_z=z;
			}
	        x = x + (GRID_SIZE/10);
		}
        z = z + (GRID_SIZE/10);
	}    

}
void CMy3DFontView::mushRoom_configuration()
{
	//Row 1
    vMap[0][0] = MUSHROOM_TYPE;
    vMap[0][1] = EMPTY_TYPE;
    vMap[0][2] = EMPTY_TYPE;
    vMap[0][3] = EMPTY_TYPE;
    vMap[0][4] = EMPTY_TYPE;
    vMap[0][5] = EMPTY_TYPE;
    vMap[0][6] = EMPTY_TYPE;
    vMap[0][7] = EMPTY_TYPE;
    vMap[0][8] = EMPTY_TYPE;
    vMap[0][9] = EMPTY_TYPE;
    //Row 2
    vMap[1][0] = EMPTY_TYPE;
    vMap[1][1] = EMPTY_TYPE;
    vMap[1][2] = EMPTY_TYPE;
    vMap[1][3] = EMPTY_TYPE;
    vMap[1][4] = EMPTY_TYPE;
    vMap[1][5] = EMPTY_TYPE;
    vMap[1][6] = EMPTY_TYPE;
    vMap[1][7] = EMPTY_TYPE;
    vMap[1][8] = EMPTY_TYPE;
    vMap[1][9] = EMPTY_TYPE;
    //Row 3
    vMap[2][0] = EMPTY_TYPE;
    vMap[2][1] = EMPTY_TYPE;
    vMap[2][2] = EMPTY_TYPE;
    vMap[2][3] = EMPTY_TYPE;
    vMap[2][4] = MUSHROOM_TYPE;
    vMap[2][5] = EMPTY_TYPE;
    vMap[2][6] = EMPTY_TYPE;
    vMap[2][7] = EMPTY_TYPE;
    vMap[2][8] = EMPTY_TYPE;
    vMap[2][9] = EMPTY_TYPE;
    //Row 4
    vMap[3][0] = EMPTY_TYPE;
    vMap[3][1] = EMPTY_TYPE;
    vMap[3][2] = EMPTY_TYPE;
    vMap[3][3] = EMPTY_TYPE;
    vMap[3][4] = EMPTY_TYPE;
    vMap[3][5] = MUSHROOM_TYPE;
    vMap[3][6] = EMPTY_TYPE;
    vMap[3][7] = EMPTY_TYPE;
    vMap[3][8] = EMPTY_TYPE;
    vMap[3][9] = EMPTY_TYPE;
    //Row 5
    vMap[4][0] = EMPTY_TYPE;
    vMap[4][1] = EMPTY_TYPE;
    vMap[4][2] = EMPTY_TYPE;
    vMap[4][3] = EMPTY_TYPE;
    vMap[4][4] = EMPTY_TYPE;
    vMap[4][5] = EMPTY_TYPE;
    vMap[4][6] = EMPTY_TYPE;
    vMap[4][7] = EMPTY_TYPE;
    vMap[4][8] = EMPTY_TYPE;
    vMap[4][9] = EMPTY_TYPE;
    //Row 6
    vMap[5][0] = EMPTY_TYPE;
    vMap[5][1] = EMPTY_TYPE;
    vMap[5][2] = EMPTY_TYPE;
    vMap[5][3] = EMPTY_TYPE;
    vMap[5][4] = EMPTY_TYPE;
    vMap[5][5] = EMPTY_TYPE;
    vMap[5][6] = EMPTY_TYPE;
    vMap[5][7] = EMPTY_TYPE;
    vMap[5][8] = EMPTY_TYPE;
    vMap[5][9] = MUSHROOM_TYPE;
    //Row 7
    vMap[6][0] = EMPTY_TYPE;
    vMap[6][1] = EMPTY_TYPE;
    vMap[6][2] = EMPTY_TYPE;
    vMap[6][3] = EMPTY_TYPE;
    vMap[6][4] = EMPTY_TYPE;
    vMap[6][5] = EMPTY_TYPE;
    vMap[6][6] = EMPTY_TYPE;
    vMap[6][7] = EMPTY_TYPE;
    vMap[6][8] = EMPTY_TYPE;
    vMap[6][9] = EMPTY_TYPE;
    //Row 8
    vMap[7][0] = MUSHROOM_TYPE;
    vMap[7][1] = EMPTY_TYPE;
    vMap[7][2] = EMPTY_TYPE;
    vMap[7][3] = EMPTY_TYPE;
    vMap[7][4] = EMPTY_TYPE;
    vMap[7][5] = EMPTY_TYPE;
    vMap[7][6] = EMPTY_TYPE;
    vMap[7][7] = EMPTY_TYPE;
    vMap[7][8] = EMPTY_TYPE;
    vMap[7][9] = EMPTY_TYPE;
    //Row 9
    vMap[8][0] = EMPTY_TYPE;
    vMap[8][1] = EMPTY_TYPE;
    vMap[8][2] = EMPTY_TYPE;
    vMap[8][3] = EMPTY_TYPE;
    vMap[8][4] = EMPTY_TYPE;
    vMap[8][5] = EMPTY_TYPE;
    vMap[8][6] = EMPTY_TYPE;
    vMap[8][7] = EMPTY_TYPE;
    vMap[8][8] = EMPTY_TYPE;
    vMap[8][9] = EMPTY_TYPE;
    //Row 10
    vMap[9][0] = EMPTY_TYPE;
    vMap[9][1] = EMPTY_TYPE;
    vMap[9][2] = EMPTY_TYPE;
    vMap[9][3] = EMPTY_TYPE;
    vMap[9][4] = EMPTY_TYPE;
    vMap[9][5] = MUSHROOM_TYPE;
    vMap[9][6] = EMPTY_TYPE;
    vMap[9][7] = EMPTY_TYPE;
    vMap[9][8] = EMPTY_TYPE;
    vMap[9][9] = EMPTY_TYPE;

}
int CMy3DFontView::getMushRoomObjectCount(int type)
{
	int i;
	int retval=0;

	if(type==MUSHROOM_TYPE)
	{
		for (i=0; i<OBJECT_LIST_SIZE; i++)
		{
			if(objMushRoomList[i].m_available_flag==FALSE)
			{
				retval++;
			}
		}
	}
	return(retval);
}

void CMy3DFontView::drawMushRoomObjectList()
{
	int i;
	int color;

		setSpecularMaterialColor(1.0f,1.0f,1.0f,1.0f);
		setMaterialShininess(128.0f);

		setAmbientMaterialColor(0.3f,0.3f,0.3f,1.0f);

		for(i=0; i<OBJECT_LIST_SIZE; i++)
		{
			if(objMushRoomList[i].m_available_flag==FALSE)
			{
				color=rand()%3;
				switch(color)
				{
				case 0:
					setDiffuseMaterialColor(0.8f,0.0f,0.0f,1.0f);
					break;
				case 1:
					setDiffuseMaterialColor(0.0f,0.8f,0.0f,1.0f);
					break;
				case 2:
					setDiffuseMaterialColor(0.0f,0.0f,0.8f,1.0f);
					break;
				case 3:
					setDiffuseMaterialColor(0.8f,0.8f,0.0f,1.0f);
					break;
				}

				glPushMatrix();
					glTranslatef(objMushRoomList[i].m_x,objMushRoomList[i].m_y,objMushRoomList[i].m_z);
					mushRoom();
				glPopMatrix();
			}
		}

}
void drawMineObjectList()
{
	int i;
	GLfloat x,y,z;
	int retval;

		for(i=0; i<MINE_LIST_SIZE; i++)
		{
			if(objMineList[i].m_available_flag==FALSE)
			{
				
				x=objMineList[i].m_x;
				y=objMineList[i].m_y;
				z=objMineList[i].m_z;

				retval=checkBreakOutHit(x,y,z);
				if(retval==1)
				{
					objMineList[i].m_available_flag=TRUE;
					//objMineList[i].m_active_flag=FALSE;
					continue;
				}

				if (checkMushRoomCollision(x,y,z)==1)
				{
					if (objMineList[i].m_direction==RIGHT_DIRECTION)
					{
						objMineList[i].m_direction=LEFT_DIRECTION;
						z+=20.0f;
					}
					else
					{
						objMineList[i].m_direction=RIGHT_DIRECTION;
						z+=20.0f;
					}
				}
				if(objMineList[i].m_direction==RIGHT_DIRECTION)
				{
					if ( ((x+10.0f)>GRID_SIZE) || (retval==1))
					{
						objMineList[i].m_direction=LEFT_DIRECTION;
						z+=20.0f;
					}
					else
					{
						if (mLevel<10)
						{
						x+=(10.0f+(mLevel*3));
						}
						else
						{
							x+=(10.0f+(30));
						}
					}
				}
				else
				{
					if ( ((x-10.0f)<-GRID_SIZE) || (retval==1))
					{
						objMineList[i].m_direction=RIGHT_DIRECTION;
						z+=20.0f;
					}
					else
					{
						if (mLevel<10)
						{
							x-=(10.0f+(mLevel*3));
						}
						else
						{
							x-=(10.0f+(30));
						}
					}
				}

				if (z>GRID_SIZE)
				{
					objMineList[i].m_available_flag=TRUE;
					//objMineList[i].m_active_flag=FALSE;
				}

				objMineList[i].m_x=x;
				objMineList[i].m_y=y;
				objMineList[i].m_z=z;

				glPushMatrix();
					glTranslatef(objMineList[i].m_x,objMineList[i].m_y,objMineList[i].m_z);
					drawMine();
				glPopMatrix();
			}
		}

}

int getMushRoomObject()
{
	int i;
	for (i=0; i<OBJECT_LIST_SIZE; i++)
	{
		if (objMushRoomList[i].m_available_flag==TRUE)
		{
			return(i);
		}
	}
	return(-1);
}
int getMineObject()
{
	int i;
	for (i=0; i<MINE_LIST_SIZE; i++)
	{
		if (objMineList[i].m_available_flag==TRUE)
		{
			return(i);
		}
	}
	return(-1);
}
int checkMushRoomCollision(GLfloat object_x,GLfloat object_y,GLfloat object_z)
{
	GLfloat distance;
	GLfloat x,y,z;
	int i;

		for(i=0; i<OBJECT_LIST_SIZE; i++)
		{
			if(objMushRoomList[i].m_available_flag==FALSE)
			{

				x=object_x-objMushRoomList[i].m_x;
				y=object_y-objMushRoomList[i].m_y;
				z=object_z-objMushRoomList[i].m_z;

				distance=(GLfloat)sqrt(x*x+y*y+z*z);

				if (distance<10)
				{
					return(1);
					break;
				}

			}
		}
		return(0);

}
void Enemy()
{
	drawEnemyMissiles();
}


void drawEnemyBody()
{
	int i;

	glPushMatrix();
		//glRotatef(spin,1,0,0);
		
		glPushMatrix();
			glRotatef(90.0f,0.0f,0.0f,1.0f);
			cylinder(5.0f,3.0f);
		glPopMatrix();

		for (i=0; i<10; i++)
		{
			glPushMatrix();
				glRotatef((GLfloat)36.0f*i,1.0f,0.0f,0.0f);
				glTranslatef(1.5f,8.0f,0.0f);
				cone(1.0f,3.0f);
			glPopMatrix();
		}

	glPopMatrix();

}
void drawEnemyLeftArm()
{
	glPushMatrix();
		glTranslatef(-5.0f,0.0f,0.0f);
		drawEnemyArm();
	glPopMatrix();
}
void drawEnemyRightArm()
{
	glPushMatrix();
		glTranslatef(6.0f,0.0f,0.0f);
		drawEnemyArm();
	glPopMatrix();
}
void drawEnemyArm()
{
	static float offset=0.0f;
	static int offset_flag=0;

	if (offset>1.8f)
	{
		offset_flag=1;
	}
	if (offset<-0.5f)
	{
		offset_flag=0;
	}

	if (offset_flag==0)
	{
		offset+=0.1f;
	}
	else
	{
		offset-=0.1f;
	}

	glPushMatrix();
		glScalef(0.5f,0.5f,0.5f);
		glRotatef(180.0f,1.0f,0.0f,0.0f);
		glPushMatrix();
			glTranslated(3.0f-offset, 0.0f, 0.0f);
			drawClamp();
		glPopMatrix();
		glPushMatrix();
			glRotated( 180.0f, 0.0f, 1.0f, 0.0f );
			glTranslated( -3.0f - offset, 0.0f, 0.0f );
			drawClamp();
		glPopMatrix();
		glTranslated( 1.5f, -1.0f, 0.0f );
		drawBase();
	glPopMatrix();

}
void drawClamp()
{
	copperMaterial();

	glBegin( GL_POLYGON );
		// front
		glNormal3d( 0.0f, 0.0f, 1.0f );
		glVertex3d( -1.0f, 12.0f, 1.0f );
		glVertex3d( -4.0f, 4.0f, 1.0f );
		glVertex3d( -4.0f, 1.0f, 1.0f );
		glVertex3d( -2.0f, 0.0f, 1.0f );
		glVertex3d( 0.0f, 0.0f, 1.0f );
		glVertex3d( 0.0f, 12.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// back
		glNormal3d( 0.0f, 0.0f, -1.0f );
		glVertex3d( 0.0f, 12.0f, -1.0f );
		glVertex3d( 0.0f, 0.0f, -1.0f );
		glVertex3d( -2.0f, 0.0f, -1.0f );
		glVertex3d( -4.0f, 1.0f, -1.0f );
		glVertex3d( -4.0f, 4.0f, -1.0f );
		glVertex3d( -1.0f, 12.0f, -1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// top
		glNormal3d( 0.0f, 1.0f, 0.0f );
		glVertex3d( 0.0f, 12.0f, -1.0f );
		glVertex3d( -1.0f, 12.0f, -1.0f );
		glVertex3d( -1.0f, 12.0f, 1.0f );
		glVertex3d( 0.0f, 12.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// left top
		glNormal3d( -0.936329177569044511547577898766f,
			0.35112344158839169183034171203725f, 0.0f );
		glVertex3d( -1.0f, 12.0f, -1.0f );
		glVertex3d( -4.0f, 4.0f, -1.0f );
		glVertex3d( -4.0f, 4.0f, 1.0f);
		glVertex3d( -1.0f, 12.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// left middle
		glNormal3d( -1.0f, 0.0f, 0.0f );
		glVertex3d( -4.0f, 4.0f, -1.0f );
		glVertex3d( -4.0f, 1.0f, -1.0f );
		glVertex3d( -4.0f, 1.0f, 1.0f );
		glVertex3d( -4.0f, 4.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// left bottom
		glNormal3d( -0.44721359549995793928183473374626f,
			-0.89442719099991587856366946749251f, 0.0f );
		glVertex3d( -4.0f, 1.0f, -1.0f );
		glVertex3d( -2.0f, 0.0f, -1.0f );
		glVertex3d( -2.0f, 0.0f, 1.0f );
		glVertex3d( -4.0f, 1.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// right
		glNormal3d( 1.0f, 0.0f, 0.0f );
		glVertex3d( 0.0f, 12.0f, 1.0f );
		glVertex3d( 0.0f, 0.0f, 1.0f );
		glVertex3d( 0.0f, 0.0f, -1.0f );
		glVertex3d( 0.0f, 12.0f, -1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// bottom
		glNormal3d( 0.0f, -1.0f, 0.0f );
		glVertex3d( 0.0f, 0.0f, 1.0f );
		glVertex3d( -2.0f, 0.0f, 1.0f );
		glVertex3d( -2.0f, 0.0f, -1.0f );
		glVertex3d( 0.0f, 0.0f, -1.0f );
	glEnd();

}
void drawBase()
{

	chromeMaterial();

	glBegin( GL_POLYGON );
		// base front
		glNormal3d( 0.0f, 0.0f, 1.0f );
		glVertex3d( -3.0f, 3.0f, 1.0f );
		glVertex3d( -3.0f, 1.0f, 1.0f );
		glVertex3d( -1.0f, 0.0f, 1.0f );
		glVertex3d( 1.0f, 0.0f, 1.0f );
		glVertex3d( 3.0f, 1.0f, 1.0f );
		glVertex3d( 3.0f, 3.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// base back
		glNormal3d( 0.0f, 0.0f, -1.0f );
		glVertex3d( 3.0f, 3.0f, -1.0f );
		glVertex3d( 3.0f, 1.0f, -1.0f );
		glVertex3d( 1.0f, 0.0f, -1.0f );
		glVertex3d( -1.0f, 0.0f, -1.0f );
		glVertex3d( -3.0f, 1.0f, -1.0f );
		glVertex3d( -3.0f, 3.0f, -1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// base top
		glNormal3d( 0.0f, 1.0f, 0.0f );
		glVertex3d( -3.0f, 3.0f, -1.0f );
		glVertex3d( -3.0f, 3.0f, 1.0f );
		glVertex3d( 3.0f, 3.0f, 1.0f );
		glVertex3d( 3.0f, 3.0f, -1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// base left
		glNormal3d( -1.0f, 0.0f, 0.0f );
		glVertex3d( -3.0f, 3.0f, -1.0f );
		glVertex3d( -3.0f, 1.0f, -1.0f );
		glVertex3d( -3.0f, 1.0f, 1.0f );
		glVertex3d( -3.0f, 3.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// base right
		glNormal3d( 1.0f, 0.0f, 0.0f );
		glVertex3d( 3.0f, 3.0f, 1.0f );
		glVertex3d( 3.0f, 1.0f, 1.0f );
		glVertex3d( 3.0f, 1.0f, -1.0f );
		glVertex3d( 3.0f, 3.0f, -1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// base bottom
		glNormal3d( 0.0f, -1.0f, 0.0f );
		glVertex3d( -1.0f, 0.0f, 1.0f );
		glVertex3d( -1.0f, 0.0f, -1.0f );
		glVertex3d( 1.0f, 0.0f, -1.0f );
		glVertex3d( 1.0f, 0.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// base bottom left
		glNormal3d( -0.44721359549995793928183473374626f,
			-0.89442719099991587856366946749251f, 0.0f );
		glVertex3d( -3.0f, 1.0f, -1.0f );
		glVertex3d( -1.0f, 0.0f, -1.0f );
		glVertex3d( -1.0f, 0.0f, 1.0f );
		glVertex3d( -3.0f, 1.0f, 1.0f );
	glEnd();

	glBegin( GL_POLYGON );
		// base bottom right
		glNormal3d( 0.44721359549995793928183473374626f,
			-0.89442719099991587856366946749251f, 0.0f );
		glVertex3d( 3.0f, 1.0f, 1.0f );
		glVertex3d( 1.0f, 0.0f, 1.0f );
		glVertex3d( 1.0f, 0.0f, -1.0f );
		glVertex3d( 3.0f, 1.0f, -1.0f );
	glEnd();

}

void drawEnemy()
{
	if (EnemyEngine[0].m_sleep==FALSE)
	{
		glPushMatrix();
			glRotatef(90.0f,0.0f,1.0f,0.0f);
			drawEnemyBody();
			drawEnemyLeftArm();
			drawEnemyRightArm();
		glPopMatrix();
	}
}
void Enemy_engine()
{
	checkEnemyCollision();
	moveEnemy();

	glTranslatef(EnemyEngine[0].x,EnemyEngine[0].y,EnemyEngine[0].z);
	glRotatef(dRadToDeg(EnemyEngine[0].m_radians+((float)PI/2.0f))+90.0f, 0.0f, 1.0f, 0.0f);

}
void checkEnemyCollision()
{
	GLfloat distance;
	GLfloat x,y,z;
	int i;
	int index;

		for(i=0; i<MINE_LIST_SIZE; i++)
		{
			if(objMineList[i].m_available_flag==FALSE)
			{

				x=EnemyEngine[0].x-objMineList[i].m_x;
				y=EnemyEngine[0].y-objMineList[i].m_y;
				z=EnemyEngine[0].z-objMineList[i].m_z;

				distance=(GLfloat)sqrt(x*x+y*y+z*z);

				if (distance<20)
				{
					objBreakOut.m_hit++;

					index=getAvailableExplosion();
					if(index>-1)
					{
						objExplosion[index].x=x;
						objExplosion[index].y=y;
						objExplosion[index].z=z;
						objExplosion[index].m_cpu_seconds=clock();
						objExplosion[index].type=SPHERE_TYPE;
					}
				}

			}
		}

}

void moveEnemy()
{

	GLfloat x,z,x2,z2;
	GLfloat distance1,distance2,distance3;
	int direction;
	GLfloat angle;
	static long current_clicks=clock();
	GLfloat old_x,old_z;
	static long mushroom_current_time=clock();

	old_x=EnemyEngine[0].x;
	old_z=EnemyEngine[0].z;


	if (EnemyEngine[0].m_sleep==TRUE)
	{
		if ((clock()-EnemyEngine[0].m_cpu_clicks)>10000)
		{
			EnemyEngine[0].m_sleep=FALSE;
		}
		return;
	}


	x=objBreakOut.m_xPos;
	z=objBreakOut.m_zPos;

	angle=EnemyEngine[0].m_radians;

	//straight line displacement
	x2 = (GLfloat) (EnemyEngine[0].m_displacement*cos(angle)+EnemyEngine[0].x);
	z2 = (GLfloat) (-EnemyEngine[0].m_displacement*sin(angle)+EnemyEngine[0].z);

	distance1=(GLfloat) sqrt((x-x2)*(x-x2)+(z-z2)*(z-z2));

	//left of center displacement
	x2 = (GLfloat) (EnemyEngine[0].m_displacement*cos(angle+(1.57f/4.0f))+EnemyEngine[0].x);
	z2 = (GLfloat) (-EnemyEngine[0].m_displacement*sin(angle+(1.57f/4.0f))+EnemyEngine[0].z);

	distance2=(GLfloat) sqrt((x-x2)*(x-x2)+(z-z2)*(z-z2));

	//right of center displacement
	x2 = (GLfloat) (EnemyEngine[0].m_displacement*cos(angle-(1.57f/4.0f))+EnemyEngine[0].x);
	z2 = (GLfloat) (-EnemyEngine[0].m_displacement*sin(angle-(1.57f/4.0f))+EnemyEngine[0].z);

	distance3=(GLfloat) sqrt((x-x2)*(x-x2)+(z-z2)*(z-z2));

	if(distance1>60)
	{

		if (
			(distance2<distance1) &&
			(distance2<distance3)
			)
			
		{
			//right
			direction=RIGHT_DIRECTION;
			EnemyEngine[0].m_displacement=1.0f;
		}
		else if(
			(distance3<distance1) &&
			(distance3<distance2)
			)
		{
			//left
			direction=LEFT_DIRECTION;
			EnemyEngine[0].m_displacement=1.0f;
		}
		else
		{
			direction=FORWARD_DIRECTION;
			EnemyEngine[0].m_displacement=5.0f;
		}
		
		moveEnemyEngine(direction);
	}
	else
	{
		if((clock()-EnemyEngine[0].m_cpu_clicks)>(1000))
		{
			if (
				(distance2<distance1) &&
				(distance2<distance3)
				)
				
			{
				//right
				direction=RIGHT_DIRECTION;
				EnemyEngine[0].m_displacement=0.1f;
			}
			else if(
				(distance3<distance1) &&
				(distance3<distance2)
				)
			{
				//left
				direction=LEFT_DIRECTION;
				EnemyEngine[0].m_displacement=0.1f;
			}
			else
			{
				direction=FORWARD_DIRECTION;
				EnemyEngine[0].m_displacement=0.2f;
				//add levels later
				if((clock()-current_clicks)>2000)
				{
					fireEnemyMissile();
					current_clicks=clock();
				}
			}

			
			moveEnemyEngine(direction);

			EnemyEngine[0].m_cpu_clicks=clock();
		
		}
	}

	
	if(EnemyEngine[0].x > GRID_SIZE)
		EnemyEngine[0].x = (GLfloat) GRID_SIZE;

	if(EnemyEngine[0].x < -GRID_SIZE)
		EnemyEngine[0].x = (GLfloat) -GRID_SIZE;

	
	if(EnemyEngine[0].z > GRID_SIZE)
	   EnemyEngine[0].z = (GLfloat) GRID_SIZE;

	if(EnemyEngine[0].z < -GRID_SIZE)
	   EnemyEngine[0].z = (GLfloat) -GRID_SIZE;

   	if(checkMushRoomCollision(EnemyEngine[0].x,3.0f,EnemyEngine[0].z)==1)
	{	
		EnemyEngine[0].x=old_x+1.0f;
		EnemyEngine[0].z=old_z;
	}
	
	if((clock()-mushroom_current_time)>6000)
	{
		if ((old_x!=EnemyEngine[0].x) &&
			(old_z!=EnemyEngine[0].z)
			)
		{
			generateMushRoom(old_x,1.0f,old_z-20.0f);
		}
		mushroom_current_time=clock();
	}

}
void moveEnemyEngine(int direction)
{
	GLfloat xDelta,zDelta;

	if(direction==RIGHT_DIRECTION)
	{
		EnemyEngine[0].m_radians+=1.57f/8.0f;
	}
	else if(direction==LEFT_DIRECTION)
	{
		EnemyEngine[0].m_radians-=1.57f/8.0f;
	}

	xDelta = (GLfloat) (EnemyEngine[0].m_displacement*cos(EnemyEngine[0].m_radians));
	zDelta = (GLfloat) (-EnemyEngine[0].m_displacement*sin(EnemyEngine[0].m_radians));
	
	EnemyEngine[0].x += xDelta;
	EnemyEngine[0].z += zDelta;

}


void drawExplosion()
{
	int i;

	for(i=0; i<EXPLOSION_SIZE; i++)
	{
		if(objExplosion[i].m_available_flag==FALSE)
		{
			if((clock()-objExplosion[i].m_cpu_seconds)>1000)
			{
				objExplosion[i].m_available_flag=TRUE;
				//objExplosion[i].m_active_flag=FALSE;
				objExplosion[i].scale_x=2.0f;
				objExplosion[i].scale_y=2.0f;
				objExplosion[i].scale_z=2.0f;
				break;
			}

			glPushMatrix();
				glTranslatef(objExplosion[i].x,objExplosion[i].y,objExplosion[i].z);
				glScalef(objExplosion[i].scale_x,objExplosion[i].scale_y,objExplosion[i].scale_z);
				objExplosion[i].scale_x+=1.0f;
				objExplosion[i].scale_y+=1.0f;
				objExplosion[i].scale_z+=1.0f;
				glRotatef(90.0f,1.0f,0.0f,0.0f);
			
				if (objExplosion[i].type==TORUS_TYPE)
				{
					setDiffuseMaterialColor(1.0f,0.0f,1.0f,0.6f);
					torus(1.0f,3.0f);
				}
				else if(objExplosion[i].type==SPHERE_TYPE)
				{
					goldMaterial();
					point_sphere(1.0f);
				}
			glPopMatrix();
		}
		
	}
}
void fireEnemyMissile()
{
	GLint i;

	i=getAvailableEnemyMissile();

	if(i>-1)
	{
		enemyMissile[i].m_x=EnemyEngine[0].x;
		enemyMissile[i].m_y=EnemyEngine[0].y;
		enemyMissile[i].m_z=EnemyEngine[0].z;
		enemyMissile[i].m_Vo=20.0f;
		enemyMissile[i].m_radians=EnemyEngine[0].m_radians;
		enemyMissile[i].m_available_flag=FALSE;
		//enemyMissile[i].m_active_flag=TRUE;
	}
}
int getAvailableEnemyMissile()
{
	int i;
	for(i=0; i<NUMBER_OF_MISSILES; i++)
	{
		if (enemyMissile[i].m_available_flag==TRUE)
		{
			return(i);
		}
	}
	return(-1);
}
void drawEnemyMissiles()
{
	GLint i=0;
	GLfloat x,z;
	GLfloat distance;
	GLint retVal;

	for(i=0; i<NUMBER_OF_MISSILES; i++)
	{
		if(enemyMissile[i].m_available_flag==FALSE)
		{
			x=(enemyMissile[i].m_Vo)*(float)cos(enemyMissile[i].m_radians);
			z=-(enemyMissile[i].m_Vo)*(float)sin(enemyMissile[i].m_radians);

			enemyMissile[i].m_x += x;
			enemyMissile[i].m_z += z;

			retVal=checkBreakOutHit(enemyMissile[i].m_x,5.0f,enemyMissile[i].m_z);

			if (retVal==1)
			{
				enemyMissile[i].m_available_flag=TRUE;
				//enemyMissile[i].m_active_flag=FALSE;
				break;
			}
			else
			{
			
				glPushMatrix();
					glTranslatef(enemyMissile[i].m_x,enemyMissile[i].m_y,enemyMissile[i].m_z);
					glScalef(0.5f,0.5f,0.5f);

					glPushMatrix();
						glRotatef(dRadToDeg(enemyMissile[i].m_radians),0.0f,1.0f,0.0f);
						glTranslatef(5.0f,10.0f,0.0f);
						glRotatef(90.0f,0.0f,1.0f,0.0f);
						toroidal_spiral();
					glPopMatrix();

				glPopMatrix();
			}

			x=EnemyEngine[0].x-enemyMissile[i].m_x;
			z=EnemyEngine[0].z-enemyMissile[i].m_z;

			distance=(float) sqrt(x*x+z*z);
			if (distance>100)
			{
				enemyMissile[i].m_available_flag=TRUE;
				//enemyMissile[i].m_active_flag=FALSE;
			}
		}
	}

	if(EnemyEngine[0].m_hit>=3)
	{
		EnemyEngine[0].m_hit=0;
		objBreakOut.m_xPos=20.0f;
		objBreakOut.m_zPos=-50.0f;
		objBreakOut.m_radians=-1.57f;
		mLives--;
	}

}

int checkEnemyHit(GLfloat x,GLfloat y,GLfloat z)
{
int retval;
GLfloat enemy_x,enemy_y,enemy_z;
GLfloat vector_x,vector_y,vector_z;
GLfloat distance;
int index;

	retval=0;

	enemy_x=EnemyEngine[0].x;
	enemy_y=EnemyEngine[0].y;
	enemy_z=EnemyEngine[0].z;

	vector_x=enemy_x-x;
	vector_y=enemy_y-y;
	vector_z=enemy_z-z;

	distance=(GLfloat) sqrt(vector_x*vector_x+vector_y*vector_y+vector_z*vector_z);

	if(distance<=10)
	{
		objBreakOut.m_hit++;

		index=getAvailableExplosion();
		if(index>-1)
		{
			objExplosion[index].x=x;
			objExplosion[index].y=y;
			objExplosion[index].z=z;
			objExplosion[index].m_cpu_seconds=clock();
			objExplosion[index].type=TORUS_TYPE;
		}


		//sound("hit.wav");
		retval=1;

		return(retval);
	}

	return(retval);
}
void toroidal_spiral()
{
	GLfloat t;
	GLfloat x,y,z;
	GLfloat a,b,c,p,q;
	GLfloat theta;

	/*
	a=radius of the torus
	b=cross section radius of the torus
	p=number of interweavings
	q=number of twists
	c=constant
	*/
		a=5.0f;
		b=3.0f;
		p=1.0f;
		q=7.0f;
		c=3.0f;

	glPushAttrib(GL_LIGHTING);
	glDisable(GL_LIGHTING);
	glRGB(255,0,0);
	glPushMatrix();
		glBegin(GL_LINE_STRIP);
		for(theta=0.0f; theta<=360.0f; theta+=1.0f)
		{
			t=(theta/180.0f*3.142f);
			x=(GLfloat)  ((a+b*cos(q*t))*cos(p*t));
			y=(GLfloat) ((a+b*cos(q*t))*sin(p*t));
			z=(GLfloat) (c*sin(q*t));
			glVertex3f(x,y,z);
		}
	glEnd();
	glPopMatrix();
	glPopAttrib();
	glEnable(GL_LIGHTING);

}
void drawMine()
{
	GLfloat glfMatColorRed[]={1.0f,0.1f,0.0f,1.0f};
	GLfloat glfMatColorYellow[]= {1.0f, 1.0f, 0.0f};
	GLfloat glfMatColorBlue[]={0.20f, 0.0f, 0.60f,1.0f};
	GLfloat glfMatColorWhite[]={0.8f, 0.8f, 0.80f,1.0f};
	GLfloat glfMatColorGrey[]={0.50f,0.50f,0.90f,1.0f};
	GLfloat glfMatColorGreen[]={0.0f, 0.6f, 0.1f,1.0f};


	glPushMatrix();
		glScalef(2.0f,2.0f,2.0f);

		glMaterialfv(GL_FRONT,GL_AMBIENT_AND_DIFFUSE,glfMatColorBlue);

		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,1.0f);
			glVertex3f(  + 0.0f ,  + 4.0f ,  + 0.0f );
			glVertex3f(  -0.25f ,  + 2.0f ,  + 0.25f );
			glVertex3f(  + 0.25f ,  + 2.0f ,  + 0.25f );
		glEnd(); /*front of spike*/
    
		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,-1.0f);
			glVertex3f(  + 0.25f ,  + 2.0f ,  -0.25f );
			glVertex3f(  -0.25f ,  + 2.0f ,  -0.25f );
			glVertex3f(  + 0.0f ,  + 4.0f ,  + 0.0f );
		glEnd();  /*back of spike*/

		glBegin(GL_POLYGON);
			glNormal3f(-1.0f,0.0f,0.0f);
			glVertex3f(  + 0.0f ,  + 4.0f ,  + 0.0f );
			glVertex3f(  -0.25f ,  + 2.0f ,  -0.25f );
			glVertex3f(  -0.25f ,  + 2.0f ,  + 0.25f );
		glEnd();  /*left of spike*/

		glBegin(GL_POLYGON);
			glNormal3f(1.0f,0.0f,0.0f);
			glVertex3f(  + 0.250f ,  + 2.0f ,  + 0.25f );
			glVertex3f(  + 0.25f ,  + 2.0f ,  -0.25f );
			glVertex3f(  + 0.0f ,  + 4.0f ,  + 0.0f );
		glEnd();  /*right of spike*/


		glMaterialfv(GL_FRONT,GL_AMBIENT_AND_DIFFUSE,glfMatColorRed);

		glBegin(GL_POLYGON);
			glNormal3f(0.0f,1.0f,0.0f);
			glVertex3f(  -0.50f ,  + 2.50f ,  -0.50f );
			glVertex3f(  -0.50f ,  + 2.50f ,  + 0.50f );
			glVertex3f(  + 0.50f ,  + 2.50f ,  + 0.50f );
			glVertex3f(  + 0.50f ,  + 2.50f ,  -0.50f );
		glEnd();      /*top of block*/
    
		glMaterialfv(GL_FRONT,GL_AMBIENT_AND_DIFFUSE,glfMatColorGrey);

		glBegin(GL_POLYGON);
			glNormal3f(0.0f,-1.0f,0.0f);
			glVertex3f(  -3.0f ,  + 0.0f ,  -3.0f );
			glVertex3f(  + 3.0f ,  + 0.0f ,  -3.0f );
			glVertex3f(  + 3.0f ,  + 0.0f ,  + 3.0f );
			glVertex3f(  -3.0f ,  + 0.0f ,  + 3.0f );
		glEnd();  /*bottom of big block*/
    
 
      
		glBegin(GL_POLYGON);
			glNormal3f(0.0f,1.0f,0.0f);
			glVertex3f(  -2.0f ,  + 2.00f ,  -2.0f );
			glVertex3f(  -2.0f ,  + 2.0f ,  + 2.0f );
			glVertex3f(  + 2.0f ,  + 2.0f ,  + 2.0f );
			glVertex3f(  + 2.0f ,  + 2.0f ,  -2.0f );
		glEnd();      /*top of big block*/

	    glMaterialfv(GL_FRONT,GL_AMBIENT_AND_DIFFUSE,glfMatColorWhite);
    
		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,1.0f);
			glVertex3f(  + 0.50f ,  + 3.0f ,  + 0.50f );
			glVertex3f(  - 0.50f ,  + 3.0f ,  + 0.50f );
			glVertex3f(  -1.0f ,  + 2.0f ,  + 1.0f );
			glVertex3f(  + 1.0f ,  + 2.0f ,  + 1.0f );
		glEnd(); /*front of block*/
    
		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,-1.0f);
			glVertex3f(  + 0.5f ,  + 3.0f ,  -0.50f );
			glVertex3f(  + 1.0f ,  + 2.0f ,  -1.0f );
			glVertex3f(  -1.0f ,  + 2.0f ,  -1.0f );
			glVertex3f(  - 0.5f ,  + 3.0f ,  - 0.50f );
		glEnd();  /*back of block*/

		glBegin(GL_POLYGON);
			glNormal3f(-1.0f,0.0f,0.0f);
			glVertex3f(  -0.50f ,  + 3.0f ,  + 0.50f );
			glVertex3f(  - 0.50f ,  + 3.0f ,  - 0.50f );
			glVertex3f(  -1.0f ,  + 2.0f ,  -1.0f );
			glVertex3f(  -1.0f ,  + 2.0f ,  + 1.0f );
		glEnd();  /*left of block*/

		glBegin(GL_POLYGON);
			glNormal3f(1.0f,0.0f,0.0f);
			glVertex3f(  + 0.50f ,  + 3.0f ,  + 0.50f );
			glVertex3f(  + 1.0f ,  + 2.0f ,  + 1.0f );
			glVertex3f(  + 1.0f ,  + 2.0f ,  -1.0f );
			glVertex3f(  + 0.50f ,  + 3.0f ,  - 0.50f );
		glEnd();  /*right of block*/
			
			
			
		glMaterialfv(GL_FRONT,GL_AMBIENT_AND_DIFFUSE,glfMatColorWhite);		
 
		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,1.0f);
			glVertex3f(  + 0.50f ,  + 2.0f ,  + 0.50f );
			glVertex3f(  - 0.50f ,  + 2.0f ,  + 0.50f );
			glVertex3f(  -0.50f ,  + 3.0f ,  + 0.50f );
			glVertex3f(  + 0.50f ,  + 3.0f ,  + 0.50f );
		glEnd(); /*front of inside of block*/
    
		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,-1.0f);
			glVertex3f(  + 0.5f ,  + 2.0f ,  -0.50f );
			glVertex3f(  + 0.50f ,  + 3.0f ,  -0.50f );
			glVertex3f(  -0.50f ,  + 3.0f ,  -0.50f );
			glVertex3f(  - 0.5f ,  + 2.0f ,  - 0.50f );
		glEnd();  /*back of  inside of block*/

		glBegin(GL_POLYGON);
			glNormal3f(1.0f,0.0f,0.0f);
			glVertex3f(  -0.50f ,  + 2.0f ,  + 0.50f );
			glVertex3f(  -0.50f ,  + 2.0f ,  -0.50f );
			glVertex3f(  - 0.50f ,  + 3.0f ,  - 0.50f );
			glVertex3f(  -0.50f ,  + 3.0f ,  + 0.50f );
		glEnd();  /*left of  inside of block*/

		glBegin(GL_POLYGON);
			glNormal3f(1.0f,0.0f,0.0f);
			glVertex3f(  + 0.50f ,  + 3.0f ,  - 0.50f );
			glVertex3f(  + 0.50f ,  + 2.0f ,  - 0.50f );
			glVertex3f(  + 0.50f ,  + 2.0f ,  +0.50f );
			glVertex3f(  + 0.50f ,  + 3.0f ,  + 0.50f );
		glEnd();  /*right of  inside of block*/		
			
		glMaterialfv(GL_FRONT,GL_AMBIENT_AND_DIFFUSE,glfMatColorGrey);

		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,1.0f);
			glVertex3f(  + 2.0f ,  + 2.0f ,  + 2.0f );
			glVertex3f(  - 2.0f ,  + 2.0f ,  + 2.0f );
			glVertex3f(  -3.0f ,  + 0.0f ,  + 3.0f );
			glVertex3f(  + 3.0f ,  + 0.0f ,  + 3.0f );
		glEnd(); /*front of big block*/
    
		glBegin(GL_POLYGON);
			glNormal3f(0.0f,0.0f,-1.0f);
			glVertex3f(  + 2.0f ,  + 2.0f ,  -2.0f );
			glVertex3f(  + 3.0f ,  + 0.0f ,  -3.0f );
			glVertex3f(  -3.0f ,  + 0.0f ,  -3.0f );
			glVertex3f(  - 2.0f ,  + 2.0f ,  - 2.00f );
		glEnd();  /*back of big block*/

		glBegin(GL_POLYGON);
			glNormal3f(-1.0f,0.0f,0.0f);
			glVertex3f(  -2.0f ,  + 2.0f ,  + 2.0f );
			glVertex3f(  - 2.0f ,  + 2.0f ,  - 2.0f );
			glVertex3f(  -3.0f ,  + 0.0f ,  -3.0f );
			glVertex3f(  -3.0f ,  + 0.0f ,  + 3.0f );
		glEnd();  /*left of big block*/

		glBegin(GL_POLYGON);
			glNormal3f(1.0f,0.0f,0.0f);
			glVertex3f(  + 2.0f ,  + 2.0f ,  + 2.0f );
			glVertex3f(  + 3.0f ,  + 0.0f ,  + 3.0f );
			glVertex3f(  + 3.0f ,  + 0.0f ,  -3.0f );
			glVertex3f(  + 2.0f ,  + 2.0f ,  - 2.0f );
		glEnd();  /*right of big block*/
		
	glPopMatrix();

}
int getAvailableBreakOutMissile()
{
	int i;
	for(i=0; i<NUMBER_OF_MISSILES; i++)
	{
		if (breakOutMissile[i].m_available_flag==TRUE)
		{
			return(i);
		}
	}
	return(-1);
}
void missileObject()
{
	glPushMatrix();
	copperMaterial();
	glScalef(0.5f,0.5f,0.5f);
	glRotatef(180.0f,0.0f,1.0f,0.0f);
	glRotatef(90.0f,0.0f,0.0f,1.0f);
	glPushMatrix();
		glPushMatrix();
			glTranslatef(0.0f,3.0f,0.0f);
			cone(1.5f,3.0f);
		glPopMatrix();

		cylinder(1.5f,10.0f);

		glPushMatrix();
			glTranslatef(0.0f,-5.0f,0.0f);
			glBegin(GL_POLYGON);
				glNormal3f(0.0f,1.0f,0.0f);
				glVertex3f(0.0f,0.0f,0.0f);
				glVertex3f(0.0f,-5.0f,0.0f);
				glVertex3f(-3.6f,-5.0f,0.0f);
				glVertex3f(-3.5f,-5.0f,0.0f);
			glEnd();

			glBegin(GL_POLYGON);
				glNormal3f(0.0f,1.0f,0.0f);
				glVertex3f(0.0f,0.0f,0.0f);
				glVertex3f(5.1f,-5.0f,0.0f);
				glVertex3f(5.0f,-5.0f,0.0f);
				glVertex3f(0.0f,-3.0f,0.0f);
			glEnd();
			
			glBegin(GL_POLYGON);
				glNormal3f(0.0f,1.0f,0.0f);
				glVertex3f(0.0f,0.0f,0.0f);
				glVertex3f(0.0f,-5.0f,0.0f);
				glVertex3f(5.0f,-5.0f,3.0f);
				glVertex3f(0.0f,-5.0f,0.0f);
			glEnd();

			glBegin(GL_POLYGON);
				glNormal3f(0.0f,1.0f,0.0f);
				glVertex3f(0.0f,0.0f,0.0f);
				glVertex3f(0.0f,-5.0f,0.0f);
				glVertex3f(5.0f,-5.0f,-3.0f);
				glVertex3f(0.0f,-5.0f,0.0f);
			glEnd();

		glPopMatrix();

	glPopMatrix();
glPopMatrix();
}
int checkBreakOutHit(GLfloat x,GLfloat y,GLfloat z)
{
int retval;
GLfloat breakOut_x,breakOut_y,breakOut_z;
GLfloat vector_x,vector_y,vector_z;
GLfloat distance;
int index;

	retval=0;

	breakOut_x=objBreakOut.m_xPos;
	breakOut_y=objBreakOut.m_yPos;
	breakOut_z=objBreakOut.m_zPos;

	vector_x=breakOut_x-x;
	vector_y=breakOut_y-y;
	vector_z=breakOut_z-z;

	distance=(GLfloat) sqrt(vector_x*vector_x+vector_y*vector_y+vector_z*vector_z);

	if(distance<=10)
	{
		EnemyEngine[0].m_hit++;

		index=getAvailableExplosion();
		if(index>-1)
		{
			objExplosion[index].x=x;
			objExplosion[index].y=y;
			objExplosion[index].z=z;
			objExplosion[index].m_cpu_seconds=clock();
			objExplosion[index].type=TORUS_TYPE;
		}

		//sound("hit.wav");
		retval=1;

		return(retval);
	}

	return(retval);
}

void mushRoom()
{

	/*
GLUnurbsObj *pNurb = NULL;
GLint nNumPoints = 4; 
GLfloat ctrlPoints[4][4][3]= {{{  -3.0f, -5.0f, 0.0f},	// u = 0,	v = 0
						      {	  -6.0f, -2.0f, 0.0f},	//			v = 1
							  {   -6.0f,  2.0f, 0.0f},	//			v = 2	
							  {   -3.0f,  5.0f, 0.0f}}, //			v = 3
							 
							  {{  -2.0f, -6.0f, 0.0f},	// u = 1	v = 0
						      {   -2.0f, -2.0f, 8.0f},	//			v = 1
							  {   -2.0f,  2.0f, 8.0f},	//			v = 2
							  {   -2.0f,  6.0f, 0.0f}},	//			v = 3
							  
							  {{   2.0f, -6.0f, 0.0f }, // u =2		v = 0
							  {    2.0f, -2.0f, 8.0f }, //			v = 1
							  {    2.0f,  2.0f, 8.0f },	//			v = 2
							  {    2.0f,  6.0f, 0.0f }},//			v = 3

							  {{   3.0f, -5.0f, 0.0f},	// u = 3	v = 0
							  {    6.0f, -2.0f, 0.0f},	//			v = 1
							  {    6.0f,  2.0f, 0.0f},	//			v = 2
							  {    3.0f,  5.0f, 0.0f}}};//			v = 3

	// Knot sequence for the NURB
	GLfloat Knots[8] = {0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f};

	pNurb = gluNewNurbsRenderer();

	gluNurbsProperty(pNurb, GLU_DISPLAY_MODE, GLU_FILL);

    gluBeginSurface(pNurb);
	
	gluNurbsSurface(pNurb, 
		8, 
		Knots, 
		8, 
		Knots, 
		4 * 3, 
		3, 
		&ctrlPoints[0][0][0], 
		4, 
		4, 
		GL_MAP2_VERTEX_3);

	
	// Done with surface
	gluEndSurface(pNurb);

	if(pNurb)
		gluDeleteNurbsRenderer(pNurb);

  */
	cylinder(5.0f,5.0f);
	glTranslatef(0.0f,1.5f,0.0f);
	cylinder(10.0f,1.0f);
}
int checkMushRoomHit(GLfloat missile_x,GLfloat missile_y,GLfloat missile_z)
{
 int i;
 GLfloat wall_x1,wall_x2;
 GLfloat wall_z1,wall_z2;
 GLfloat cellsize;
 int index;
	
	cellsize=(GLfloat)(GRID_SIZE/10.0f);

	for(i=0; i<OBJECT_LIST_SIZE; i++)
	{
		if	(objMushRoomList[i].m_available_flag==FALSE)
		{
				wall_x1=objMushRoomList[i].m_x-(cellsize/2);
				wall_x2=objMushRoomList[i].m_x+(cellsize/2);
				wall_z1=objMushRoomList[i].m_z+(cellsize/2);
				wall_z2=objMushRoomList[i].m_z-(cellsize/2);

				if (
					(missile_x>wall_x1) &&
					(missile_x<wall_x2) &&
					(missile_z<wall_z1) &&
					(missile_z>wall_z2)
				)
				{
					index=getAvailableExplosion();
					if(index>-1)
					{
						objExplosion[index].x=objMushRoomList[i].m_x;
						objExplosion[index].y=2.0f;
						objExplosion[index].z=objMushRoomList[i].m_z;
						objExplosion[index].m_cpu_seconds=clock();
						objExplosion[index].type=SPHERE_TYPE;
					}

					objMushRoomList[i].m_available_flag=TRUE;
					objBreakOut.m_score+=10;
					m_subtotal_score+=10;

					return(1);
				}
				/*

				glPushMatrix();
					glBegin(GL_LINE_LOOP);
						glVertex3f(wall_x1,5.0f,wall_z1);
						glVertex3f(wall_x2,5.0f,wall_z1);
						glVertex3f(wall_x2,5.0f,wall_z2);
						glVertex3f(wall_x1,5.0f,wall_z2);
					glEnd();
				glPopMatrix();
				*/
		} // end if
	} //end for
	return(0);

}
void generateMushRoom(GLfloat x,GLfloat y,GLfloat z)
{
	int i;

	for(i=0; i<OBJECT_LIST_SIZE; i++)
	{
		if	(objMushRoomList[i].m_available_flag==TRUE)
		{
			objMushRoomList[i].m_available_flag=FALSE;
			objMushRoomList[i].m_x=x;
			objMushRoomList[i].m_y=y;
			objMushRoomList[i].m_z=z;
			break;
		} // end if
	} //end for

}