/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Rectangle;
import java.util.Vector;

public class Canfield
extends CardGame {
    private int a;
    private int b;

    public Canfield(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Canfield", deck, gameTable, n2, n3);
    }

    protected void SetupCells() {
        for (int i2 = 0; i2 < 11; ++i2) {
            this.Table.AddCell(new TableCell());
        }
    }

    protected void Layout() {
        this.Table.Resize(24 + (6 + this.CardWidth) * 6, 30 + (this.CardHeight + 4) * 3);
        float f2 = (float)((double)this.CardWidth / 88.0);
        int n2 = (int)(14.0f * f2);
        this.Table.GetCell(1).SetPos(6, 5 + (this.CardHeight + 4));
        this.Table.GetCell(0).SetPos(6, 5 + (this.CardHeight + 4 << 1));
        TableCell tableCell = this.Table.GetCell(2);
        tableCell.SetPos(18 + this.CardWidth, 5 + this.CardHeight / 2 + 2);
        tableCell.SetCardSpacing(0, n2);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.Table.GetCell(i2 + 3).SetPos(18 + (i2 + 2) * (6 + this.CardWidth), 5);
            tableCell = this.Table.GetCell(i2 + 7);
            tableCell.SetPos(18 + (i2 + 2) * (6 + this.CardWidth), 5 + this.CardHeight + 4);
            tableCell.SetCardSpacing(0, n2);
        }
    }

    protected void PlaceCards() {
        CardWrapper cardWrapper;
        Card card;
        int n2;
        int n3 = 34;
        TableCell tableCell = this.Table.GetCell(2);
        for (n2 = 0; n2 < 13; ++n2) {
            card = this.MyDeck.Pick();
            cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(n2 == 12);
        }
        card = this.MyDeck.Pick();
        cardWrapper = this.Table.WrapCard(card);
        this.a = card.GetValue();
        this.Table.GetCell(3).AddCard(cardWrapper);
        cardWrapper.SetFrontUp(true);
        for (n2 = 7; n2 < 11; ++n2) {
            card = this.MyDeck.Pick();
            tableCell = this.Table.GetCell(n2);
            cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(true);
        }
        tableCell = this.Table.GetCell(0);
        while (n3-- > 0) {
            card = this.MyDeck.Pick();
            cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(false);
        }
        this.b = 1;
    }

    protected boolean CanMove(Card card, int n2) {
        Card card2 = this.Table.GetCell(n2).GetCard(-1);
        int n3 = card.GetValue();
        boolean bl = false;
        if (n2 >= 3 && n2 <= 6) {
            bl = card2 == null && n3 == this.a;
            if (!bl && card2 != null && card.GetSuit() == card2.GetSuit()) {
                int n4 = card2.GetValue() + 1;
                if (n4 > 13) {
                    n4 = 1;
                }
                bl = n4 == n3;
            }
        } else if (n2 >= 7 && n2 <= 11 && card2 != null && card.GetColor() != card2.GetColor()) {
            int n5 = card2.GetValue() - 1;
            if (n5 <= 0) {
                n5 = 13;
            }
            bl = n5 == n3;
        }
        return bl;
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
        if (n2 == 0) {
            TableCell tableCell = this.Table.GetCell(0);
            TableCell tableCell2 = this.Table.GetCell(1);
            UndoStep undoStep = this.NewMove(true);
            for (int i2 = 0; i2 < 3; ++i2) {
                CardWrapper cardWrapper2 = tableCell.PopCard();
                if (cardWrapper2 == null) {
                    while ((cardWrapper2 = tableCell2.PopCard()) != null) {
                        undoStep.AddMove(cardWrapper2, tableCell2);
                        cardWrapper2.SetFrontUp(false);
                        tableCell.AddCard(cardWrapper2);
                    }
                    cardWrapper2 = tableCell.PopCard();
                }
                if (cardWrapper2 == null) continue;
                undoStep.AddMove(cardWrapper2, tableCell);
                cardWrapper2.SetFrontUp(true);
                tableCell2.AddCard(cardWrapper2);
            }
            this.AddUndo(undoStep);
            if (cardWrapper != null) {
                this.Table.repaint();
            }
        }
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
        TableCell tableCell = this.Table.GetCell(n2);
        if (n2 == 1 || n2 == 2) {
            if (cardWrapper == tableCell.GetWrapper(-1)) {
                cardWrapper.SetMoving(true);
                return;
            }
        } else if (n2 >= 7) {
            if (cardWrapper == tableCell.GetWrapper(-1)) {
                cardWrapper.SetMoving(true);
                return;
            }
            int n6 = tableCell.GetCardsCount();
            Card card = null;
            boolean bl = false;
            int n7 = -1;
            while (!bl && --n6 >= 0) {
                CardWrapper cardWrapper2 = tableCell.GetWrapper(n6);
                Card card2 = cardWrapper2.GetCard();
                int n8 = 0;
                if (card != null && (n8 = card.GetValue() + 1) > 13) {
                    n8 = 1;
                }
                if (!cardWrapper2.GetFrontUp() || card != null && (card2.GetColor() == card.GetColor() || card2.GetValue() != n8)) break;
                card = cardWrapper2.GetCard();
                bl = cardWrapper == cardWrapper2;
                n7 = n6;
            }
            if (bl) {
                do {
                    cardWrapper.SetMoving(true);
                } while ((cardWrapper = tableCell.GetWrapper(++n7)) != null);
            }
        }
    }

    public void CardMouseUp(int n2, int n3) {
        Vector vector = new Vector();
        this.GetMovingCards(vector);
        if (vector.size() > 0) {
            int n4;
            Object object;
            Rectangle rectangle = new Rectangle();
            Object object2 = null;
            int n5 = 0;
            int n6 = 0;
            this.GetCardsRect(vector, rectangle);
            CardWrapper cardWrapper = (CardWrapper)vector.get(0);
            for (int i2 = 3; i2 < 11; ++i2) {
                object = this.Table.GetCell(i2);
                if (object == cardWrapper.GetCell() || (n4 = ((TableCell)object).CoverArea(rectangle)) <= n5) continue;
                object2 = object;
                n5 = n4;
                n6 = i2;
            }
            if (n5 > 25 && this.CanMove(cardWrapper.GetCard(), n6)) {
                object = this.NewMove();
                for (n4 = 0; n4 < vector.size(); ++n4) {
                    cardWrapper = (CardWrapper)vector.get(n4);
                    ((UndoStep)object).AddMove(cardWrapper);
                    ((TableCell)object2).AddCard(cardWrapper);
                }
                this.FillPiles((UndoStep)object);
                CardWrapper cardWrapper2 = this.Table.GetCell(2).GetWrapper(-1);
                if (cardWrapper2 != null) {
                    ((UndoStep)object).AddCard(cardWrapper2);
                    cardWrapper2.SetFrontUp(true);
                }
                this.AddUndo((UndoStep)object);
                if (n6 >= 3 && n6 <= 6) {
                    ++this.b;
                }
            }
        }
        super.CardMouseUp(n2, n3);
        if (this.b >= 52) {
            this.GameOver(true);
        }
    }

    protected void FillPiles(UndoStep undoStep) {
        undoStep.BeginStep(true);
        for (int i2 = 7; i2 < 11; ++i2) {
            TableCell tableCell = this.Table.GetCell(i2);
            if (tableCell.GetCard(-1) != null) continue;
            CardWrapper cardWrapper = this.Table.GetCell(2).PopCard();
            if (cardWrapper == null) {
                cardWrapper = this.Table.GetCell(1).PopCard();
            }
            if (cardWrapper == null) {
                this.CardClick(null, 0, 0);
                cardWrapper = this.Table.GetCell(1).PopCard();
            }
            if (cardWrapper == null) continue;
            undoStep.AddMove(cardWrapper);
            cardWrapper.SetFrontUp(true);
            tableCell.AddCard(cardWrapper);
        }
    }

    public void Undo() {
        super.Undo();
        this.b = 0;
        for (int i2 = 7; i2 < 11; ++i2) {
            this.b += this.Table.GetCell(i2).GetCardsCount();
        }
    }
}

