#! English version
#! Creating by Alexander Ageev (ageev@mbit.ru), from November, 15, 2002
#!
#TEMPLATE(AAERW, 'Excel read/write utility support'),FAMILY('ABC','CW20','Clarion')
#!
#!==========================================================================
#! Global extension
#!==========================================================================
#! This extension used to
#!  - Delare transfer files or use pre-declared files from dictionary
#!  - Declare and support global variables
#!
#EXTENSION (AAERWGE,'ERW global extension'),Application
#!
#!--------------------------------------------------------------------------
#!
#Prepare
#EndPrepare
#!
#SHEET, HSCROLL, ADJUST
  #TAB('Main')
    #Display('You must use global variable to store record counter.'), At(10,,180,16)
    #PROMPT('Variable:', @s32), %ERWvarCounter, Req
    #PROMPT('This variable always declared', Check), %ERWvarCounterOld, At(10)
    #Display('Please, Import storage files from "storage.dct" dictionary. Note:'), At(10,,180,16)
    #Display('  1. Set THREAD attibute'), At(10,,180,8)
    #Display('  2. Set exclusive file access (in global properties)'), At(10,,180,8)
    #Display('  3. Use variable file name (also THREADed)'), At(10,,180,8)
    #Display('  4. Both content and sheets'' names storage files must have the same driver.'), At(10,,180,16)
    #Display('  5. You can change file label and prefix, but don''t change labels of fields.'), At(10,,180,16)
    #Display('')
    #PROMPT('Content storage file:', FILE), %ERWcontLabel
    #PROMPT('Sheets'' names storage file:', FILE), %ERWsheLabel
    #Display('If this files use variable file names, enter this variables into the next fields:'), At(10,,180,16)
    #PROMPT('Content file name var:', @s32), %ERWcontName
    #PROMPT('Sheets file name var:', @s32), %ERWsheName
    #Display('If you don''t fill this variables in program before using, its will be filled by random values and files will be deleted after using:'), At(10,,180,24)
  #ENDTAB
#ENDSHEET
#!
#AtStart
  #Declare(%ErwTextOutput)
  #Declare(%ErwDrvName)
  #Set(%ErwTextOutput,0)
  #Fix(%File, %ERWsheLabel)
  #Case(Upper(%FileDriver))
  #Of('ASCII')       
    #Set(%ErwTextOutput, 1)
  #EndCase
  #Case(Upper(%FileDriver))
  #Of('TOPSPEED')
    #Set(%ErwDrvName, 'TPS')
  #Of('ASCII')       
    #Set(%ErwDrvName, 'TXT')
  #Of('DBASE4')
    #Set(%ErwDrvName, 'DBF')
  #Of('ODBC')
    #Set(%ErwDrvName, 'ODBC')
  #EndCase
#EndAt
#!
#AT(%GlobalData),Where(%ERWvarCounterOld=0)
%[21]ERWvarCounter Long, Thread
#EndAt
#!
#!
#AT(%GlobalMap),Where(%ErwTextOutput)
  ErwSetQuotes(String InpStr, *String OutStr)
  #If(%TemplateVersion='ABC')
  ErwRemQuotes(String InpStr, FileManager InpFile, *String OutStr, Long OutBufSize)
  #Else
  ErwRemQuotes(String InpStr, File InpFile, *String OutStr, Long OutBufSize)
  #EndIf
#ENDAT
#!
#AT(%ProgramProcedures),Where(%ErwTextOutput)

ErwSetQuotes Procedure(String InpStr, *String OutStr)
BufSize Long
  Code
  BufSize=Len(OutStr)
  Start#=Len(Clip(OutStr))+1
  Len#=Len(Clip(InpStr))
  If Start#>BufSize then Return.
  OutStr[Start#]='"'
  Start#+=1
  If Start#=BufSize then OutStr[Start#]='"'; Return.
  Loop I#=1 to Len#
    If InpStr[I#]='"'
      Do AddChar
      Do AddChar
    Else
      Do AddChar
    .
  .
  If Start#>BufSize then Return.
  OutStr[Start#]='"'
  Return

AddChar Routine
  If Start#>BufSize then Return.
  OutStr[Start#]=InpStr[I#]
  Start#+=1

  #Declare(%TemplateVersion)
  #IF(NOT VAREXISTS(%ABCVersion))
    #Set(%TemplateVersion, 'CLA')
  #ELSE
    #Set(%TemplateVersion, 'ABC')
  #ENDIF
  #If(%TemplateVersion='ABC')
ErwRemQuotes  Procedure(String InpStr, FileManager InpFile, *String OutStr, Long OutBufSize)
  #Else
ErwRemQuotes  Procedure(String InpStr, File InpFile, *String OutStr, Long OutBufSize)
  #EndIf
StartByte Long
  Code
  OutStr=''
  OutByte#=0
  QuotFound#=0
  StartByte=InString('"',InpStr,1,1)
  If StartByte=0 then Return.
  Loop
    Loop I#=StartByte+1 to Len(Clip(InpStr))
      If InpStr[I#]<>'"'
        If QuotFound#=1 then Return.
        Do AddChar
        Cycle
      .
      QuotFound#=1-QuotFound#
      If QuotFound#=0 then Do AddChar.
    .
    If QuotFound#=1 Then Return.

  #If(%TemplateVersion='ABC')
    If InpFile.Next()<>Level:Benign Then Return.
  #Else
    Next(InpFile)
    If ErrorCode() then Return.
  #EndIf
    StartByte=0
  .

AddChar         Routine
  OutByte#+=1
  If OutByte#=OutBufSize Then Return.
  OutStr[OutByte#]=InpStr[I#]

#ENDAT
#!
#Code(AAERWInitFilling,'Initiate ERW files filling'), Req(AAERWGE)
#SHEET, HSCROLL, ADJUST
  #TAB('Main')
    #Display('You must use variable to store current status (in order to avoid illegal operations). It can be temporary (var#) or pre-defined variable.'), At(10,,180,24)
    #ENABLE(%ERWstartusTempVar=''), Clear
      #PROMPT('Pre-defined variable:',FIELD), %ERWstartusDefVar
    #ENDENABLE
    #ENABLE(%ERWstartusDefVar=''), Clear
      #PROMPT('Temporary variable:',@s32),%ERWstartusTempVar
    #ENDENABLE
    #PROMPT('Empty storage files before filling',Check), %ERWemptyFiles, At(10)
    #Display('Variable with target'), At(10)
    #PROMPT(' Excel file name:',FIELD), %ERWexcelFileNameVar, Req
    #Prompt('Clear Excel file before filling',Check),%ErwClearExcel,Default(1), At(10)
    #Enable(%ErwClearExcel=0)
      #PROMPT('Excel file used as template',Check), %ErwTemplateFile, Default(0), At(10)
    #EndEnable
    #Enable(%ErwTemplateFile=1)
      #Display('Variable with template'), At(10)
      #PROMPT(' Excel file name:',FIELD), %ErwTemplateFileName, Req
      #Validate(%ErwTemplateFileName<>%ERWexcelFileNameVar, 'Template file and result file can''t be the same.')
      #PROMPT('Clone some template row',Check), %ErwTemplateRow, Default(1), At(10)
      #Enable(%ErwTemplateRow=1)
        #PROMPT('Sheet # with clonable row:', Expr), %ErwTemplateRowSheet, Req
        #PROMPT('Clonable Row #:', Expr), %ErwTemplateRowNum, Req
      #EndEnable
    #EndEnable
    #Display('Filling process procedures:'), At(10)
    #Button('Filling processes'), Inline, Multi(%ErwFillingProcedures, %ErwFillingProc)
      #Display('You can use several filling procedures to fill one Excel file, but only one procedure can clone record in template excel file (place this procedure first!).'), At(10,,180,24)
      #Display('PROCESS template recommended'), At(10)
      #PROMPT('Stream filling procedure:', Procedure),%ErwFillingProc, Req
      #Display('For teamplate filling procedure fill next fields by ''1'' both'), At(10,,180,8)
      #PROMPT('Filling rows on sheet #:', Expr), %ErwFillSheetNum, req
      #PROMPT('Start filling from Row #:', Expr), %ErwFillRowNum, req
    #EndButton
  #ENDTAB
  #TAB('Output Data')
    #Display('Sheet''s names:'), At(10)
    #Button('Sheet''s names'), Req, Inline, Multi(%ErwSheetNames, %ErwSheetName)
      #Display('Enter valid expression as sheet name'), At(10,,170,24)
      #Prompt('Sheet name', Expr), %ErwSheetName, Req
    #EndButton
    #Display('Cell content:'), At(10)
    #Button('Cell content'), Inline, Multi(%ErwCellContents, 'Sheet=' & %ErwCellSheet & ', Row=' & %ErwCellRow & ', Col=' & %ErwCellCol & ', Val=' & %ErwCellValue & ', Type=' & %ErwCellType)
      #Display('Enter valid expression into each entry field'), At(10)
      #Prompt('Sheet #', Expr), %ErwCellSheet, Req
      #Prompt('Row #',   Expr), %ErwCellRow, Req
      #Prompt('Col #',   Expr), %ErwCellCol, Req
      #Prompt('Content type', OPTION), %ErwCellType, Req, Default('String')
      #Prompt('INT', Radio)
      #Prompt('Real', Radio)
      #Prompt('String', Radio)
      #Prompt('INT as Date', Radio)
      #Prompt('Content Value', Expr), %ErwCellValue, Req
    #EndButton
  #ENDTAB
#ENDSHEET
#!
#AtStart
  #Declare(%ERWstartusVar)
  #If(%ERWstartusTempVar)
    #Set(%ERWstartusVar, %ERWstartusTempVar)
    #If(Sub(%ERWstartusVar,Len(%ERWstartusVar),1)<>'#')
      #Set(%ERWstartusVar, %ERWstartusVar & '#')
    #EndIf
  #Else
    #Set(%ERWstartusVar, %ERWstartusDefVar)
  #EndIf
  #Declare(%ValueForName)
  #Declare(%Value1stChar)
  #Declare(%ErwShePre)
  #Declare(%ErwConPre)
  #Fix(%File, %ERWsheLabel)
  #Set(%ErwShePre, %FilePrefix)
  #Fix(%File, %ERWcontLabel)
  #Set(%ErwConPre, %FilePrefix)
  #Declare(%ErwCurrentSheet)
  #Declare(%CurInst)
  #Set(%CurInst, %ActiveTemplateInstance)
  #Declare(%TemplateVersion)
  #IF(NOT VAREXISTS(%ABCVersion))
    #Set(%TemplateVersion, 'CLA')
  #ELSE
    #Set(%TemplateVersion, 'ABC')
  #ENDIF
#EndAt
#AT(%DataSectionAfterWindow)
ERWhiddenContentsName%CurInst String(255)
ERWhiddenSheetsName%CurInst   String(255)
ERWhiddenRunString%CurInst    String(1000)
ErwTempContName%CurInst       Long(0)
ErwTempSheName%CurInst        Long(0)
#EndAt
! SetCursor(Cursor:Wait)
%ERWstartusVar=0
Loop 1 times
  ErwTempContName%CurInst=0
  ErwTempSheName%CurInst=0
  If %ERWexcelFileNameVar='' Then %ERWstartusVar=3; Break.
  If Status(%ERWcontLabel)=0
  #IF(%ERWcontName)
    If %ERWcontName=''
      Loop ErwTempContName%CurInst=1 to 12
        %ERWcontName[ErwTempContName%CurInst]=Chr(Random(Val('a'), Val('z')))
      .
      %ERWcontName[13:16]='.tmp'
    .
  #EndIf
  #If(%TemplateVersion='ABC')
    Relate:%ERWcontLabel.Open()
  #Else
    CheckOpen(%ERWcontLabel,1,12h)
  #EndIf
    If Status(%ERWcontLabel)=0 Then %ERWstartusVar=1; Break.
  .
  If Status(%ERWsheLabel)=0
  #IF(%ERWsheName)
    If %ERWsheName=''
      Loop ErwTempSheName%CurInst=1 to 12
        %ERWsheName[ErwTempSheName%CurInst]=Chr(Random(Val('a'), Val('z')))
      .
      %ERWsheName[13:16]='.tmp'
    .
  #EndIf
  #If(%TemplateVersion='ABC')
    Relate:%ERWsheLabel.Open()
  #Else
    CheckOpen(%ERWsheLabel,1,12h)
  #EndIf
    If Status(%ERWsheLabel)=0 Then %ERWstartusVar=2; Break.
  .

  #If(%ERWemptyFiles)
  Empty(%ERWcontLabel)
  If ErrorCode() Then %ERWstartusVar=4; Break.
  Empty(%ERWsheLabel)
  If ErrorCode() Then %ERWstartusVar=5; Break.
  #EndIf
  #Set(%ErwCurrentSheet,0)
  #For(%ErwSheetNames)
    #Set(%ErwCurrentSheet, %ErwCurrentSheet + 1)
    #If(%ErwTextOutput)
  %(%ErwShePre & ':Str')= %ErwCurrentSheet & ','
  ErwSetQuotes(%ErwSheetName, %(%ErwShePre & ':Str'))
    #Else
  %(%ErwShePre & ':SHEET') = %ErwCurrentSheet
  %(%ErwShePre & ':NAME')  = %ErwSheetName
    #EndIf
  Append(%ERWsheLabel)
  If ErrorCode() Then %ERWstartusVar=6; Break.
  #EndFor
#!
  #Case(%ErwDrvName)
  #Of('DBF')
  #OrOf('TPS')
  Stream(%ERWcontLabel)
  #EndCase

  #For(%ErwCellContents)
  Clear(%(%ErwConPre & ':Record'))
    #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= %ErwCellSheet & ',' & %ErwCellRow & ',' & %ErwCellCol & ',0,' ! Style alwais 0
    #Else
  %(%ErwConPre & ':SHEET')=%ErwCellSheet
  %(%ErwConPre & ':ROW')=%ErwCellRow
  %(%ErwConPre & ':Col')=%ErwCellCol
  %(%ErwConPre & ':Value')=%ErwCellValue
    #EndIf
    #Case(%ErwCellType)
    #Of('INT')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '1,' & %ErwCellValue
      #Else
  %(%ErwConPre & ':Type')=1
  %(%ErwConPre & ':Other')=''
      #EndIf
    #Of('Real')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '2,' & %ErwCellValue
      #Else
  %(%ErwConPre & ':Type')=2
  %(%ErwConPre & ':Other')=''
      #EndIf
    #Of('String')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '3,'
  ErwSetQuotes(%ErwCellValue, %(%ErwConPre & ':Str'))
      #Else
  %(%ErwConPre & ':Type')=3
  %(%ErwConPre & ':Other')=%ErwCellValue
      #EndIf
    #Of('INT as Date')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '1,' & (%ErwCellValue-36161)
      #Else
  %(%ErwConPre & ':Type')=1
  %(%ErwConPre & ':Value')=(%ErwCellValue)-36161
  %(%ErwConPre & ':Other')=''
      #EndIf
    #EndCase
  Append(%ERWcontLabel)
  If ErrorCode() Then %ERWstartusVar=7; Break.
  #EndFor
#!
  #Declare(%ErwLoopCounter, LONG)
  #Set(%ErwLoopCounter, 1)
  #For(%ErwFillingProcedures)
    #Set(%ErwLoopCounter, %ErwLoopCounter+1)
  #EndFor
  #For(%ErwFillingProcedures), Reverse
    #Set(%ErwLoopCounter, %ErwLoopCounter-1)
    #If(%ErwClearExcel=0 and %ErwLoopCounter=1 and %ErwTemplateFile=1 and %ErwTemplateFileName and %ErwTemplateRow=1 and %ErwTemplateRowSheet and %ErwTemplateRowNum)
  %ERWvarCounter=(%ErwTemplateRowNum)+(%ErwTemplateRowSheet)*65536
    #ElsIf(%ErwFillRowNum and %ErwFillSheetNum)
  %ERWvarCounter=(%ErwFillRowNum)+(%ErwFillSheetNum)*65536
    #Else
  %ERWvarCounter=0
    #EndIf
  %ErwFillingProc
  #EndFor
.
#!
#Code(AAErwPrepAndRun,'Prepare and Run ERW utility'), Req(AAERWInitFilling)
#!
#AtStart
  #Declare(%ErwRunOtherKeys)
#EndAt
Loop 1 times
  If %ERWstartusVar<>0 Then Break.
  #Case(%ErwDrvName)
  #Of('DBF')
  #OrOf('TPS')
  Flush(%ERWcontLabel)
  #EndCase
  ERWhiddenSheetsName%CurInst   =%ERWsheLabel{Prop:Name}
  ERWhiddenContentsName%CurInst =%ERWcontLabel{Prop:Name}
  #If(%TemplateVersion='ABC')
  Access:%ERWsheLabel.Close()
  Access:%ERWcontLabel.Close()
  #Else
  Close(%ERWsheLabel)
  Close(%ERWcontLabel)
  #EndIf
  If Status(%ERWsheLabel) then Break.
  If Status(%ERWcontLabel) then Break.
  #!!!!!!!!!!!!!!!
  #If(%ErwTemplateFileName and %ErwTemplateFile)
  Copy(%ErwTemplateFileName, %ERWexcelFileNameVar)
  #EndIf
  ERWhiddenRunString%CurInst='ERW.EXE to="' & Clip(%ERWexcelFileNameVar) & '" DRV=%ErwDrvName Cont="' & Clip(ERWhiddenContentsName%CurInst) & '"'
  ERWhiddenRunString%CurInst=Clip(ERWhiddenRunString%CurInst) & ' Sheet="' & Clip(ERWhiddenSheetsName%CurInst) & '"' & '/Auto'
  #If(%ErwClearExcel)
  ERWhiddenRunString%CurInst=Clip(ERWhiddenRunString%CurInst) & ' /CE'
  #ElsIf(%ErwTemplateRow=1)
  ErwTemplateRowNum#=%ErwTemplateRowNum
  ErwTemplateRowSheet#=%ErwTemplateRowSheet
  ERWhiddenRunString%CurInst=Clip(ERWhiddenRunString%CurInst) & ' MulCount=' & (%ERWvarCounter - ErwTemplateRowNum#) & ' MulSheet=' & ErwTemplateRowSheet# & ' MulRow=' & ErwTemplateRowNum#
  #EndIf
  Run(ERWhiddenRunString%CurInst, 1)
  If ErwTempContName%CurInst
    Remove(ERWhiddenContentsName%CurInst)
    %ERWcontName=''
    ErwTempContName%CurInst=0
  .
  If ErwTempSheName%CurInst
    Remove(ERWhiddenSheetsName%CurInst)
    %ERWsheName=''
    ErwTempSheName%CurInst=0
  .
.
#!
#Code(AAErwFillClonedRow,'Fill row from file''s fields'), Req(AAERWGE)
  #Button('Cell content'), Inline, Multi(%ErwRowCellContents, 'Col=' & %ErwRowCellCol & ', Val=' & %ErwRowCellValue & ', Type=' & %ErwRowCellType)
    #Display('Enter variable (starts with ''!''), constant (in '''') or evaluated expression (starts with ''='') into each entry field'), At(10,,170,24)
    #Prompt('Col #',   Expr), %ErwRowCellCol, Req
    #Prompt('Content type', OPTION), %ErwRowCellType, Req, Default('String')
    #Prompt('INT', Radio)
    #Prompt('Real', Radio)
    #Prompt('String', Radio)
    #Prompt('INT as Date', Radio)
    #Prompt('Content Value', Expr), %ErwRowCellValue, Req
  #EndButton
#AtStart
  #Declare(%ValueForName)
  #Declare(%Value1stChar)
  #Declare(%ErwConPre)
  #Fix(%File, %ERWcontLabel)
  #Set(%ErwConPre, %FilePrefix)
  #Declare(%CurInst)
  #Set(%CurInst, %ActiveTemplateInstance)
#EndAt
#AT(%DataSectionAfterWindow), Where(%ErwTextOutput=1)
ERWhiddenSheetNum%CurInst Long
#EndAt
If %ERWvarCounter>65536
  Clear(%ErwConPre:Record)
  #If(%ErwTextOutput=0)
  %ErwConPre:SHEET=%ERWvarCounter/65536
  #Else
  ERWhiddenSheetNum%CurInst=%ERWvarCounter/65536
  #EndIf
  %ERWvarCounter=%ERWvarCounter %% 65536
ElsIf %ERWvarCounter<65536
  %ERWvarCounter+=1
.
  #If(%ErwTextOutput)
If %ERWvarCounter>0 and ERWhiddenSheetNum%CurInst>0 and ERWhiddenSheetNum%CurInst<33
  #Else
%ErwConPre:ROW=%ERWvarCounter
If %ERWvarCounter>0 and %ErwConPre:SHEET>0 and %ErwConPre:SHEET<33
  #EndIf
  #For(%ErwRowCellContents)
    #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= ERWhiddenSheetNum%CurInst & ',' & %ERWvarCounter & ',' & %ErwRowCellCol & ',0,' ! Style alwais 0
    #Else
  %(%ErwConPre & ':ROW')=%ERWvarCounter
  %(%ErwConPre & ':Col')=%ErwRowCellCol
    #EndIf
    #Case(%ErwRowCellType)
    #Of('INT')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '1,' & %ErwRowCellValue
      #Else
  %(%ErwConPre & ':Type')=1
  %(%ErwConPre & ':Value')=%ErwRowCellValue
  %(%ErwConPre & ':Other')=''
      #EndIf
    #Of('Real')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '2,' & %ErwRowCellValue
      #Else
  %(%ErwConPre & ':Type')=2
  %(%ErwConPre & ':Value')=%ErwRowCellValue
  %(%ErwConPre & ':Other')=''
      #EndIf
    #Of('String')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '3,'
  ErwSetQuotes(%ErwRowCellValue, %(%ErwConPre & ':Str'))
      #Else
  %(%ErwConPre & ':Type')=3
  %(%ErwConPre & ':Value')=%ErwRowCellValue
  %(%ErwConPre & ':Other')=%ErwRowCellValue
      #EndIf
    #Of('INT as Date')
      #If(%ErwTextOutput)
  %(%ErwConPre & ':Str')= Clip(%(%ErwConPre & ':Str')) & '1,' & ((%ErwRowCellValue)-36161)
      #Else
  %(%ErwConPre & ':Type')=1
  %(%ErwConPre & ':Value')=(%ErwRowCellValue)-36161
  %(%ErwConPre & ':Other')=''
      #EndIf
    #EndCase
  Append(%ERWcontLabel)
  #EndFor
.
#!
#Code(AAERWreading,'Read data from ERW files'), Req(AAERWGE)
  #PROMPT(' Excel file name:',FIELD), %ERWexcelFileNameVar, Req
  #Display('You must use variable to store current status (in order to avoid illegal operations). It can be temporary (var#) or pre-defined variable.'), At(10,,180,24)
  #ENABLE(%ERWstartusTempVar=''), Clear
    #PROMPT('Pre-defined variable:',FIELD), %ERWstartusDefVar
  #ENDENABLE
  #ENABLE(%ERWstartusDefVar=''), Clear
    #PROMPT('Temporary variable:',@s32),%ERWstartusTempVar
  #ENDENABLE
  #Boxed('Queue to read to')
    #PROMPT ('Queue name', Field),              %AAerwInitStorageForQueueP, REQ
    #Display('Queue fields for data')
    #PROMPT ('Sheet (Byte-Long)', Field),       %AAerwInitStorageForSheetP, REQ
    #PROMPT ('Row (Ushort-Long)', Field),       %AAerwInitStorageForRowP, REQ
    #PROMPT ('Col (Byte-Long)', Field),         %AAerwInitStorageForColP, REQ
    #PROMPT ('Type (Byte-Long)', Field),        %AAerwInitStorageForTypeP, REQ
    #PROMPT ('Value (String(32-65536))', Field), %AAerwInitStorageForValueP, REQ
  #EndBoxed
#AtStart
  #Declare(%ERWstartusVar)
  #If(%ERWstartusTempVar)
    #Set(%ERWstartusVar, %ERWstartusTempVar)
    #If(Sub(%ERWstartusVar,Len(%ERWstartusVar),1)<>'#')
      #Set(%ERWstartusVar, %ERWstartusVar & '#')
    #EndIf
  #Else
    #Set(%ERWstartusVar, %ERWstartusDefVar)
  #EndIf
  #Declare(%ErwShePre)
  #Declare(%ErwConPre)
  #Fix(%File, %ERWsheLabel)
  #Set(%ErwShePre, %FilePrefix)
  #Fix(%File, %ERWcontLabel)
  #Set(%ErwConPre, %FilePrefix)
  #Declare(%CurInst)
  #Set(%CurInst, %ActiveTemplateInstance)
  #Declare(%TemplateVersion)
  #IF(NOT VAREXISTS(%ABCVersion))
    #Set(%TemplateVersion, 'CLA')
  #ELSE
    #Set(%TemplateVersion, 'ABC')
  #ENDIF
  #Fix(%File, %ERWsheLabel)
  #Declare(%ErwDrvName)
  #Case(Upper(%FileDriver))
  #Of('TOPSPEED')
    #Set(%ErwDrvName, 'TPS')
  #Of('ASCII')       
    #Set(%ErwDrvName, 'TXT')
  #Of('DBASE4')
    #Set(%ErwDrvName, 'DBF')
  #Of('ODBC')
    #Set(%ErwDrvName, 'ODBC')
  #EndCase
#EndAt
#AT(%DataSectionAfterWindow)
ERWhiddenReadContentsName%CurInst String(255)
ERWhiddenReadSheetsName%CurInst   String(255)
ErwTempReadContName%CurInst       Long(0)
ErwTempReadSheName%CurInst        Long(0)
#EndAt
! SetCursor(Cursor:Wait)
%ERWstartusVar=0
Loop 1 times
  ErwTempReadContName%CurInst=0
  ErwTempReadSheName%CurInst=0
  If %ERWexcelFileNameVar='' Then %ERWstartusVar=3; Break.

  ERWhiddenReadContentsName%CurInst=%ERWcontLabel{Prop:Name}
  If Status(%ERWcontLabel)=0
  #IF(%ERWcontName)
    If %ERWcontName=''
      Loop ErwTempReadContName%CurInst=1 to 12
        %ERWcontName[ErwTempReadContName%CurInst]=Chr(Random(Val('a'), Val('z')))
      .
      %ERWcontName[13:16]='.tmp'
    .
    ERWhiddenReadContentsName%CurInst=%ERWcontName
  #EndIf
  Else
  #If(%TemplateVersion='ABC')
    Access:%ERWcontLabel.Close()
  #Else
    Close(%ERWcontLabel)
  #EndIf
  .
  If Status(%ERWcontLabel) then %ERWstartusVar=1; Break.

  ERWhiddenReadSheetsName%CurInst=%ERWsheLabel{Prop:Name}
  If Status(%ERWsheLabel)=0
  #IF(%ERWsheName)
    If %ERWsheName=''
      Loop ErwTempReadSheName%CurInst=1 to 12
        %ERWsheName[ErwTempReadSheName%CurInst]=Chr(Random(Val('a'), Val('z')))
      .
      %ERWsheName[13:16]='.tmp'
    .
    ERWhiddenReadSheetsName%CurInst=%ERWsheName
  #EndIf
  Else
  #If(%TemplateVersion='ABC')
    Access:%ERWsheLabel.Close()
  #Else
    Close(%ERWsheLabel)
  #EndIf
    If Status(%ERWsheLabel) Then %ERWstartusVar=2; Break.
  .
  Run('ERW.EXE From="' & Clip(%ERWexcelFileNameVar) & '" DRV=%ErwDrvName Cont="' & Clip(ERWhiddenReadContentsName%CurInst) & '" Sheet="' & Clip(ERWhiddenReadSheetsName%CurInst) & '" /CS /CC /Auto', 1)

  #If(%TemplateVersion='ABC')
  Relate:%ERWsheLabel.Open()
  #Else
  CheckOpen(%ERWsheLabel)
  #EndIf
  If Status(%ERWsheLabel)=0 then %ERWstartusVar=3; Break.
  #If(%TemplateVersion='ABC')
  Relate:%ERWcontLabel.Open()
  #Else
  CheckOpen(%ERWcontLabel)
  #EndIf
  If Status(%ERWcontLabel)=0 Then %ERWstartusVar=4; Break.

  ! Read to queue
  Set(%ERWcontLabel)
  Loop
  #If(%TemplateVersion='ABC')
    If Access:%ERWcontLabel.Next()<>Level:Benign Then Break.
  #Else
    Next(%ERWcontLabel)
    If ErrorCode() then Break.
  #EndIf
    Clear(%AAerwInitStorageForQueueP)
  #If(%ErwDrvName='TXT')
    cndldhbvdlx#=0
    cndldhbvdla#=Len(Clip(%ErwConPre:Str))

    OldCndldhbvdlx#=cndldhbvdlx#
    CurCndldhbvdlx#=0
    Loop cndldhbvdlx#=OldCndldhbvdlx#+1 to cndldhbvdla#
      ChrCndldhbvdlx#=Val(%ErwConPre:Str[cndldhbvdlx#])
      If ChrCndldhbvdlx#=Val(',') then Break.
      If InRange(ChrCndldhbvdlx#, Val('0'), Val('9'))
        CurCndldhbvdlx#=CurCndldhbvdlx#*10+ChrCndldhbvdlx#-48
    . .
    %AAerwInitStorageForSheetP=CurCndldhbvdlx#

    OldCndldhbvdlx#=cndldhbvdlx#
    CurCndldhbvdlx#=0
    Loop cndldhbvdlx#=OldCndldhbvdlx#+1 to cndldhbvdla#
      ChrCndldhbvdlx#=Val(%ErwConPre:Str[cndldhbvdlx#])
      If ChrCndldhbvdlx#=Val(',') then Break.
      If InRange(ChrCndldhbvdlx#, Val('0'), Val('9'))
        CurCndldhbvdlx#=CurCndldhbvdlx#*10+ChrCndldhbvdlx#-48
    . .
    %AAerwInitStorageForRowP=CurCndldhbvdlx#

    OldCndldhbvdlx#=cndldhbvdlx#
    CurCndldhbvdlx#=0
    Loop cndldhbvdlx#=OldCndldhbvdlx#+1 to cndldhbvdla#
      ChrCndldhbvdlx#=Val(%ErwConPre:Str[cndldhbvdlx#])
      If ChrCndldhbvdlx#=Val(',') then Break.
      If InRange(ChrCndldhbvdlx#, Val('0'), Val('9'))
        CurCndldhbvdlx#=CurCndldhbvdlx#*10+ChrCndldhbvdlx#-48
    . .
    %AAerwInitStorageForColP=CurCndldhbvdlx#

    OldCndldhbvdlx#=cndldhbvdlx#
    CurCndldhbvdlx#=0
    Loop cndldhbvdlx#=OldCndldhbvdlx#+1 to cndldhbvdla#
      ChrCndldhbvdlx#=Val(%ErwConPre:Str[cndldhbvdlx#])
      If ChrCndldhbvdlx#=Val(',') then Break.
      If InRange(ChrCndldhbvdlx#, Val('0'), Val('9'))
        CurCndldhbvdlx#=CurCndldhbvdlx#*10+ChrCndldhbvdlx#-48
    . .
    !%%AAerwInitStorageForStyleP=CurCndldhbvdlx#

    OldCndldhbvdlx#=cndldhbvdlx#
    CurCndldhbvdlx#=0
    Loop cndldhbvdlx#=OldCndldhbvdlx#+1 to cndldhbvdla#
      ChrCndldhbvdlx#=Val(%ErwConPre:Str[cndldhbvdlx#])
      If ChrCndldhbvdlx#=Val(',') then Break.
      If InRange(ChrCndldhbvdlx#, Val('0'), Val('9'))
        CurCndldhbvdlx#=CurCndldhbvdlx#*10+ChrCndldhbvdlx#-48
    . .
    %AAerwInitStorageForTypeP=CurCndldhbvdlx#

    Case %AAerwInitStorageForTypeP
    Of 1
    OrOf 2
      If cndldhbvdla# > cndldhbvdlx# Then %AAerwInitStorageForValueP=%ErwConPre:Str[cndldhbvdlx#+1 : cndldhbvdla#].
    Of 3
    #If(%TemplateVersion='ABC')
      ErwRemQuotes(%ErwConPre:Str, Access:%ERWcontLabel, %AAerwInitStorageForValueP, Size(%AAerwInitStorageForValueP))
    #Else
      ErwRemQuotes(%ErwConPre:Str, %ERWcontLabel, %AAerwInitStorageForValueP, Size(%AAerwInitStorageForValueP))
    #EndIf
    .
  #Else
    %AAerwInitStorageForSheetP=%ErwConPre:Sheet
    %AAerwInitStorageForRowP=%ErwConPre:Row
    %AAerwInitStorageForColP= %ErwConPre:Col
    %AAerwInitStorageForTypeP=%ErwConPre:Type
    Case %ErwConPre:Type
    Of 1
    OrOf 2
      %AAerwInitStorageForValueP=%ErwConPre:Value
    Of 3
      %AAerwInitStorageForValueP=%ErwConPre:Other
    Else
      If Len(Clip(%ErwConPre:Value))>0
        If Len(Clip(%ErwConPre:Other))>Len(Clip(%ErwConPre:Value))
          %AAerwInitStorageForValueP=%ErwConPre:Other
        Else
          %AAerwInitStorageForValueP=%ErwConPre:Value
    . . .
  #EndIf
    Add(%AAerwInitStorageForQueueP)
    If BAnd(records(%AAerwInitStorageForQueueP), 127)=0 then Yield.
  .

  If ErwTempReadContName%CurInst
  #If(%TemplateVersion='ABC')
    Access:%ERWcontLabel.Close()
  #Else
    Close(%ERWcontLabel)
  #EndIf
    Remove(ERWhiddenReadContentsName%CurInst)
    %ERWcontName=''
    ErwTempReadContName%CurInst=0
  .
  If ErwTempReadSheName%CurInst
  #If(%TemplateVersion='ABC')
    Access:%ERWsheLabel.Close()
  #Else
    Close(%ERWsheLabel)
  #EndIf
    Remove(ERWhiddenReadSheetsName%CurInst)
    %ERWsheName=''
    ErwTempReadSheName%CurInst=0
. .