<%@ Control Language="c#" AutoEventWireup="false" Codebehind="List.ascx.cs" Inherits="Tp.Web.ProjectSpace.Planning.UserStories.List" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<DIV class="title green">User Stories</DIV>
<br>
Show: <asp:DropDownList runat="server" ID="ddFilterByIteration" AutoPostBack=True></asp:DropDownList>
<br><br>
<asp:Panel Runat="server" ID="pnlList">
<asp:datagrid id="dgUserStories" runat="server" CssClass="table" CellSpacing="0" CellPadding="4"
	BorderWidth="0" ItemStyle-CssClass="row" HeaderStyle-CssClass="tableHead" Width="100%" 
	OnItemCreated="dgUserStories_ItemCreated" AutoGenerateColumns="False" DataKeyField="UserStoryId">
	<Columns>
		<asp:TemplateColumn>
			<HeaderTemplate>
				User Story
			</HeaderTemplate>
			<ItemTemplate>
				<b><a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/UserStories/<%# DataBinder.Eval(Container.DataItem, "UserStoryId")%>/Edit.aspx')">
				<%# DataBinder.Eval(Container.DataItem, "Name")%></a></b><br />
				<%# DataBinder.Eval(Container.DataItem, "Description")%>
			</ItemTemplate>
		</asp:TemplateColumn>
		
		
		<asp:BoundColumn HeaderText="Effort" DataField="Effort" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" />
		
		<asp:TemplateColumn>
			<HeaderTemplate>
				Business Value
			</HeaderTemplate>
			<ItemTemplate>
				<asp:Label ID="lblBusinessValue" Runat=server /></asp:Label>
			</ItemTemplate>
		</asp:TemplateColumn>
				
		<asp:TemplateColumn>
			<HeaderTemplate>
				Assign on 
			</HeaderTemplate>
			<ItemTemplate>
				<asp:DropDownList runat="server" ID="ddIterations" DataSource="<%# GetIterationsList(true) %>" DataTextField="Name" DataValueField="IterationId" /><br>
				<asp:DropDownList runat="server" ID="ddUsers" DataSource="<%# GetUsersList(true) %>" DataTextField="FullName" DataValueField="UserId" /><br>
				<asp:Label ID="lblStatus" Runat=server Font-Bold=True /></asp:Label>
				<br>
				 <nobr><asp:LinkButton Runat=server CommandName="ChangeStatus" ID="lbChangeStatus"></asp:LinkButton>,&nbsp;&nbsp;&nbsp;<a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/UserStories/<%# DataBinder.Eval(Container.DataItem, "UserStoryId")%>/Edit.aspx')">Edit</a>
				 or <asp:LinkButton Runat=server CommandName="Delete" ID="lbDelete">Delete</asp:LinkButton>?</nobr>
			</ItemTemplate>
		</asp:TemplateColumn>
	</Columns>
</asp:datagrid>
<BR>
<div style="width: 100%; text-align: right">
	<asp:Button id="btnUpdate" CssClass="button" Runat="server" Text="Assign"></asp:Button>
</div>
</asp:Panel>
<asp:Panel ID="pnlNotFound" Runat=server Visible=False>
	No User Stories found.  But you may <a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/UserStories/Add.aspx')"><b>Add a New User Story</b></a>.
</asp:Panel>

