<%@ Control Language="c#" AutoEventWireup="false" Codebehind="Edit.ascx.cs" Inherits="Tp.Web.ProjectSpace.Planning.UserStories.Edit" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<asp:Panel id="mainPanel" Runat="server">
	<DIV class="wizardTitle green">User Story</DIV>
	<TABLE class="wizardMain" id="Table1" cellSpacing="5" cellPadding="0" width="320" border="0">
		<TR>
			<TD>Title <SPAN class="warning">*</SPAN></TD>
			<TD>
				<asp:RequiredFieldValidator
					id="vldNameReq"
					EnableClientScript="False"
					ControlToValidate="txtName"
					Display="Dynamic"
					ErrorMessage="Title field should not be empty"
					CssClass="warning"
					runat="server" />
				<asp:TextBox
					id="txtName"
					runat="server"
					Width="360"
					MaxLength="140"></asp:TextBox></TD>
		</TR>
		<TR>
			<TD>Description</TD>
			<TD>
				 <asp:RegularExpressionValidator
					id="nameRegex"
					runat="server" 
					ControlToValidate="txtDescription" 
					Display="Dynamic"
					EnableClientScript="False"
					CssClass="warning"
			        ValidationExpression="^[a-zA-Z'.\s\S-]{1,2500}$" 
					ErrorMessage="Description should be no more than 2500 characters length" />
					
				<asp:TextBox
					id="txtDescription"
					runat="server"
					Width="360"
					TextMode="MultiLine"
					Height="260"></asp:TextBox></TD>
		</TR>
		<TR>
			<TD><BR>
				Effort <SPAN class="warning">*</SPAN></TD>
			<TD>
				<asp:RequiredFieldValidator
					id="vldEffort"
					ControlToValidate="txtEffort"
					Display="Dynamic"
					ErrorMessage="Effort field should not be empty"
					CssClass="warning"
					runat="server" />
				<asp:CompareValidator
					id="vldEffortCompare"
					ControlToValidate="txtEffort"
					Display="Dynamic"
					ErrorMessage="Effort should be an integer, no letters"
					CssClass="warning"
					runat="server"
					Operator="DataTypeCheck"
					Type="Integer" /><BR />
				<asp:TextBox
					id="txtEffort"
					runat="server"
					Width="26">1</asp:TextBox>
				</TD>
		</TR>
		<TR>
			<TD>Business Value</td>
			<td><asp:DropDownList
					id="ddBusinessValueId"
					runat="server" />&nbsp;&nbsp;
				Risk
				<asp:DropDownList
					id="ddRiskId"
					runat="server" /></TD>
		</TR>
		
		<TR>
			<TD>Iteration</TD>
			<TD>
				<asp:DropDownList
					id="ddIterationId"
					runat="server" /></TD>
		</TR>
		<TR>
			<TD></TD>
			<TD>
				<asp:Button id="btnAdd" CssClass="button" runat="server" Text="Save & Exit"></asp:Button>
				&nbsp;
				<asp:Button id="btnAddNext" CssClass="button" runat="server" Text="Save & Add New  >" />
			</TD>
		</TR>
	</TABLE>
</asp:Panel>
