<%@ Control Language="c#" AutoEventWireup="false" Codebehind="List.ascx.cs" Inherits="Tp.Web.ProjectSpace.Planning.Iterations.List" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<DIV class="title green">Iterations</DIV>
<br>
Iterations in: <asp:DropDownList runat="server" ID="ddFilterByRelease" AutoPostBack="True" />
<br><br>
<asp:Panel Runat="server" ID="pnlList">
<asp:datagrid id="dgIterations" runat="server" Width="100%" CssClass="table" CellSpacing="0" CellPadding="4"
	BorderWidth="0" ItemStyle-CssClass="row" HeaderStyle-CssClass="tableHead"
	OnItemCreated="dgIterations_ItemCreated" AutoGenerateColumns="False" DataKeyField="IterationId">
	<Columns>
		
		<asp:TemplateColumn>
			<HeaderTemplate>
				Iteration
			</HeaderTemplate>
			<ItemTemplate>
				<b><%# DataBinder.Eval(Container.DataItem, "Name")%></b><br />
				<%# DataBinder.Eval(Container.DataItem, "Description")%>
			</ItemTemplate>
		</asp:TemplateColumn>
		
		<asp:TemplateColumn ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center">
			<HeaderTemplate>
				Start / Finish
			</HeaderTemplate>
			<ItemTemplate>
				<asp:Panel ID="pnlDates" Runat="server">
				<nobr>
				<asp:Label ID="lblStartDate" Runat=server /></asp:Label> / 
				<asp:Label ID="lblFinishDate" Runat=server /></asp:Label>
				</nobr>
				</asp:Panel>
			</ItemTemplate>
		</asp:TemplateColumn>
		
		
		<asp:BoundColumn DataField="Velocity" HeaderText="Velocity" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign=Center />
		
		
		<asp:TemplateColumn ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center">
			<HeaderTemplate>
				User Stories
			</HeaderTemplate>
			<ItemTemplate>
				<b><asp:Label ID="lblDoneUserStoriesCount" Runat=server /></asp:Label></b>/
				<a href="<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/Iterations/<%# DataBinder.Eval(Container.DataItem, "IterationId")%>/UserStories/List.aspx">
				<b><asp:Label ID="lblTotalUserStoriesCount" Runat=server></asp:Label></b></a>
			</ItemTemplate>
		</asp:TemplateColumn>
		
		<asp:TemplateColumn>
			<ItemTemplate>
				<a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/Iterations/<%# DataBinder.Eval(Container.DataItem, "IterationId")%>/Edit.aspx')">Edit</a>
				<br>or<br>
				<asp:LinkButton Runat=server ID="lbDelete">Delete</asp:LinkButton>?
			</ItemTemplate>
		</asp:TemplateColumn>
	</Columns>
</asp:datagrid>
</asp:Panel>
<asp:Panel ID="pnlNotFound" Runat=server Visible=False>
	No Iterations found. But you may <a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/Iterations/Add.aspx')"><b>Add a New Iteration</b></a>.
	Please, make sure that at least one Release already exists. If not, you should <a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/Releases/Add.aspx')"><b>Add a New Release</b></a> first.
</asp:Panel>
