<%@ Control Language="c#" AutoEventWireup="false" Codebehind="List.ascx.cs" Inherits="Tp.Web.ProjectSpace.ProjectsList" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<div class="title orange">Projects</div>
<br>
<asp:Panel Runat="server" ID="pnlList">
<asp:datagrid id="dgProjects" CssClass="table" CellSpacing="0" CellPadding="6" BorderWidth="0"
	ItemStyle-CssClass="row" HeaderStyle-CssClass="tableHead" AutoGenerateColumns="False"
	DataKeyField="ProjectId" runat="server">
	<Columns>
		<asp:HyperLinkColumn
			HeaderText="Name"
			DataNavigateUrlField="ProjectId"
			DataNavigateUrlFormatString="~/{0}/General/Dashboard/Dashboard.aspx"
			DataTextField="Name" />
			
		<asp:BoundColumn
			HeaderText="Description"
			DataField="Description" />
		
		<asp:BoundColumn
			HeaderText="Start Date"
			ItemStyle-Wrap="False"
			DataField="StartDate"
			DataFormatString="{0:dd-MMM-yyyy}" />
		
		<asp:BoundColumn
			HeaderText="End Date"
			ItemStyle-Wrap="False"
			DataField="EndDate"
			DataFormatString="{0:dd-MMM-yyyy}" />
			
		<asp:HyperLinkColumn
			DataNavigateUrlField="ProjectId" 
			DataNavigateUrlFormatString="javascript:OpenWizard('{0}/Edit.aspx');"
			DataTextField="ProjectId"
			DataTextFormatString="{0:Edit}" />
			
		<asp:ButtonColumn
			ButtonType="LinkButton"
			CommandName="Delete"
			DataTextField="ProjectId"
			DataTextFormatString="{0:Delete}"  />
	</Columns>
</asp:datagrid>
</asp:Panel>
<asp:Panel ID="pnlNotFound" Runat=server Visible=False>
	No Projects found. But you may 
	<a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/Add.aspx')">
	<b>Add a New Project</b></a>.
</asp:Panel>