CREATE TABLE practices
(
	practice_id INTEGER  NOT NULL IDENTITY ,
	name VARCHAR (150) NOT NULL,
	description VARCHAR (600) NULL,
	is_active VARCHAR (15) NULL,
	
		CONSTRAINT pk_practices PRIMARY KEY
		(
		practice_id
		)
	
);
	
CREATE TABLE projects
(
	project_id INTEGER  NOT NULL IDENTITY ,
	name VARCHAR (150) NOT NULL,
	description VARCHAR (600) NULL,
	start_date DATETIME  NOT NULL,
	end_date DATETIME  NULL,
	
		CONSTRAINT pk_projects PRIMARY KEY
		(
		project_id
		)
	
);
	
CREATE TABLE project_plans
(
	project_plan_id INTEGER  NOT NULL IDENTITY ,
	project_id INTEGER  NOT NULL,
	
		CONSTRAINT pk_project_plans PRIMARY KEY
		(
		project_plan_id
		)
	
);
	
CREATE TABLE releases
(
	release_id INTEGER  NOT NULL IDENTITY ,
	name VARCHAR (150) NOT NULL,
	goal VARCHAR (500) NULL,
	project_plan_id INTEGER  NOT NULL,
	start_date DATETIME  NULL,
	finish_date DATETIME  NULL,
	
		CONSTRAINT pk_releases PRIMARY KEY
		(
		release_id
		)
	
);
	
CREATE TABLE iterations
(
	iteration_id INTEGER  NOT NULL IDENTITY ,
	name VARCHAR (150) NOT NULL,
	description VARCHAR (500) NULL,
	velocity DECIMAL  NULL,
	start_date DATETIME  NULL,
	release_id INTEGER  NOT NULL,
	duration INTEGER  NULL,
	
		CONSTRAINT pk_iterations PRIMARY KEY
		(
		iteration_id
		)
	
);
	
CREATE TABLE user_stories
(
	user_story_id INTEGER  NOT NULL IDENTITY ,
	name VARCHAR (250) NOT NULL,
	description VARCHAR (2500) NULL,
	effort DECIMAL  NOT NULL,
	status INTEGER  NOT NULL,
	project_plan_id INTEGER  NOT NULL,
	iteration_id INTEGER  NOT NULL,
	business_value_id INTEGER  NOT NULL,
	risk_id INTEGER  NOT NULL,
	user_id INTEGER  NULL,
	created_date DATETIME  NULL,
	completed_date DATETIME  NULL,
	
		CONSTRAINT pk_user_stories PRIMARY KEY
		(
		user_story_id
		)
	
);
	
CREATE TABLE business_value
(
	business_value_id INTEGER  NOT NULL IDENTITY ,
	value VARCHAR (25) NOT NULL,
	
		CONSTRAINT pk_business_value PRIMARY KEY
		(
		business_value_id
		)
	
);
	
CREATE TABLE risk
(
	risk_id INTEGER  NOT NULL IDENTITY ,
	value VARCHAR (25) NOT NULL,
	
		CONSTRAINT pk_risk PRIMARY KEY
		(
		risk_id
		)
	
);
	
CREATE TABLE team
(
	user_id INTEGER  NOT NULL,
	project_id INTEGER  NOT NULL,
	
		CONSTRAINT pk_team PRIMARY KEY
		(
		user_id,project_id
		)
	
);
	
CREATE TABLE users
(
	user_id INTEGER  NOT NULL IDENTITY ,
	name VARCHAR (150) NOT NULL,
	surname VARCHAR (150) NOT NULL,
	email VARCHAR (150) NULL,
	login VARCHAR (50) NOT NULL,
	password VARCHAR (50) NOT NULL,
	
		CONSTRAINT pk_users PRIMARY KEY
		(
		user_id
		)
	
);
	
ALTER TABLE releases

		ADD CONSTRAINT fk_releases_ProjectPlan FOREIGN KEY
		(
		project_plan_id
		)
		REFERENCES project_plans
		(
		project_plan_id		
		)
 ON DELETE CASCADE 
;
		
ALTER TABLE iterations

		ADD CONSTRAINT fk_iterations_Release FOREIGN KEY
		(
		release_id
		)
		REFERENCES releases
		(
		release_id		
		)
 ON DELETE CASCADE 
;
		
ALTER TABLE user_stories

		ADD CONSTRAINT fk_user_stories_ProjectPlan FOREIGN KEY
		(
		project_plan_id
		)
		REFERENCES project_plans
		(
		project_plan_id		
		)
 ON DELETE CASCADE 
;
		
ALTER TABLE team

		ADD CONSTRAINT fk_team_Project FOREIGN KEY
		(
		project_id
		)
		REFERENCES projects
		(
		project_id		
		)
 ON DELETE CASCADE 
;
		
ALTER TABLE team

		ADD CONSTRAINT fk_team_User FOREIGN KEY
		(
		user_id
		)
		REFERENCES users
		(
		user_id		
		)
 ON DELETE CASCADE 
;
		

INSERT INTO users (name, surname, email, login, password) VALUES ('Ted', 'Kein', 'www@www.com', 'ted', 'ted')
INSERT INTO users (name, surname, email, login, password) VALUES ('Mike', 'Leb', 'aaa@www.com', 'mike', 'mike')
INSERT INTO users (name, surname, email, login, password) VALUES ('Korny', 'Fisher', 'vvv@www.com', 'korny', 'korny')
INSERT INTO users (name, surname, email, login, password) VALUES ('Admin', '', '', 'admin', 'admin')


INSERT INTO risk (value) VALUES ('High')
INSERT INTO risk (value) VALUES ('Medium')
INSERT INTO risk (value) VALUES ('Low')

INSERT INTO business_value (value) VALUES ('Great')
INSERT INTO business_value (value) VALUES ('Good')
INSERT INTO business_value (value) VALUES ('Average')
INSERT INTO business_value (value) VALUES ('Nice to have')

INSERT INTO projects (name, description, start_date, end_date) VALUES ('TargetProcess', 'Development process and project management tool.', '2/2/2004', '3/4/2005')
INSERT INTO project_plans (project_id) VALUES (1)

INSERT INTO team (project_id, user_id) VALUES (1, 1)

INSERT INTO releases (name, goal, project_plan_id, start_date, finish_date) VALUES ('Release #1', 'In this release we will create basic system (so-called walking skeleton) to prove main architectural concepts', 1,  '2/2/2004', '3/4/2005')

-- Name, Description, Velocity, StartDate, ReleaseId, Duration
INSERT INTO iterations 
(name, description, velocity, start_date, release_id, duration)
VALUES
('Iteration #1', 'This is first iteration', 11, '8/24/2004', 1, 12)
INSERT INTO iterations
(name, description, velocity, start_date, release_id, duration)
VALUES ('Iteration #2', 'This is second iteration', 12, '11/26/2004', 1, 2)


-- Name, Description, Effort, Status (0|1), ProjectId, IterationId, BusinessValueId, RiskId, UserId
INSERT INTO user_stories (name, description, effort, status, project_plan_id, iteration_id, business_value_id, risk_id, user_id, created_date, completed_date)
VALUES ('Create user permissions mechanism', 'There will be several type of user permissions.', 12, 0, 1, 0, 1, 1, 1, NULL, NULL)

-- Assigned on Iteration #1 (Done)
INSERT INTO user_stories  (name, description, effort, status, project_plan_id, iteration_id, business_value_id, risk_id, user_id, created_date, completed_date)
VALUES ('Learn Ant tool', 'Install Ant and make simple build', 4, 1, 1, 1, 4, 3, 0, NULL, NULL)

INSERT INTO user_stories  (name, description, effort, status, project_plan_id, iteration_id, business_value_id, risk_id, user_id, created_date, completed_date)
VALUES ('Install Tomcat', 'Just install it on dedicated server', 1.5, 1, 1, 1, 3, 3, 0, NULL, NULL)

-- Assigned on Iteration #2 
INSERT INTO user_stories  (name, description, effort, status, project_plan_id, iteration_id, business_value_id, risk_id, user_id, created_date, completed_date)
VALUES ('Learn Struts', 'Create small test app', 4, 0, 1, 2, 2, 3, 0, NULL, NULL)
