/*
 * Name:      MicroEMACS
 *            WBC -- Culbertson's additions
 * Date:      24 November 1986
 *
 * Profile format:
 *   Multiple lines of form [<qualifiers>] <character> <function>.
 *   <qualifiers> can be "M-", "C-", and "C-X".  If "C-X" is repeated,
 *   it is parsed as C-X C- X, where the final X is the <character>.
 *   Each of the three qualifiers is treated like a shift of the
 *   <character>; the code returned consists of bits corresponding
 *   to the qualifiers OR'ed with the <character>.  <Function> is one
 *   of the strings listed in symbol.c.  The function is not contained
 *   in quotes like it is in display-bindings; otherwise, the files
 *   are similar.  Bug: I do not think RUBOUT can be represented.
 *   The qualifiers are indifferent to case.  If there are any qualifiers,
 *   then the <character> is up shifted.  White space can be spaces or
 *   tabs.  The profile file is ~\uemacs.pro; be sure to set a "HOME"
 *   environment variable.
 *   Examples:
 *     C-H       back-del-char
 *     M->       goto-eob
 *     C-M-H     back-del-word 
 *     C-X C-X   swap-dot-and-mark
 */
#include "def.h"
#define  PROLEN  128
#define  PRO_FILE "~/.uemacs_pro"

int
get_profile()
{
  char s [PROLEN],
       ch,
       *p;
  int  i;
  FILE *fp;

  strcpy (s, PRO_FILE);
  adjustcase (s);
  i = 0;
  if ((fp = fopen (s, "r")) != NULL) {
    while (NULL != fgets (s, PROLEN, fp)) {
      ++i;
      p = s;
      if (!proc_pro_binding (p, get_key_code (&p, TRUE))) {
        eprintf ("Profile file error line %d, press any key to continue.", i);
        ttgetc();
      }
    }
    fclose (fp);
  }
  return TRUE;
}

/*
 * Parse keycode from uemacs.pro.  Examples: "C-H", "C-X N", "C-X C-X",
 * "C-M-A", "M-C-A".
 */
int
get_key_code (p, first)
char **p;
int  first;                                  /* true on first invocation */
{
  while (**p == ' ' || **p == '\t') ++(*p);
  if (first && (**p == '\0' || **p == '\n')) /* ignore blank lines */
    return -1;
  if (first && my_strcmp (*p, "C-X")) {
    *p += 3;
    return get_key_code (p, FALSE) | KCTLX;
  } else if (my_strcmp (*p, "C-")) {
    *p += 2;
    return get_key_code (p, FALSE) | KCTRL;
  } else if (my_strcmp (*p, "M-")) {
    *p += 2;
    return get_key_code (p, FALSE) | KMETA;
  } else if (!first && (**p >= 'a' && **p <= 'z'))
    return *(*p)++ - 'a' + 'A';              /* map to upper if control */
  else return *(*p)++;
}

/*
 * See if the second string matches the first few characters of the
 * case shifted first string.
 */
int
my_strcmp (s1, s2)
char *s1, *s2;
{
  while (*s2) {
    if (*s1 >= 'a' && *s1 <= 'z') {
      if (*s1++ - 'a' + 'A' != *s2++) return FALSE;
    } else if (*s1++ != *s2++) return FALSE;
  }
  return TRUE;
}

/*
 * Passed a keycode and a function, try to bind the function to the
 * keycode.
 */
int
proc_pro_binding (p, ch)
int ch;
char *p;
{
  char *q;
  SYMBOL *sp;

  if (ch == -1) return TRUE;                      /* blank line */
  while (*p == ' ' || *p == '\t') ++p;            /* trim white space */
  for (q = p; *q != '\n' && *q != '\0' && *q != ' ' && *q != '\t'; ++q);
  *q = '\0';
  if ((sp=symlookup(p)) == NULL) return (FALSE);
  if (binding[ch] != NULL) --binding[ch]->s_nkey; /* unbind old  */
  binding[ch] = sp;                               /* rebind new  */
  ++sp->s_nkey;
  return TRUE;
}
