
/*  A Bison parser, made from parser.y  */

#define YYBISON 1  /* Identify Bison output.  */

#define	sySkip	258
#define	syRoutine	259
#define	sySimpleRoutine	260
#define	sySimpleProcedure	261
#define	syProcedure	262
#define	syFunction	263
#define	sySubsystem	264
#define	syKernelUser	265
#define	syKernelServer	266
#define	syMsgOption	267
#define	syMsgSeqno	268
#define	syWaitTime	269
#define	syNoWaitTime	270
#define	syErrorProc	271
#define	syServerPrefix	272
#define	syUserPrefix	273
#define	syServerDemux	274
#define	syRCSId	275
#define	syImport	276
#define	syUImport	277
#define	sySImport	278
#define	syIn	279
#define	syOut	280
#define	syInOut	281
#define	syRequestPort	282
#define	syReplyPort	283
#define	sySReplyPort	284
#define	syUReplyPort	285
#define	syType	286
#define	syArray	287
#define	syStruct	288
#define	syOf	289
#define	syInTran	290
#define	syOutTran	291
#define	syDestructor	292
#define	syCType	293
#define	syCUserType	294
#define	syCServerType	295
#define	syCString	296
#define	syColon	297
#define	sySemi	298
#define	syComma	299
#define	syPlus	300
#define	syMinus	301
#define	syStar	302
#define	syDiv	303
#define	syLParen	304
#define	syRParen	305
#define	syEqual	306
#define	syCaret	307
#define	syTilde	308
#define	syLAngle	309
#define	syRAngle	310
#define	syLBrack	311
#define	syRBrack	312
#define	syBar	313
#define	syError	314
#define	syNumber	315
#define	sySymbolicType	316
#define	syIdentifier	317
#define	syString	318
#define	syQString	319
#define	syFileName	320
#define	syIPCFlag	321

#line 158 "parser.y"


#include "lexxer.h"
#include "string.h"
#include "type.h"
#include "routine.h"
#include "statement.h"
#include "global.h"

static char *import_name();


#line 171 "parser.y"
typedef union
{
    u_int number;
    identifier_t identifier;
    string_t string;
    statement_kind_t statement_kind;
    ipc_type_t *type;
    struct
    {
	u_int innumber;		/* msgt_name value, when sending */
	string_t instr;
	u_int outnumber;	/* msgt_name value, when receiving */
	string_t outstr;
	u_int size;		/* 0 means there is no default size */
    } symtype;
    routine_t *routine;
    arg_kind_t direction;
    argument_t *argument;
    ipc_flags_t flag;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		211
#define	YYFLAG		-32768
#define	YYNTBASE	67

#define YYTRANSLATE(x) ((unsigned)(x) <= 321 ? yytranslate[x] : 112)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
    56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
    66
};

static const short yyprhs[] = {     0,
     0,     1,     4,     7,    10,    13,    16,    19,    22,    25,
    28,    31,    34,    37,    40,    42,    45,    50,    52,    53,
    56,    58,    60,    62,    64,    68,    72,    74,    77,    80,
    83,    86,    90,    92,    94,    96,   100,   103,   107,   109,
   118,   127,   135,   140,   145,   150,   152,   154,   157,   160,
   163,   166,   168,   170,   177,   178,   182,   188,   190,   192,
   194,   198,   200,   205,   211,   219,   225,   231,   236,   243,
   247,   251,   255,   259,   261,   265,   267,   269,   271,   273,
   275,   279,   283,   287,   291,   296,   299,   303,   305,   309,
   314,   315,   317,   319,   321,   323,   325,   327,   329,   331,
   333,   335,   338,   341,   342,   343
};

static const short yyrhs[] = {    -1,
    67,    68,     0,    69,    43,     0,    76,    43,     0,    75,
    43,     0,    77,    43,     0,    78,    43,     0,    79,    43,
     0,    80,    43,     0,    84,    43,     0,    98,    43,     0,
     3,    43,     0,    81,    43,     0,    83,    43,     0,    43,
     0,     1,    43,     0,    70,    71,    73,    74,     0,     9,
     0,     0,    71,    72,     0,    10,     0,    11,     0,    62,
     0,    60,     0,   109,    12,    63,     0,   109,    14,    63,
     0,    15,     0,    16,    62,     0,    17,    62,     0,    18,
    62,     0,    19,    62,     0,   110,    82,    65,     0,    21,
     0,    22,     0,    23,     0,   111,    20,    64,     0,    31,
    85,     0,    62,    51,    86,     0,    87,     0,    86,    35,
    42,    62,    62,    49,    62,    50,     0,    86,    36,    42,
    62,    62,    49,    62,    50,     0,    86,    37,    42,    62,
    49,    62,    50,     0,    86,    38,    42,    62,     0,    86,
    39,    42,    62,     0,    86,    40,    42,    62,     0,    88,
     0,    92,     0,    93,    87,     0,    94,    87,     0,    52,
    87,     0,    95,    87,     0,    96,     0,    91,     0,    49,
    91,    44,    97,    89,    50,     0,     0,    89,    44,    66,
     0,    89,    44,    66,    56,    57,     0,    60,     0,    61,
     0,    90,     0,    90,    58,    90,     0,    62,     0,    32,
    56,    57,    34,     0,    32,    56,    47,    57,    34,     0,
    32,    56,    47,    42,    97,    57,    34,     0,    32,    56,
    97,    57,    34,     0,    33,    56,    97,    57,    34,     0,
    41,    56,    97,    57,     0,    41,    56,    47,    42,    97,
    57,     0,    97,    45,    97,     0,    97,    46,    97,     0,
    97,    47,    97,     0,    97,    48,    97,     0,    60,     0,
    49,    97,    50,     0,    99,     0,   100,     0,   101,     0,
   102,     0,   103,     0,     4,    62,   104,     0,     5,    62,
   104,     0,     7,    62,   104,     0,     6,    62,   104,     0,
     8,    62,   104,   108,     0,    49,    50,     0,    49,   105,
    50,     0,   106,     0,   106,    43,   105,     0,   107,    62,
   108,    89,     0,     0,    24,     0,    25,     0,    26,     0,
    27,     0,    28,     0,    29,     0,    30,     0,    14,     0,
    12,     0,    13,     0,    42,    62,     0,    42,    85,     0,
     0,     0,     0
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   194,   195,   198,   199,   200,   201,   202,   203,   204,   205,
   206,   216,   218,   219,   220,   221,   225,   238,   250,   251,
   254,   260,   268,   271,   274,   291,   297,   305,   313,   321,
   329,   337,   348,   349,   350,   353,   363,   373,   377,   379,
   399,   419,   434,   448,   457,   469,   471,   473,   475,   477,
   479,   481,   485,   491,   500,   502,   509,   518,   524,   528,
   530,   554,   558,   560,   562,   567,   571,   575,   577,   582,
   584,   586,   588,   590,   592,   597,   598,   599,   600,   601,
   604,   608,   612,   616,   620,   624,   626,   631,   633,   640,
   650,   651,   652,   653,   654,   655,   656,   657,   658,   659,
   660,   663,   669,   673,   677,   681
};

static const char * const yytname[] = {   "$","error","$illegal.","sySkip","syRoutine",
"sySimpleRoutine","sySimpleProcedure","syProcedure","syFunction","sySubsystem",
"syKernelUser","syKernelServer","syMsgOption","syMsgSeqno","syWaitTime","syNoWaitTime",
"syErrorProc","syServerPrefix","syUserPrefix","syServerDemux","syRCSId","syImport",
"syUImport","sySImport","syIn","syOut","syInOut","syRequestPort","syReplyPort",
"sySReplyPort","syUReplyPort","syType","syArray","syStruct","syOf","syInTran",
"syOutTran","syDestructor","syCType","syCUserType","syCServerType","syCString",
"syColon","sySemi","syComma","syPlus","syMinus","syStar","syDiv","syLParen",
"syRParen","syEqual","syCaret","syTilde","syLAngle","syRAngle","syLBrack","syRBrack",
"syBar","syError","syNumber","sySymbolicType","syIdentifier","syString","syQString",
"syFileName","syIPCFlag","Statements","Statement","Subsystem","SubsystemStart",
"SubsystemMods","SubsystemMod","SubsystemName","SubsystemBase","MsgOption","WaitTime",
"Error","ServerPrefix","UserPrefix","ServerDemux","Import","ImportIndicant",
"RCSDecl","TypeDecl","NamedTypeSpec","TransTypeSpec","TypeSpec","BasicTypeSpec",
"IPCFlags","PrimIPCType","IPCType","PrevTypeSpec","VarArrayHead","ArrayHead",
"StructHead","CStringSpec","IntExp","RoutineDecl","Routine","SimpleRoutine",
"Procedure","SimpleProcedure","Function","Arguments","ArgumentList","Argument",
"Direction","ArgumentType","LookString","LookFileName","LookQString",""
};
#endif

static const short yyr1[] = {     0,
    67,    67,    68,    68,    68,    68,    68,    68,    68,    68,
    68,    68,    68,    68,    68,    68,    69,    70,    71,    71,
    72,    72,    73,    74,    75,    76,    76,    77,    78,    79,
    80,    81,    82,    82,    82,    83,    84,    85,    86,    86,
    86,    86,    86,    86,    86,    87,    87,    87,    87,    87,
    87,    87,    88,    88,    89,    89,    89,    90,    90,    91,
    91,    92,    93,    93,    93,    94,    95,    96,    96,    97,
    97,    97,    97,    97,    97,    98,    98,    98,    98,    98,
    99,   100,   101,   102,   103,   104,   104,   105,   105,   106,
   107,   107,   107,   107,   107,   107,   107,   107,   107,   107,
   107,   108,   108,   109,   110,   111
};

static const short yyr2[] = {     0,
     0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     1,     2,     4,     1,     0,     2,
     1,     1,     1,     1,     3,     3,     1,     2,     2,     2,
     2,     3,     1,     1,     1,     3,     2,     3,     1,     8,
     8,     7,     4,     4,     4,     1,     1,     2,     2,     2,
     2,     1,     1,     6,     0,     3,     5,     1,     1,     1,
     3,     1,     4,     5,     7,     5,     5,     4,     6,     3,
     3,     3,     3,     1,     3,     1,     1,     1,     1,     1,
     3,     3,     3,     3,     4,     2,     3,     1,     3,     4,
     0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     2,     2,     0,     0,     0
};

static const short yydefact[] = {     1,
     0,     0,     0,     0,     0,     0,     0,     0,    18,    27,
     0,     0,     0,     0,     0,    15,     2,     0,    19,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
    77,    78,    79,    80,     0,     0,     0,    16,    12,     0,
     0,     0,     0,     0,    28,    29,    30,    31,     0,    37,
     3,     0,     5,     4,     6,     7,     8,     9,    13,    14,
    10,    11,     0,     0,    33,    34,    35,     0,     0,    91,
    81,    82,    84,    83,     0,     0,    21,    22,    23,    20,
     0,    25,    26,    32,    36,   100,   101,    99,    92,    93,
    94,    95,    96,    97,    98,    86,     0,    88,     0,     0,
    85,     0,     0,     0,     0,     0,    58,    59,    62,    38,
    39,    46,    60,    53,    47,     0,     0,     0,    52,    24,
    17,    87,    91,     0,   102,   103,     0,     0,     0,     0,
    50,     0,     0,     0,     0,     0,     0,     0,    48,    49,
    51,    89,    55,     0,     0,     0,    74,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    61,    90,
     0,     0,     0,    63,     0,     0,     0,     0,     0,     0,
     0,    68,    55,     0,     0,     0,    43,    44,    45,     0,
     0,    64,    75,    70,    71,    72,    73,    66,    67,     0,
     0,     0,     0,     0,    56,     0,    69,    54,     0,     0,
     0,     0,    65,     0,     0,    42,    57,    40,    41,     0,
     0
};

static const short yydefgoto[] = {     1,
    17,    18,    19,    52,    80,    81,   121,    20,    21,    22,
    23,    24,    25,    26,    68,    27,    28,    50,   110,   111,
   112,   160,   113,   114,   115,   116,   117,   118,   119,   148,
    29,    30,    31,    32,    33,    34,    71,    97,    98,    99,
   101,    35,    36,    37
};

static const short yypact[] = {-32768,
     2,   -31,    -3,   -16,   -11,    -8,     6,     8,-32768,-32768,
     9,    33,    35,    41,    49,-32768,-32768,    67,-32768,    89,
    90,    91,    93,    94,    95,   107,   113,   114,   115,-32768,
-32768,-32768,-32768,-32768,    18,    64,    24,-32768,-32768,     4,
     4,     4,     4,     4,-32768,-32768,-32768,-32768,   108,-32768,
-32768,   -10,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,    97,    98,-32768,-32768,-32768,    99,   102,    48,
-32768,-32768,-32768,-32768,   120,    47,-32768,-32768,-32768,-32768,
   103,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,   117,   122,   106,   109,
-32768,   116,   118,   119,   -23,    47,-32768,-32768,-32768,   105,
-32768,-32768,   112,-32768,-32768,    47,    47,    47,-32768,-32768,
-32768,-32768,    88,   120,   108,-32768,   -18,   -45,   -13,   125,
-32768,   131,   134,   135,   136,   137,   138,   -23,-32768,-32768,
-32768,-32768,-32768,   -29,   -45,   147,-32768,    10,    36,   140,
    74,   -45,   121,   123,   124,   126,   127,   128,-32768,   143,
   -45,   150,   101,-32768,   -45,   -45,   -45,   -45,   157,   158,
   -45,-32768,    44,   132,   133,   144,-32768,-32768,-32768,   130,
    78,-32768,-32768,     1,     1,-32768,-32768,-32768,-32768,    82,
    -9,   148,   149,   139,   146,   165,-32768,-32768,   141,   142,
   155,   151,-32768,   156,   159,-32768,-32768,-32768,-32768,   200,
-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   110,-32768,   -12,
-32768,    34,    73,   129,-32768,-32768,-32768,-32768,-32768,  -102,
-32768,-32768,-32768,-32768,-32768,-32768,   111,    92,-32768,-32768,
    96,-32768,-32768,-32768
};


#define	YYLAST		234


static const short yytable[] = {    77,
    78,   210,     2,   145,     3,     4,     5,     6,     7,     8,
     9,    38,   161,  -104,   147,  -104,    10,    11,    12,    13,
    14,  -106,  -105,  -105,  -105,   149,   151,   162,   144,    63,
   145,    64,    15,   150,   180,   145,   107,   108,   146,    39,
   198,   147,   163,    69,    16,    40,   147,   167,   168,   173,
    41,    79,    70,    42,   165,   166,   167,   168,   181,    86,
    87,    88,   184,   185,   186,   187,   169,    43,   190,    44,
    45,    89,    90,    91,    92,    93,    94,    95,   102,   103,
   165,   166,   167,   168,    65,    66,    67,   104,   165,   166,
   167,   168,   170,   131,    46,   105,    47,    96,   106,    86,
    87,    88,    48,   139,   140,   141,   107,   108,   109,    51,
    49,    89,    90,    91,    92,    93,    94,    95,   165,   166,
   167,   168,   165,   166,   167,   168,   165,   166,   167,   168,
   172,    53,    54,    55,   196,    56,    57,    58,   197,   132,
   133,   134,   135,   136,   137,   165,   166,   167,   168,    59,
   183,    72,    73,    74,    75,    60,    61,    62,    76,    82,
    83,   100,   120,    84,   123,    85,   122,   124,   152,   138,
   125,   127,   153,   128,   129,   154,   155,   156,   157,   158,
   164,   171,   174,   182,   175,   176,   180,   177,   178,   179,
   188,   189,   194,   192,   193,   195,   199,   200,   203,   211,
   201,   202,   204,   205,   206,   208,   191,   207,   209,   126,
   159,     0,     0,     0,   142,     0,     0,     0,     0,   143,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   130
};

static const short yycheck[] = {    10,
    11,     0,     1,    49,     3,     4,     5,     6,     7,     8,
     9,    43,    42,    12,    60,    14,    15,    16,    17,    18,
    19,    20,    21,    22,    23,   128,   129,    57,    47,    12,
    49,    14,    31,    47,    44,    49,    60,    61,    57,    43,
    50,    60,   145,    20,    43,    62,    60,    47,    48,   152,
    62,    62,    49,    62,    45,    46,    47,    48,   161,    12,
    13,    14,   165,   166,   167,   168,    57,    62,   171,    62,
    62,    24,    25,    26,    27,    28,    29,    30,    32,    33,
    45,    46,    47,    48,    21,    22,    23,    41,    45,    46,
    47,    48,    57,   106,    62,    49,    62,    50,    52,    12,
    13,    14,    62,   116,   117,   118,    60,    61,    62,    43,
    62,    24,    25,    26,    27,    28,    29,    30,    45,    46,
    47,    48,    45,    46,    47,    48,    45,    46,    47,    48,
    57,    43,    43,    43,    57,    43,    43,    43,    57,    35,
    36,    37,    38,    39,    40,    45,    46,    47,    48,    43,
    50,    41,    42,    43,    44,    43,    43,    43,    51,    63,
    63,    42,    60,    65,    43,    64,    50,    62,    44,    58,
    62,    56,    42,    56,    56,    42,    42,    42,    42,    42,
    34,    42,    62,    34,    62,    62,    44,    62,    62,    62,
    34,    34,    49,    62,    62,    66,    49,    49,    34,     0,
    62,    56,    62,    62,    50,    50,   173,    57,    50,   100,
   138,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,   124,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,   105
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 169 "/usr/local/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yysp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yysp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symboles being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 11:
#line 207 "parser.y"
{
    register statement_t *st = stAlloc();

    st->stKind = skRoutine;
    st->stRoutine = yyvsp[-1].routine;
    rtCheckRoutine(yyvsp[-1].routine);
    if (BeVerbose)
	rtPrintRoutine(yyvsp[-1].routine);
;
    break;}
case 12:
#line 217 "parser.y"
{ rtSkip(); ;
    break;}
case 16:
#line 222 "parser.y"
{ yyerrok; ;
    break;}
case 17:
#line 227 "parser.y"
{
    if (BeVerbose)
    {
	printf("Subsystem %s: base = %u%s%s\n\n",
	       SubsystemName, SubsystemBase,
	       IsKernelUser ? ", KernelUser" : "",
	       IsKernelServer ? ", KernelServer" : "");
    }
;
    break;}
case 18:
#line 239 "parser.y"
{
    if (SubsystemName != strNULL)
    {
	warn("previous Subsystem decl (of %s) will be ignored", SubsystemName);
	IsKernelUser = FALSE;
	IsKernelServer = FALSE;
	strfree(SubsystemName);
    }
;
    break;}
case 21:
#line 255 "parser.y"
{
    if (IsKernelUser)
	warn("duplicate KernelUser keyword");
    IsKernelUser = TRUE;
;
    break;}
case 22:
#line 261 "parser.y"
{
    if (IsKernelServer)
	warn("duplicate KernelServer keyword");
    IsKernelServer = TRUE;
;
    break;}
case 23:
#line 268 "parser.y"
{ SubsystemName = yyvsp[0].identifier; ;
    break;}
case 24:
#line 271 "parser.y"
{ SubsystemBase = yyvsp[0].number; ;
    break;}
case 25:
#line 275 "parser.y"
{
    if (streql(yyvsp[0].string, "MACH_MSG_OPTION_NONE"))
    {
	MsgOption = strNULL;
	if (BeVerbose)
	    printf("MsgOption: canceled\n\n");
    }
    else
    {
	MsgOption = yyvsp[0].string;
	if (BeVerbose)
	    printf("MsgOption %s\n\n",yyvsp[0].string);
    }
;
    break;}
case 26:
#line 292 "parser.y"
{
    WaitTime = yyvsp[0].string;
    if (BeVerbose)
	printf("WaitTime %s\n\n", WaitTime);
;
    break;}
case 27:
#line 298 "parser.y"
{
    WaitTime = strNULL;
    if (BeVerbose)
	printf("NoWaitTime\n\n");
;
    break;}
case 28:
#line 306 "parser.y"
{
    ErrorProc = yyvsp[0].identifier;
    if (BeVerbose)
	printf("ErrorProc %s\n\n", ErrorProc);
;
    break;}
case 29:
#line 314 "parser.y"
{
    ServerPrefix = yyvsp[0].identifier;
    if (BeVerbose)
	printf("ServerPrefix %s\n\n", ServerPrefix);
;
    break;}
case 30:
#line 322 "parser.y"
{
    UserPrefix = yyvsp[0].identifier;
    if (BeVerbose)
	printf("UserPrefix %s\n\n", UserPrefix);
;
    break;}
case 31:
#line 330 "parser.y"
{
    ServerDemux = yyvsp[0].identifier;
    if (BeVerbose)
	printf("ServerDemux %s\n\n", ServerDemux);
;
    break;}
case 32:
#line 338 "parser.y"
{
    register statement_t *st = stAlloc();
    st->stKind = yyvsp[-1].statement_kind;
    st->stFileName = yyvsp[0].string;

    if (BeVerbose)
	printf("%s %s\n\n", import_name(yyvsp[-1].statement_kind), yyvsp[0].string);
;
    break;}
case 33:
#line 348 "parser.y"
{ yyval.statement_kind = skImport; ;
    break;}
case 34:
#line 349 "parser.y"
{ yyval.statement_kind = skUImport; ;
    break;}
case 35:
#line 350 "parser.y"
{ yyval.statement_kind = skSImport; ;
    break;}
case 36:
#line 354 "parser.y"
{
    if (RCSId != strNULL)
	warn("previous RCS decl will be ignored");
    if (BeVerbose)
	printf("RCSId %s\n\n", yyvsp[0].string);
    RCSId = yyvsp[0].string;
;
    break;}
case 37:
#line 364 "parser.y"
{
    register identifier_t name = yyvsp[0].type->itName;

    if (itLookUp(name) != itNULL)
	warn("overriding previous definition of %s", name);
    itInsert(name, yyvsp[0].type);
;
    break;}
case 38:
#line 374 "parser.y"
{ itTypeDecl(yyvsp[-2].identifier, yyval.type = yyvsp[0].type); ;
    break;}
case 39:
#line 378 "parser.y"
{ yyval.type = itResetType(yyvsp[0].type); ;
    break;}
case 40:
#line 381 "parser.y"
{
    yyval.type = yyvsp[-7].type;

    if ((yyval.type->itTransType != strNULL) && !streql(yyval.type->itTransType, yyvsp[-4].identifier))
	warn("conflicting translation types (%s, %s)",
	     yyval.type->itTransType, yyvsp[-4].identifier);
    yyval.type->itTransType = yyvsp[-4].identifier;

    if ((yyval.type->itInTrans != strNULL) && !streql(yyval.type->itInTrans, yyvsp[-3].identifier))
	warn("conflicting in-translation functions (%s, %s)",
	     yyval.type->itInTrans, yyvsp[-3].identifier);
    yyval.type->itInTrans = yyvsp[-3].identifier;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yyvsp[-1].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yyvsp[-1].identifier);
    yyval.type->itServerType = yyvsp[-1].identifier;
;
    break;}
case 41:
#line 401 "parser.y"
{
    yyval.type = yyvsp[-7].type;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yyvsp[-4].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yyvsp[-4].identifier);
    yyval.type->itServerType = yyvsp[-4].identifier;

    if ((yyval.type->itOutTrans != strNULL) && !streql(yyval.type->itOutTrans, yyvsp[-3].identifier))
	warn("conflicting out-translation functions (%s, %s)",
	     yyval.type->itOutTrans, yyvsp[-3].identifier);
    yyval.type->itOutTrans = yyvsp[-3].identifier;

    if ((yyval.type->itTransType != strNULL) && !streql(yyval.type->itTransType, yyvsp[-1].identifier))
	warn("conflicting translation types (%s, %s)",
	     yyval.type->itTransType, yyvsp[-1].identifier);
    yyval.type->itTransType = yyvsp[-1].identifier;
;
    break;}
case 42:
#line 421 "parser.y"
{
    yyval.type = yyvsp[-6].type;

    if ((yyval.type->itDestructor != strNULL) && !streql(yyval.type->itDestructor, yyvsp[-3].identifier))
	warn("conflicting destructor functions (%s, %s)",
	     yyval.type->itDestructor, yyvsp[-3].identifier);
    yyval.type->itDestructor = yyvsp[-3].identifier;

    if ((yyval.type->itTransType != strNULL) && !streql(yyval.type->itTransType, yyvsp[-1].identifier))
	warn("conflicting translation types (%s, %s)",
	     yyval.type->itTransType, yyvsp[-1].identifier);
    yyval.type->itTransType = yyvsp[-1].identifier;
;
    break;}
case 43:
#line 435 "parser.y"
{
    yyval.type = yyvsp[-3].type;

    if ((yyval.type->itUserType != strNULL) && !streql(yyval.type->itUserType, yyvsp[0].identifier))
	warn("conflicting user types (%s, %s)",
	     yyval.type->itUserType, yyvsp[0].identifier);
    yyval.type->itUserType = yyvsp[0].identifier;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yyvsp[0].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yyvsp[0].identifier);
    yyval.type->itServerType = yyvsp[0].identifier;
;
    break;}
case 44:
#line 449 "parser.y"
{
    yyval.type = yyvsp[-3].type;

    if ((yyval.type->itUserType != strNULL) && !streql(yyval.type->itUserType, yyvsp[0].identifier))
	warn("conflicting user types (%s, %s)",
	     yyval.type->itUserType, yyvsp[0].identifier);
    yyval.type->itUserType = yyvsp[0].identifier;
;
    break;}
case 45:
#line 459 "parser.y"
{
    yyval.type = yyvsp[-3].type;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yyvsp[0].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yyvsp[0].identifier);
    yyval.type->itServerType = yyvsp[0].identifier;
;
    break;}
case 46:
#line 470 "parser.y"
{ yyval.type = yyvsp[0].type; ;
    break;}
case 47:
#line 472 "parser.y"
{ yyval.type = yyvsp[0].type; ;
    break;}
case 48:
#line 474 "parser.y"
{ yyval.type = itVarArrayDecl(yyvsp[-1].number, yyvsp[0].type); ;
    break;}
case 49:
#line 476 "parser.y"
{ yyval.type = itArrayDecl(yyvsp[-1].number, yyvsp[0].type); ;
    break;}
case 50:
#line 478 "parser.y"
{ yyval.type = itPtrDecl(yyvsp[0].type); ;
    break;}
case 51:
#line 480 "parser.y"
{ yyval.type = itStructDecl(yyvsp[-1].number, yyvsp[0].type); ;
    break;}
case 52:
#line 482 "parser.y"
{ yyval.type = yyvsp[0].type; ;
    break;}
case 53:
#line 486 "parser.y"
{
    yyval.type = itShortDecl(yyvsp[0].symtype.innumber, yyvsp[0].symtype.instr,
		     yyvsp[0].symtype.outnumber, yyvsp[0].symtype.outstr,
		     yyvsp[0].symtype.size);
;
    break;}
case 54:
#line 493 "parser.y"
{
    yyval.type = itLongDecl(yyvsp[-4].symtype.innumber, yyvsp[-4].symtype.instr,
		    yyvsp[-4].symtype.outnumber, yyvsp[-4].symtype.outstr,
		    yyvsp[-4].symtype.size, yyvsp[-2].number, yyvsp[-1].flag);
;
    break;}
case 55:
#line 501 "parser.y"
{ yyval.flag = flNone; ;
    break;}
case 56:
#line 503 "parser.y"
{
    if (yyvsp[-2].flag & yyvsp[0].flag)
	warn("redundant IPC flag ignored");
    else
	yyval.flag = yyvsp[-2].flag | yyvsp[0].flag;
;
    break;}
case 57:
#line 510 "parser.y"
{
    if (yyvsp[-2].flag != flDealloc)
	warn("only Dealloc is variable");
    else
	yyval.flag = yyvsp[-4].flag | flMaybeDealloc;
;
    break;}
case 58:
#line 519 "parser.y"
{
    yyval.symtype.innumber = yyval.symtype.outnumber = yyvsp[0].number;
    yyval.symtype.instr = yyval.symtype.outstr = strNULL;
    yyval.symtype.size = 0;
;
    break;}
case 59:
#line 525 "parser.y"
{ yyval.symtype = yyvsp[0].symtype; ;
    break;}
case 60:
#line 529 "parser.y"
{ yyval.symtype = yyvsp[0].symtype; ;
    break;}
case 61:
#line 531 "parser.y"
{
    if (yyvsp[-2].symtype.size != yyvsp[0].symtype.size)
    {
	if (yyvsp[-2].symtype.size == 0)
	    yyval.symtype.size = yyvsp[0].symtype.size;
	else if (yyvsp[0].symtype.size == 0)
	    yyval.symtype.size = yyvsp[-2].symtype.size;
	else
	{
	    error("sizes in IPCTypes (%d, %d) aren't equal",
		  yyvsp[-2].symtype.size, yyvsp[0].symtype.size);
	    yyval.symtype.size = 0;
	}
    }
    else
	yyval.symtype.size = yyvsp[-2].symtype.size;
    yyval.symtype.innumber = yyvsp[-2].symtype.innumber;
    yyval.symtype.instr = yyvsp[-2].symtype.instr;
    yyval.symtype.outnumber = yyvsp[0].symtype.outnumber;
    yyval.symtype.outstr = yyvsp[0].symtype.outstr;
;
    break;}
case 62:
#line 555 "parser.y"
{ yyval.type = itPrevDecl(yyvsp[0].identifier); ;
    break;}
case 63:
#line 559 "parser.y"
{ yyval.number = 0; ;
    break;}
case 64:
#line 561 "parser.y"
{ yyval.number = 0; ;
    break;}
case 65:
#line 564 "parser.y"
{ yyval.number = yyvsp[-2].number; ;
    break;}
case 66:
#line 568 "parser.y"
{ yyval.number = yyvsp[-2].number; ;
    break;}
case 67:
#line 572 "parser.y"
{ yyval.number = yyvsp[-2].number; ;
    break;}
case 68:
#line 576 "parser.y"
{ yyval.type = itCStringDecl(yyvsp[-1].number, FALSE); ;
    break;}
case 69:
#line 579 "parser.y"
{ yyval.type = itCStringDecl(yyvsp[-1].number, TRUE); ;
    break;}
case 70:
#line 583 "parser.y"
{ yyval.number = yyvsp[-2].number + yyvsp[0].number;	;
    break;}
case 71:
#line 585 "parser.y"
{ yyval.number = yyvsp[-2].number - yyvsp[0].number;	;
    break;}
case 72:
#line 587 "parser.y"
{ yyval.number = yyvsp[-2].number * yyvsp[0].number;	;
    break;}
case 73:
#line 589 "parser.y"
{ yyval.number = yyvsp[-2].number / yyvsp[0].number;	;
    break;}
case 74:
#line 591 "parser.y"
{ yyval.number = yyvsp[0].number;	;
    break;}
case 75:
#line 593 "parser.y"
{ yyval.number = yyvsp[-1].number;	;
    break;}
case 76:
#line 597 "parser.y"
{ yyval.routine = yyvsp[0].routine; ;
    break;}
case 77:
#line 598 "parser.y"
{ yyval.routine = yyvsp[0].routine; ;
    break;}
case 78:
#line 599 "parser.y"
{ yyval.routine = yyvsp[0].routine; ;
    break;}
case 79:
#line 600 "parser.y"
{ yyval.routine = yyvsp[0].routine; ;
    break;}
case 80:
#line 601 "parser.y"
{ yyval.routine = yyvsp[0].routine; ;
    break;}
case 81:
#line 605 "parser.y"
{ yyval.routine = rtMakeRoutine(yyvsp[-1].identifier, yyvsp[0].argument); ;
    break;}
case 82:
#line 609 "parser.y"
{ yyval.routine = rtMakeSimpleRoutine(yyvsp[-1].identifier, yyvsp[0].argument); ;
    break;}
case 83:
#line 613 "parser.y"
{ yyval.routine = rtMakeProcedure(yyvsp[-1].identifier, yyvsp[0].argument); ;
    break;}
case 84:
#line 617 "parser.y"
{ yyval.routine = rtMakeSimpleProcedure(yyvsp[-1].identifier, yyvsp[0].argument); ;
    break;}
case 85:
#line 621 "parser.y"
{ yyval.routine = rtMakeFunction(yyvsp[-2].identifier, yyvsp[-1].argument, yyvsp[0].type); ;
    break;}
case 86:
#line 625 "parser.y"
{ yyval.argument = argNULL; ;
    break;}
case 87:
#line 627 "parser.y"
{ yyval.argument = yyvsp[-1].argument; ;
    break;}
case 88:
#line 632 "parser.y"
{ yyval.argument = yyvsp[0].argument; ;
    break;}
case 89:
#line 634 "parser.y"
{
    yyval.argument = yyvsp[-2].argument;
    yyval.argument->argNext = yyvsp[0].argument;
;
    break;}
case 90:
#line 641 "parser.y"
{
    yyval.argument = argAlloc();
    yyval.argument->argKind = yyvsp[-3].direction;
    yyval.argument->argName = yyvsp[-2].identifier;
    yyval.argument->argType = yyvsp[-1].type;
    yyval.argument->argFlags = yyvsp[0].flag;
;
    break;}
case 91:
#line 650 "parser.y"
{ yyval.direction = akNone; ;
    break;}
case 92:
#line 651 "parser.y"
{ yyval.direction = akIn; ;
    break;}
case 93:
#line 652 "parser.y"
{ yyval.direction = akOut; ;
    break;}
case 94:
#line 653 "parser.y"
{ yyval.direction = akInOut; ;
    break;}
case 95:
#line 654 "parser.y"
{ yyval.direction = akRequestPort; ;
    break;}
case 96:
#line 655 "parser.y"
{ yyval.direction = akReplyPort; ;
    break;}
case 97:
#line 656 "parser.y"
{ yyval.direction = akSReplyPort; ;
    break;}
case 98:
#line 657 "parser.y"
{ yyval.direction = akUReplyPort; ;
    break;}
case 99:
#line 658 "parser.y"
{ yyval.direction = akWaitTime; ;
    break;}
case 100:
#line 659 "parser.y"
{ yyval.direction = akMsgOption; ;
    break;}
case 101:
#line 660 "parser.y"
{ yyval.direction = akMsgSeqno; ;
    break;}
case 102:
#line 664 "parser.y"
{
    yyval.type = itLookUp(yyvsp[0].identifier);
    if (yyval.type == itNULL)
	error("type '%s' not defined", yyvsp[0].identifier);
;
    break;}
case 103:
#line 670 "parser.y"
{ yyval.type = yyvsp[0].type; ;
    break;}
case 104:
#line 674 "parser.y"
{ LookString(); ;
    break;}
case 105:
#line 678 "parser.y"
{ LookFileName(); ;
    break;}
case 106:
#line 682 "parser.y"
{ LookQString(); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 440 "/usr/local/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) xmalloc(size + 15);
	  strcpy(msg, "parse error");

	  if (count < 5)
	    {
	      count = 0;
	      for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		if (yycheck[x + yyn] == x)
		  {
		    strcat(msg, count == 0 ? ", expecting `" : " or `");
		    strcat(msg, yytname[x]);
		    strcat(msg, "'");
		    count++;
		  }
	    }
	  yyerror(msg);
	  free(msg);
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 685 "parser.y"


yyerror(s)
    char *s;
{
    error(s);
}

static char *
import_name(sk)
    statement_kind_t sk;
{
    switch (sk)
    {
      case skImport:
	return "Import";
      case skSImport:
	return "SImport";
      case skUImport:
	return "UImport";
      default:
	fatal("import_name(%d): not import statement", (int) sk);
	/*NOTREACHED*/
    }
}
