# include "stdio.h"
#define yywrap() 1
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* 
 * Mach Operating System
 * Copyright (c) 1991,1990 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	lexxer.l,v $
 * Revision 2.7  92/01/23  15:21:24  rpd
 * 	Fixed macros for STDC.
 * 	[92/01/16            rpd]
 * 
 * Revision 2.6  92/01/03  20:29:25  dbg
 * 	Add 'CountInOut' flag.
 * 	[91/11/11            dbg]
 * 
 * Revision 2.5  91/08/28  11:17:01  jsb
 * 	Added syServerDemux.
 * 	[91/08/13            rpd]
 * 
 * 	Removed syMsgKind, syCamelot, syCamelotRoutine, syTrapRoutine,
 * 	syTrapSimpleRoutine.  Added syMsgSeqno.
 * 	[91/08/11            rpd]
 * 
 * Revision 2.4  91/07/31  18:09:31  dbg
 * 	Add 'serverCopy' keyword.
 * 	[91/06/05            dbg]
 * 
 * 	Add 'c_string' keyword.
 * 	[91/04/03            dbg]
 * 
 * Revision 2.3  91/02/05  17:54:51  mrt
 * 	Changed to new Mach copyright
 * 	[91/02/01  17:54:35  mrt]
 * 
 * Revision 2.2  90/06/02  15:04:54  rpd
 * 	Created for new IPC.
 * 	[90/03/26  21:11:34  rpd]
 * 
 * 07-Apr-89  Richard Draves (rpd) at Carnegie-Mellon University
 *	Extensive revamping.  Added polymorphic arguments.
 *	Allow multiple variable-sized inline arguments in messages.
 *
 * 27-May-87  Richard Draves (rpd) at Carnegie-Mellon University
 *	Created.
 */

#include <mach/message.h>
#include "string.h"
#include "type.h"
#include "statement.h"
#include "global.h"
#include "parser.h"
#include "lexxer.h"

#ifdef	__STDC__
#define stringize(x)	#x
#else	__STDC__
#define	stringize(x)	"x"
#endif	__STDC__

#ifdef	LDEBUG
#define RETURN(sym)							\
{									\
    printf("yylex: returning '%s' (%d)\n", stringize(sym), (sym));	\
    return (sym);							\
}
#else	LDEBUG
#define RETURN(sym)	return (sym)
#endif	LDEBUG

#define	TPRETURN(intype, outtype, tsize)				\
{									\
    yylval.symtype.innumber = (intype);					\
    yylval.symtype.instr = stringize(intype);				\
    yylval.symtype.outnumber = (outtype);				\
    yylval.symtype.outstr = stringize(outtype);				\
    yylval.symtype.size = (tsize);					\
    RETURN(sySymbolicType);						\
}

#define	TRETURN(type, tsize)	TPRETURN(type,type,tsize)

#define	FRETURN(val)							\
{									\
    yylval.flag = (val);						\
    RETURN(syIPCFlag);							\
}

static struct yysvf *oldYYBegin;

static void doSharp(); /* process body of # directives */
# define Normal 2
# define String 4
# define FileName 6
# define QString 8
# define SkipToEOL 10
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	RETURN(syRoutine);
break;
case 2:
RETURN(syFunction);
break;
case 3:
RETURN(syProcedure);
break;
case 4:
RETURN(sySimpleProcedure);
break;
case 5:
RETURN(sySimpleRoutine);
break;
case 6:
RETURN(sySubsystem);
break;
case 7:
RETURN(syMsgOption);
break;
case 8:
RETURN(syMsgSeqno);
break;
case 9:
RETURN(syWaitTime);
break;
case 10:
RETURN(syNoWaitTime);
break;
case 11:
			RETURN(syIn);
break;
case 12:
			RETURN(syOut);
break;
case 13:
		RETURN(syInOut);
break;
case 14:
RETURN(syRequestPort);
break;
case 15:
	RETURN(syReplyPort);
break;
case 16:
RETURN(syUReplyPort);
break;
case 17:
RETURN(sySReplyPort);
break;
case 18:
		RETURN(syArray);
break;
case 19:
			RETURN(syOf);
break;
case 20:
		RETURN(syErrorProc);
break;
case 21:
RETURN(syServerPrefix);
break;
case 22:
RETURN(syUserPrefix);
break;
case 23:
RETURN(syServerDemux);
break;
case 24:
		RETURN(syRCSId);
break;
case 25:
	RETURN(syImport);
break;
case 26:
	RETURN(syUImport);
break;
case 27:
	RETURN(sySImport);
break;
case 28:
		RETURN(syType);
break;
case 29:
RETURN(syKernelServer);
break;
case 30:
RETURN(syKernelUser);
break;
case 31:
		RETURN(sySkip);
break;
case 32:
	RETURN(syStruct);
break;
case 33:
	RETURN(syInTran);
break;
case 34:
	RETURN(syOutTran);
break;
case 35:
RETURN(syDestructor);
break;
case 36:
			RETURN(syCType);
break;
case 37:
	RETURN(syCUserType);
break;
case 38:
RETURN(syCServerType);
break;
case 39:
		RETURN(syCString);
break;
case 40:
	FRETURN(flLong);
break;
case 41:
FRETURN(flNotLong);
break;
case 42:
	FRETURN(flDealloc);
break;
case 43:
FRETURN(flNotDealloc);
break;
case 44:
FRETURN(flServerCopy);
break;
case 45:
FRETURN(flCountInOut);
break;
case 46:
TRETURN(MACH_MSG_TYPE_POLYMORPHIC,32);
break;
case 47:
TRETURN(MACH_MSG_TYPE_UNSTRUCTURED,0);
break;
case 48:
	TRETURN(MACH_MSG_TYPE_BIT,1);
break;
case 49:
	TRETURN(MACH_MSG_TYPE_BOOLEAN,32);
break;
case 50:
TRETURN(MACH_MSG_TYPE_INTEGER_16,16);
break;
case 51:
TRETURN(MACH_MSG_TYPE_INTEGER_32,32);
break;
case 52:
	TRETURN(MACH_MSG_TYPE_CHAR,8);
break;
case 53:
	TRETURN(MACH_MSG_TYPE_BYTE,8);
break;
case 54:
TRETURN(MACH_MSG_TYPE_INTEGER_8,8);
break;
case 55:
	TRETURN(MACH_MSG_TYPE_REAL,0);
break;
case 56:
	TRETURN(MACH_MSG_TYPE_STRING,0);
break;
case 57:
TRETURN(MACH_MSG_TYPE_STRING_C,0);
break;
case 58:
TPRETURN(MACH_MSG_TYPE_MOVE_RECEIVE,MACH_MSG_TYPE_PORT_RECEIVE,32);
break;
case 59:
TPRETURN(MACH_MSG_TYPE_COPY_SEND,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 60:
TPRETURN(MACH_MSG_TYPE_MAKE_SEND,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 61:
TPRETURN(MACH_MSG_TYPE_MOVE_SEND,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 62:
TPRETURN(MACH_MSG_TYPE_MAKE_SEND_ONCE,MACH_MSG_TYPE_PORT_SEND_ONCE,32);
break;
case 63:
TPRETURN(MACH_MSG_TYPE_MOVE_SEND_ONCE,MACH_MSG_TYPE_PORT_SEND_ONCE,32);
break;
case 64:
TRETURN(MACH_MSG_TYPE_PORT_NAME,32);
break;
case 65:
TPRETURN(MACH_MSG_TYPE_POLYMORPHIC,MACH_MSG_TYPE_PORT_RECEIVE,32);
break;
case 66:
TPRETURN(MACH_MSG_TYPE_POLYMORPHIC,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 67:
TPRETURN(MACH_MSG_TYPE_POLYMORPHIC,MACH_MSG_TYPE_PORT_SEND_ONCE,32);
break;
case 68:
TRETURN(MACH_MSG_TYPE_POLYMORPHIC,0);
break;
case 69:
	RETURN(syColon);
break;
case 70:
	RETURN(sySemi);
break;
case 71:
	RETURN(syComma);
break;
case 72:
	RETURN(syPlus);
break;
case 73:
	RETURN(syMinus);
break;
case 74:
	RETURN(syStar);
break;
case 75:
	RETURN(syDiv);
break;
case 76:
	RETURN(syLParen);
break;
case 77:
	RETURN(syRParen);
break;
case 78:
	RETURN(syEqual);
break;
case 79:
	RETURN(syCaret);
break;
case 80:
	RETURN(syTilde);
break;
case 81:
	RETURN(syLAngle);
break;
case 82:
	RETURN(syRAngle);
break;
case 83:
	RETURN(syLBrack);
break;
case 84:
	RETURN(syRBrack);
break;
case 85:
	RETURN(syBar);
break;
case 86:
	{ yylval.identifier = strmake(yytext);
			  RETURN(syIdentifier); }
break;
case 87:
{ yylval.number = atoi(yytext); RETURN(syNumber); }
break;
case 88:
{ yylval.string = strmake(yytext);
			  BEGIN Normal; RETURN(syString); }
break;
case 89:
{ yylval.string = strmake(yytext);
			  BEGIN Normal; RETURN(syFileName); }
break;
case 90:
{ yylval.string = strmake(yytext);
			  BEGIN Normal; RETURN(syQString); }
break;
case 91:
{ doSharp(yytext+1);
					  oldYYBegin = yybgin;
					  BEGIN SkipToEOL; }
break;
case 92:
			{ doSharp(yytext+1);
					  oldYYBegin = yybgin;
					  BEGIN SkipToEOL; }
break;
case 93:
				{ yyerror("illegal # directive");
					  oldYYBegin = yybgin;
					  BEGIN SkipToEOL; }
break;
case 94:
	yybgin = oldYYBegin;
break;
case 95:
	;
break;
case 96:
		;
break;
case 97:
		{ BEGIN Normal; RETURN(syError); }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

extern void
LookNormal()
{
    BEGIN Normal;
}

extern void
LookString()
{
    BEGIN String;
}

extern void
LookQString()
{
    BEGIN QString;
}

extern void
LookFileName()
{
    BEGIN FileName;
}

static void
doSharp(body)
    char *body;
{
    register char *startName;

    yylineno = atoi(body);
    startName = index(body, '"');
    if (startName != NULL)
    {
	*rindex(body, '"') = '\0';
	strfree(yyinname);
	yyinname = strmake(startName+1);
    }
}
int yyvstop[] = {
0,

97,
0,

96,
97,
0,

96,
0,

93,
97,
0,

76,
97,
0,

77,
97,
0,

74,
97,
0,

72,
97,
0,

71,
97,
0,

73,
97,
0,

75,
97,
0,

87,
97,
0,

69,
97,
0,

70,
97,
0,

81,
97,
0,

78,
97,
0,

82,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

86,
97,
0,

83,
97,
0,

84,
97,
0,

79,
97,
0,

86,
97,
0,

85,
97,
0,

80,
97,
0,

88,
97,
0,

97,
0,

97,
0,

97,
0,

95,
97,
0,

95,
96,
97,
0,

94,
96,
0,

93,
95,
97,
0,

92,
0,

87,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

11,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

19,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

88,
0,

89,
0,

90,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

12,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

91,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

31,
86,
0,

86,
0,

86,
0,

86,
0,

28,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

18,
86,
0,

86,
0,

86,
0,

36,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

20,
86,
0,

86,
0,

86,
0,

13,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

24,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

25,
86,
0,

33,
86,
0,

40,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

32,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

42,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

34,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

1,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

27,
86,
0,

86,
0,

86,
0,

26,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

39,
86,
0,

86,
0,

2,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

8,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

9,
86,
0,

86,
0,

86,
0,

37,
86,
0,

86,
0,

41,
86,
0,

86,
0,

86,
0,

86,
0,

7,
86,
0,

86,
0,

86,
0,

86,
0,

3,
86,
0,

15,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

6,
86,
0,

86,
0,

86,
0,

45,
86,
0,

86,
0,

35,
86,
0,

86,
0,

30,
86,
0,

86,
0,

43,
86,
0,

10,
86,
0,

86,
0,

86,
0,

44,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

17,
86,
0,

16,
86,
0,

22,
86,
0,

38,
86,
0,

86,
0,

86,
0,

46,
86,
0,

14,
86,
0,

23,
86,
0,

86,
0,

86,
0,

86,
0,

29,
86,
0,

86,
0,

21,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

5,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

4,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

48,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

53,
86,
0,

52,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

55,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

56,
86,
0,

86,
0,

49,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

57,
86,
0,

86,
0,

59,
86,
0,

86,
0,

86,
0,

54,
86,
0,

60,
86,
0,

86,
0,

61,
86,
0,

86,
0,

64,
86,
0,

86,
0,

66,
86,
0,

86,
0,

50,
86,
0,

51,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

68,
86,
0,

86,
0,

86,
0,

86,
0,

86,
0,

58,
86,
0,

86,
0,

65,
86,
0,

86,
0,

47,
86,
0,

86,
0,

86,
0,

86,
0,

62,
86,
0,

63,
86,
0,

67,
86,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,13,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,14,	1,15,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	63,107,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,13,	
2,16,	1,13,	7,54,	8,54,	
8,16,	9,56,	10,56,	10,16,	
12,60,	63,107,	0,0,	63,108,	
0,0,	1,13,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
0,0,	0,0,	0,0,	1,13,	
7,55,	8,55,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	3,13,	
101,0,	31,65,	103,0,	34,73,	
46,99,	65,65,	104,0,	3,14,	
3,15,	0,0,	0,0,	0,0,	
32,67,	0,0,	0,0,	32,65,	
32,68,	32,69,	32,70,	35,65,	
39,81,	46,65,	35,74,	39,65,	
0,0,	0,0,	0,0,	0,0,	
32,71,	50,65,	50,80,	0,0,	
3,13,	31,65,	3,13,	34,73,	
46,99,	65,65,	3,17,	3,18,	
3,19,	3,20,	3,21,	3,22,	
32,67,	3,23,	3,24,	32,65,	
32,68,	32,69,	32,70,	35,65,	
39,81,	46,65,	35,74,	39,65,	
3,25,	3,26,	3,27,	3,28,	
3,29,	50,65,	50,80,	3,30,	
3,31,	3,32,	3,33,	3,34,	
3,35,	3,31,	3,31,	3,36,	
3,31,	3,37,	3,31,	3,38,	
3,39,	3,40,	3,41,	3,31,	
3,42,	3,43,	3,44,	3,45,	
3,31,	3,46,	3,31,	3,31,	
4,16,	3,47,	0,0,	3,48,	
3,49,	4,17,	4,18,	4,19,	
4,20,	4,21,	4,22,	41,84,	
4,23,	44,65,	41,85,	38,79,	
33,72,	37,78,	66,109,	3,50,	
44,95,	73,117,	0,0,	4,25,	
4,26,	4,27,	4,28,	0,0,	
0,0,	33,65,	37,65,	0,0,	
38,65,	38,80,	3,51,	67,65,	
3,52,	16,61,	67,110,	70,65,	
70,113,	68,111,	0,0,	41,84,	
0,0,	44,65,	41,85,	0,0,	
33,72,	37,78,	66,109,	0,0,	
44,95,	73,117,	68,65,	78,124,	
4,47,	0,0,	4,48,	4,49,	
16,62,	33,65,	37,65,	5,53,	
38,65,	38,80,	0,0,	67,65,	
0,0,	0,0,	67,110,	70,65,	
70,113,	68,111,	4,50,	5,53,	
16,63,	16,63,	16,63,	16,63,	
16,63,	16,63,	16,63,	16,63,	
16,63,	16,63,	68,65,	78,124,	
75,119,	4,51,	75,65,	4,52,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	6,16,	6,53,	61,61,	
75,119,	0,0,	75,65,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	6,53,	0,0,	
0,0,	0,0,	0,0,	61,106,	
61,106,	61,106,	61,106,	61,106,	
61,106,	61,106,	61,106,	61,106,	
61,106,	0,0,	0,0,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
11,57,	0,0,	40,82,	0,0,	
79,125,	36,75,	36,76,	82,65,	
11,58,	11,59,	36,65,	36,77,	
45,96,	69,65,	40,65,	0,0,	
42,86,	40,83,	42,87,	79,65,	
69,112,	45,97,	45,98,	71,65,	
71,114,	83,65,	74,118,	83,129,	
42,88,	0,0,	74,65,	42,65,	
0,0,	11,57,	40,82,	11,57,	
0,0,	36,75,	36,76,	82,65,	
0,0,	0,0,	36,65,	36,77,	
45,96,	69,65,	40,65,	11,57,	
42,86,	40,83,	42,87,	79,65,	
69,112,	45,97,	45,98,	71,65,	
71,114,	83,65,	74,118,	83,129,	
42,88,	11,57,	74,65,	42,65,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	0,0,	
76,120,	86,65,	86,132,	76,65,	
0,0,	76,121,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,66,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
76,120,	86,65,	86,132,	76,65,	
30,65,	76,121,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,66,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
43,89,	77,122,	85,131,	77,123,	
43,90,	85,65,	43,91,	77,65,	
0,0,	81,65,	89,136,	81,127,	
93,140,	43,92,	81,128,	43,93,	
43,94,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	111,150,	0,0,	
43,89,	77,122,	85,131,	77,123,	
43,90,	85,65,	43,91,	77,65,	
53,100,	81,65,	89,136,	81,127,	
93,140,	43,92,	81,128,	43,93,	
43,94,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	111,150,	87,133,	
87,134,	87,65,	95,142,	0,0,	
95,65,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	87,133,	
87,134,	87,65,	95,142,	53,100,	
95,65,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	53,100,	
53,100,	53,100,	53,100,	54,101,	
107,107,	72,115,	0,0,	84,130,	
80,126,	121,160,	90,137,	54,101,	
54,0,	84,65,	88,65,	90,65,	
91,138,	88,135,	0,0,	80,65,	
92,139,	96,143,	72,65,	72,116,	
110,149,	91,65,	96,65,	107,107,	
110,65,	107,108,	124,163,	0,0,	
0,0,	92,65,	124,65,	0,0,	
54,102,	72,115,	54,101,	84,130,	
80,126,	121,160,	90,137,	0,0,	
0,0,	84,65,	88,65,	90,65,	
91,138,	88,135,	54,101,	80,65,	
92,139,	96,143,	72,65,	72,116,	
110,149,	91,65,	96,65,	0,0,	
110,65,	112,151,	124,163,	112,65,	
54,101,	92,65,	124,65,	54,101,	
54,101,	54,101,	54,101,	54,101,	
54,101,	54,101,	54,101,	54,101,	
54,101,	54,101,	54,101,	54,101,	
54,101,	54,101,	54,101,	54,101,	
54,101,	54,101,	54,101,	54,101,	
54,101,	54,101,	54,101,	54,101,	
55,103,	112,151,	94,141,	112,65,	
97,144,	99,146,	98,145,	109,148,	
55,103,	55,0,	113,152,	114,65,	
127,167,	114,153,	99,65,	0,0,	
115,154,	97,65,	94,65,	98,65,	
125,164,	145,185,	115,65,	113,65,	
109,65,	116,65,	127,65,	116,155,	
117,156,	0,0,	125,65,	117,65,	
0,0,	55,103,	94,141,	55,103,	
97,144,	99,146,	98,145,	109,148,	
0,0,	0,0,	113,152,	114,65,	
127,167,	114,153,	99,65,	55,103,	
115,154,	97,65,	94,65,	98,65,	
0,0,	145,185,	115,65,	113,65,	
109,65,	116,65,	127,65,	116,155,	
117,156,	55,102,	125,65,	117,65,	
55,103,	55,103,	55,103,	55,103,	
55,103,	55,103,	55,103,	55,103,	
55,103,	55,103,	55,103,	55,103,	
55,103,	55,103,	55,103,	55,103,	
55,103,	55,103,	55,103,	55,103,	
55,103,	55,103,	55,103,	55,103,	
55,103,	56,104,	0,0,	0,0,	
0,0,	0,0,	130,65,	152,191,	
119,158,	56,104,	56,0,	119,65,	
106,107,	130,170,	118,157,	120,65,	
0,0,	131,171,	120,159,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	118,65,	0,0,	153,192,	
131,65,	0,0,	56,105,	106,107,	
56,104,	106,108,	130,65,	152,191,	
119,158,	0,0,	0,0,	119,65,	
0,0,	130,170,	118,157,	120,65,	
56,104,	131,171,	120,159,	106,106,	
106,106,	106,106,	106,106,	106,106,	
106,106,	106,106,	106,106,	106,106,	
106,106,	118,65,	56,104,	153,192,	
131,65,	56,104,	56,104,	56,104,	
56,104,	56,104,	56,104,	56,104,	
56,104,	56,104,	56,104,	56,104,	
56,104,	56,104,	56,104,	56,104,	
56,104,	56,104,	56,104,	56,104,	
56,104,	56,104,	56,104,	56,104,	
56,104,	56,104,	108,108,	0,0,	
122,161,	0,0,	123,162,	122,65,	
128,168,	123,65,	108,108,	108,108,	
126,165,	132,172,	155,194,	126,65,	
126,166,	0,0,	129,65,	142,182,	
129,169,	133,173,	132,65,	134,65,	
156,195,	128,65,	134,174,	133,65,	
135,65,	136,65,	135,175,	0,0,	
142,65,	136,176,	0,0,	108,147,	
122,161,	108,108,	123,162,	122,65,	
128,168,	123,65,	0,0,	0,0,	
126,165,	132,172,	155,194,	126,65,	
126,166,	108,108,	129,65,	142,182,	
129,169,	133,173,	132,65,	134,65,	
156,195,	128,65,	134,174,	133,65,	
135,65,	136,65,	135,175,	108,108,	
142,65,	136,176,	108,108,	108,108,	
108,108,	108,108,	108,108,	108,108,	
108,108,	108,108,	108,108,	108,108,	
108,108,	108,108,	108,108,	108,108,	
108,108,	108,108,	108,108,	108,108,	
108,108,	108,108,	108,108,	108,108,	
108,108,	108,108,	108,108,	137,177,	
138,178,	137,65,	138,65,	139,179,	
140,65,	139,65,	0,0,	140,180,	
141,65,	141,181,	143,183,	144,184,	
143,65,	144,65,	146,65,	148,65,	
146,186,	149,65,	158,197,	149,188,	
150,65,	154,193,	148,187,	0,0,	
150,189,	151,190,	157,65,	154,65,	
157,196,	0,0,	0,0,	137,177,	
138,178,	137,65,	138,65,	139,179,	
140,65,	139,65,	151,65,	140,180,	
141,65,	141,181,	143,183,	144,184,	
143,65,	144,65,	146,65,	148,65,	
146,186,	149,65,	158,197,	149,188,	
150,65,	154,193,	148,187,	160,199,	
150,189,	151,190,	157,65,	154,65,	
157,196,	159,65,	161,200,	159,198,	
163,202,	162,65,	161,65,	162,201,	
164,65,	165,204,	151,65,	165,65,	
160,65,	166,205,	168,207,	167,206,	
169,208,	163,65,	171,210,	170,209,	
0,0,	164,203,	173,65,	168,65,	
170,65,	0,0,	166,65,	160,199,	
167,65,	173,212,	0,0,	171,65,	
178,65,	159,65,	161,200,	159,198,	
163,202,	162,65,	161,65,	162,201,	
164,65,	165,204,	182,65,	165,65,	
160,65,	166,205,	168,207,	167,206,	
169,208,	163,65,	171,210,	170,209,	
172,211,	175,214,	173,65,	168,65,	
170,65,	174,213,	166,65,	176,215,	
167,65,	173,212,	175,65,	171,65,	
178,65,	177,216,	172,65,	179,218,	
177,217,	181,65,	174,65,	177,65,	
176,65,	179,65,	182,65,	180,219,	
181,220,	183,221,	187,65,	190,65,	
183,65,	184,222,	195,65,	188,225,	
172,211,	175,214,	185,223,	184,65,	
185,65,	174,213,	180,65,	176,215,	
188,65,	186,65,	175,65,	186,224,	
0,0,	177,216,	172,65,	179,218,	
177,217,	181,65,	174,65,	177,65,	
176,65,	179,65,	198,65,	180,219,	
181,220,	183,221,	187,65,	190,65,	
183,65,	184,222,	195,65,	188,225,	
189,226,	192,228,	185,223,	184,65,	
185,65,	191,65,	180,65,	191,227,	
188,65,	186,65,	192,65,	186,224,	
193,229,	189,65,	194,65,	193,65,	
196,231,	194,230,	197,65,	199,233,	
197,232,	201,235,	198,65,	199,65,	
200,234,	196,65,	203,237,	201,65,	
202,236,	205,239,	205,65,	203,65,	
189,226,	192,228,	202,65,	200,65,	
204,65,	191,65,	204,238,	191,227,	
209,243,	206,240,	192,65,	209,65,	
193,229,	189,65,	194,65,	193,65,	
196,231,	194,230,	197,65,	199,233,	
197,232,	201,235,	211,65,	199,65,	
200,234,	196,65,	206,65,	201,65,	
202,236,	205,239,	205,65,	203,65,	
208,242,	210,244,	202,65,	200,65,	
204,65,	207,65,	204,238,	207,241,	
209,243,	206,240,	212,245,	209,65,	
212,65,	213,65,	213,246,	210,65,	
214,247,	208,65,	215,248,	217,250,	
214,65,	216,249,	211,65,	218,65,	
221,254,	219,65,	206,65,	219,252,	
220,65,	220,253,	218,251,	222,65,	
208,242,	210,244,	216,65,	223,256,	
225,258,	207,65,	222,255,	207,241,	
225,65,	0,0,	212,245,	226,259,	
212,65,	213,65,	213,246,	210,65,	
214,247,	208,65,	215,248,	217,250,	
214,65,	216,249,	229,262,	218,65,	
221,254,	219,65,	227,65,	219,252,	
220,65,	220,253,	218,251,	222,65,	
224,257,	227,260,	216,65,	223,256,	
225,258,	229,65,	222,255,	232,65,	
225,65,	224,65,	228,261,	226,259,	
230,263,	231,264,	228,65,	233,65,	
231,65,	234,65,	235,265,	237,65,	
237,268,	235,65,	229,262,	243,274,	
240,271,	238,269,	227,65,	230,65,	
236,65,	236,266,	240,65,	236,267,	
224,257,	227,260,	238,65,	244,65,	
239,270,	229,65,	244,275,	232,65,	
239,65,	224,65,	228,261,	0,0,	
230,263,	231,264,	228,65,	233,65,	
231,65,	234,65,	235,265,	237,65,	
241,65,	235,65,	241,272,	243,274,	
240,271,	238,269,	252,65,	230,65,	
236,65,	236,266,	240,65,	236,267,	
247,278,	242,273,	238,65,	244,65,	
239,270,	242,65,	244,275,	245,276,	
239,65,	246,65,	245,65,	246,277,	
256,289,	247,65,	248,279,	248,280,	
249,282,	250,65,	249,283,	250,284,	
241,65,	251,285,	241,272,	251,65,	
262,65,	256,65,	252,65,	248,281,	
253,65,	248,65,	253,286,	0,0,	
247,278,	242,273,	254,65,	0,0,	
254,287,	242,65,	255,288,	245,276,	
255,65,	246,65,	245,65,	246,277,	
256,289,	247,65,	248,279,	248,280,	
249,282,	250,65,	249,283,	250,284,	
259,65,	251,285,	259,292,	251,65,	
262,65,	256,65,	257,290,	248,281,	
253,65,	248,65,	253,286,	257,65,	
258,291,	261,294,	254,65,	258,65,	
254,287,	260,293,	255,288,	260,65,	
255,65,	263,65,	264,296,	263,295,	
261,65,	265,297,	264,65,	266,298,	
268,300,	265,65,	267,65,	267,299,	
259,65,	269,301,	259,292,	0,0,	
269,65,	272,304,	257,290,	268,65,	
266,65,	273,65,	271,303,	257,65,	
258,291,	261,294,	272,65,	258,65,	
271,65,	260,293,	274,305,	260,65,	
274,65,	263,65,	264,296,	263,295,	
261,65,	265,297,	264,65,	266,298,	
275,306,	265,65,	267,65,	267,299,	
270,302,	269,301,	276,307,	270,65,	
269,65,	272,304,	278,65,	268,65,	
266,65,	273,65,	271,303,	277,308,	
279,309,	277,65,	272,65,	279,65,	
271,65,	280,310,	274,305,	281,311,	
274,65,	282,312,	283,313,	284,65,	
285,314,	283,65,	286,315,	285,65,	
275,306,	287,65,	280,65,	0,0,	
270,302,	288,316,	276,307,	270,65,	
288,65,	290,318,	278,65,	286,65,	
289,317,	292,65,	294,65,	277,308,	
279,309,	277,65,	296,65,	279,65,	
292,320,	280,310,	290,65,	281,311,	
289,65,	282,312,	283,313,	284,65,	
285,314,	283,65,	286,315,	285,65,	
291,65,	287,65,	280,65,	291,319,	
293,321,	288,316,	298,324,	295,322,	
288,65,	290,318,	295,65,	286,65,	
289,317,	292,65,	294,65,	297,323,	
299,325,	293,65,	296,65,	301,327,	
292,320,	300,65,	290,65,	301,65,	
289,65,	302,65,	297,65,	303,328,	
304,329,	299,65,	303,65,	305,330,	
291,65,	304,65,	300,326,	291,319,	
293,321,	306,331,	298,324,	295,322,	
314,339,	305,65,	295,65,	307,65,	
309,334,	307,332,	309,65,	297,323,	
299,325,	293,65,	306,65,	301,327,	
0,0,	300,65,	316,341,	301,65,	
318,65,	302,65,	297,65,	303,328,	
304,329,	299,65,	303,65,	305,330,	
308,333,	304,65,	310,335,	308,65,	
311,336,	306,331,	321,65,	310,65,	
314,339,	305,65,	315,340,	307,65,	
309,334,	307,332,	309,65,	315,65,	
312,337,	311,65,	306,65,	312,65,	
313,65,	317,342,	316,341,	313,338,	
318,65,	319,65,	320,344,	319,343,	
320,65,	322,345,	317,65,	323,65,	
308,333,	324,65,	310,335,	308,65,	
311,336,	324,346,	321,65,	310,65,	
325,347,	326,65,	315,340,	326,348,	
327,65,	331,65,	332,65,	315,65,	
312,337,	311,65,	333,352,	312,65,	
313,65,	317,342,	329,350,	313,338,	
328,349,	319,65,	320,344,	319,343,	
320,65,	322,345,	317,65,	323,65,	
340,65,	324,65,	330,351,	329,65,	
0,0,	324,346,	337,356,	328,65,	
325,347,	326,65,	334,65,	330,65,	
327,65,	331,65,	332,65,	336,355,	
335,65,	334,353,	333,352,	335,354,	
343,65,	337,65,	329,350,	338,65,	
328,349,	338,357,	339,65,	336,65,	
339,358,	341,65,	342,65,	341,359,	
340,65,	344,361,	330,351,	329,65,	
342,360,	345,65,	337,356,	328,65,	
347,65,	346,362,	334,65,	330,65,	
349,65,	350,65,	344,65,	336,355,	
335,65,	334,353,	0,0,	335,354,	
343,65,	337,65,	346,65,	338,65,	
353,65,	338,357,	339,65,	336,65,	
339,358,	341,65,	342,65,	341,359,	
348,65,	344,361,	351,364,	0,0,	
342,360,	345,65,	358,65,	348,363,	
347,65,	346,362,	355,367,	359,65,	
349,65,	350,65,	344,65,	354,65,	
352,65,	351,65,	352,365,	355,65,	
356,368,	354,366,	346,65,	360,65,	
353,65,	361,65,	357,369,	362,370,	
363,371,	364,65,	363,65,	365,65,	
348,65,	356,65,	351,364,	357,65,	
366,65,	369,374,	358,65,	367,65,	
368,373,	369,65,	355,367,	359,65,	
370,65,	367,372,	372,65,	354,65,	
352,65,	351,65,	352,365,	355,65,	
356,368,	354,366,	368,65,	360,65,	
0,0,	361,65,	357,369,	362,370,	
376,379,	364,65,	363,65,	365,65,	
377,65,	356,65,	371,375,	357,65,	
366,65,	369,374,	0,0,	367,65,	
368,373,	369,65,	374,377,	375,65,	
370,65,	367,372,	372,65,	371,65,	
373,65,	379,388,	0,0,	373,376,	
378,380,	378,381,	368,65,	374,65,	
375,378,	0,0,	0,0,	378,382,	
376,379,	380,389,	379,65,	378,383,	
377,65,	0,0,	378,384,	380,390,	
378,385,	378,386,	380,65,	378,387,	
382,394,	388,65,	374,377,	375,65,	
382,65,	380,391,	381,392,	371,65,	
373,65,	379,388,	383,395,	373,376,	
385,398,	381,393,	384,397,	374,65,	
381,65,	384,65,	386,65,	387,400,	
386,399,	392,404,	379,65,	387,65,	
383,396,	385,65,	399,412,	383,65,	
378,65,	389,65,	380,65,	389,401,	
390,402,	388,65,	401,65,	390,65,	
382,65,	391,65,	392,65,	391,403,	
393,405,	394,65,	393,65,	394,406,	
395,407,	398,411,	0,0,	397,409,	
381,65,	384,65,	386,65,	395,65,	
396,65,	397,410,	402,414,	387,65,	
396,408,	385,65,	399,65,	383,65,	
402,65,	389,65,	398,65,	400,65,	
400,413,	403,415,	401,65,	390,65,	
404,416,	391,65,	392,65,	415,65,	
405,65,	394,65,	393,65,	406,418,	
407,419,	408,420,	403,65,	405,417,	
409,65,	416,65,	0,0,	395,65,	
396,65,	397,65,	0,0,	409,421,	
406,65,	407,65,	408,65,	410,65,	
402,65,	410,422,	398,65,	400,65,	
411,423,	412,424,	414,426,	413,65,	
404,65,	413,425,	411,65,	415,65,	
405,65,	417,65,	412,65,	423,65,	
418,428,	425,434,	403,65,	414,65,	
409,65,	416,65,	419,65,	420,65,	
426,435,	422,65,	417,427,	418,65,	
406,65,	407,65,	408,65,	410,65,	
421,431,	427,65,	427,436,	419,429,	
420,430,	421,65,	422,432,	413,65,	
424,433,	426,65,	411,65,	428,437,	
424,65,	417,65,	412,65,	423,65,	
437,449,	425,65,	0,0,	414,65,	
429,65,	429,438,	419,65,	420,65,	
428,65,	422,65,	435,447,	418,65,	
430,439,	430,440,	435,65,	431,441,	
433,445,	427,65,	431,65,	432,442,	
436,448,	421,65,	438,450,	432,443,	
432,444,	426,65,	434,65,	433,65,	
424,65,	434,446,	439,451,	441,453,	
437,65,	436,65,	440,452,	438,65,	
429,65,	442,454,	443,455,	444,456,	
428,65,	446,458,	447,65,	439,65,	
430,65,	448,459,	435,65,	440,65,	
445,65,	448,65,	431,65,	443,65,	
444,65,	449,65,	442,65,	432,65,	
446,65,	451,462,	434,65,	433,65,	
450,461,	445,457,	455,466,	441,65,	
450,65,	436,65,	449,460,	438,65,	
453,464,	452,463,	453,65,	454,465,	
451,65,	452,65,	447,65,	439,65,	
454,65,	455,65,	456,467,	440,65,	
445,65,	448,65,	456,65,	443,65,	
444,65,	449,65,	442,65,	458,65,	
446,65,	458,469,	460,471,	457,468,	
460,472,	459,470,	468,65,	470,65,	
450,65,	460,473,	461,474,	0,0,	
462,475,	463,476,	453,65,	465,478,	
451,65,	452,65,	457,65,	459,65,	
454,65,	455,65,	464,477,	466,479,	
461,65,	462,65,	456,65,	463,65,	
465,65,	467,480,	469,65,	458,65,	
464,65,	469,481,	472,483,	460,65,	
466,65,	471,482,	468,65,	470,65,	
473,65,	474,65,	476,65,	467,65,	
475,485,	478,65,	481,490,	482,65,	
483,65,	477,487,	457,65,	459,65,	
479,488,	475,65,	474,484,	476,486,	
461,65,	462,65,	477,65,	463,65,	
465,65,	479,65,	469,65,	480,65,	
464,65,	471,65,	472,65,	460,65,	
466,65,	0,0,	490,497,	0,0,	
473,65,	474,65,	476,65,	467,65,	
480,489,	478,65,	481,65,	482,65,	
483,65,	484,491,	485,65,	490,65,	
484,65,	475,65,	485,492,	487,494,	
486,493,	494,65,	477,65,	486,65,	
488,65,	479,65,	492,499,	480,65,	
488,495,	471,65,	472,65,	495,501,	
489,496,	491,498,	487,65,	489,65,	
493,500,	491,65,	496,502,	492,65,	
493,65,	499,65,	496,65,	497,503,	
495,65,	498,504,	485,65,	490,65,	
484,65,	500,505,	501,65,	503,65,	
504,507,	494,65,	507,65,	486,65,	
488,65,	497,65,	508,65,	509,65,	
498,65,	0,0,	502,506,	0,0,	
500,65,	504,65,	487,65,	489,65,	
505,508,	491,65,	0,0,	492,65,	
493,65,	499,65,	496,65,	506,509,	
495,65,	502,65,	0,0,	0,0,	
0,0,	505,65,	501,65,	503,65,	
0,0,	0,0,	507,65,	0,0,	
506,65,	497,65,	508,65,	509,65,	
498,65,	0,0,	0,0,	0,0,	
500,65,	504,65,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	502,65,	0,0,	0,0,	
0,0,	505,65,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
506,65,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-1,	yysvec+1,	0,	
yycrank+-90,	0,		0,	
yycrank+-145,	yysvec+3,	0,	
yycrank+-207,	yysvec+1,	0,	
yycrank+-262,	yysvec+1,	0,	
yycrank+-4,	yysvec+1,	0,	
yycrank+-5,	yysvec+1,	0,	
yycrank+-7,	yysvec+1,	0,	
yycrank+-8,	yysvec+1,	0,	
yycrank+-351,	0,		0,	
yycrank+-9,	yysvec+11,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+208,	0,		yyvstop+8,
yycrank+0,	0,		yyvstop+11,
yycrank+0,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+17,
yycrank+0,	0,		yyvstop+20,
yycrank+0,	0,		yyvstop+23,
yycrank+0,	0,		yyvstop+26,
yycrank+0,	0,		yyvstop+29,
yycrank+2,	0,		yyvstop+32,
yycrank+0,	0,		yyvstop+35,
yycrank+0,	0,		yyvstop+38,
yycrank+0,	0,		yyvstop+41,
yycrank+0,	0,		yyvstop+44,
yycrank+0,	0,		yyvstop+47,
yycrank+393,	0,		yyvstop+50,
yycrank+11,	yysvec+30,	yyvstop+53,
yycrank+25,	yysvec+30,	yyvstop+56,
yycrank+127,	yysvec+30,	yyvstop+59,
yycrank+13,	yysvec+30,	yyvstop+62,
yycrank+29,	yysvec+30,	yyvstop+65,
yycrank+280,	yysvec+30,	yyvstop+68,
yycrank+128,	yysvec+30,	yyvstop+71,
yycrank+130,	yysvec+30,	yyvstop+74,
yycrank+33,	yysvec+30,	yyvstop+77,
yycrank+284,	yysvec+30,	yyvstop+80,
yycrank+112,	yysvec+30,	yyvstop+83,
yycrank+301,	yysvec+30,	yyvstop+86,
yycrank+447,	yysvec+30,	yyvstop+89,
yycrank+111,	yysvec+30,	yyvstop+92,
yycrank+291,	yysvec+30,	yyvstop+95,
yycrank+31,	yysvec+30,	yyvstop+98,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	0,		yyvstop+104,
yycrank+0,	0,		yyvstop+107,
yycrank+39,	yysvec+30,	yyvstop+110,
yycrank+0,	0,		yyvstop+113,
yycrank+0,	0,		yyvstop+116,
yycrank+520,	0,		yyvstop+119,
yycrank+-642,	0,		yyvstop+122,
yycrank+-731,	0,		yyvstop+124,
yycrank+-820,	0,		yyvstop+126,
yycrank+0,	0,		yyvstop+128,
yycrank+0,	0,		yyvstop+131,
yycrank+0,	0,		yyvstop+135,
yycrank+0,	yysvec+16,	yyvstop+138,
yycrank+267,	yysvec+16,	0,	
yycrank+0,	yysvec+16,	0,	
yycrank+13,	yysvec+16,	yyvstop+142,
yycrank+0,	yysvec+24,	yyvstop+144,
yycrank+15,	yysvec+30,	yyvstop+146,
yycrank+116,	yysvec+30,	yyvstop+148,
yycrank+133,	yysvec+30,	yyvstop+150,
yycrank+152,	yysvec+30,	yyvstop+152,
yycrank+283,	yysvec+30,	yyvstop+154,
yycrank+137,	yysvec+30,	yyvstop+156,
yycrank+293,	yysvec+30,	yyvstop+158,
yycrank+580,	yysvec+30,	yyvstop+160,
yycrank+119,	yysvec+30,	yyvstop+162,
yycrank+300,	yysvec+30,	yyvstop+164,
yycrank+188,	yysvec+30,	yyvstop+166,
yycrank+373,	yysvec+30,	yyvstop+168,
yycrank+441,	yysvec+30,	yyvstop+171,
yycrank+153,	yysvec+30,	yyvstop+173,
yycrank+289,	yysvec+30,	yyvstop+175,
yycrank+577,	yysvec+30,	yyvstop+177,
yycrank+443,	yysvec+30,	yyvstop+179,
yycrank+277,	yysvec+30,	yyvstop+181,
yycrank+295,	yysvec+30,	yyvstop+184,
yycrank+571,	yysvec+30,	yyvstop+186,
yycrank+439,	yysvec+30,	yyvstop+188,
yycrank+371,	yysvec+30,	yyvstop+190,
yycrank+499,	yysvec+30,	yyvstop+192,
yycrank+572,	yysvec+30,	yyvstop+194,
yycrank+444,	yysvec+30,	yyvstop+196,
yycrank+573,	yysvec+30,	yyvstop+198,
yycrank+583,	yysvec+30,	yyvstop+200,
yycrank+591,	yysvec+30,	yyvstop+202,
yycrank+446,	yysvec+30,	yyvstop+204,
yycrank+668,	yysvec+30,	yyvstop+206,
yycrank+502,	yysvec+30,	yyvstop+208,
yycrank+584,	yysvec+30,	yyvstop+210,
yycrank+667,	yysvec+30,	yyvstop+212,
yycrank+669,	yysvec+30,	yyvstop+214,
yycrank+664,	yysvec+30,	yyvstop+216,
yycrank+0,	yysvec+53,	yyvstop+218,
yycrank+-82,	yysvec+54,	0,	
yycrank+0,	0,		yyvstop+220,
yycrank+-84,	yysvec+55,	0,	
yycrank+-88,	yysvec+56,	0,	
yycrank+0,	0,		yyvstop+222,
yycrank+823,	0,		0,	
yycrank+635,	0,		0,	
yycrank+-909,	0,		0,	
yycrank+674,	yysvec+30,	yyvstop+224,
yycrank+586,	yysvec+30,	yyvstop+226,
yycrank+464,	yysvec+30,	yyvstop+228,
yycrank+621,	yysvec+30,	yyvstop+230,
yycrank+673,	yysvec+30,	yyvstop+232,
yycrank+661,	yysvec+30,	yyvstop+234,
yycrank+672,	yysvec+30,	yyvstop+236,
yycrank+675,	yysvec+30,	yyvstop+238,
yycrank+681,	yysvec+30,	yyvstop+240,
yycrank+767,	yysvec+30,	yyvstop+242,
yycrank+749,	yysvec+30,	yyvstop+244,
yycrank+753,	yysvec+30,	yyvstop+246,
yycrank+567,	yysvec+30,	yyvstop+248,
yycrank+833,	yysvec+30,	yyvstop+250,
yycrank+835,	yysvec+30,	yyvstop+252,
yycrank+592,	yysvec+30,	yyvstop+254,
yycrank+680,	yysvec+30,	yyvstop+256,
yycrank+841,	yysvec+30,	yyvstop+258,
yycrank+676,	yysvec+30,	yyvstop+260,
yycrank+851,	yysvec+30,	yyvstop+262,
yycrank+844,	yysvec+30,	yyvstop+264,
yycrank+744,	yysvec+30,	yyvstop+267,
yycrank+770,	yysvec+30,	yyvstop+269,
yycrank+848,	yysvec+30,	yyvstop+271,
yycrank+853,	yysvec+30,	yyvstop+273,
yycrank+849,	yysvec+30,	yyvstop+275,
yycrank+854,	yysvec+30,	yyvstop+277,
yycrank+855,	yysvec+30,	yyvstop+279,
yycrank+919,	yysvec+30,	yyvstop+281,
yycrank+920,	yysvec+30,	yyvstop+283,
yycrank+923,	yysvec+30,	yyvstop+285,
yycrank+922,	yysvec+30,	yyvstop+287,
yycrank+926,	yysvec+30,	yyvstop+289,
yycrank+858,	yysvec+30,	yyvstop+291,
yycrank+930,	yysvec+30,	yyvstop+293,
yycrank+931,	yysvec+30,	yyvstop+295,
yycrank+671,	yysvec+30,	yyvstop+297,
yycrank+932,	yysvec+30,	yyvstop+299,
yycrank+0,	0,		yyvstop+301,
yycrank+933,	yysvec+30,	yyvstop+303,
yycrank+935,	yysvec+30,	yyvstop+305,
yycrank+938,	yysvec+30,	yyvstop+307,
yycrank+956,	yysvec+30,	yyvstop+309,
yycrank+745,	yysvec+30,	yyvstop+311,
yycrank+769,	yysvec+30,	yyvstop+313,
yycrank+945,	yysvec+30,	yyvstop+315,
yycrank+840,	yysvec+30,	yyvstop+317,
yycrank+850,	yysvec+30,	yyvstop+319,
yycrank+944,	yysvec+30,	yyvstop+321,
yycrank+936,	yysvec+30,	yyvstop+323,
yycrank+979,	yysvec+30,	yyvstop+325,
yycrank+990,	yysvec+30,	yyvstop+327,
yycrank+984,	yysvec+30,	yyvstop+329,
yycrank+983,	yysvec+30,	yyvstop+331,
yycrank+995,	yysvec+30,	yyvstop+333,
yycrank+986,	yysvec+30,	yyvstop+335,
yycrank+989,	yysvec+30,	yyvstop+337,
yycrank+1004,	yysvec+30,	yyvstop+339,
yycrank+1006,	yysvec+30,	yyvstop+341,
yycrank+1001,	yysvec+30,	yyvstop+343,
yycrank+994,	yysvec+30,	yyvstop+345,
yycrank+1002,	yysvec+30,	yyvstop+347,
yycrank+1009,	yysvec+30,	yyvstop+349,
yycrank+1044,	yysvec+30,	yyvstop+351,
yycrank+1000,	yysvec+30,	yyvstop+353,
yycrank+1048,	yysvec+30,	yyvstop+355,
yycrank+1040,	yysvec+30,	yyvstop+357,
yycrank+1050,	yysvec+30,	yyvstop+359,
yycrank+1049,	yysvec+30,	yyvstop+361,
yycrank+1010,	yysvec+30,	yyvstop+363,
yycrank+1051,	yysvec+30,	yyvstop+366,
yycrank+1068,	yysvec+30,	yyvstop+368,
yycrank+1047,	yysvec+30,	yyvstop+370,
yycrank+1020,	yysvec+30,	yyvstop+372,
yycrank+1058,	yysvec+30,	yyvstop+375,
yycrank+1065,	yysvec+30,	yyvstop+377,
yycrank+1066,	yysvec+30,	yyvstop+379,
yycrank+1071,	yysvec+30,	yyvstop+381,
yycrank+1056,	yysvec+30,	yyvstop+383,
yycrank+1070,	yysvec+30,	yyvstop+386,
yycrank+1107,	yysvec+30,	yyvstop+388,
yycrank+1057,	yysvec+30,	yyvstop+390,
yycrank+1099,	yysvec+30,	yyvstop+393,
yycrank+1104,	yysvec+30,	yyvstop+395,
yycrank+1109,	yysvec+30,	yyvstop+397,
yycrank+1108,	yysvec+30,	yyvstop+399,
yycrank+1060,	yysvec+30,	yyvstop+401,
yycrank+1119,	yysvec+30,	yyvstop+404,
yycrank+1112,	yysvec+30,	yyvstop+406,
yycrank+1084,	yysvec+30,	yyvstop+408,
yycrank+1117,	yysvec+30,	yyvstop+411,
yycrank+1129,	yysvec+30,	yyvstop+413,
yycrank+1121,	yysvec+30,	yyvstop+415,
yycrank+1128,	yysvec+30,	yyvstop+417,
yycrank+1125,	yysvec+30,	yyvstop+419,
yycrank+1130,	yysvec+30,	yyvstop+421,
yycrank+1124,	yysvec+30,	yyvstop+423,
yycrank+1152,	yysvec+30,	yyvstop+425,
yycrank+1163,	yysvec+30,	yyvstop+427,
yycrank+1175,	yysvec+30,	yyvstop+429,
yycrank+1137,	yysvec+30,	yyvstop+431,
yycrank+1173,	yysvec+30,	yyvstop+433,
yycrank+1148,	yysvec+30,	yyvstop+435,
yycrank+1170,	yysvec+30,	yyvstop+438,
yycrank+1171,	yysvec+30,	yyvstop+440,
yycrank+1178,	yysvec+30,	yyvstop+442,
yycrank+1176,	yysvec+30,	yyvstop+444,
yycrank+1192,	yysvec+30,	yyvstop+446,
yycrank+1177,	yysvec+30,	yyvstop+448,
yycrank+1181,	yysvec+30,	yyvstop+450,
yycrank+1183,	yysvec+30,	yyvstop+452,
yycrank+1186,	yysvec+30,	yyvstop+454,
yycrank+1182,	yysvec+30,	yyvstop+456,
yycrank+1189,	yysvec+30,	yyvstop+458,
yycrank+1193,	yysvec+30,	yyvstop+460,
yycrank+1231,	yysvec+30,	yyvstop+462,
yycrank+1198,	yysvec+30,	yyvstop+464,
yycrank+1201,	yysvec+30,	yyvstop+466,
yycrank+1216,	yysvec+30,	yyvstop+468,
yycrank+1236,	yysvec+30,	yyvstop+470,
yycrank+1227,	yysvec+30,	yyvstop+472,
yycrank+1249,	yysvec+30,	yyvstop+474,
yycrank+1238,	yysvec+30,	yyvstop+476,
yycrank+1229,	yysvec+30,	yyvstop+478,
yycrank+1237,	yysvec+30,	yyvstop+481,
yycrank+1239,	yysvec+30,	yyvstop+484,
yycrank+1243,	yysvec+30,	yyvstop+487,
yycrank+1250,	yysvec+30,	yyvstop+489,
yycrank+1241,	yysvec+30,	yyvstop+491,
yycrank+1256,	yysvec+30,	yyvstop+493,
yycrank+1262,	yysvec+30,	yyvstop+495,
yycrank+1252,	yysvec+30,	yyvstop+497,
yycrank+1274,	yysvec+30,	yyvstop+499,
yycrank+1291,	yysvec+30,	yyvstop+501,
yycrank+1245,	yysvec+30,	yyvstop+503,
yycrank+1257,	yysvec+30,	yyvstop+505,
yycrank+1296,	yysvec+30,	yyvstop+507,
yycrank+1295,	yysvec+30,	yyvstop+509,
yycrank+1299,	yysvec+30,	yyvstop+511,
yycrank+1315,	yysvec+30,	yyvstop+513,
yycrank+1304,	yysvec+30,	yyvstop+515,
yycrank+1303,	yysvec+30,	yyvstop+517,
yycrank+1309,	yysvec+30,	yyvstop+519,
yycrank+1280,	yysvec+30,	yyvstop+521,
yycrank+1314,	yysvec+30,	yyvstop+524,
yycrank+1320,	yysvec+30,	yyvstop+526,
yycrank+1326,	yysvec+30,	yyvstop+528,
yycrank+1311,	yysvec+30,	yyvstop+530,
yycrank+1349,	yysvec+30,	yyvstop+532,
yycrank+1353,	yysvec+30,	yyvstop+534,
yycrank+1338,	yysvec+30,	yyvstop+536,
yycrank+1357,	yysvec+30,	yyvstop+538,
yycrank+1362,	yysvec+30,	yyvstop+540,
yycrank+1310,	yysvec+30,	yyvstop+542,
yycrank+1359,	yysvec+30,	yyvstop+545,
yycrank+1364,	yysvec+30,	yyvstop+547,
yycrank+1367,	yysvec+30,	yyvstop+549,
yycrank+1378,	yysvec+30,	yyvstop+551,
yycrank+1368,	yysvec+30,	yyvstop+553,
yycrank+1377,	yysvec+30,	yyvstop+555,
yycrank+1374,	yysvec+30,	yyvstop+557,
yycrank+1405,	yysvec+30,	yyvstop+559,
yycrank+1386,	yysvec+30,	yyvstop+561,
yycrank+1384,	yysvec+30,	yyvstop+563,
yycrank+1379,	yysvec+30,	yyvstop+565,
yycrank+1390,	yysvec+30,	yyvstop+568,
yycrank+1398,	yysvec+30,	yyvstop+570,
yycrank+1404,	yysvec+30,	yyvstop+572,
yycrank+1415,	yysvec+30,	yyvstop+574,
yycrank+1408,	yysvec+30,	yyvstop+576,
yycrank+1417,	yysvec+30,	yyvstop+579,
yycrank+1432,	yysvec+30,	yyvstop+581,
yycrank+1421,	yysvec+30,	yyvstop+583,
yycrank+1423,	yysvec+30,	yyvstop+585,
yycrank+1427,	yysvec+30,	yyvstop+587,
yycrank+1425,	yysvec+30,	yyvstop+589,
yycrank+1429,	yysvec+30,	yyvstop+592,
yycrank+1441,	yysvec+30,	yyvstop+594,
yycrank+1431,	yysvec+30,	yyvstop+596,
yycrank+1438,	yysvec+30,	yyvstop+599,
yycrank+1454,	yysvec+30,	yyvstop+601,
yycrank+1452,	yysvec+30,	yyvstop+603,
yycrank+1462,	yysvec+30,	yyvstop+605,
yycrank+1443,	yysvec+30,	yyvstop+607,
yycrank+1479,	yysvec+30,	yyvstop+609,
yycrank+1444,	yysvec+30,	yyvstop+611,
yycrank+1472,	yysvec+30,	yyvstop+614,
yycrank+1448,	yysvec+30,	yyvstop+616,
yycrank+1488,	yysvec+30,	yyvstop+619,
yycrank+1468,	yysvec+30,	yyvstop+621,
yycrank+1491,	yysvec+30,	yyvstop+623,
yycrank+1483,	yysvec+30,	yyvstop+625,
yycrank+1485,	yysvec+30,	yyvstop+627,
yycrank+1487,	yysvec+30,	yyvstop+629,
yycrank+1492,	yysvec+30,	yyvstop+632,
yycrank+1495,	yysvec+30,	yyvstop+634,
yycrank+1503,	yysvec+30,	yyvstop+636,
yycrank+1512,	yysvec+30,	yyvstop+638,
yycrank+1505,	yysvec+30,	yyvstop+640,
yycrank+1529,	yysvec+30,	yyvstop+642,
yycrank+1508,	yysvec+30,	yyvstop+644,
yycrank+1533,	yysvec+30,	yyvstop+646,
yycrank+1543,	yysvec+30,	yyvstop+648,
yycrank+1545,	yysvec+30,	yyvstop+650,
yycrank+1546,	yysvec+30,	yyvstop+652,
yycrank+1502,	yysvec+30,	yyvstop+654,
yycrank+1541,	yysvec+30,	yyvstop+656,
yycrank+1516,	yysvec+30,	yyvstop+658,
yycrank+1556,	yysvec+30,	yyvstop+660,
yycrank+1518,	yysvec+30,	yyvstop+662,
yycrank+1551,	yysvec+30,	yyvstop+665,
yycrank+1554,	yysvec+30,	yyvstop+667,
yycrank+1532,	yysvec+30,	yyvstop+669,
yycrank+1555,	yysvec+30,	yyvstop+672,
yycrank+1557,	yysvec+30,	yyvstop+674,
yycrank+1559,	yysvec+30,	yyvstop+677,
yycrank+1566,	yysvec+30,	yyvstop+679,
yycrank+1567,	yysvec+30,	yyvstop+681,
yycrank+1570,	yysvec+30,	yyvstop+683,
yycrank+1597,	yysvec+30,	yyvstop+686,
yycrank+1593,	yysvec+30,	yyvstop+688,
yycrank+1601,	yysvec+30,	yyvstop+690,
yycrank+1571,	yysvec+30,	yyvstop+692,
yycrank+1572,	yysvec+30,	yyvstop+695,
yycrank+1576,	yysvec+30,	yyvstop+698,
yycrank+1600,	yysvec+30,	yyvstop+700,
yycrank+1606,	yysvec+30,	yyvstop+702,
yycrank+1617,	yysvec+30,	yyvstop+704,
yycrank+1611,	yysvec+30,	yyvstop+706,
yycrank+1613,	yysvec+30,	yyvstop+708,
yycrank+1616,	yysvec+30,	yyvstop+710,
yycrank+1590,	yysvec+30,	yyvstop+712,
yycrank+1619,	yysvec+30,	yyvstop+715,
yycrank+1620,	yysvec+30,	yyvstop+717,
yycrank+1610,	yysvec+30,	yyvstop+719,
yycrank+1636,	yysvec+30,	yyvstop+722,
yycrank+1627,	yysvec+30,	yyvstop+724,
yycrank+1644,	yysvec+30,	yyvstop+727,
yycrank+1630,	yysvec+30,	yyvstop+729,
yycrank+1654,	yysvec+30,	yyvstop+732,
yycrank+1634,	yysvec+30,	yyvstop+734,
yycrank+1635,	yysvec+30,	yyvstop+737,
yycrank+1671,	yysvec+30,	yyvstop+740,
yycrank+1670,	yysvec+30,	yyvstop+742,
yycrank+1646,	yysvec+30,	yyvstop+744,
yycrank+1669,	yysvec+30,	yyvstop+747,
yycrank+1673,	yysvec+30,	yyvstop+749,
yycrank+1687,	yysvec+30,	yyvstop+751,
yycrank+1689,	yysvec+30,	yyvstop+753,
yycrank+1660,	yysvec+30,	yyvstop+755,
yycrank+1665,	yysvec+30,	yyvstop+758,
yycrank+1677,	yysvec+30,	yyvstop+761,
yycrank+1679,	yysvec+30,	yyvstop+764,
yycrank+1681,	yysvec+30,	yyvstop+767,
yycrank+1684,	yysvec+30,	yyvstop+769,
yycrank+1683,	yysvec+30,	yyvstop+771,
yycrank+1685,	yysvec+30,	yyvstop+774,
yycrank+1690,	yysvec+30,	yyvstop+777,
yycrank+1693,	yysvec+30,	yyvstop+780,
yycrank+1708,	yysvec+30,	yyvstop+782,
yycrank+1695,	yysvec+30,	yyvstop+784,
yycrank+1698,	yysvec+30,	yyvstop+786,
yycrank+1733,	yysvec+30,	yyvstop+789,
yycrank+1700,	yysvec+30,	yyvstop+791,
yycrank+1734,	yysvec+30,	yyvstop+794,
yycrank+1741,	yysvec+30,	yyvstop+796,
yycrank+1729,	yysvec+30,	yyvstop+798,
yycrank+1714,	yysvec+30,	yyvstop+800,
yycrank+1718,	yysvec+30,	yyvstop+802,
yycrank+1754,	yysvec+30,	yyvstop+805,
yycrank+1748,	yysvec+30,	yyvstop+807,
yycrank+1756,	yysvec+30,	yyvstop+809,
yycrank+1774,	yysvec+30,	yyvstop+811,
yycrank+1762,	yysvec+30,	yyvstop+813,
yycrank+1785,	yysvec+30,	yyvstop+815,
yycrank+1775,	yysvec+30,	yyvstop+817,
yycrank+1783,	yysvec+30,	yyvstop+819,
yycrank+1776,	yysvec+30,	yyvstop+821,
yycrank+1781,	yysvec+30,	yyvstop+823,
yycrank+1759,	yysvec+30,	yyvstop+825,
yycrank+1787,	yysvec+30,	yyvstop+828,
yycrank+1793,	yysvec+30,	yyvstop+830,
yycrank+1795,	yysvec+30,	yyvstop+832,
yycrank+1796,	yysvec+30,	yyvstop+834,
yycrank+1800,	yysvec+30,	yyvstop+836,
yycrank+1799,	yysvec+30,	yyvstop+838,
yycrank+1809,	yysvec+30,	yyvstop+840,
yycrank+1810,	yysvec+30,	yyvstop+842,
yycrank+1811,	yysvec+30,	yyvstop+844,
yycrank+1820,	yysvec+30,	yyvstop+846,
yycrank+1784,	yysvec+30,	yyvstop+848,
yycrank+1821,	yysvec+30,	yyvstop+850,
yycrank+1792,	yysvec+30,	yyvstop+852,
yycrank+1818,	yysvec+30,	yyvstop+855,
yycrank+1836,	yysvec+30,	yyvstop+857,
yycrank+1826,	yysvec+30,	yyvstop+859,
yycrank+1830,	yysvec+30,	yyvstop+861,
yycrank+1846,	yysvec+30,	yyvstop+863,
yycrank+1847,	yysvec+30,	yyvstop+865,
yycrank+1848,	yysvec+30,	yyvstop+867,
yycrank+1838,	yysvec+30,	yyvstop+869,
yycrank+1849,	yysvec+30,	yyvstop+871,
yycrank+1860,	yysvec+30,	yyvstop+873,
yycrank+1864,	yysvec+30,	yyvstop+875,
yycrank+1857,	yysvec+30,	yyvstop+877,
yycrank+1869,	yysvec+30,	yyvstop+879,
yycrank+1829,	yysvec+30,	yyvstop+881,
yycrank+1839,	yysvec+30,	yyvstop+884,
yycrank+1863,	yysvec+30,	yyvstop+887,
yycrank+1877,	yysvec+30,	yyvstop+889,
yycrank+1872,	yysvec+30,	yyvstop+891,
yycrank+1873,	yysvec+30,	yyvstop+893,
yycrank+1887,	yysvec+30,	yyvstop+895,
yycrank+1875,	yysvec+30,	yyvstop+897,
yycrank+1865,	yysvec+30,	yyvstop+899,
yycrank+1894,	yysvec+30,	yyvstop+902,
yycrank+1867,	yysvec+30,	yyvstop+904,
yycrank+1891,	yysvec+30,	yyvstop+906,
yycrank+1883,	yysvec+30,	yyvstop+908,
yycrank+1906,	yysvec+30,	yyvstop+910,
yycrank+1902,	yysvec+30,	yyvstop+912,
yycrank+1910,	yysvec+30,	yyvstop+914,
yycrank+1916,	yysvec+30,	yyvstop+916,
yycrank+1921,	yysvec+30,	yyvstop+918,
yycrank+1925,	yysvec+30,	yyvstop+920,
yycrank+1924,	yysvec+30,	yyvstop+922,
yycrank+1912,	yysvec+30,	yyvstop+924,
yycrank+1931,	yysvec+30,	yyvstop+926,
yycrank+1898,	yysvec+30,	yyvstop+928,
yycrank+1933,	yysvec+30,	yyvstop+930,
yycrank+1941,	yysvec+30,	yyvstop+932,
yycrank+1945,	yysvec+30,	yyvstop+934,
yycrank+1929,	yysvec+30,	yyvstop+936,
yycrank+1952,	yysvec+30,	yyvstop+938,
yycrank+1949,	yysvec+30,	yyvstop+940,
yycrank+1950,	yysvec+30,	yyvstop+942,
yycrank+1946,	yysvec+30,	yyvstop+944,
yycrank+1954,	yysvec+30,	yyvstop+947,
yycrank+1940,	yysvec+30,	yyvstop+949,
yycrank+1947,	yysvec+30,	yyvstop+952,
yycrank+1951,	yysvec+30,	yyvstop+954,
yycrank+1962,	yysvec+30,	yyvstop+956,
yycrank+1970,	yysvec+30,	yyvstop+958,
yycrank+1971,	yysvec+30,	yyvstop+960,
yycrank+1968,	yysvec+30,	yyvstop+962,
yycrank+1974,	yysvec+30,	yyvstop+964,
yycrank+1975,	yysvec+30,	yyvstop+966,
yycrank+1980,	yysvec+30,	yyvstop+968,
yycrank+2004,	yysvec+30,	yyvstop+970,
yycrank+1985,	yysvec+30,	yyvstop+972,
yycrank+2005,	yysvec+30,	yyvstop+974,
yycrank+2021,	yysvec+30,	yyvstop+976,
yycrank+2010,	yysvec+30,	yyvstop+978,
yycrank+2011,	yysvec+30,	yyvstop+980,
yycrank+2013,	yysvec+30,	yyvstop+982,
yycrank+2018,	yysvec+30,	yyvstop+984,
yycrank+2014,	yysvec+30,	yyvstop+986,
yycrank+2022,	yysvec+30,	yyvstop+988,
yycrank+2029,	yysvec+30,	yyvstop+990,
yycrank+1992,	yysvec+30,	yyvstop+992,
yycrank+2016,	yysvec+30,	yyvstop+995,
yycrank+1993,	yysvec+30,	yyvstop+997,
yycrank+2051,	yysvec+30,	yyvstop+1000,
yycrank+2052,	yysvec+30,	yyvstop+1002,
yycrank+2026,	yysvec+30,	yyvstop+1004,
yycrank+2027,	yysvec+30,	yyvstop+1007,
yycrank+2039,	yysvec+30,	yyvstop+1010,
yycrank+2028,	yysvec+30,	yyvstop+1012,
yycrank+2044,	yysvec+30,	yyvstop+1015,
yycrank+2031,	yysvec+30,	yyvstop+1017,
yycrank+2047,	yysvec+30,	yyvstop+1020,
yycrank+2049,	yysvec+30,	yyvstop+1022,
yycrank+2032,	yysvec+30,	yyvstop+1025,
yycrank+2033,	yysvec+30,	yyvstop+1027,
yycrank+2034,	yysvec+30,	yyvstop+1030,
yycrank+2070,	yysvec+30,	yyvstop+1033,
yycrank+2068,	yysvec+30,	yyvstop+1035,
yycrank+2077,	yysvec+30,	yyvstop+1037,
yycrank+2088,	yysvec+30,	yyvstop+1039,
yycrank+2078,	yysvec+30,	yyvstop+1041,
yycrank+2089,	yysvec+30,	yyvstop+1043,
yycrank+2069,	yysvec+30,	yyvstop+1045,
yycrank+2091,	yysvec+30,	yyvstop+1047,
yycrank+2093,	yysvec+30,	yyvstop+1049,
yycrank+2094,	yysvec+30,	yyvstop+1051,
yycrank+2075,	yysvec+30,	yyvstop+1053,
yycrank+2098,	yysvec+30,	yyvstop+1056,
yycrank+2096,	yysvec+30,	yyvstop+1058,
yycrank+2111,	yysvec+30,	yyvstop+1060,
yycrank+2114,	yysvec+30,	yyvstop+1062,
yycrank+2095,	yysvec+30,	yyvstop+1064,
yycrank+2118,	yysvec+30,	yyvstop+1067,
yycrank+2104,	yysvec+30,	yyvstop+1069,
yycrank+2131,	yysvec+30,	yyvstop+1072,
yycrank+2105,	yysvec+30,	yyvstop+1074,
yycrank+2119,	yysvec+30,	yyvstop+1077,
yycrank+2135,	yysvec+30,	yyvstop+1079,
yycrank+2142,	yysvec+30,	yyvstop+1081,
yycrank+2108,	yysvec+30,	yyvstop+1083,
yycrank+2112,	yysvec+30,	yyvstop+1086,
yycrank+2113,	yysvec+30,	yyvstop+1089,
0,	0,	0};
struct yywork *yytop = yycrank+2256;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,'$' ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,'$' ,'$' ,'$' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,'>' ,01  ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'H' ,'I' ,'J' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'S' ,'T' ,'U' ,'V' ,'W' ,
'X' ,'Y' ,'J' ,01  ,01  ,01  ,01  ,'J' ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'H' ,'I' ,'J' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'S' ,'T' ,'U' ,'V' ,'W' ,
'X' ,'Y' ,'J' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
