#ifndef	_memory_object_server_
#define	_memory_object_server_

/* Module memory_object */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* SimpleRoutine memory_object_init */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_init
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, memory_object_name, memory_object_page_size)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	mach_port_t memory_object_name;
	vm_size_t memory_object_page_size;
{ return seqnos_memory_object_init(memory_object, seqno, memory_control, memory_object_name, memory_object_page_size); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	mach_port_t memory_object_name,
	vm_size_t memory_object_page_size
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_terminate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_terminate
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, memory_object_name)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	mach_port_t memory_object_name;
{ return seqnos_memory_object_terminate(memory_object, seqno, memory_control, memory_object_name); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	mach_port_t memory_object_name
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_copy */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_copy
#if	defined(LINTLIBRARY)
    (old_memory_object, seqno, old_memory_control, offset, length, new_memory_object)
	mach_port_t old_memory_object;
	mach_port_seqno_t seqno;
	mach_port_t old_memory_control;
	vm_offset_t offset;
	vm_size_t length;
	mach_port_t new_memory_object;
{ return seqnos_memory_object_copy(old_memory_object, seqno, old_memory_control, offset, length, new_memory_object); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t old_memory_object,
	mach_port_seqno_t seqno,
	mach_port_t old_memory_control,
	vm_offset_t offset,
	vm_size_t length,
	mach_port_t new_memory_object
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_data_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_data_request
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, offset, length, desired_access)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
	vm_prot_t desired_access;
{ return seqnos_memory_object_data_request(memory_object, seqno, memory_control, offset, length, desired_access); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length,
	vm_prot_t desired_access
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_data_unlock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_data_unlock
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, offset, length, desired_access)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
	vm_prot_t desired_access;
{ return seqnos_memory_object_data_unlock(memory_object, seqno, memory_control, offset, length, desired_access); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length,
	vm_prot_t desired_access
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_data_write */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_data_write
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, offset, data, dataCnt)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_offset_t data;
	mach_msg_type_number_t dataCnt;
{ return seqnos_memory_object_data_write(memory_object, seqno, memory_control, offset, data, dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_offset_t data,
	mach_msg_type_number_t dataCnt
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_lock_completed */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_lock_completed
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, offset, length)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
{ return seqnos_memory_object_lock_completed(memory_object, seqno, memory_control, offset, length); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_supply_completed */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_supply_completed
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, offset, length, result, error_offset)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
	kern_return_t result;
	vm_offset_t error_offset;
{ return seqnos_memory_object_supply_completed(memory_object, seqno, memory_control, offset, length, result, error_offset); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length,
	kern_return_t result,
	vm_offset_t error_offset
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_data_return */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_data_return
#if	defined(LINTLIBRARY)
    (memory_object, seqno, memory_control, offset, data, dataCnt, dirty, kernel_copy)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_offset_t data;
	mach_msg_type_number_t dataCnt;
	boolean_t dirty;
	boolean_t kernel_copy;
{ return seqnos_memory_object_data_return(memory_object, seqno, memory_control, offset, data, dataCnt, dirty, kernel_copy); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_offset_t data,
	mach_msg_type_number_t dataCnt,
	boolean_t dirty,
	boolean_t kernel_copy
);
#else
    ();
#endif
#endif

/* SimpleRoutine memory_object_change_completed */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t seqnos_memory_object_change_completed
#if	defined(LINTLIBRARY)
    (memory_object, seqno, may_cache, copy_strategy)
	mach_port_t memory_object;
	mach_port_seqno_t seqno;
	boolean_t may_cache;
	memory_object_copy_strategy_t copy_strategy;
{ return seqnos_memory_object_change_completed(memory_object, seqno, may_cache, copy_strategy); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_seqno_t seqno,
	boolean_t may_cache,
	memory_object_copy_strategy_t copy_strategy
);
#else
    ();
#endif
#endif

#endif	_memory_object_server_
