/* Module memory_object */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* SimpleRoutine memory_object_init */
mig_internal novalue _Xmemory_object_init
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t memory_object_nameType;
		mach_port_t memory_object_name;
		mach_msg_type_t memory_object_page_sizeType;
		vm_size_t memory_object_page_size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_init
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, mach_port_t memory_object_name, vm_size_t memory_object_page_size);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_object_nameCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_object_page_sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 17) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_object_nameType != * (int *) &memory_object_nameCheck)
#else	UseStaticMsgType
	if ((In0P->memory_object_nameType.msgt_inline != TRUE) ||
	    (In0P->memory_object_nameType.msgt_longform != FALSE) ||
	    (In0P->memory_object_nameType.msgt_name != 17) ||
	    (In0P->memory_object_nameType.msgt_number != 1) ||
	    (In0P->memory_object_nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_object_page_sizeType != * (int *) &memory_object_page_sizeCheck)
#else	UseStaticMsgType
	if ((In0P->memory_object_page_sizeType.msgt_inline != TRUE) ||
	    (In0P->memory_object_page_sizeType.msgt_longform != FALSE) ||
	    (In0P->memory_object_page_sizeType.msgt_name != 2) ||
	    (In0P->memory_object_page_sizeType.msgt_number != 1) ||
	    (In0P->memory_object_page_sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_init(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->memory_object_name, In0P->memory_object_page_size);
}

/* SimpleRoutine memory_object_terminate */
mig_internal novalue _Xmemory_object_terminate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t memory_object_nameType;
		mach_port_t memory_object_name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_terminate
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, mach_port_t memory_object_name);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		16,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_object_nameCheck = {
		/* msgt_name = */		16,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 16) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_object_nameType != * (int *) &memory_object_nameCheck)
#else	UseStaticMsgType
	if ((In0P->memory_object_nameType.msgt_inline != TRUE) ||
	    (In0P->memory_object_nameType.msgt_longform != FALSE) ||
	    (In0P->memory_object_nameType.msgt_name != 16) ||
	    (In0P->memory_object_nameType.msgt_number != 1) ||
	    (In0P->memory_object_nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_terminate(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->memory_object_name);
}

/* SimpleRoutine memory_object_copy */
mig_internal novalue _Xmemory_object_copy
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t old_memory_controlType;
		mach_port_t old_memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t new_memory_objectType;
		mach_port_t new_memory_object;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_copy
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t old_memory_object, mach_port_seqno_t seqno, mach_port_t old_memory_control, vm_offset_t offset, vm_size_t length, mach_port_t new_memory_object);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t old_memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_memory_objectCheck = {
		/* msgt_name = */		16,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->old_memory_controlType != * (int *) &old_memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->old_memory_controlType.msgt_inline != TRUE) ||
	    (In0P->old_memory_controlType.msgt_longform != FALSE) ||
	    (In0P->old_memory_controlType.msgt_name != 17) ||
	    (In0P->old_memory_controlType.msgt_number != 1) ||
	    (In0P->old_memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lengthType != * (int *) &lengthCheck)
#else	UseStaticMsgType
	if ((In0P->lengthType.msgt_inline != TRUE) ||
	    (In0P->lengthType.msgt_longform != FALSE) ||
	    (In0P->lengthType.msgt_name != 2) ||
	    (In0P->lengthType.msgt_number != 1) ||
	    (In0P->lengthType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_memory_objectType != * (int *) &new_memory_objectCheck)
#else	UseStaticMsgType
	if ((In0P->new_memory_objectType.msgt_inline != TRUE) ||
	    (In0P->new_memory_objectType.msgt_longform != FALSE) ||
	    (In0P->new_memory_objectType.msgt_name != 16) ||
	    (In0P->new_memory_objectType.msgt_number != 1) ||
	    (In0P->new_memory_objectType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_copy(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->old_memory_control, In0P->offset, In0P->length, In0P->new_memory_object);
}

/* SimpleRoutine memory_object_data_request */
mig_internal novalue _Xmemory_object_data_request
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t desired_accessType;
		vm_prot_t desired_access;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_data_request
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, vm_offset_t offset, vm_size_t length, vm_prot_t desired_access);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t desired_accessCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 17) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lengthType != * (int *) &lengthCheck)
#else	UseStaticMsgType
	if ((In0P->lengthType.msgt_inline != TRUE) ||
	    (In0P->lengthType.msgt_longform != FALSE) ||
	    (In0P->lengthType.msgt_name != 2) ||
	    (In0P->lengthType.msgt_number != 1) ||
	    (In0P->lengthType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->desired_accessType != * (int *) &desired_accessCheck)
#else	UseStaticMsgType
	if ((In0P->desired_accessType.msgt_inline != TRUE) ||
	    (In0P->desired_accessType.msgt_longform != FALSE) ||
	    (In0P->desired_accessType.msgt_name != 2) ||
	    (In0P->desired_accessType.msgt_number != 1) ||
	    (In0P->desired_accessType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_data_request(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->offset, In0P->length, In0P->desired_access);
}

/* SimpleRoutine memory_object_data_unlock */
mig_internal novalue _Xmemory_object_data_unlock
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t desired_accessType;
		vm_prot_t desired_access;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_data_unlock
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, vm_offset_t offset, vm_size_t length, vm_prot_t desired_access);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t desired_accessCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 17) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lengthType != * (int *) &lengthCheck)
#else	UseStaticMsgType
	if ((In0P->lengthType.msgt_inline != TRUE) ||
	    (In0P->lengthType.msgt_longform != FALSE) ||
	    (In0P->lengthType.msgt_name != 2) ||
	    (In0P->lengthType.msgt_number != 1) ||
	    (In0P->lengthType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->desired_accessType != * (int *) &desired_accessCheck)
#else	UseStaticMsgType
	if ((In0P->desired_accessType.msgt_inline != TRUE) ||
	    (In0P->desired_accessType.msgt_longform != FALSE) ||
	    (In0P->desired_accessType.msgt_name != 2) ||
	    (In0P->desired_accessType.msgt_number != 1) ||
	    (In0P->desired_accessType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_data_unlock(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->offset, In0P->length, In0P->desired_access);
}

/* SimpleRoutine memory_object_data_write */
mig_internal novalue _Xmemory_object_data_write
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_data_write
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, vm_offset_t offset, vm_offset_t data, mach_msg_type_number_t dataCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 17) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->dataType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->dataType.msgtl_name != 9) ||
	    (In0P->dataType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_data_write(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->offset, In0P->data, In0P->dataType.msgtl_number);
}

/* SimpleRoutine memory_object_lock_completed */
mig_internal novalue _Xmemory_object_lock_completed
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_lock_completed
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, vm_offset_t offset, vm_size_t length);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 17) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lengthType != * (int *) &lengthCheck)
#else	UseStaticMsgType
	if ((In0P->lengthType.msgt_inline != TRUE) ||
	    (In0P->lengthType.msgt_longform != FALSE) ||
	    (In0P->lengthType.msgt_name != 2) ||
	    (In0P->lengthType.msgt_number != 1) ||
	    (In0P->lengthType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_lock_completed(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->offset, In0P->length);
}

/* SimpleRoutine memory_object_supply_completed */
mig_internal novalue _Xmemory_object_supply_completed
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t resultType;
		kern_return_t result;
		mach_msg_type_t error_offsetType;
		vm_offset_t error_offset;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_supply_completed
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, vm_offset_t offset, vm_size_t length, kern_return_t result, vm_offset_t error_offset);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t resultCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t error_offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 64) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 17) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lengthType != * (int *) &lengthCheck)
#else	UseStaticMsgType
	if ((In0P->lengthType.msgt_inline != TRUE) ||
	    (In0P->lengthType.msgt_longform != FALSE) ||
	    (In0P->lengthType.msgt_name != 2) ||
	    (In0P->lengthType.msgt_number != 1) ||
	    (In0P->lengthType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->resultType != * (int *) &resultCheck)
#else	UseStaticMsgType
	if ((In0P->resultType.msgt_inline != TRUE) ||
	    (In0P->resultType.msgt_longform != FALSE) ||
	    (In0P->resultType.msgt_name != 2) ||
	    (In0P->resultType.msgt_number != 1) ||
	    (In0P->resultType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->error_offsetType != * (int *) &error_offsetCheck)
#else	UseStaticMsgType
	if ((In0P->error_offsetType.msgt_inline != TRUE) ||
	    (In0P->error_offsetType.msgt_longform != FALSE) ||
	    (In0P->error_offsetType.msgt_name != 2) ||
	    (In0P->error_offsetType.msgt_number != 1) ||
	    (In0P->error_offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_supply_completed(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->offset, In0P->length, In0P->result, In0P->error_offset);
}

/* SimpleRoutine memory_object_data_return */
mig_internal novalue _Xmemory_object_data_return
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
		mach_msg_type_t dirtyType;
		boolean_t dirty;
		mach_msg_type_t kernel_copyType;
		boolean_t kernel_copy;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_data_return
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, mach_port_t memory_control, vm_offset_t offset, vm_offset_t data, mach_msg_type_number_t dataCnt, boolean_t dirty, boolean_t kernel_copy);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memory_controlCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t dirtyCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t kernel_copyCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 72) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_controlType != * (int *) &memory_controlCheck)
#else	UseStaticMsgType
	if ((In0P->memory_controlType.msgt_inline != TRUE) ||
	    (In0P->memory_controlType.msgt_longform != FALSE) ||
	    (In0P->memory_controlType.msgt_name != 17) ||
	    (In0P->memory_controlType.msgt_number != 1) ||
	    (In0P->memory_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->dataType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->dataType.msgtl_name != 9) ||
	    (In0P->dataType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->dirtyType != * (int *) &dirtyCheck)
#else	UseStaticMsgType
	if ((In0P->dirtyType.msgt_inline != TRUE) ||
	    (In0P->dirtyType.msgt_longform != FALSE) ||
	    (In0P->dirtyType.msgt_name != 0) ||
	    (In0P->dirtyType.msgt_number != 1) ||
	    (In0P->dirtyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->kernel_copyType != * (int *) &kernel_copyCheck)
#else	UseStaticMsgType
	if ((In0P->kernel_copyType.msgt_inline != TRUE) ||
	    (In0P->kernel_copyType.msgt_longform != FALSE) ||
	    (In0P->kernel_copyType.msgt_name != 0) ||
	    (In0P->kernel_copyType.msgt_number != 1) ||
	    (In0P->kernel_copyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_data_return(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->memory_control, In0P->offset, In0P->data, In0P->dataType.msgtl_number, In0P->dirty, In0P->kernel_copy);
}

/* SimpleRoutine memory_object_change_completed */
mig_internal novalue _Xmemory_object_change_completed
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t may_cacheType;
		boolean_t may_cache;
		mach_msg_type_t copy_strategyType;
		memory_object_copy_strategy_t copy_strategy;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t seqnos_memory_object_change_completed
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_object, mach_port_seqno_t seqno, boolean_t may_cache, memory_object_copy_strategy_t copy_strategy);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t may_cacheCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copy_strategyCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->may_cacheType != * (int *) &may_cacheCheck)
#else	UseStaticMsgType
	if ((In0P->may_cacheType.msgt_inline != TRUE) ||
	    (In0P->may_cacheType.msgt_longform != FALSE) ||
	    (In0P->may_cacheType.msgt_name != 0) ||
	    (In0P->may_cacheType.msgt_number != 1) ||
	    (In0P->may_cacheType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->copy_strategyType != * (int *) &copy_strategyCheck)
#else	UseStaticMsgType
	if ((In0P->copy_strategyType.msgt_inline != TRUE) ||
	    (In0P->copy_strategyType.msgt_longform != FALSE) ||
	    (In0P->copy_strategyType.msgt_name != 2) ||
	    (In0P->copy_strategyType.msgt_number != 1) ||
	    (In0P->copy_strategyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = seqnos_memory_object_change_completed(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->may_cache, In0P->copy_strategy);
}

static mig_routine_t seqnos_memory_object_server_routines[] = {
		_Xmemory_object_init,
		_Xmemory_object_terminate,
		_Xmemory_object_copy,
		_Xmemory_object_data_request,
		_Xmemory_object_data_unlock,
		_Xmemory_object_data_write,
		_Xmemory_object_lock_completed,
		_Xmemory_object_supply_completed,
		_Xmemory_object_data_return,
		_Xmemory_object_change_completed,
};

mig_external boolean_t seqnos_memory_object_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 2209) || (InP->msgh_id < 2200) ||
	    ((routine = seqnos_memory_object_server_routines[InP->msgh_id - 2200]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t seqnos_memory_object_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 2200;

	if ((msgh_id > 9) || (msgh_id < 0))
		return 0;

	return seqnos_memory_object_server_routines[msgh_id];
}

