#include "device.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine xxx_device_set_filter */
mig_external kern_return_t xxx_device_set_filter
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t device,
	mach_port_t receive_port,
	mach_msg_type_name_t receive_portPoly,
	int priority,
	filter_array_t filter,
	mach_msg_type_number_t filterCnt
)
#else
	(device, receive_port, receive_portPoly, priority, filter, filterCnt)
	mach_port_t device;
	mach_port_t receive_port;
	mach_msg_type_name_t receive_portPoly;
	int priority;
	filter_array_t filter;
	mach_msg_type_number_t filterCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t receive_portType;
		mach_port_t receive_port;
		mach_msg_type_t priorityType;
		int priority;
		mach_msg_type_long_t filterType;
		filter_t filter[64];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
	boolean_t msgh_simple = TRUE;
	unsigned int msgh_size;

#if	UseStaticMsgType
	static mach_msg_type_t receive_portType = {
		/* msgt_name = */		((mach_msg_type_name_t) -1),
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t priorityType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t filterType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	1,
		/* msgtl_size = */	16,
		/* msgtl_number = */	64,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->receive_portType = receive_portType;
#else	UseStaticMsgType
	InP->receive_portType.msgt_size = 32;
	InP->receive_portType.msgt_number = 1;
	InP->receive_portType.msgt_inline = TRUE;
	InP->receive_portType.msgt_longform = FALSE;
	InP->receive_portType.msgt_deallocate = FALSE;
	InP->receive_portType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->receive_port = receive_port;

	if (MACH_MSG_TYPE_PORT_ANY(receive_portPoly))
		msgh_simple = FALSE;

	InP->receive_portType.msgt_name = receive_portPoly;

#if	UseStaticMsgType
	InP->priorityType = priorityType;
#else	UseStaticMsgType
	InP->priorityType.msgt_name = 2;
	InP->priorityType.msgt_size = 32;
	InP->priorityType.msgt_number = 1;
	InP->priorityType.msgt_inline = TRUE;
	InP->priorityType.msgt_longform = FALSE;
	InP->priorityType.msgt_deallocate = FALSE;
	InP->priorityType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->priority = priority;

#if	UseStaticMsgType
	InP->filterType = filterType;
#else	UseStaticMsgType
	InP->filterType.msgtl_name = 1;
	InP->filterType.msgtl_size = 16;
	InP->filterType.msgtl_header.msgt_name = 0;
	InP->filterType.msgtl_header.msgt_size = 0;
	InP->filterType.msgtl_header.msgt_number = 0;
	InP->filterType.msgtl_header.msgt_inline = TRUE;
	InP->filterType.msgtl_header.msgt_longform = TRUE;
	InP->filterType.msgtl_header.msgt_deallocate = FALSE;
	InP->filterType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (filterCnt > 64) {
		return MIG_ARRAY_TOO_LARGE;
	}
	else {
		bcopy((char *) filter, (char *) InP->filter, 2 * filterCnt);
	}

	InP->filterType.msgtl_number = filterCnt;

	msgh_size = 52 + (2 * filterCnt + 3 & ~3);
	InP->Head.msgh_bits = msgh_simple ?
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE) :
		(MACH_MSGH_BITS_COMPLEX|
		 MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE));
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = device;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2808;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 2908) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}
