#include "mach_host.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine processor_set_info */
mig_external kern_return_t processor_set_info
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t set_name,
	int flavor,
	mach_port_t *host,
	processor_set_info_t info_out,
	mach_msg_type_number_t *info_outCnt
)
#else
	(set_name, flavor, host, info_out, info_outCnt)
	mach_port_t set_name;
	int flavor;
	mach_port_t *host;
	processor_set_info_t info_out;
	mach_msg_type_number_t *info_outCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
		mach_msg_type_t info_outCntType;
		mach_msg_type_number_t info_outCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t hostType;
		mach_port_t host;
		mach_msg_type_t info_outType;
		int info_out[1024];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t flavorType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t info_outCntType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t hostCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->flavorType = flavorType;
#else	UseStaticMsgType
	InP->flavorType.msgt_name = 2;
	InP->flavorType.msgt_size = 32;
	InP->flavorType.msgt_number = 1;
	InP->flavorType.msgt_inline = TRUE;
	InP->flavorType.msgt_longform = FALSE;
	InP->flavorType.msgt_deallocate = FALSE;
	InP->flavorType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->flavor = flavor;

#if	UseStaticMsgType
	InP->info_outCntType = info_outCntType;
#else	UseStaticMsgType
	InP->info_outCntType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->info_outCntType.msgt_size = 32;
	InP->info_outCntType.msgt_number = 1;
	InP->info_outCntType.msgt_inline = TRUE;
	InP->info_outCntType.msgt_longform = FALSE;
	InP->info_outCntType.msgt_deallocate = FALSE;
	InP->info_outCntType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (*info_outCnt < 1024)
		InP->info_outCnt = *info_outCnt;
	else
		InP->info_outCnt = 1024;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = set_name;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2640;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 2740) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 44) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->hostType != * (int *) &hostCheck)
#else	UseStaticMsgType
	if ((OutP->hostType.msgt_inline != TRUE) ||
	    (OutP->hostType.msgt_longform != FALSE) ||
	    (OutP->hostType.msgt_name != 17) ||
	    (OutP->hostType.msgt_number != 1) ||
	    (OutP->hostType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*host = OutP->host;

#if	TypeCheck
	if ((OutP->info_outType.msgt_inline != TRUE) ||
	    (OutP->info_outType.msgt_longform != FALSE) ||
	    (OutP->info_outType.msgt_name != 2) ||
	    (OutP->info_outType.msgt_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 44 + (4 * OutP->info_outType.msgt_number))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->info_outType.msgt_number > *info_outCnt) {
		bcopy((char *) OutP->info_out, (char *) info_out, 4 * *info_outCnt);
		*info_outCnt = OutP->info_outType.msgt_number;
		return MIG_ARRAY_TOO_LARGE;
	}
	else {
		bcopy((char *) OutP->info_out, (char *) info_out, 4 * OutP->info_outType.msgt_number);
	}

	*info_outCnt = OutP->info_outType.msgt_number;

	return KERN_SUCCESS;
}
