#include "mach_debug.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine mach_port_space_info */
mig_external kern_return_t mach_port_space_info
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t task,
	ipc_info_space_t *info,
	ipc_info_name_array_t *table_info,
	mach_msg_type_number_t *table_infoCnt,
	ipc_info_tree_name_array_t *tree_info,
	mach_msg_type_number_t *tree_infoCnt
)
#else
	(task, info, table_info, table_infoCnt, tree_info, tree_infoCnt)
	mach_port_t task;
	ipc_info_space_t *info;
	ipc_info_name_array_t *table_info;
	mach_msg_type_number_t *table_infoCnt;
	ipc_info_tree_name_array_t *tree_info;
	mach_msg_type_number_t *tree_infoCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t table_infoCntType;
		mach_msg_type_number_t table_infoCnt;
		mach_msg_type_t tree_infoCntType;
		mach_msg_type_number_t tree_infoCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		ipc_info_space_t info;
		mach_msg_type_long_t table_infoType;
		ipc_info_name_t table_info[56];
		mach_msg_type_long_t tree_infoType;
		ipc_info_tree_name_t tree_info[46];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t table_infoCntType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t tree_infoCntType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t infoCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		6,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->table_infoCntType = table_infoCntType;
#else	UseStaticMsgType
	InP->table_infoCntType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->table_infoCntType.msgt_size = 32;
	InP->table_infoCntType.msgt_number = 1;
	InP->table_infoCntType.msgt_inline = TRUE;
	InP->table_infoCntType.msgt_longform = FALSE;
	InP->table_infoCntType.msgt_deallocate = FALSE;
	InP->table_infoCntType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (*table_infoCnt < 56)
		InP->table_infoCnt = *table_infoCnt;
	else
		InP->table_infoCnt = 56;

#if	UseStaticMsgType
	InP->tree_infoCntType = tree_infoCntType;
#else	UseStaticMsgType
	InP->tree_infoCntType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->tree_infoCntType.msgt_size = 32;
	InP->tree_infoCntType.msgt_number = 1;
	InP->tree_infoCntType.msgt_inline = TRUE;
	InP->tree_infoCntType.msgt_longform = FALSE;
	InP->tree_infoCntType.msgt_deallocate = FALSE;
	InP->tree_infoCntType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (*tree_infoCnt < 46)
		InP->tree_infoCnt = *tree_infoCnt;
	else
		InP->tree_infoCnt = 46;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = task;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 3010;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 3110) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 84)) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->infoType != * (int *) &infoCheck)
#else	UseStaticMsgType
	if ((OutP->infoType.msgt_inline != TRUE) ||
	    (OutP->infoType.msgt_longform != FALSE) ||
	    (OutP->infoType.msgt_name != 2) ||
	    (OutP->infoType.msgt_number != 6) ||
	    (OutP->infoType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*info = OutP->info;

#if	TypeCheck
	if ((OutP->table_infoType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->table_infoType.msgtl_name != 2) ||
	    (OutP->table_infoType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->table_infoType.msgtl_header.msgt_inline) ? 4 * OutP->table_infoType.msgtl_number : sizeof(ipc_info_name_t *);
#if	TypeCheck
	if (msgh_size < 84 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->table_infoType.msgtl_header.msgt_inline)
	    *table_info = *((ipc_info_name_t **)OutP->table_info);
	else if (OutP->table_infoType.msgtl_number / 9 > *table_infoCnt) {
	    mig_allocate((vm_offset_t *)table_info,
		4 * OutP->table_infoType.msgtl_number);
	    bcopy((char *) OutP->table_info, (char *) *table_info, 4 * OutP->table_infoType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->table_info, (char *) *table_info, 4 * OutP->table_infoType.msgtl_number);
	}

	*table_infoCnt = OutP->table_infoType.msgtl_number / 9;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2016);

#if	TypeCheck
	if ((OutP->tree_infoType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->tree_infoType.msgtl_name != 2) ||
	    (OutP->tree_infoType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 84 + ((OutP->tree_infoType.msgtl_header.msgt_inline) ? 4 * OutP->tree_infoType.msgtl_number : sizeof(ipc_info_tree_name_t *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (!OutP->tree_infoType.msgtl_header.msgt_inline)
	    *tree_info = *((ipc_info_tree_name_t **)OutP->tree_info);
	else if (OutP->tree_infoType.msgtl_number / 11 > *tree_infoCnt) {
	    mig_allocate((vm_offset_t *)tree_info,
		4 * OutP->tree_infoType.msgtl_number);
	    bcopy((char *) OutP->tree_info, (char *) *tree_info, 4 * OutP->tree_infoType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->tree_info, (char *) *tree_info, 4 * OutP->tree_infoType.msgtl_number);
	}

	*tree_infoCnt = OutP->tree_infoType.msgtl_number / 11;

	return KERN_SUCCESS;
}
