#include "default_pager.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine default_pager_objects */
mig_external kern_return_t default_pager_objects
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t default_pager,
	default_pager_object_array_t *objects,
	mach_msg_type_number_t *objectsCnt,
	mach_port_array_t *ports,
	mach_msg_type_number_t *portsCnt
)
#else
	(default_pager, objects, objectsCnt, ports, portsCnt)
	mach_port_t default_pager;
	default_pager_object_array_t *objects;
	mach_msg_type_number_t *objectsCnt;
	mach_port_array_t *ports;
	mach_msg_type_number_t *portsCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t objectsCntType;
		mach_msg_type_number_t objectsCnt;
		mach_msg_type_t portsCntType;
		mach_msg_type_number_t portsCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t objectsType;
		default_pager_object_t objects[256];
		mach_msg_type_long_t portsType;
		mach_port_t ports[512];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t objectsCntType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t portsCntType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->objectsCntType = objectsCntType;
#else	UseStaticMsgType
	InP->objectsCntType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->objectsCntType.msgt_size = 32;
	InP->objectsCntType.msgt_number = 1;
	InP->objectsCntType.msgt_inline = TRUE;
	InP->objectsCntType.msgt_longform = FALSE;
	InP->objectsCntType.msgt_deallocate = FALSE;
	InP->objectsCntType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (*objectsCnt < 256)
		InP->objectsCnt = *objectsCnt;
	else
		InP->objectsCnt = 256;

#if	UseStaticMsgType
	InP->portsCntType = portsCntType;
#else	UseStaticMsgType
	InP->portsCntType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->portsCntType.msgt_size = 32;
	InP->portsCntType.msgt_number = 1;
	InP->portsCntType.msgt_inline = TRUE;
	InP->portsCntType.msgt_longform = FALSE;
	InP->portsCntType.msgt_deallocate = FALSE;
	InP->portsCntType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (*portsCnt < 512)
		InP->portsCnt = *portsCnt;
	else
		InP->portsCnt = 512;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = default_pager;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2277;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 2377) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 56) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->objectsType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->objectsType.msgtl_name != 2) ||
	    (OutP->objectsType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->objectsType.msgtl_header.msgt_inline) ? 4 * OutP->objectsType.msgtl_number : sizeof(default_pager_object_t *);
#if	TypeCheck
	if (msgh_size < 56 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->objectsType.msgtl_header.msgt_inline)
	    *objects = *((default_pager_object_t **)OutP->objects);
	else if (OutP->objectsType.msgtl_number / 2 > *objectsCnt) {
	    mig_allocate((vm_offset_t *)objects,
		4 * OutP->objectsType.msgtl_number);
	    bcopy((char *) OutP->objects, (char *) *objects, 4 * OutP->objectsType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->objects, (char *) *objects, 4 * OutP->objectsType.msgtl_number);
	}

	*objectsCnt = OutP->objectsType.msgtl_number / 2;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
	if ((OutP->portsType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->portsType.msgtl_name != 17) ||
	    (OutP->portsType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 56 + ((OutP->portsType.msgtl_header.msgt_inline) ? 4 * OutP->portsType.msgtl_number : sizeof(mach_port_t *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (!OutP->portsType.msgtl_header.msgt_inline)
	    *ports = *((mach_port_t **)OutP->ports);
	else if (OutP->portsType.msgtl_number > *portsCnt) {
	    mig_allocate((vm_offset_t *)ports,
		4 * OutP->portsType.msgtl_number);
	    bcopy((char *) OutP->ports, (char *) *ports, 4 * OutP->portsType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->ports, (char *) *ports, 4 * OutP->portsType.msgtl_number);
	}

	*portsCnt = OutP->portsType.msgtl_number;

	return KERN_SUCCESS;
}
