#include "mach_user_kernel.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine xxx_task_get_emulation_vector */
mig_external kern_return_t r_xxx_task_get_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
(
	ipc_port_t task,
	int *vector_start,
	emulation_vector_t emulation_vector,
	mach_msg_type_number_t *emulation_vectorCnt
)
#else
	(task, vector_start, emulation_vector, emulation_vectorCnt)
	ipc_port_t task;
	int *vector_start;
	emulation_vector_t emulation_vector;
	mach_msg_type_number_t *emulation_vectorCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t vector_startType;
		int vector_start;
		mach_msg_type_long_t emulation_vectorType;
		vm_offset_t emulation_vector[1024];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t vector_startCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = (mach_port_t) task;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2045;

	msg_result = mach_msg_rpc_from_kernel(&InP->Head, sizeof(Request), sizeof(Reply));
	if (msg_result != MACH_MSG_SUCCESS) {
		return msg_result;
	}

	if (OutP->Head.msgh_id != 2145) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size < 52) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->vector_startType != * (int *) &vector_startCheck)
#else	UseStaticMsgType
	if ((OutP->vector_startType.msgt_inline != TRUE) ||
	    (OutP->vector_startType.msgt_longform != FALSE) ||
	    (OutP->vector_startType.msgt_name != 2) ||
	    (OutP->vector_startType.msgt_number != 1) ||
	    (OutP->vector_startType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*vector_start = OutP->vector_start;

#if	TypeCheck
	if ((OutP->emulation_vectorType.msgtl_header.msgt_inline != TRUE) ||
	    (OutP->emulation_vectorType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->emulation_vectorType.msgtl_name != 2) ||
	    (OutP->emulation_vectorType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 52 + (4 * OutP->emulation_vectorType.msgtl_number))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->emulation_vectorType.msgtl_number > *emulation_vectorCnt) {
		bcopy((char *) OutP->emulation_vector, (char *) emulation_vector, 4 * *emulation_vectorCnt);
		*emulation_vectorCnt = OutP->emulation_vectorType.msgtl_number;
		return MIG_ARRAY_TOO_LARGE;
	}
	else {
		bcopy((char *) OutP->emulation_vector, (char *) emulation_vector, 4 * OutP->emulation_vectorType.msgtl_number);
	}

	*emulation_vectorCnt = OutP->emulation_vectorType.msgtl_number;

	return KERN_SUCCESS;
}
