#include "mach_user_kernel.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine thread_info */
mig_external kern_return_t r_thread_info
#if	(defined(__STDC__) || defined(c_plusplus))
(
	ipc_port_t target_thread,
	int flavor,
	thread_info_t thread_info_out,
	mach_msg_type_number_t *thread_info_outCnt
)
#else
	(target_thread, flavor, thread_info_out, thread_info_outCnt)
	ipc_port_t target_thread;
	int flavor;
	thread_info_t thread_info_out;
	mach_msg_type_number_t *thread_info_outCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
		mach_msg_type_t thread_info_outCntType;
		mach_msg_type_number_t thread_info_outCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t thread_info_outType;
		int thread_info_out[1024];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t flavorType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t thread_info_outCntType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->flavorType = flavorType;
#else	UseStaticMsgType
	InP->flavorType.msgt_name = 2;
	InP->flavorType.msgt_size = 32;
	InP->flavorType.msgt_number = 1;
	InP->flavorType.msgt_inline = TRUE;
	InP->flavorType.msgt_longform = FALSE;
	InP->flavorType.msgt_deallocate = FALSE;
	InP->flavorType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->flavor = flavor;

#if	UseStaticMsgType
	InP->thread_info_outCntType = thread_info_outCntType;
#else	UseStaticMsgType
	InP->thread_info_outCntType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->thread_info_outCntType.msgt_size = 32;
	InP->thread_info_outCntType.msgt_number = 1;
	InP->thread_info_outCntType.msgt_inline = TRUE;
	InP->thread_info_outCntType.msgt_longform = FALSE;
	InP->thread_info_outCntType.msgt_deallocate = FALSE;
	InP->thread_info_outCntType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (*thread_info_outCnt < 1024)
		InP->thread_info_outCnt = *thread_info_outCnt;
	else
		InP->thread_info_outCnt = 1024;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = (mach_port_t) target_thread;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2019;

	msg_result = mach_msg_rpc_from_kernel(&InP->Head, sizeof(Request), sizeof(Reply));
	if (msg_result != MACH_MSG_SUCCESS) {
		return msg_result;
	}

	if (OutP->Head.msgh_id != 2119) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size < 36) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->thread_info_outType.msgt_inline != TRUE) ||
	    (OutP->thread_info_outType.msgt_longform != FALSE) ||
	    (OutP->thread_info_outType.msgt_name != 2) ||
	    (OutP->thread_info_outType.msgt_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 36 + (4 * OutP->thread_info_outType.msgt_number))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->thread_info_outType.msgt_number > *thread_info_outCnt) {
		bcopy((char *) OutP->thread_info_out, (char *) thread_info_out, 4 * *thread_info_outCnt);
		*thread_info_outCnt = OutP->thread_info_outType.msgt_number;
		return MIG_ARRAY_TOO_LARGE;
	}
	else {
		bcopy((char *) OutP->thread_info_out, (char *) thread_info_out, 4 * OutP->thread_info_outType.msgt_number);
	}

	*thread_info_outCnt = OutP->thread_info_outType.msgt_number;

	return KERN_SUCCESS;
}
