/*	$NetBSD: amdgpu_umc_v6_0.c,v 1.2 2021/12/18 23:44:58 riastradh Exp $	*/

/*
 * Copyright 2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: amdgpu_umc_v6_0.c,v 1.2 2021/12/18 23:44:58 riastradh Exp $");

#include "umc_v6_0.h"
#include "amdgpu.h"

static void umc_v6_0_init_registers(struct amdgpu_device *adev)
{
	unsigned i,j;

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			WREG32((i*0x100000 + 0x5010c + j*0x2000)/4, 0x1002);
}

const struct amdgpu_umc_funcs umc_v6_0_funcs = {
	.init_registers = umc_v6_0_init_registers,
};
