#define POA_UNUSED	-1
#define POA_CONST	0
#define POA_INDIR1	1
#define POA_INDIR2	2
#define POA_PRE		3
#define POA_POST	4
#define PARANOID	1

static char *reg_name[] = REGISTER_NAMES;

struct adr_parts {
  rtx constant;
  rtx constant2;
  int reg;
  int ix_scale;
  int ix_reg;
};

print_operand_address (file, addr)
FILE *file;
register rtx addr;
{
  struct adr_parts ap [3];
  int ret;

  ap[0].constant = ap[1].constant = ap[2].constant = NULL;
  ap[0].constant2 = ap[1].constant2 = ap[2].constant2 = NULL;
  ap[0].reg = ap[1].reg = ap[2].reg =
    ap[1].ix_reg = ap[1].ix_scale = POA_UNUSED;
  ret = poa_parse_rtx (addr, POA_INDIR1, ap+1);
  poa_print (file, ret, ap);
}

int
poa_parse_rtx (addr, num_mem, ap)
register rtx addr;
int num_mem;
register struct adr_parts *ap;
{
  int ret0, ret1, reg;

  if (CONSTANT_P (addr)) {
#   if PARANOID
    if (ap->constant != NULL && ap->constant2 != NULL)
      poa_error ("too many const's");
#   endif
    if (ap->constant == NULL)
      ap->constant = addr;
    else ap->constant2 = addr;
    return num_mem;
  } else switch (GET_CODE (addr)) {
    /* leaves */
    case REG:
#     if PARANOID
      if (ap->reg != POA_UNUSED && ap->ix_reg != POA_UNUSED)
	poa_error ("too many reg's");
#     endif
      reg = REGNO(addr);
      if (ap->reg != POA_UNUSED) {
	if (reg < 8)			/* probably should use some macro */
	  ap->ix_reg = reg;
	else {
	  ap->ix_reg = ap->reg;
	  ap->reg = reg;
	}
      } else {
	ap->reg = reg;
      }
      return num_mem;
    case PRE_DEC:
#     if PARANOID
      if (ap->constant != NULL || ap->reg != POA_UNUSED)
	 poa_error ("pre_dec plus const or reg");
#     endif
      return POA_PRE;
    case POST_INC:
#     if PARANOID
      if (ap->constant != NULL || ap->reg != POA_UNUSED)
	 poa_error ("post_inc plus constant or reg");
#     endif
      return POA_POST;
    /* non leaves */
    case MEM:
#     if PARANOID
      if (num_mem == POA_INDIR2) poa_error ("too many mem rtx's");
#     endif
      return poa_parse_rtx (XEXP (addr, 0), num_mem + 1, ap + 1);
    case PLUS:
      ret0 = poa_parse_rtx (XEXP (addr, 0), num_mem, ap);
      ret1 = poa_parse_rtx (XEXP (addr, 1), num_mem, ap);
      return (ret0 > ret1)? ret0: ret1;
    case MULT:
#     if PARANOID
      if (num_mem != POA_INDIR1)
	poa_error ("index at level %d", num_mem);
#     endif
      for (ret1 = 0; ret1 < 2; ++ret1) {
	switch (GET_CODE (XEXP (addr, ret1))) {
	  case REG:
	    ap->ix_reg = REGNO (XEXP (addr, ret1));
	    break;
	  case CONST_INT:
	    ap->ix_scale = INTVAL (XEXP (addr, ret1));
	    break;
	  default:
#	    if PARANOID
	    poa_error ("code %d found in index",
	      GET_CODE (XEXP (addr, ret1)));
#	    endif
	    break;
        }
      }
      return num_mem;
    default:
#     if PARANOID
      poa_error ("code %d found in rtx", GET_CODE (addr));
#     endif
      return num_mem;
  }
}

poa_print (file, ret, ap)
FILE *file;
int ret;
register struct adr_parts *ap;
{
  register struct adr_parts *ap1 = &ap[1];
  register struct adr_parts *ap2 = &ap[2];
  int abs;

  switch (ret) {
    case POA_CONST:
      if (ap->reg != NULL)
	fprintf (file, "$s", reg_name [ap->reg]);
      else
#     if PARANOID
      if (ap->constant == NULL) {
	poa_error ("POA_CONST but no const");
	fputc ('0',file);
      } else
#     endif
      output_addr_const (file, ap->constant);
      if (ap->constant2 != NULL) {
	fputc ('+', file);
	output_addr_const (file, ap->constant2);
      }
      break;
    case POA_INDIR1:
      if (abs = (ap1->reg == POA_UNUSED) && ((ap1->constant == NULL) ||
      (GET_CODE (ap1->constant) == CONST_INT)))
        fputc ('@', file);
      if (ap1->constant == NULL)
        fputc ('0', file);
      else {
	output_addr_const (file, ap1->constant);
        if (ap1->constant2 != NULL) {
	  fputc ('+', file);
	  output_addr_const (file, ap1->constant2);
        }
      }
      if (!abs)	fprintf (file, "(%s)",
        (ap1->reg == POA_UNUSED)? "pc": reg_name [ap1->reg]);
      break;
    case POA_INDIR2:
      if (ap1->reg != POA_UNUSED) {	/* must be index */
#	if PARANOID
	  if (ap1->ix_reg != POA_UNUSED)
	    poa_error ("2 first level regs in double indirect");
#	endif
	ap1->ix_reg = ap1->reg;
      }
      if (ap1->constant == NULL)
        fputc ('0', file);
      else {
	output_addr_const (file, ap1->constant);
        if (ap1->constant2 != NULL) {
	  fputc ('+', file);
	  output_addr_const (file, ap1->constant2);
        }
      }
      fputc ('(', file);
      if (ap2->constant == NULL)
        fputc ('0', file);
      else {
	output_addr_const (file, ap2->constant);
	if (ap2->constant2 != NULL) {
	  fputc ('+', file);
	  output_addr_const (file, ap2->constant2);
	}
      }
      fprintf (file, "(%s))",
	(ap2->reg == POA_UNUSED)? "sb": reg_name [ap2->reg]);
      break;
    case POA_PRE:
    case POA_POST:
      fputs ("tos", file);
      break;
#   if PARANOID
    default:
      poa_error ("bad level: %d", ret);
#   endif
  }      
  if (ap1->ix_reg != POA_UNUSED) {
    if (ap1->ix_scale == POA_UNUSED) ap1->ix_scale = 1;
    fprintf (file, "[%s:%c]", reg_name [ap1->ix_reg],
      *("?bw?d???q" + ap1->ix_scale));
  }
}

#if PARANOID
poa_error (arg1, arg2, arg3)
char *arg1;
int arg2, arg3;
{
  fputs ("print_operand_address: ", stderr);
  fprintf (stderr, arg1, arg2, arg3);
  fputc ('\n', stderr);
}
#endif
