/*
 *  Bruce Culbertson  23 March 1987
 *  NM.C -- dumps names from a.out file
 */
#include <stdio.h>
#include <fcntl.h>
#ifdef MSDOS
#include "a_out.h"
#else
#include "a.out.h"
#endif
#include "magic.h"
#include "conv.h"

extern char *malloc();
int verbose = 0;

main (argc, argv)
int argc;
char **argv;
{
  ++argv;
  if (argc > 1 && **argv == '-' && *(*argv + 1) == 'v') {
    --argc;
    ++argv;
    ++verbose;
  }
  if (argc == 1) dump (NULL);
  else if (argc == 2) dump (*argv);
  else while (--argc) {
    printf ("%s:\n", *argv);
    dump (*argv++);
    if (argc != 1) putchar ('\n');
  }
  exit (0);
}

dump (filename)
char *filename;
{
  int fd;
  struct exec e;

  if (filename == NULL) fd = 0;
#ifdef MSDOS
  else if ((fd = open (filename, O_RDONLY | O_BINARY)) == -1) {
#else
  else if ((fd = open (filename, O_RDONLY)) == -1) {
#endif
    puts ("Could not open file");
    return;
  }
  if (sizeof (struct exec) != read (fd, &e, sizeof (struct exec))) {
    puts ("File too short");
    return;
  }
  CM2L (e.a_magic);
  CM2L (e.a_text);
  CM2L (e.a_data);
  CM2L (e.a_bss);
  CM2L (e.a_trsize);
  CM2L (e.a_drsize);
  CM2L (e.a_sym);
  CM2L (e.a_str);
  CM2L (e.a_entry);
  CM2L (e.a_tstart);
  CM2L (e.a_dstart);
  if (e.a_magic != RELOC_MAGIC && e.a_magic != EXEC_MAGIC) {
    printf ("Bad magic number: 0x%lx\n", e.a_magic);
    return;
  }
  if (verbose) printhead (&e);
  if (e.a_sym == 0 || e.a_str == 0)
    puts ("File has no symbol table\n");
  else print_syms (&e, fd);
  close (fd);
}

print_syms (e, fd)
struct exec *e;
int fd;
{
  struct nlist *nl, *p;
  char *str;

  if (!read_tbl (fd, &nl, e->a_sym, (long)(SYMPOS (*e))) ||
  !read_tbl (fd, &str, e->a_str, (long)(STRPOS (*e)))) return;
  for (p = nl; p < nl + e->a_sym/sizeof(struct nlist); ++p) {
    CM2S (p->n_type);
    CM2L (p->n_value);
    CM2L (p->n_stroff);
    switch (p -> n_type) {
      case T_UNDF:
        printf ("\t UNDEF\t%s\n", str + p->n_stroff);
        break;
      case T_TEXT:
        printf ("%8lx TEXT\t%s\n", p->n_value, str + p->n_stroff);
        break;
      case T_DATA:
        printf ("%8lx DATA\t%s\n", p->n_value, str + p->n_stroff);
        break;
      case T_BSS:
        printf ("%8lx BSS\t%s\n", p->n_value, str + p->n_stroff);
        break;
      default:
        printf ("\t BAD TYPE\t\"%s\", type = 0x%x\n",
          str + p->n_stroff, p->n_type);
        break;
     }
  }
  free (nl);
  free (str);
}

read_tbl (fd, ptr, size, pos)
int fd;
char **ptr;
long size, pos;
{
  if (NULL == (*ptr = malloc ((unsigned)size))) {
    puts ("Could not allocate memory");
    return 0;
  }
  if (-1 == lseek (fd, pos, 0)) {
    puts ("Could not seek file");
    return 0;
  }
  if (size != read (fd, *ptr, (unsigned)size)) {
    puts ("Could not read symbol or string table");
    return 0;
  }
  return 1;
}

printhead (e)
struct exec *e;
{
  if (e->a_magic == EXEC_MAGIC) {
    printf ("             Type: executable\n");
    printf ("            Entry: 0x%lx\n", e->a_entry);
    printf ("           Tstart: 0x%lx\n", e->a_tstart);
    printf ("           Dstart: 0x%lx\n", e->a_dstart);
  } else
    printf ("             Type: relocatable\n");
  printf ("             Text: 0x%lx bytes\n", e->a_text);
  printf ("             Data: 0x%lx bytes\n", e->a_data);
  printf ("              BSS: 0x%lx bytes\n", e->a_bss);
  printf ("  Text relocation: %ld records, 0x%lx bytes\n",
    e->a_trsize/sizeof (struct r_info), e->a_trsize);
  printf ("  Data relocation: %ld records, 0x%lx bytes\n",
    e->a_drsize/sizeof (struct r_info), e->a_drsize);
  printf ("     Symbol table: %ld records, 0x%lx bytes\n",
    e->a_sym/sizeof (struct nlist), e->a_sym);
  printf ("     String table: 0x%lx bytes\n", e->a_str);
}
