/* Ld.h
 * Header file for NSC 32K loader
 */
#include <stdio.h>
#ifdef MSDOS
#include "a_out.h"
#else
#include <a.out.h>
#endif
#include <ar.h>
#include <magic.h>
#include <conv.h>
#include <ranlib.h>

#ifndef LIBDIR
#  define LIBDIR "/lib/lib"   /* -lxxx expands to LIBDIRxxx.a */
#endif

#define U16 unsigned short
#define HASHLEN 0x400         /* hash pointer array size (power of two) */
#define SBUFSZ 0x1000         /* string buffer size */
#define R_INFOSZ (sizeof (struct r_info))
#define max(a,b) (((a)>(b))?(a):(b))
#define DEFAULT 0xffffffff    /* indicates no user supplied segment addresses */
#define DEFAULT_TSTART 0      /* default start of text segment */
#define DEFAULT_OUT "a.out"   /* default output file name */
#define ENTRY_ID "start"      /* seed label to bring in C runtime */
#define BTEXT_ID "_btext"     /* special labels: begin text */
#define ETEXT_ID "_etext"     /*   end text */
#define BDATA_ID "_bdata"     /*   begin data */
#define EDATA_ID "_edata"     /*   end data */
#define END_ID   "_end"       /*   end bss */
#define TRUE 1
#define FALSE 0

typedef struct hashnode *hashptr;
typedef struct nlist *nlptr;
typedef struct filenode *fileptr;

#define HASHNODESZ   (sizeof (struct hashnode))
#define STRNODESZ    (sizeof (struct strnode))
#define FILENODESZ   (sizeof (struct filenode))

struct hashnode {                     /* hash table bucket */
  char *id;                           /* pointer to symbol in string tab */
  nlptr nlp;                          /* nlist which defines symbol */
  short index;                        /* index in output file symbol table */
  hashptr link;
};

struct strnode {                      /* node of string tab linked list */
  struct strnode *link;
  long size;                          /* characters in this strnode */
  char sbuf [SBUFSZ];
};

struct filenode {                     /* records files for second pass */
  fileptr link;                       /* for linked queue */
  char *name;                         /* file name */
  long offset;                        /* offset into archive, 0 for a.out */
  nlptr nlp;                          /* file's symbol table */
  long new_text,                      /* offset of text seg in new module */
       new_data,                      /* offset of data seg in new module */
       new_bss;                       /* offset of bss seg in new module */
  union {
    struct exec e;
    struct {
      MAGIC_TYPE magic;
      struct ar_header ar;
    } ar;
  } h;
};

extern hashptr find(), insert(), hash[];
extern struct strnode *strhead, *strtail;
extern struct exec head;
extern fileptr filehead, filetail;
extern int num_errors, reloc, printundef(), fixup_syms(), sym_index,
           write_nlist(), debug;
extern char *malloc(), *myalloc(), *curfile, outname[], entry_id[], *getseg();
extern long lseek(), link_sym(), seg_reloc();
extern FILE *fopen(), *infile;
extern struct rl_file *proc_rl_file();
extern unsigned long tstart_, dstart_, bstart_;
