/* A.out file format.
 *
 *   +-------------+
 *   |header       |
 *   +-------------+
 *   |text         |
 *   +-------------+
 *   |data         |
 *   +-------------+
 *   |text reloc   |
 *   +-------------+
 *   |data reloc   |
 *   +-------------+
 *   |symbol table |
 *   +-------------+
 *   |string table |
 *   +-------------+
 */

/* header structure
 */
struct exec {
  long     a_magic;
  long     a_text;       /* length of text segment */
  long     a_data;       /* length of data segment */
  long     a_bss;        /* length of uninitialized data segment */

  long     a_trsize;     /* length of text relocation table */
  long     a_drsize;     /* length of data relocation table */
  long     a_sym;        /* length of symbol table */
  long     a_str;        /* length of string table */

  long     a_entry;      /* program entry point */
  long     a_tstart;     /* text load point (see ld -T option) */
  long     a_dstart;     /* data load point (see ld -D option) */
  long     dummy;
};

/* symbol table entry
 */
struct nlist {
  long     n_value;      /* value of symbol, offset from beginning of text */
  long     n_stroff;     /* offset of identifier in string table */
  short    n_type;       /* undefined, text, data, bss (abs?) */
};

/* relocation table entry
 */
struct r_info {
  long     r_adr;        /* location to modify, offset in current segment */
  short    r_sym;        /* index in symbol table */
};
/* r_info.r_sym values
 *
 * All objects except displacements and general operand immediate extensions
 * are stored least significant byte first.  Displacements (R_NSCDISP) are
 * stored most significant byte first and include a size field of one
 * or two bits.  Since we only relocate 32 bit objects, we only need to worry
 * about the 32 bit displacement -- its two most significant two bits are 1's.
 * A 32 bit immediate extension (R_GENIMM) is just four bytes starting with
 * the msb.  R_GENIMM & R_NSCDISP is illegal.
 *
 * Addressing modes supported are absolute and PC relative.  R_PCREL
 * indicates the later.  
 *
 * Bits 12-0 of r_sym are the index of the symbol in the symbol table,
 * unless bits 12-2 are all 1.  After a location is linked to a symbol,
 * its r_sym index is replaced with R_SPECIAL or'd with R_TEXT, R_DATA,
 * or R_BSS, depending on the symbol's segment.  
 */
#define R_NSCDISP  0x8000  /* 15: 32000 displacement (msbyte first) */
#define R_PCREL    0x4000  /* 14: PC relative addressing mode */
#define R_GENIMM   0x2000  /* 13: gen operand immediate (byte swapped) */
#define R_FLAGS    (R_NSCDISP | R_PCREL | R_GENIMM)
#define R_SYM      (0xffff & ~R_FLAGS) /* symbol index */
#define R_SEG      0x0003  /* mask for T_TEXT, R_DATA, R_BSS */
#define R_TEXT     0x0000
#define R_DATA     0x0001
#define R_BSS      0x0002
#define R_SPECIAL  (R_SYM & ~R_SEG) /* if these bits set, then special symbol */

#ifdef NS32532
#  define PAGESZ   4096    /* for aligning segments on pages */
#else
#  define PAGESZ   1024    /* for aligning segments on pages */
#endif
#define BLKSZ	1024

/* macros which define various positions in a.out */
#define TEXTPOS(p) (((p).a_magic == EXEC_MAGIC)? BLKSZ: (sizeof(struct exec)))
#define DATAPOS(p) (TEXTPOS(p)+(p).a_text)
#define TRPOS(p)   (DATAPOS(p)+(p).a_data)
#define DRPOS(p)   (TRPOS(p)+(p).a_trsize)
#define SYMPOS(p)  (DRPOS(p)+(p).a_drsize)
#define STRPOS(p)  (SYMPOS(p)+(p).a_sym)

/* symbol table types */
#define T_UNDF   1      /* do not know yet */
#define T_TEXT   2      /* code segment label */
#define T_DATA   4      /* data segment label */
#define T_BSS    8      /* common (bss) segment label */
#define T_STATIC 16     /* or'd with T_TEXT, T_DATA, T_BSS */
