/* NS32000 Assembler
 * Phase2.c
 * Shrinks displacements in text segment to smallest possible size.
 */
#include <stdio.h>
#ifdef MSDOS
#  include "a_out.h"
#else
#  include "a.out.h"
#endif
#include "glob.h"

/* Turns on and off minimization of displacements */
#define OPTIMIZE
/* Rounds up segments sizes */
#define SEG_CEIL(x) ((x)+SEGALIGN-1&~(SEGALIGN-1))

phase2()
{
  phase = 2;
#ifdef OPTIMIZE
  reduce_disp();
  fix_data_structs();
#else
  module_offsets (tlbl_head, 0L);      /* temporary */
#endif
  module_offsets (dlbl_head,           /* convert label seg offs to mod offs */
    SEG_CEIL (header.a_text));
  module_offsets (blbl_head, SEG_CEIL (header.a_text) +
    SEG_CEIL (header.a_data));
}

/* Determine minimal size for displacements.  Only T_IMM and T_TEXT
 * can be reduced because other displacements can increase in size
 * during linking.  While references to text will still be unresolved,
 * they cannot get bigger -- this makes the reduction in size possible.
 */
reduce_disp()
{
  patchptr pchp;
  register int typ, flags;

  for (pchp = tpatch_head; pchp != NULL; pchp = pchp->link) {
    flags = pchp->flags;
    if (flags & pDISP && !(flags & pWRITTEN)) {
      lnnum = pchp->lnnum;
      eval_exp (pchp->exp, &pchp->typ, &pchp->val, &pchp->undf);
      typ = pchp->typ;
      /* was: if (pchp->typ & (T_IMM | T_TEXT)). bug fix 6/30/88 */
      if (typ & T_IMM || (typ & T_TEXT && flags & pPCREL))
        if (4 != (pchp->size =
        disp_size ((flags & pPCREL)?
        pchp->val - pchp->offset: pchp->val)))
          pchp->flags |= pREDUCED;
    } 
  }
}
        
/* Called after the size of all displacements has been determined.
 * Fixes the text patches, text labels, and line number map to reflect
 * the reduction in size of the displacements.
 */
fix_data_structs()
{
  U32 curoff,                          /* current offset (before reduction) */
    old_fix;                           /* total reduction so far */
  int new_fix;                         /* reduction for this line */
  lblptr lblp;
  lnptr lnp;
  patchptr pchp;
  struct melt *meltp;

  curoff = -1;				/* Bug fix.  Used to be = 0.  This
					 * fix forces the first patch to be
					 * a "new instruction" so that labels
					 * on or before the first patch will
					 * not be altered.
					 */
  old_fix = new_fix = 0;
  lblp = tlbl_head;
  if (tpatch_head != NULL) {
    if (listing) {
      lnp = ln_head;
      meltp = lnp->map;
    }
    for (pchp = tpatch_head;           /* for all text patches */
    pchp != NULL; pchp = pchp->link) {
      if (curoff != pchp->offset) {    /* new instruction? */
        if (listing) {
          meltp->size -= new_fix;      /* fix lnmap for previous line */
          while (meltp->lnnum <        /* keep in sync with line map */
          pchp->lnnum)
            next_melt (&lnp, &meltp);
        }
        curoff = pchp->offset;
        old_fix += new_fix;
        new_fix = 0;
        while (lblp != NULL &&         /* fix labels up to current offset */
        lblp->val <= curoff) {
          lblp->typ |= T_RESOLVED;
          lblp->val -= old_fix;
          lblp = lblp->llink;
        }
      }
      pchp->offset -= old_fix;         /* fix this patch's offset */
      pchp->pcoff -= new_fix;          /* fix this patch's pcoff */
      if (pchp->flags &                /* if reduced, update new_fix */
      (pREDUCED | pALIGN)) {
        if (pchp->flags & pALIGN)      /* if alignment, reduce here */
          pchp->size = pchp->val - 1 - /* val is modulus */
            (pchp->offset-1) % pchp->val;
        new_fix += 4 - pchp->size;
      }
    }
    if (listing) meltp->size -= new_fix;
  }
  old_fix += new_fix;                  /* fix rest of labels */
  while (lblp != NULL) {
    lblp->typ |= T_RESOLVED;
    lblp->val -= old_fix;
    lblp = lblp->llink;
  }
  header.a_text -= old_fix;            /* update segment size */
}

/* Loops, when called successively, through all line map elements.
 */
next_melt (lnp, meltp)
register lnptr *lnp;
register struct melt **meltp;
{
  if (++*meltp - (*lnp)->map >= (*lnp)->len)
    if ((*lnp)->link == NULL) *meltp = NULL;
    else {
      *lnp = (*lnp)->link;
      *meltp = (*lnp)->map;
    }
}

/* Ultimately we want label offsets to be offsets from the beginning of the
 * module.  However, until displacements are minimized, we do not know the
 * length of the text segment.  This routine is called once the text segment
 * size of known; it adds the size of the preceding segment(s) to the labels
 * in the label list.
 */
module_offsets (list, inc)
register lblptr list;
register long inc;
{
  for (; list != NULL; list = list->llink) {
    list->val += inc;
    list->typ |= T_RESOLVED;
  }
}

print_patch_lists ()
{
  patchptr pchp;

  if (NULL != tpatch_head) {
    fprintf (stderr, "Text patches:\n");
    for (pchp = tpatch_head; NULL != pchp; pchp = pchp->link)
      print_patch (pchp);
  }
  if (NULL != dpatch_head) {
    fprintf (stderr, "Data patches:\n");
    for (pchp = dpatch_head; NULL != pchp; pchp = pchp->link)
      print_patch (pchp);
  }
}

static char *pchflg[] = {
	"DISP",		/* 1 */
	"IMM",		/* 2 */
	"SHORT",	/* 4 */	
	"PCREL",	/* 8 */	
	"?",		/* 0x10 */
	"NEED_IMM",	/* 0x20 */	
	"NEED_TEXT",	/* 0x40 */	
	"WRITTEN",	/* 0x80 */	
	"REDUCED",	/* 0x100 */	
	"BYTEREV",	/* 0x200 */
	"GENIMM",	/* 0x400 */
	"ALIGN",	/* 0x800 */
	};
static char *pchtyp[] = {
	"T_UNDF",	/* 1 */
	"T_TEXT",	/* 2 */
	"T_DATA",	/* 4 */
	"T_BSS",	/* 8 */
	"T_STATIC",	/* 0x10 */
	NULL,		/* 0x20 */
	"T_IMM",	/* 0x40 */
	NULL,		/* 0x80 */
	NULL,		/* 0x100 */
	NULL,		/* 0x200 */
	"T_RESOLVED",	/* 0x400 */
	};

print_patch (pchp)
patchptr pchp;
{
  int i;
  char **p;

  fprintf (stderr, "  offset=0x%lx line=%d size=%d pcoff=%d ",
    pchp->offset, pchp->lnnum, pchp->size, pchp->pcoff);
  for (i = 1, p = pchflg; i <= 0x800; i <<= 1, ++p)
    if (pchp->flags & i) fprintf (stderr, "%s ", *p);
  for (i = 1, p = pchtyp; i <= 0x400; i <<= 1, ++p)
    if ((pchp->typ & i) && NULL != *p)
      fprintf (stderr, "%s ", *p);
  fputc ('\n', stderr);
}
 
