#include <stdio.h>
#include <sys/types.h>
#include "config.h"
  
#ifdef BSD
/* Couldn't find replacement in BSD, returns fp to a temporary file */

FILE *tmpfile()
{
  int fd;
  FILE *fp;
  char *temporary_name = "/tmp/rfmailXXXXXX";
  
  if ((fd = mkstemp(temporary_name)) == -1) {
    return (FILE *) NULL;
  } else {
    fp = fdopen(fd, "w+");

    /* Get rid of directory entry so we don't have to
       worry about it any more. */
    
    if (unlink(temporary_name) == -1) {
      log("Warning, unlinking temporary %s failed", temporary_name);
    }
  }
  return fp;
}
#endif

