#include <string.h>
#include <ctype.h>
#include "hsu.h"

/* Check if string just consists of space (or is null). Return TRUE if so */

strempty(s)
     char *s;
{
  while (*s) if (!isspace(*s)) return FALSE; else s++;
  return TRUE;
}

/* Clean up space from start and end */

char *strclean(s)
     char *s;
{
  char *d = s, *p = s;

  /* Find first non-space char */
  for (; *p; p++) if (!isspace(*p)) break;

  /* Copy until end */
  if (d != p) while (*d++ = *p++);

  /* Strip space from end */
  while (strlen(s) && isspace(s[strlen(s) - 1])) s[strlen(s) - 1] = 0;

  return s;
}

/* Clean up whitespace from start */
char *strsclean(s)
     char *s;
{
  char *d = s, *p = s;

  /* Find first non-space char */
  for (; *p; p++) if (!isspace(*p)) break;

  /* Copy until end */
  if (d != p) while (*d++ = *p++);

  return s;
}

