#include <stdio.h>
#include <varargs.h>
#include "hsu.h"

#define MAX_CONVERT_BUFFERS 10
#define MAX_CONVERT_BUFLEN 80
static char bufs[MAX_CONVERT_BUFFERS][MAX_CONVERT_BUFLEN], *tcharp;
static bflag;

#define SHUFFLEBUFFERS \
loop_increment(bflag, MAX_CONVERT_BUFFERS); tcharp = bufs[bflag]

/* Strcat creating its own buffer */

char *sstrcat(d, s)
     char *d, *s;
{
  SHUFFLEBUFFERS;

  (void) strncpy(tcharp, d, MAX_CONVERT_BUFLEN);
  tcharp[MAX_CONVERT_BUFLEN - 1] = '\0';
  (void) strncat(tcharp, s, MAX_CONVERT_BUFLEN);
  return tcharp;
}

/* Sprintf with own buffer */

/*VARARGS1*/
char *sprintfs(fmt, va_alist)
     char *fmt;
     va_dcl
{
  va_list pvar;

  va_start(pvar);

  SHUFFLEBUFFERS;

  (void) vsprintf(tcharp, fmt, pvar);

  va_end(pvar);

  return tcharp;
}

