#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Replacement for rmail. This looks out, if destination system
   name is numeric, and if it is, feeds mail to fidonet mail
   server. If system name is not numeric, this executes real rmail.
   If this site is not a fidonet gateway, define GATEWAY in rmail.h
   to path to route to that host.

   This is just a temporary replacement, MUCH MORE better is to use
   sendmail for gatewaying or smail 2.3 version that also can invoke
   other mailers.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to foreign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include "hsu.h"
#include "rmail.h"
#include "config.h"
#include "nodelist.h"
#include "fnet.h"
#include "configs.h"
     
extern char *malloc();
extern void exit();
extern void perror();
extern char *regex();

#ifndef GATEWAY


/* Open stream associated with program's standard input. Program is invoked
   with given argument list. Popen(3S) would invoke mailer thru sh(1),
   so this uses less memory and is faster. */

FILE *
open_mailer(program, args, pid)
     char *program, **args;
     int *pid;
{
  FILE *fp;
  int fd[2];
  
  /* create pipe */
  if (pipe(fd) == -1)
    {
      perror("rmail: pipe");
      exit(EX_OSERR);
    }
  
  switch (*pid = fork())
    {
    case -1:
      perror("rmail: fork");
      exit(EX_OSERR);
    case 0:
      (void) close(0);
      if (dup(fd[0]) == 0)
        {
          (void) close(fd[0]);
          (void) close(fd[1]);
          (void) execvp(program, args);
          perror(program);
        }
      else
        perror("rmail: dup");
      exit(EX_OSERR);
    default:
      (void) close(fd[0]);
      if ((fp = fdopen(fd[1], "w")) == NULL)
        {
          perror("rmail: fdopen");
          exit(EX_OSERR);
        }
    }
  return fp;
}

#endif


/* ARGSUSED */
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  int cnt;
  char *fidomailer, *if_fidoaddr();

#ifdef GATEWAY
  
  char *path;
  
#else
  
  char **rargs = marray(argc + 1), **fargs = marray(argc + 1);
  int rrec = 0, frec = 0, rargc = 1, fargc = 1;
  int status = EX_OK;
  char dummyname[100];
  Node dummynode;
  
#endif

  get_configuration();
  
  fidomailer = (char *) malloc(sizeof(config.libdir) + sizeof(FIDOMAILER) + 1);
  (void) sprintf(fidomailer, "%s/%s", config.libdir, FIDOMAILER);

#ifdef GATEWAY
  
  /* If GATEWAY is defined, send all mail going to fidonet to there.
     If domain .FidoNet is known by other mahcines, routing is not
     really problem and this rmail is not needed elsewhere than in
     real gateway if there's no sendmail or other intelligent system
     in use. */
  
  for (cnt = 1; cnt < argc; cnt++)
    if (if_fidoaddr(argv[cnt], dummyname, &dummynet, &dummynode) == NULL)
      {
#ifdef DEBUG
        (void) debug(3, "Routing %s to %s", argv[cnt], GATEWAY);
#endif
        path = malloc((unsigned) (strlen(GATEWAY) +
                                  strlen(argv[cnt]) + 2));
        (void) strcpy(path, GATEWAY);
        (void) strcat(path, "!");
        argv[cnt] = strcat(path, argv[cnt]);
      }
  
  (void) execvp(REAL_RMAIL, argv);
  perror(REAL_RMAIL);
  
#else
  
  *rargs = REAL_RMAIL;
  *fargs = FIDOMAILER;
  
  /* Scan thru receiver list and put all receivers in fidonet in fido-
     mailer's receiver-list and all others in real rmail's one. No
     options can be passed to fidomailer thru this, because it would
     be too difficult to determine which one goes to which one and
     there might be same options also. Somehow it's good that fidomailer
     is well hidden under this... */
  
  for (cnt = 1; cnt < argc; cnt++)
    if (*argv[cnt] == '-')
      rargs[rargc++] = strsave(argv[cnt]);
    else
      {
        if (if_fidoaddr(argv[cnt], dummyname, &dummynode) == NULL)
          {
#ifdef DEBUG
            (void) debug(3, "Argument %d (receiver %d) in fidomailer: %s",
			 fargc, frec + 1, argv[cnt]);
#endif
            fargs[fargc++] = strsave(argv[cnt]);
            frec++;
          }
        else
          {
#ifdef DEBUG
            (void) debug(3, "Argument %d (receiver %d) in rmail: %s",
			 rargc, rrec + 1, argv[cnt]);
#endif
            rargs[rargc++] = strsave(argv[cnt]);
            rrec++;
          }
      }
  
  /* NULL terminate argument lists */
  rargs[rargc] = NULL;
  fargs[fargc] = NULL;
  
  /* If there is mail only to rmail or fidomail, execute that mailer
     with our original argument list. */
  
  if (!frec)
    {
#ifdef DEBUG
      (void) debug(3, "No mail to fidonet, executing %s", REAL_RMAIL);
#endif
      (void) execvp(REAL_RMAIL, argv);
      perror(REAL_RMAIL);
      exit(EX_OSERR);
    }
  else
    if (!rrec)
      {
#ifdef DEBUG
        (void) debug(3, "No mail to UUCP, executing %s", fidomailer);
#endif
        (void) execvp(fidomailer, argv);
        perror(fidomailer);
        exit(EX_OSERR);
      }
    else
      {
        
        /* There's mail to both fidonet and usenet. We'll have to open
           both mailers and feed this letter to them at the same time.
           This is quite risky: If one of the mailers exits for any
           reason, we will get SIGPIPE and we'll fall down.... if that
           happens, the other mailer got incomplete letter. */
        
        int rmail_pid, fmail_pid;
        register FILE *rmail = open_mailer(REAL_RMAIL, rargs, &rmail_pid);
        register FILE *fmail = open_mailer(fidomailer, fargs, &fmail_pid);
        char buffer[BUFSIZ];
        int pid;
#ifdef USG
        int stat_loc;
#else
	union wait *stat_loc;

	stat_loc = (union wait *) malloc(sizeof(*stat_loc));
#endif	

        
#ifdef DEBUG
        (void) debug(3, "Mail both to fidonet and UUCP");
#endif
        while (fgets(buffer, BUFSIZ, stdin))
          {
            (void) fputs(buffer, rmail);
            (void) fputs(buffer, fmail);
          }
        (void) fclose(rmail);
        (void) fclose(fmail);
        
        /* We should wait for both mailers to exit and check their exit
           statuses. Then we should decide which one we should return,
           in this case let's return status from rmail, if other than
           EX_OK, otherwise from fidomail. */
        
        while ((pid = wait(&stat_loc)) != -1)
          if (pid == rmail_pid)
            {
              if ((stat_loc & 0377) == 0)
                status = stat_loc >> 8;
            }
          else
            if (pid == fmail_pid)
              {
                if ((stat_loc & 0377) == 0 && status == EX_OK)
                  status = stat_loc >> 8;
              }
      }
#endif
  
  exit(status);
  /* NOTREACHED */
}

/*
 * Jari Malinen 1989 (jam@hutcs.hut.fi | jam@finhutcs.BITNET)
 * Routine checks if we have a probable fidonet address by examining
 * the following (see more in the header of address.c for fido addr syntax)
 * - Possible path syntax: fido address can't currently be in uucp path
 *   form i.e. contain a '!' character. If it does even with GATEWAY option
 *   then it still is not a fido address an must be passed to rmail as is.
 * - domain: if we have '@' and .fidonet or .FIDONET as
 *   last component of the address then it is a possible fido address.
 * Only then we call parse_address() to check for the details, else address
 * is preserved untampered i.e. no case altering takes place, which can
 * be a fatal mistake when sending to other networks where mailers might
 * be case sensitive.
 * Note:
 *   address name@fidonet DOESN'T go to fidomailer.
 *   name can't contain '@' character.
 */
char *
if_fidoaddr(address, name, node)
     char *address, *name;
     Node *node;
{
  static char error[64], tmpaddr[BUFSIZ];
  register char *cp, *dp;

  error[0] = NULL;
  if( strchr( address, '!' ) || ! (cp = strchr( address, '@' ) ) )
    {
      debug(3, "Not a fido address: %s: '!' found or '@' missing", address);
      (void) sprintf(error, "Invalid or missing path caracter in address");
      return error;
    }
  else
    {
      dp = address;
/*      while( *dp++ ); dp--;		/* goto end of string for strrchr */
      if( ( dp = strrchr( address, '.' ) ) != NULL ) cp = dp;
      (void) strcpy( tmpaddr, cp );
      for( dp = tmpaddr; *dp; dp++ )
          if( isupper(*dp) ) *dp = tolower( *dp );
      if( strcmp( tmpaddr, ".fidonet" ) )
        {
          debug(3, "Not a fido address: no fidonet domain in address");
          (void) sprintf(error, "No .fidonet address %s", address);
          return error;
        }
    }
  (void) strcpy( tmpaddr, address );	/* preserve address untampered */
  return parse_address( tmpaddr, name, node );
}
