#ifndef H_HSU
#define H_HSU 1

/* I'm here !!! */

#define HSU 1

/* Msc doesn't define SIG_ERR */

#ifndef SIG_ERR
#define SIG_ERR ((int (*)())-1)
#endif
#ifndef SIG_TYPE
#ifdef i386
#define SIG_TYPE void (*)()
#define SIG_FTYPE void
typedef void (*sig_t)();
#else
#define SIG_TYPE int (*)()
#define SIG_FTYPE int
typedef int (*sig_t)();
#endif
#endif

/* General stuff I like */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define LINEBUF 256
#define ERRBUF 512

#define FLOATCHARS "0123456789.-eE+"
#define INTCHARS "0123456789-"
#define UNSIGNEDCHARS "0123456789"
#define SEPARATORS " ,;\015\012\011"
#define WHITESPACE " \015\012\011"

/* Swap two variables (works only for ints, longs) */

#define ISWAP(x, y) ((x) ^= (y) ^= (x) ^= (y))

/* make < 0 -1, > 0 1, = 0 0 */

#define REDUCE(x) (((x) < 0) ? -1 : ((x) ? 1 : 0))

/* Functions. */

#ifdef lint
extern char *strsave(), *strasave(), *strnsave();
#else
#define strsave(s) (strcpy(malloc((unsigned) (strlen(s) + 1)), (s)))
#define strasave(s) { char *p; \
			p = alloca((unsigned) (strlen(s) + 1)), \
		     strcpy(p, (s))}
#define strnsave(s, n) {char *p ; \
			p = strncpy(malloc((unsigned) ((n) + 1)), (s), (n)), \
			  p[n] = 0}
#endif

#define strequ(x,y) (strcmp(x,y) == 0)
#define strnequ(x,y) (strcmp(x,y) != 0)
#define strnotnull(x) (*x != '\0')
#define strnull(x) (*x == '\0');
/* Pointer to end of string */
#define strend(x) ((x) + strlen(x))

/* Increment counter, looping back to 0 if wrap-over */

#define loop_increment(x,y) (x = (++x >= (y)) ? 0 : x)
#define loop_decrement(x,y) (x = (--x < 0) ? (y)-1 : x)

/* Some procedures */

#ifdef lint
#ifdef clearerr
#undef clearerr
#endif
extern void clearerr();
#endif
extern char *alloca(), *strncpy(), *strncat(), *sprintfs(), *sstrcat();
extern char *mktemp(), *strclean(), *strsclean(), *ctime();
extern int strempty(), mkdir();
extern void exit(), qsort(), free();
extern long time(), getdate();
extern unsigned short getuid();
extern unsigned short geteuid();
extern unsigned short getgid();
extern unsigned short getegid();
extern unsigned alarm();
extern unsigned sleep();

/* Defines which are not in std headers (why!?) */

extern char *optarg, *sys_errlist[], *getenv(), *bsearch();
extern int optind, opterr, errno, sys_nerr;
extern long atol();
extern void qsort();

/* Macro version of getw putw. w is destination. */

#ifdef SAFE_STDIO_ROUTINES
#define FGETW(w, fp) (w = getw(fp))
#define FPUTW(w, fp) putw(w, fp)
#define FGETINT16(w, fp) fread( (char *) &(w), 2, 1, fp)
#define FPUTINT16(w, fp) fwrite( (char *) &(w), 2, 1, fp)
#define FGETLW(w, fp) fread( (char *) &(w), sizeof(long), 1, fp)
#define FPUTLW(w, fp) fwrite( (char *) &(w), sizeof(long), 1, fp)
#define FREAD(p, bytes, nitems, fp) (void) fread(p, bytes, nitems, fp)
#define FWRITE(p, bytes, nitems, fp) (void) fwrite(p, bytes, nitems, fp)
#define FFORWARDSEEK(bytes, fp) (void) fseek(fp, (long) (bytes), SEEK_CUR)
#define FGETS(cp, maxlen, fp) \
{ (void) fgets(cp, maxlen, fp); \
    if (strchr(cp, '\n')) *(strchr(cp, '\n')) = '\0'; }
#define ferr(fp) (ferror(fp) | feof(fp))

#else /* Safe stdio */

/* Dangerous and unportable but faster macros */
#define FGETW(w, fp) \
  if ((fp)->_cnt < sizeof(int)) \
    w = getw(fp); \
  else { w = *(int *) (fp)->_ptr; \
	   (fp)->_ptr += sizeof(int); (fp)->_cnt -= sizeof(int); }

#define FPUTW(w, fp) \
  if ((fp)->_cnt < sizeof(int)) \
    (void) putw(w, fp); \
  else { *(int *) (fp)->_ptr = w; \
	   (fp)->_ptr += sizeof(int); (fp)->_cnt -= sizeof(int); }

#define FGETINT16(w, fp) \
  if ((fp)->_cnt < sizeof(short)) \
    (void) fread( (char *) &(w), sizeof(short), 1, fp); \
  else { w = *(short *) (fp)->_ptr; \
	   (fp)->_ptr += sizeof(short); (fp)->_cnt -= sizeof(short); }

#define FPUTINT16(w, fp) \
  if ((fp)->_cnt < sizeof(short)) \
    (void) fwrite( (char *) &(w), sizeof(short), 1, fp); \
  else { *(short *) (fp)->_ptr = w; \
	   (fp)->_ptr += sizeof(short); (fp)->_cnt -= sizeof(short); }

#define FGETLW(w, fp) \
  if ((fp)->_cnt < sizeof(long)) \
    (void) fread( (char *) &w, sizeof(long), 1, fp); \
  else { w = *(long *) (fp)->_ptr; \
	   (fp)->_ptr += sizeof(long); (fp)->_cnt -= sizeof(long); }

#define FPUTLW(w, fp) \
  if ((fp)->_cnt < sizeof(long)) \
    (void) fwrite( (char *) &w, sizeof(long), 1, fp); \
  else { *(long *) (fp)->_ptr = w; \
	   (fp)->_ptr += sizeof(long); (fp)->_cnt -= sizeof(long); }

/* And fread, fwrite. Don't return a value, so it has to be checked. */
/*
  could this work? test it!
  #define FREAD(p, bytes, nitems, fp)
  (((fp)->_cnt < (nitems) * (bytes)) ? fread(p, bytes, nitems, fp) :
  memcpy( (p), (char *) (fp)->_ptr, (int) ((nitems) * (bytes))),
  (fp)->_ptr += (nitems) * (bytes), (fp)->_cnt -= (nitems) * (bytes), nitems)

  */
#define FREAD(p, bytes, nitems, fp) \
  if ((fp)->_cnt < (nitems) * (bytes)) \
    (void) fread(p, bytes, nitems, fp); \
  else { \
    (void) memcpy( (p), (char *) (fp)->_ptr, \
		  (int) ((nitems) * (bytes))); \
		    (fp)->_ptr += (nitems) * (bytes); \
		      (fp)->_cnt -= (nitems) * (bytes); }

#define FWRITE(p, bytes, nitems, fp) \
  if ((fp)->_cnt < (nitems) * (bytes)) \
    (void) fwrite(p, bytes, nitems, fp); \
  else { \
    (void) memcpy( (char *) (fp)->_ptr, (p), (int) ((nitems) * (bytes))); \
	   (fp)->_ptr += (nitems) * (bytes); \
	     (fp)->_cnt -= (nitems) * (bytes); }

#define FFORWARDSEEK(bytes, fp) \
  if ((fp)->_cnt < (bytes)) \
    (void) fseek(fp, (long) (bytes), SEEK_CUR); \
  else { \
	   (fp)->_ptr += (bytes); \
	     (fp)->_cnt -= (bytes); }

/* FGETS differ from original: \n in the end is NOT copied!! (because
   I don't like that) */

extern char *strnchr();

#define FGETS(cp, maxlen, fp) \
  if (strnchr((fp)->_ptr, '\n', (fp)->_cnt)) \
{ \
  register zzcount; \
  register char *zzp; \
  for (zzcount = 1, zzp = cp; (*zzp = *(fp)->_ptr++) != '\n'; \
       zzp++, zzcount++) \
    if (zzcount >= (maxlen)) break; \
  *zzp = '\0'; \
  (fp)->_cnt -= zzcount; \
} else { \
  (void) fgets(cp, maxlen, fp); \
  if (strchr(cp, '\n')) *(strchr(cp, '\n')) = '\0'; \
}

/* Checks for both eof and error status, better than feof || ferror when
   compilers are stupid enough not to optimize that kind of situation. */

#define ferr(fp) ((fp)->_flag & (_IOEOF | _IOERR))

#endif /* Safe stdio */

#endif /* H_HSU */

