/* @(#)%M%  %I%  Teemu Torma %H%
   
   Header file for FidoNet-routines.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* Structure for packet header. */

typedef struct _packet {
  short orig_node; /* originating node */
  short dest_node; /* destinating mode */
  short year; /* packing year (e.g. 1986) */
  short month; /* 0-11 for Jan - Dec */
  short day; /* 1-31 */
  short hour; /* 0-23 */
  short minute; /* 0-59 */
  short second; /* 0-59 */
  short rate; /* maximum baud rate */
  short ver; /* header version */
  short orig_net; /* originating net */
  short dest_net; /* destination net */
  char product; /* product */
  char x1; /* Extra byte */
#ifdef FIDO_V11w
  short fill[16]; /* extra space */
#else
  char pwd_kludge[8];
  short orig_zone;
  short dest_zone;
  char B_fill2[16];
  long B_fill3;
#endif
} Packet;

/* Attributes tranferred via mail. + not cleared when packetizing, s seadog */

#define ATTR_PRIVATE    (0000001) /* +  private msg */
#define ATTR_CRASH      (0000002) /* +s SEAdog only */
#define ATTR_RECD       (0000004) /*    Received */
#define ATTR_SENT	(0000010) /*    Sent */
#define ATTR_FILE	(0000020) /* +  files attached */
#define ATTR_INTRANSIT 	(0000040) /*    In transit */
#define ATTR_ORPHAN	(0000100) /*    Orphan */
#define ATTR_KILLSENT	(0000200) /*    Kill when sent */
#define ATTR_LOCAL	(0000400) /*    Local message, not sent out */
#define ATTR_HOLD	(0001000) /*  s Hold for Pickup */
#define ATTR_UNUSED 	(0002000) /* +  unused */
#define ATTR_FILEREQ	(0004000) /*  s File request */
#define ATTR_RRR 	(0010000) /* +s Returnreceiptrequest */
#define ATTR_IRR 	(0020000) /* +s Isreturnreceipt */
#define ATTR_AUDREQ 	(0040000) /* +s Audit Request */
#define ATTR_UPDREQ	(0100000) /*  s File update request */

/* Packet and message types. */

#define HDRVER (02)
#define MSGTYPE (02)
