#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "config.h"
#include "hsu.h"
#ifdef USG
#include <termio.h>
#include <dial.h>
#endif
#ifdef BSD
#include <sgtty.h>
#include "dial.h"
#endif

#include "nodelist.h"
#include "configs.h"
#include "fnet.h"
  
#ifdef BSD
  
/*

  Really quick hack replacement for normal dial. Currently only for BSD.
  This won't work with anything else than rfmail, it is not strictly
  dial() compatible, like ignoring given tty settings and setting it
  directly to raw mode.
  
 */
  

baud_to_bsdbaud(baud)
     int baud;
{
  switch (baud) {
   case 50:
    return B50;
   case 75:
    return B75;
   case 110:
    return B110;
   case 134:
    return B134;
   case 200:
    return B200;
   case 300:
    return B300;
   case 600:
    return B600;
   case 1200:
    return B1200;
   case 1800:
    return B1800;
   case 2400:
    return B2400;
   case 4800:
    return B4800;
   case 9600:
    return B9600;
   case 19200:
    return EXTA; /* Guess. This may blow up something! */
   case 38400:
    return EXTB; /* Guess, again. */
   case 0:
    log("0 baud rate requested, returning B9600");
    return B9600;
  }
}

write_string(s)
     char *s;
{
  for (; *s; s++) sendline(*s);
}

wait_for_string(s, timeout)
     char *s;
     int timeout;
{
  char *p;
  int c, t;
  long stime;
  
  SetStart();
  for (; !Timeout(timeout);) {
    p = s;
    
    /* Loop as long as string matches. */
    
    while ((c = readline((t = Timeleft(timeout)) ? t : 1)) == *p) {
      if (!*p) return FALSE; /* Got it (with a nul after) */
      p++;
    }
    if (!*p) return FALSE; /* Got it (with non-nul after) */
  }
  
  return TRUE; /* No matching string during timeout period. */
}

dial(call)
     CALL call;
{
  int fd, returncode = DIAL_INTERNAL_ERROR;

  if (!call.line) return DV_NT_K; /* Need the line */
  if (!call.telno) return DV_NT_K; /* Best thing I guess, no phone number? */
  
  if (createlock(call.line), config.lock_timeout) return DV_NT_A; /* Busy! */

  fd = open(call.line, O_RDWR | O_NDELAY);
  if (fd < 0) {
    returncode = L_PROB; /* Cannot open the device? */
    goto error_cleanup_nofile;
  }
  if (ioctl(fd, TIOCGETP, call.attr) < 0) {
    returncode = L_PROB;
    goto error_cleanup;
  }
  call.attr->sg_ospeed = call.attr->sg_ispeed = baud_to_bsdbaud(call.baud);
  call.attr->sg_flags = RAW;
  if (ioctl(fd, TIOCSETP, call.attr) < 0) {
    returncode = L_PROB;
    goto error_cleanup;
  }
  
  /* Then do actual Dialing */

  line = fd; /* fio.c routines use line for communication. */

  /* Initialize the modem. */

  if (*config.dial_initstring) {
    write_string(config.dial_initstring);
    write_string("\r"); /* Modems usually expect \r */
    if (*config.dial_initreply) {
      if (wait_for_string(config.dial_initreply, config.dial_inittimeout)) {
	log("Cannot initialize modem, no reply");
	returncode = D_HUNG;
	goto error_cleanup;
      }
    }
  }
    
  /* Send dialing command. */
    
  if (*config.dial_prefix) {
    write_string(config.dial_prefix);
    write_string(call.telno);
    write_string(config.dial_trailer);
    write_string("\r");
    
    /* Then wait until we get a connection or just time out (crude, just
       like in HDB uucp!). Could accept multiple strings, but who cares. */
    
    if (*config.dial_connect) {
      if (wait_for_string(config.dial_connect, config.dial_timeout)) {
	returncode = NO_ANS;
	goto error_cleanup;
      } else {
	return fd;
      }
    }
  }
  return fd;
  
 error_cleanup:
  (void) close(fd);

 error_cleanup_nofile:
  removelock(call.line);
  return returncode;
}

undial(fd)
     int fd;
{
  (void) close(fd); /* Maybe it should clean up, but ahh, ... */
}

#endif /* BSD */
