#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include "config.h"
#include "hsu.h"
#include "fnet.h"
#include "nodelist.h"
#include "configs.h"

/* Create a lock file. Return TRUE if failed */
  
createlock(s, timeout)
     char *s;	/* Thing to be locked */
     int timeout;
{
  int fd, process_id;
  long stime;

  SetStart();

  while (!Timeout(timeout)) {
    fd = open(sprintfs("%s/LCK..%s", config.lockdir, s),
	      O_CREAT | O_EXCL | O_RDWR, 0);
    if (fd < 0) {
      if (errno != EEXIST) {
	log("$Could not create lock file for %s", s);
	return TRUE; /* Creating lock file failed for some reason. */
      }

      /* Fall thru if EEXIST and try again. Sleep a second between so
	 we leave some cpu for others. */
      
      sleep(1);
    } else {
      break; /* Created ok! */
    }
  }
  
  if (fd < 0) return TRUE; /* Timed out */

  /* Have it open now, what to put in there? */
  
  if (!strcmp(config.locks, "bsd")) {
    (void) write(fd, (char *) &process_id, sizeof(process_id));
  } else if (!strcmp(config.locks, "hdb")) {
    (void) write(fd, sprintfs("%10d\n", process_id), 11);
  } else if (strcmp(config.locks, "empty")) {
    log("Unknown lock type %s", config.locks);
  } /* empty is empty! */

  (void) close(fd); /* so what */
  return FALSE; /* Everything went ok */
}


