/* interpret configuration file */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "hsu.h"
#include "config.h"
#include "fnet.h"
#include "nodelist.h"
#include "configs.h"

static int configline;

config_t config;

/* Searches char * table for string */

int listscan(list,search)
     char **list;
     char *search;
{
  register int i;
  static char *p1, *p2;
  
  i = 0;
  p1 = *list++;
  while (*p1 != '\0') {
    p2 = search;
    while (*p1 == *p2) {
      if (*p1++ == '\0')
	return(i);
      p2++;
    }
    if (*p2 == ' ') return i;
    i++;
    p1 = *list++;
  }
  return -1;
}

getint()
{
  char *p;
  
  if (p = strtok(NULL, SEPARATORS)) return atoi(p);
  return 0;
}

char *getstring(len)
     int len;
{
  char *p;

  if (p = strtok(NULL, SEPARATORS)) {
    if (strlen(p) >= len - 1) {
      log("Too long string in config (%s)", p);
      exit(EX_DATAERR);
    }
    return p;
  }
  return "";
}

/* strtok with second parameter as empty string should return
   all remaining stuff, according to how I understand strtok to
   work? Please tell me if I'm not right here! */

char *getrestofline()
{
  char *p;

  if (p = strtok(NULL, "")) return p;
  return "";
}

static char *trues[] = { "yes", "ok", "true", "1", "y", "on" };
static char *falses[] = { "no", "false", "0", "n", "none", "off" };

gettruth()
{
  char *p;

  if (p = strtok(NULL, SEPARATORS)) {
    if (listscan(trues, ascii_convert(p)) != -1) return TRUE;
    if (listscan(falses, ascii_convert(p)) != -1) return FALSE;
    log("Suspicious word of truth in config (%d): %s, returning true",
	p, configline);
  }
  return TRUE; /* Silence means yes */
}

#define its(s) (!strcmp(p, s))

/* Like fgets, but no \n is returned */

char *localfgets(buffer, size, fp)
     char *buffer;
     int size;
     FILE *fp;
{
  char *p, *p1;

  p = fgets(buffer, size, fp);
  if (p) if (p1 = strchr(buffer, '\n')) *p1 = 0;
  return p;
}

read_configuration()
{
  FILE *configfp;
  char buffer[BUFSIZ];
  char *p;
  int count;

  /* Clear up config structure */
  
  (void) memset( &config, 0, sizeof(config) );

  configline = 0;
  
  config.rfc_received_header = FALSE;
  config.prewait = 5;
  config.waitclear = 2;
  config.max_send_retries = 1;
  config.maxbaud = 1200;
  config.minbaud = 1200;
  config.max_linelen = 78;
  (void) strcpy(config.receive_path, "dosbox");
  (void) strcpy(config.domain, ".UUCP");
  (void) strcpy(config.spool, "/usr/spool/fnet");
  (void) strcpy(config.unpacked, "/usr/spool/fnet/unpacked");
  config.save_unpacked_packets = TRUE;
  (void) strcpy(config.sentbundles, "/usr/spool/fnet/sentbundles");
  config.save_sent_packets = TRUE;
  (void) strcpy(config.libdir, "/usr/lib/fnet");
  (void) strcpy(config.rnews, "/usr/bin/rnews");
  (void) strcpy(config.logfile, "/usr/lib/fnet/log");
  (void) strcpy(config.orphans, "/usr/lib/fnet/orphans");
  (void) strcpy(config.badarticles, "/usr/spool/fnet/bad");
  config.save_bad_messages = TRUE;
  config.save_bad_packets = FALSE;
  (void) strcpy(config.sequence, "/usr/lib/fnet/seq");
  (void) strcpy(config.idsequence, "/usr/lib/fnet/idseq");
  (void) strcpy(config.ipacketsequence, "/usr/lib/fnet/ipacketseq");
  (void) strcpy(config.opacketsequence, "/usr/lib/fnet/opacketseq");
  (void) strcpy(config.badsequence, "/usr/lib/fnet/badseq");
  config.useruid = 50;
  (void) strcpy(config.alias, "/usr/lib/fnet/Alias");
  (void) strcpy(config.rmail, "/bin/rmail");
  config.return_failed_mail = TRUE;
  (void) strcpy(config.dialtable[0], "358-0-");
  (void) strcpy(config.dialtable[1], "");
  (void) strcpy(config.dialtable[2], "358-");
  (void) strcpy(config.dialtable[3], "9");
  (void) strcpy(config.dialtable[4], "");
  (void) strcpy(config.dialtable[5], "990");
  config.newsgroups = 0;
  config.headers = 0;
  (void) strcpy(config.origin, "Missing Link (between usenet and fidonet)");
  (void) strcpy(config.seenby, "504/1 7");
  (void) strcpy(config.outtty, "");
  
  if (configfp = fopen(CONFIGFILE, "r")) {

    while (localfgets(buffer, BUFSIZ, configfp)) {

      configline++;
      
      p = strtok(buffer, SEPARATORS);

      /* Empty lines skipped silently */
      
      if (!p) continue;

      /* Skip comment lines */
      
      if (*p == '#') continue;

      if (its("debuglevel")) {
	config.debuglevel = getint();
	verbose = config.debuglevel;
      } else if (its("save-bad-packets")) {
	config.save_bad_packets = gettruth();
      } else if (its("save-bad-messages")) {
	config.save_bad_messages = gettruth();
      } else if (its("save-unpacked-packets")) {
	config.save_unpacked_packets = gettruth();
      } else if (its("save-sent-packets")) {
	config.save_sent_packets = gettruth();
      }	else if (its("mynode")) {
	if (parsefnetaddress(p = getstring(), &config.mynode)) {
	  log("Cannot parse fidonet address %s", p);
	  exit(EX_DATAERR);
	}
      } else if (its("myregion")) {
	config.mynode.region = getint();
      }	else if (its("echofeed")) {
	if (parsefnetaddress(p = getstring(), &config.echofeed)) {
	  log("Cannot parse echofeed address %s", p);
	  exit(EX_DATAERR);
	}
      } else if (its("rfc-received-header")) {
	config.rfc_received_header = gettruth();
      } else if (its("prewait")) {
	config.prewait = getint();
      } else if (its("waitclear")) {
	config.waitclear = getint();
      } else if (its("max-send-retries")) {
	config.max_send_retries = getint();
      } else if (its("maxbaud")) {
	config.maxbaud = getint();
      } else if (its("minbaud")) {
	config.minbaud = getint();
      } else if (its("max-line-len")) {
	config.max_linelen = getint();
      } else if (its("receive-path")) {
	(void) strcpy(config.receive_path, getstring(RECEIVE_PATH_LEN));
      } else if (its("domain")) {
	(void) strcpy(config.domain, getrestofline(DOMAIN_LEN));
      } else if (its("spool")) {
	(void) strcpy(config.spool, getstring(PATH_LEN));
      } else if (its("unpacked")) {
	(void) strcpy(config.unpacked, getstring(PATH_LEN));
      } else if (its("sentbundles")) {
	(void) strcpy(config.sentbundles, getstring(PATH_LEN));
      } else if (its("libdir")) {
	(void) strcpy(config.libdir, getstring(PATH_LEN));
      } else if (its("rnews")) {
	(void) strcpy(config.rnews, getstring(PATH_LEN));
      } else if (its("logfile")) {
	(void) strcpy(config.logfile, getstring(PATH_LEN));
      } else if (its("badfiles")) {
	(void) strcpy(config.badfiles, getstring(PATH_LEN));
      } else if (its("badarticles")) {
	(void) strcpy(config.badarticles, getstring(PATH_LEN));
      } else if (its("nodelist")) {
	(void) strcpy(config.nodelist, getstring(PATH_LEN));
      } else if (its("nodelist-index")) {
	(void) strcpy(config.nodelist_index, getstring(PATH_LEN));
      } else if (its("nodelist-name-index")) {
	(void) strcpy(config.nodelist_name_index, getstring(PATH_LEN));
      } else if (its("sequence")) {
	(void) strcpy(config.sequence, getstring(PATH_LEN));
      } else if (its("idsequence")) {
	(void) strcpy(config.idsequence, getstring(PATH_LEN));
      } else if (its("ipacketsequence")) {
	(void) strcpy(config.ipacketsequence, getstring(PATH_LEN));
      } else if (its("opacketsequence")) {
	(void) strcpy(config.opacketsequence, getstring(PATH_LEN));
      } else if (its("badsequence")) {
	(void) strcpy(config.badsequence, getstring(PATH_LEN));
      }	else if (its("firstuseruid")) {
	config.useruid = getint();
      } else if (its("alias")) {
	(void) strcpy(config.alias, getstring(PATH_LEN));
      } else if (its("rmail")) {
	(void) strcpy(config.rmail, getstring(PATH_LEN));
      } else if (its("return-failed-mail")) {
	config.return_failed_mail = gettruth();
      } else if (its("dial")) {
	config.dials = 0;
	for (p = strtok(NULL, SEPARATORS); p; p = strtok(NULL, SEPARATORS)) {
	  if (config.dials >= DIALS) {
	    log("Dial table overflow, max %d lines", DIALS);
	    exit(EX_DATAERR);
	  }
	  if (!strcmp(p, "\"\"")) *p = 0;
	  if (!strcmp(p, "''")) *p = 0;
	  if (strlen(p) >= DIALSTRING_LEN) {
	    log("Too long dial string %s", p);
	    exit(EX_DATAERR);
	  }
	  (void) strcpy(config.dialtable[config.dials], p);
	  config.dials++;
	}

	if (config.dials & 1) {
	  log("Dial table must have pairs of strings, %d found", config.dials);
	  exit(EX_DATAERR);
	}
      } else if (its("newsgroups")) {
	config.newsgroups = 0;
	while (localfgets(buffer, BUFSIZ, configfp)) {
	  configline++;

	  if (config.newsgroups >= MAX_NEWSGROUPS) {
	    log("Too many newsgroups, %d max", MAX_NEWSGROUPS);
	    exit(EX_DATAERR);
	  }

	  /* '#' is a comment */

	  if (*buffer == '#') continue;
	  
	  /* '*' means end of groups */
	  
	  if (*buffer == '*') break;

	  /* Get echo name */
	  
	  if (p = strtok(buffer, SEPARATORS)) {
	    if (strlen(p) >= MAX_ECHOLEN) {
	      log("Too long echo %s", p);
	      exit(EX_DATAERR);
	    }

	    (void) strcpy(config.ng[config.newsgroups].echo, p);

	    /* Get newsgroup name */
	    
	    if (p = strtok(NULL, SEPARATORS)) {
	      if (strlen(p) >= MAX_NGLEN) {
		log("Too long newsgroup %s", p);
		exit(EX_DATAERR);
	      }

	      (void) strcpy(config.ng[config.newsgroups].ng, p);

	      /* Get distribution */
	      
	      if (p = strtok(NULL, SEPARATORS)) {

		if (strlen(p) >= MAX_DISTRIBUTION_LEN) {
		  log("Too long distribution %s", p);
		  exit(EX_DATAERR);
		}

		(void) strcpy(config.ng[config.newsgroups].distribution, p);

		/* Get flags and parse them */

		config.ng[config.newsgroups].acceptprivate = FALSE;
		config.ng[config.newsgroups].trashprivate = FALSE;
		*config.ng[config.newsgroups].command = 0;

		while (p = strtok(NULL, SEPARATORS)) {
		  if (its("accept-private")) {
		    config.ng[config.newsgroups].acceptprivate = TRUE;
		  } else if (its("command")) {

		    /* Rest of the line should be the command to be executed */
		    
		    p = strtok(NULL, "");

		    if (!p) {
		      log("No command at config line %d ?", configline);
		      exit(EX_DATAERR);
		    }
		    if (strlen(p) >= MAX_COMMAND_LEN) {
		      log("Too long command %s at config line %d",
			  p, configline);
		      exit(EX_DATAERR);
		    }

		    (void) strcpy(config.ng[config.newsgroups].command, p);
		  } else if (its("trash-private")) {
		    config.ng[config.newsgroups].trashprivate = TRUE;
		  } else {
		    log("Bad flag '%s' for newsgroup %s, line %d", p,
			configline);
		  }
		} /* while more flags */
	      } else {
		log("No distribution for %s at config line %d",
		    config.ng[config.newsgroups].ng, configline);
		exit(EX_DATAERR);
	      }
	    } else {
	      log("No newsgroup name for %s at config line %d",
		  config.ng[config.newsgroups].echo, configline);
	      exit(EX_DATAERR);
	    }
	  } else {
	    log("No echo name at config line %d", configline);
	    exit(EX_DATAERR);
	  }

	  config.newsgroups++;
	  
	} /* While more newsgroups */
      } else if (its("headers")) {
       	config.headers = 0;
	while (localfgets(buffer, BUFSIZ, configfp)) {
	  configline++;

	  /* '#' is a comment */

	  if (*buffer == '#') continue;
	  
	  /* '*' means end of headers */
	  
	  if (*buffer == '*') break;

	  (void) strcpy(config.header[config.headers++], buffer);
	} /* While more headers */
      } else if (its("seenbys")) {
	config.seenbys = 2;
	if (!config.mynode.net || !config.echofeed.net) {
	  log("Node or echofeed must be set before seenbys");
	  exit(EX_DATAERR);
	}
	config.seenby[0] = config.mynode;
	config.seenby[1] = config.echofeed;

	while (localfgets(buffer, BUFSIZ, configfp)) {
	  configline++;

	  /* '#' is a comment */

	  if (*buffer == '#') continue;

	  /* '*' means end of seenbys */

	  if (*buffer == '*') break;
	  
	  if (parsefnetaddress(p = getrestofline(),
			       &config.seenby[config.seenbys++])) {
	    log("Cannot parse fidonet address %s", p);
	    exit(EX_DATAERR);
	  }
	}
	qsort( (char *) config.seenby, (unsigned) config.seenbys,
	      sizeof(Node), cmpnode);
      } else if (its("akas")) {
	config.akas = 0;

	while (localfgets(buffer, BUFSIZ, configfp)) {
	  configline++;

	  /* '#' is a comment */

	  if (*buffer == '#') continue;

	  /* '*' means end of akas */

	  if (*buffer == '*') break;
	  
	  if (parsefnetaddress(p = getrestofline(),
			       &config.aka[config.akas++])) {
	    log("Cannot parse fidonet address %s", p);
	    exit(EX_DATAERR);
	  }
	}
	qsort( (char *) config.aka, (unsigned) config.akas,
	      sizeof(Node), cmpnode);
      } else if (its("origin")) {
	(void) strcpy(config.origin, getrestofline(ORIGIN_LEN));
      } else if (its("out-tty")) {
	(void) strcpy(config.outtty, getrestofline(PATH_LEN));
      } else if (its("nocheck")) {
	config.nocheck = gettruth();
      } else if (its("use-internal-dial")) {
	config.use_internal_dial = gettruth();
      } else if (its("dial-modem-delay")) {
	config.dial_modem_delay = getint();
      } else if (its("dial-retries")) {
	config.dial_retries = getint();
      } else if (its("dial-initstring")) {
	strcpy(config.dial_initstring, getstring(PATH_LEN));
      } else if (its("dial-initreply")) {
	strcpy(config.dial_initreply, getstring(PATH_LEN));
      } else if (its("dial-inittimeout")) {
	config.dial_inittimeout = getint();
      } else if (its("dial-prefix")) {
	strcpy(config.dial_prefix, getstring(PATH_LEN));
      } else if (its("dial-trailer")) {
	strcpy(config.dial_trailer, getstring(PATH_LEN));
      } else if (its("dial-connect")) {
	strcpy(config.dial_connect, getstring(PATH_LEN));
      } else if (its("dial-timeout")) {
	config.dial_timeout = getint();
      } else if (its("lockdir")) {
	strcpy(config.lockdir, getstring(PATH_LEN));
      } else if (its("locks")) {
	strcpy(config.locks, getstring(PATH_LEN));
	if (!*config.lockdir) {
	  if (!strcmp(config.locks, "bsd") || !strcmp(config.locks, "old")) {
	    strcpy(config.lockdir, "/usr/spool/uucp");
	  } else if (!strcmp(config.locks, "hdb")) {
	    strcpy(config.lockdir, "/usr/spool/locks");
	  } else {
	    log("Unknown lock type %s", config.locks);
	  }
	}
      } else if (its("lock-timeout")) {
	config.lock_timeout = getint();
      } else {
	log("Unknown config parameter %s", p);
      } /* End switch (nested if) config parameter */
    } /* More config lines */

    (void) fclose(configfp);
  } else {
    log("$Cannot open config file %s", CONFIGFILE);
  }

  if (verbose > 10) {
    debug(10, "Debuglevel %d", config.debuglevel);
    debug(10, "My node %s", ascnode(config.mynode));
    debug(10, "Echofeed %s", ascnode(config.echofeed));
    debug(10, "Insert rfc received header %d", config.rfc_received_header);
    debug(10, "Wait after connecting %d", config.prewait);
    debug(10, "Wait for input to clear %d", config.waitclear);
    debug(10, "Maximum xmodem send retries %d", config.max_send_retries);
    debug(10, "Maximum baud rate %d", config.maxbaud);
    debug(10, "Minimum baud rate %d", config.minbaud);
    debug(10, "Receive path %s", config.receive_path);
    debug(10, "Domain %s", config.domain);
    debug(10, "Spool %s", config.spool);
    debug(10, "Unpacked %s", config.unpacked);
    debug(10, "Sentbundles %s", config.sentbundles);
    debug(10, "Libdir %s", config.libdir);
    debug(10, "Rnews %s", config.rnews);
    debug(10, "Logfile %s", config.logfile);
    debug(10, "Orphans %s", config.orphans);
    debug(10, "Badarticles %s", config.badarticles);
    debug(10, "sequence %s", config.sequence);
    debug(10, "idsequence %s", config.idsequence);
    debug(10, "ipacketsequence %s", config.ipacketsequence);
    debug(10, "opacketsequence %s", config.opacketsequence);
    debug(10, "badsequence %s", config.badsequence);
    debug(10, "Lowest user id %d", config.useruid);
    debug(10, "Aliases %s", config.alias);
    debug(10, "Rmail %s", config.rmail);
    debug(10, "Return failed mail %d", config.return_failed_mail);
    for (count = 0; count < config.dials; count += 2) {
      debug(10, "Dialtable: '%s' -> '%s'", config.dialtable[count],
	    config.dialtable[count + 1]);
    }
    for (count = 0; count < config.newsgroups; count++) {
      debug(10, "Echo %s Ng %s Dist %s AP %d TP %d Cmd '%s'",
	    config.ng[count].echo, config.ng[count].ng,
	    config.ng[count].distribution, config.ng[count].acceptprivate,
	    config.ng[count].trashprivate, config.ng[count].command);
    }
    debug(10, "Seenby '%s'", config.seenby);
  }
}

/* Reads configuration, recompiling it if necessary */

get_configuration()
{
  struct stat binstat, configstat;
  char configname[BUFSIZ], *p;
  int recompile = FALSE;

  (void) strcpy(configname, CONFIGFILE);
  (void) strcat(configname, ".bin");
  
  if (stat(CONFIGFILE, &configstat) == -1) {
    log("$Could not get config file status");
    exit(EX_OSFILE);
  }

  if (stat(configname, &binstat) == -1) {
    if (errno != ENOENT) {
      log("$Could not get binary config file status");
      exit(EX_OSFILE);
    } else {
      recompile = TRUE;
    }
  } else {
    if (binstat.st_mtime <= configstat.st_mtime) {
      recompile = TRUE;
    }
  }

  if (recompile) {

    /* Get configuration information into config structure */
    
    read_configuration();
    
    /* Write it to binary configuration file */
    
    (void) write_file( (char *) &config, configname, sizeof(config));
  } else {

    p = NULL;
    if (read_file( (char **) &p, configname) != sizeof(config)) {
      log("%s is not size of config structure");
      exit(EX_OSFILE);
    }
    (void) memcpy( (char *) &config, p, sizeof(config));
    free(p); /* read_file mallocated it! */
  }

  verbose = config.debuglevel;
}
