/* @(#)%M%  %I%  Teemu Torma %H%

   Structures and definitions for nodelist.

   @(#)Copyright (c) 1987 by Teemu Torma
 
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* Change these if you wish. */

/* Name of nodelist in LIBDIR */
#define NODELIST "nodelist"

/* Name of nodelist index file in LIBDIR */
#define INODELIST "nodelist.idx"

/* Structure for nodelist entry. Routines to get one node from nodelist
   will return this structure. */

typedef struct _node {
  int type; /* type of entry (see below) */
  int net; /* net/region of node */
  int node; /* number of node */
  char name[20]; /* name of fido */
  char city[40]; /* city */
  char sysop[36]; /* name of sysop */
  char phone[40]; /* phone-number */
  int speed; /* speeds */
  char flags[60]; /* flags-string */
} Node;

/* Entry types. */

#define REGION (1) /* region-host */
#define HOST (2) /* net-host */
#define HUB (3) /* local-host */
#define PVT (4) /* private node */
#define HOLD (5) /* no mail to this node */
#define DOWN (6) /* node is down */
#define KENL (7) /* should not be comminucated */
#define NORMAL (8) /* normal node */

/* Declarations for routines. */

Node *node_entry(); /* get entry from nodelist */
char *update_index(); /* update index-file */
