#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif lint

/* Unpaketize fido-mail packets and send mail to reciver or send it to
   news-server.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <ndir.h>
#include "config.h"
#include "fnet.h"
#include "fpack.h"
#include "nodelist.h"
#include "sysexits.h"

#define MAXARGS (32) /* maximum number of arguments */

extern time_t time();
extern char *tzname[];
extern int getopt();
extern int optind;
extern char *optarg;
extern void exit(), perror(), free();
extern char *malloc();
extern time_t dateconv();
extern void swab();

int verbose = 0;
char *version = "%I%";

/* Test if string is totally numeric. */

bool
numeric(s)
     register char *s;
{
  while (*s)
    if (!isdigit(*s++))
      return False;
  return True;
}

/* Return msdos interger as machine integer */

int
int16(msint)
     INT16 msint;
{
  INT16 value;
  
#ifdef SWAB_BYTES
  swab((char *) &msint, (char *) &value, 2);
#else !SWAB_BYTES
  value = msint;
#endif !SWAB_BYTES
  return (int) value;
}

/* Replacement for fgets(3S) to understand cr's generated by Fido
   and 'soft' cr's generated by SEAdog. It return EOF if text is over,
   ie. 0 is got from file. */

static char *
fgets(buffer, maxlen, fp)
     char *buffer;
     int maxlen;
     FILE *fp;
{
  register int c, c1;
  register char *cp;
  
  cp = buffer;
  while (--maxlen > 0 && (c = getc(fp)) != EOF && c)
    {
      if (c == '\r')
        {
          /* cr followed by lf, ignore cr */
          if ((c1 = getc(fp)) == '\n')
            c = '\n';
          else
            (void) ungetc(c1, fp);
        }
      else
        if (c == 0x8d)
          {
            /* ignore SEAdog soft cr's */
            c = '\n';
            if ((c1 = getc(fp)) != '\n')
              (void) ungetc(c1, fp);
          }
      *cp++ = c;
      if (c == '\n')
        break;
    }
  
  /* if we got nul, put it back if occurred in the middle of line */
  if (!c && cp != buffer)
    (void) ungetc(0, fp);
  
  *cp = 0;
  return ((!c || c == EOF) && cp == buffer) ? (char *) 0 : buffer;
}

/* Execute sender of fido-message. Argument will be program name, anrgument
   for that and pid to return. */

FILE *
open_sender(program, args, pid)
     char *program, **args;
     int *pid;
{
  FILE *fp;
  int fd[2];
  
  if (pipe(fd) == -1)
    {
      perror("funpack: pipe");
      return (FILE *) 0;
    }
  
  switch (*pid = fork())
    {
    case -1:
      perror("funpack: fork failed");
      return (FILE *) 0;
    case 0:
      (void) close(0);
      if (dup(fd[0]) == 0)
        {
          (void) close(fd[0]);
          (void) close(fd[1]);
          if (args)
            (void) execvp(program, args);
          else
            (void) execlp(program, basename(program), (char *) 0);
          perror(program);
        }
      else
        perror("funpack: dup");
      exit(EX_OSERR);
    default:
      (void) close(fd[0]);
      if ((fp = fdopen(fd[1], "w")) == NULL)
        {
          perror("funpack: fdopen");
          return (FILE *) 0;
        }
    }
  return fp;
}

/* Return int from file. Int in file is supposed to be 16 bit ms-dos
   integer. */

int
read_int(fp)
     FILE *fp;
{
  INT16 value;
  
  if (fread((char *) &value, 2, 1, fp) != 1)
    value = 0;
  return int16(value);
}

/* Read null-terminated string from file. Ensure that buffer is also
   null-terminated. */

void
get_string(buffer, fp, nbytes)
     char *buffer;
     FILE *fp;
     int nbytes;
{
  register int n;
  
  for (n = 0, *buffer = 0; n < nbytes; n++)
    if ((buffer[n] = getc(fp)) == 0)
      break;
  buffer[nbytes] = 0;
}

/* Check if message is news-message (currenlty: if first line begins
   with AREA:). If area is found, we'll return name for that area,
   otherwise NULL. */

char *
news_msg(fp)
     FILE *fp;
{
  long offset = ftell(fp);
  char *cp;
  static char area[64];
  
  if (fgets(area, 64, fp) && !strncmp(area, "AREA:", 5))
    {
      /* this is echomail-message */
      area[strlen(area) - 1] = 0;
      
      /* strip possible spaces */
      for (cp = area + 5; *cp && isspace(*cp); cp++);
      
      /* return area-name */
      return cp;
    }
  else
    {
      /* this is not echomail message, seek back */
      (void) fseek(fp, offset, 0);
      return (char *) 0;
    }
  /* NOTREACHED */
}

/* Return date of message. Date will be read and converted to one
   long-interger as normal Unix-time will be.
   
   Both SEAdog and Fido date formats are understood.
   SEAgod: Mon 1 Jan 86 02:34
   Fido:   01 Jan 86 02:34:56 */

time_t
getdate(packet)
     FILE *packet;
{
  char buffer[20], month[4];
  int mm, dd, yy, h, m, s = 0;
  time_t msg_date;
  int n;
  
  /* literal months */
  static char *months[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
    (char *) 0,
  };
  
  /* read date from packet */
  for (n = 0; n < 20; n++)
    buffer[n] = getc(packet);
  buffer[19] = 0;
  
  /* try to get date */
  if (sscanf(buffer, "%2d %3s %2d %02d:%02d:%02d",
             &dd, month, &yy, &h, &m, &s) == 6 ||
      sscanf(buffer, "%*3s %2d %3s %2d %02d:%02d",
             &dd, month, &yy, &h, &m) == 5)
    {
      /* we found correct date, try to get number of month */
      for (n = 0; months[n]; n++)
        if (!strncmp(month, months[n], 3))
          {
            /* got month, now return result */
            mm = n + 1;
            if ((msg_date = dateconv(mm, dd, yy, h, m, s, 24,
                                     timezone / 60l, False)) == -1l)
              return time((long *) 0);
            else
              return msg_date;
          }
    }
  
  /* somthing went wrong, return currect date */
  return time((long *) 0);
}

/* Unpack packet and all files in it. Packet's header will be stripped
   off. For each message check if it is news-msg (First line begins
   with AREA:). If it is, send it to news-sender sfnews, otherwise
   send it to rmail. Address is given in to-field, or if it wont
   fit to it, in the first line of message. In later case to-field
   must be "Usenet". */

void
unpack(packet, packet_net, packet_node)
     FILE *packet;
     int packet_net, packet_node;
{
  int net, node, orignet, orignode;
  char to[36], from[36], subject[72];
  char *args[MAXARGS];
  
  char buffer[BUFSIZ], *cp;
  FILE *sender;
  int n, pid, stat_loc, c;
  long msgid;
  Node *entry;
  char hostname[10];
  time_t msg_date;
  char *area;
  
  /* get node-entry fo packet-sender */
  if (node_entry(packet_net, packet_node) == NULL)
    {
      log("Unknown packet sender: %d/%d", packet_net, packet_node);
      return;
    }

  if ((entry = node_entry(NET, NODE)) == NULL)
    {
      log("Unable to find this net/node from nodelist");
      return;
    }
  
  /* get our uucp-nodename */
  if (gethostname(hostname, 10) == -1)
    {
      log("$Unable to get hostname");
      return;
    }
  
  while (read_int(packet) == MSGTYPE)
    {
      *args = NULL;
      
      /* get nodes information about message */
      orignode = read_int(packet);
      node = read_int(packet);
      
      /* get nodes from message */
      orignet = read_int(packet);
      net = read_int(packet);
      
      debug(2, "Original net/node = %d/%d", orignet, orignode);
      debug(2, "Destination net/node = %d/%d", net, node);
      
      /* we're not interested about attributes currenty */
      (void) read_int(packet);
      
      /* through away cost */
      (void) read_int(packet);
      
      /* get date */
      msg_date = getdate(packet);
      
      /* get receiver of message */
      get_string(to, packet, 35);
      debug(2, "Msg is to '%s'", to);
      
      /* get sender of message */
      get_string(from, packet, 35);
      debug(2, "Msg is from '%s'", from);
      
      /* get subject */
      get_string(subject, packet, 71);
      debug(2, "Subject is '%s'", subject);
      
      /* check that message is to this node */
      if (net != NET || node != NODE)
        {
          log("Msg from %s to %s at %d/%d: wrong net/node",from,to,net,node);
          goto error;
        }
      
      /* check is this is news-message */
      if (area = news_msg(packet))
        {
          /* This is news-artcile. Open sendfidonews and give area name as
             argument to it. Input of sfnews will be just like input
             of mail. */
          
          debug(1, "Message is news-article");
          
          /* create args for sender */
          *args = malloc(sizeof(LIBDIR) + 8);
          (void) sprintf(*args, "%s/sfnews", LIBDIR);
          args[1] = strsave(area);
          args[2] = NULL;
          
          /* open sender */
          if ((sender = open_sender(*args, args, &pid)) == NULL)
            {
              log("Can not execute %s", *args);
              goto error;
            }
        }
      else
        {
          debug(1, "Message is for mail");
          
          /* If message receiver is Usenet, then receiver of mail will
             be at first-line of message separated by commands/spaces.
             If receiver is not usenet, mail will be sent to normal
             receiver, but in this case all charactes will be converted
             to lower case (Fido changes them, you know). */
          
          if (!strcmp(to, "Usenet"))
            {
              if (fgets(buffer, BUFSIZ, packet) == NULL)
                {
                  log("Missing receiver in msg from %s at %d/%d", from,
                      orignet, orignode);
                  goto error;
                }
              buffer[strlen(buffer) - 1] = 0;
            }
          else
            {
              (void) strcpy(buffer, to);
              for (n = 0; buffer[n]; n++)
                buffer[n] = tolower(buffer[n]);
            }
          
          *args = strsave(basename(RMAIL));
          for (n = 1, cp = strtok(buffer, ", \t"); cp && n < MAXARGS;
               cp = strtok((char *) 0, ", \t"), n++)
            args[n] = strsave(cp);
          args[n] = NULL;
          
          for (n = 1; args[n]; n++)
            log("Sending mail from %s at %d/%d to %s", from, orignet,
                orignode, args[n]);
          
          /* open rmail for sending message */
          if ((sender = open_sender(RMAIL, args, &pid)) == NULL)
            {
              log("Can not execute %s", RMAIL);
              goto error;
            }
        }
      
      /* change all spaces in name to _'s */
      for (n = 0; from[n]; n++)
        if (from[n] == ' ')
          from[n] = '_';
      
      /* set From_ line */
      (void) fprintf(sender, "From %d!%s %s remote from %d\n", orignode,
                     from, date("%a %h %d %T 19%y", (long *) 0), orignet);
      
      /* Now generate valid RFC 822 header for mail. Some fields may
         be different, in all places there may be comments between (
         and )-charactes. */
      
      /* print Received: field */
      (void) fprintf(sender, "Received: by %d.%d.fidonet (funpack%s/%s)\n",
                     entry->node, entry->net, version, entry->name);
      (void) fprintf(sender, "\tid AA%05d; %s\n",
                     getpid(), date("%a, %d %h %y %T %o (%z)", (long *) 0));

      /* print Date: field */
      (void) fprintf(sender, "Date: %s\n", date("%a, %d %h %y %T %o",
                                                &msg_date));
      
      /* print From: field */
      (void) fprintf(sender, "From: %s@%d.%d.fidonet\n", from, orignode,
                     orignet);
      
      /* print Subject: field */
      (void) fprintf(sender, "Subject: %s\n", subject);
      
      /* print Message-Id: field */
      (void) fprintf(sender, "Message-Id: <%s.AA%05d@%d.%d.fidonet>\n",
                     date("%y%m%q%H%M", (long *) 0), getpid(), entry->node,
                     entry->net);
      
      /* print To: field */
      (void) fprintf(sender, "To: ");
      for (n = 1; args[n]; n++)
        {
          (void) fprintf(sender, "%s", args[n]);
          if (args[n + 1])
            (void) fprintf(sender, ", ");
        }
      (void) putc('\n', sender);
      
      /* print Reply-To: field */
      (void) fprintf(sender, "Reply-To: %s\n", buffer);
      
      /* done with header, now send message text */
      
      (void) putc('\n', sender);
      while (fgets(buffer, BUFSIZ, packet))
        (void) fputs(buffer, sender);
      
      /* done with this msg, wait process to finish */
      (void) fclose(sender);
      while ((n = wait(&stat_loc)) != pid && n != -1);
      
      debug(2, "Wait status: %o", stat_loc);
      debug(1, "Done with message");
      
      /* free argument-list */
      for (n = 0; args[n]; n++)
        free(args[n]);
      continue;
      
      /* in the case of error skip text of message */
    error:
      while ((c = getc(packet)) && c != EOF);
      
      /* free argument-list */
      for (n = 0; args[n]; n++)
        free(args[n]);
    }
  
  debug(1, "Done with packet");
}

/* ARGSUSED */
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  struct direct *dir;
  DIR *dp;
  int c;
  Packet header;
  FILE *packet;
  char files[BUFLEN];
  int net = -1, node = -1;
  bool nocheck = False;
  char *error;
  
  while ((c = getopt(argc, argv, "in:vV:")) != EOF)
    switch (c)
      {
      case 'V':
        version = optarg;
        break;
      case 'i':
        nocheck = True;
        break;
      case 'v':
        verbose++;
        break;
      case 'n':
        if (numeric(optarg))
          {
            net = atoi(optarg);
            if (optind < argc)
              if (numeric(argv[optind]))
                node = atoi(argv[optind++]);
              else
                {
                  log("Non-numeric node");
                  exit(1);
                }
            else
              {
                log("Missing node");
                exit(1);
              }
          }
        else
          {
            log("Non-numeric net");
            exit(1);
          }
        break;
      default:
        (void) fprintf(stderr, "Usage: %s [-v] [-n <net> <node>]\n",
                       *argv);
        exit(EX_USAGE);
      }
  
  /* create name for unpacking */
  if (net == -1 || node == -1)
    (void) strcpy(files, "I.");
  else
    (void) sprintf(files, "I.%d-%d", net, node);
  
  debug(2, "Unpacking packets beginning with %s", files);
  
  if (chdir(SPOOL) == -1)
    {
      log("$Cannot chdir to %s", SPOOL);
      exit(EX_OSERR);
    };
  
  /* try to update nodelist-index */
  if (error = update_index())
    {
      if (*error == '$')
        log("$Cannot update nodelist-index: %s", error + 1);
      else
        log("Cannot update nodelist-index: %s", error);
      exit(EX_OSERR);
    }
  
  if (dp = opendir("."))
    {
      while (dir = readdir(dp))
        if (!strncmp(dir->d_name, files, strlen(files)))
          {
            
            /* this packet is right */
            debug(1, "Unpacking %s", dir->d_name);
            
            /* open packet */
            if (packet = fopen(dir->d_name, "r"))
              {
                if (fread((char *) &header, sizeof(Packet), 1, packet)
                    != 1)
                  log("Missing packet header");
                else
                  if (nocheck || (int16(header.dest_node) == NODE &&
                                  int16(header.dest_net) == NET))
                    unpack(packet, int16(header.orig_net),
                           int16(header.orig_node));
                  else
                    log("Packet is to %d/%d",
                        int16(header.dest_net),
                        int16(header.dest_node));
                (void) fclose(packet);
              }
            else
              log("$Unable open packet %s", dir->d_name);
          }
      (void) closedir(dp);
    }
  else
    {
      log("$Unable to open spool directory");
      exit(EX_OSERR);
    }
  exit(EX_OK);
  /* NOTREACHED */
}
