#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif lint

/* Routines for io for fidonet software.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <signal.h>
#include <termio.h>
#include <sys/types.h>
#include "fnet.h"
#include "fio.h"

/* number of characters in input buffer */
int nchars = 0;

/* Signal trapper for readline. */

static int
trap(sig)
     int sig;
{
  (void) signal(sig, trap);
  return 0;
}

/* Read one character from line. We will do buffering up to BUFBIZ
   characters. TIMEOUT will be returned it readline timeouts */

int
readline(timeout)
     int timeout;
{
  int c;
  static unsigned char buffer[BUFSIZ];
  static int pos = 0;
  int (*alrm)();
  
  if (pos < nchars)
    /* there are characters in buffer */
    c = buffer[pos++];
  else
    {
      /* trap alarm signals and set timeout value */
      alrm = signal(SIGALRM, trap);
      (void) alarm((unsigned) timeout);
      
      /* read characters */
      nchars = read(line, (char *) buffer, BUFSIZ);
      debug(10, "Read returned %d", nchars);
      
      /* turn off alarm and return function value */
      (void) alarm((unsigned) 0);
      (void) signal(SIGALRM, alrm);
      
      /* if we got characters return first of them, otherwise return
         TIMEOUT */
      
      if (nchars <= 0)
        c = TIMEOUT;
      else
        c = buffer[pos = 0];
    }
  
  debug(8, "Readline returns %02x", c);
  return c;
}

/* Flush line. Both terminal buffers and input buffer of readline will
   be flushed */

void
flush()
{
  (void) ioctl(line, TCFLSH, 0);
  nchars = 0;
}

/* Send character c to line. This also clears readline's input buffer
   but not terminal buffers because it might takes too much time */

void
sendline(c)
     int c;
{
  unsigned char cc = (c & 0377);
  
  debug(8, "Sendline sends %02x", cc);
  (void) write(line, (char *) &cc, 1);
  nchars = 0;
}
