#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Convert date to type time_t (time in seconds since 1 Jan 1970).
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* LINTLIBRARY */

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include "fnet.h"

#define epoch 1970
#define daysec (24l * 60l * 60l)
#define AM 1
#define PM 2

/* days in each month */
static int mdays[12] = {
  31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31,
};

/* Convert hours, minutes and seconds to seconds */

time_t
timeconv(hh, mm, ss, mer)
     int hh, mm, ss;
     int mer;
{
  /* check correctness of time */
  if (mm < 0 || mm > 59 || ss < 0 || ss > 59)
    return (time_t) -1;
  
  /* count time */
  switch (mer)
    {
    case AM:
      if (hh < 1 || hh > 12)
        return(time_t) 1;
      return (60L * ((hh % 12) * 60L + mm) + ss);
    case PM:
      if (hh < 1 || hh > 12)
        return(time_t) 1;
      return (60L * ((hh % 12 +12) * 60L + mm) + ss);
    case 24:
      if (hh < 0 || hh > 23)
        return (time_t) 1;
      return (60L * (hh * 60L + mm) + ss);
    default:
      return (time_t) 1;
    }
  /* NOTREACHED */
}

/* Convert date to seconds from beginning of year 1970 (normal Unix
   time). Return -1 if something wen't wrong. */

/* ARGSUSED */
time_t
dateconv(mm, dd, yy, h, m, s, mer, zone, dayflag)
     int mm, dd, yy, h, m, s;
     int mer, zone;
{
  time_t tod, jdate;
  register int n;
  
  /* if negative year make it positive */
  if (yy < 0)
    yy = -yy;
  
  /* if year is 00..99 make it right */
  if (yy < 100)
    yy += 1900;
  
  /* count days for february */
  mdays[1] = 28 + (yy % 4 == 0 && (yy % 100 != 0 || yy % 400 == 0));
  
  /* check correctess of date (year 1970..1999) */
  if (yy < epoch || yy > 1999 || mm < 1 || mm > 12 || dd < 1 ||
      dd > mdays[--mm])
    return (time_t) -1;
  
  /* counts days from beginning of year */
  jdate = (time_t ) (dd - 1);
  for (n = 0; n < mm; n++)
    jdate += (time_t) mdays[n];
  
  /* add years to days */
  for (n = epoch; n < yy; n++)
    jdate += (time_t) (365 + (n % 4 == 0));
  
  /* convert days to seconds */
  jdate *= daysec;
  
  /* add time of day */
  if ((tod = timeconv(h, m, s, mer)) < 0)
    return (time_t) -1;
  jdate += tod;
  
  /* add time zone to date */
  jdate += (time_t) zone * 60L;
  
  return jdate;
}
