#ifndef lint
static	char	*sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif  lint

/* Routines to handle fidonet addresses. Currently addres format in outside
   fidonet is <name>@<node>.<net>.fidonet. This will propablty change when
   zones are coming. Those standards are ready, but I haven't seen them
   yet.
   
   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* LINTLIBRARY */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "fnet.h"


/* Parse fidonet address to name, net and node. Address contains address,
   and name, net and node will be returned. Return NULL is it was valid
   fidonet address, otherwise string to error message. */

char *
parse_address(address, name, net, node)
     char *address, *name;
     int *net, *node;
{
  static char error[64];
  register char *cp;
  register int cnt;

  /* make address to lowercase */
  for (cp = address; *cp; cp++)
    if (isupper(*cp))
      *cp = tolower(*cp);

  /* Get name. We assume that name has space at least 36 charcers (maximum
     length of name in fido). First check wheather format is name@domain
     of domain!name format. */
  if ((cp = strchr(address, '!')) != NULL)
    {
      debug(2, "Fidonet address domain!name");
      for (cp++, cnt = 0; *cp && cnt < 35; cnt++, cp++)
        name[cnt] = *cp;
      name[cnt] = 0;
      cp = address;
      debug(3, "Name %s", name);
    }
  else
    {
      debug(2, "Fidonet address name@domain");
      for (cp = address, cnt = 0; *cp && cnt < 35 && *cp != '@'; cp++, cnt++)
        name[cnt] = *cp;
      name[cnt] = 0;
      debug(3, "Name %s", name);

      if (*cp != '@')
        {
          /* name is too long or address is invalid */
          while (*cp && *cp != '@')
            cp++;
          if (*cp == 0)
            {
              debug(1, "Invalid address: %s: missing @", address);
              (void) sprintf(error, "No @ in address %s", address);
              return error;
            }
        }
      cp++;
    }

  debug(2, "Address %s, up to '!' or end", cp);

  /* now parse address, cp points to beginning of it. */
  for (*node = 0; isdigit(*cp); cp++)
    *node = 10 * *node + *cp - '0';
  if (*cp != '.')
    {
      debug(1, "Invalid address: %s: no . after node", address);
      debug(2, "Rest of address %s, node %d", cp, *node);
      (void) sprintf(error, "No net number in address %s", address);
      return error;
    }

  /* get net */
  for (cp++, *net = 0; isdigit(*cp); cp++)
    *net = 10 * *net + *cp - '0';
  if (*cp != '.')
    {
      debug(1, "Invalid address: %s: no . after net", address);
      debug(2, "Rest of address %s, net/node %d/%d", *net, *node);
      (void) sprintf(error, "No domain in address %s", address);
      return error;
    }

  cp++;
  debug(3, "Domain %s", cp);
  
  /* check that .fidonet is present */
  if (strncmp(cp, "fidonet", 7) || (cp[7] != 0 && cp[7] != '!'))
    {
      debug(1, "Invalid address: %s: not .fidonet domain", address);
      (void) sprintf(error, "Domain is not .fidonet in address %s", address);
      return error;
    }

  /* we're done */
  return NULL;
}
