; Function cputype(), for real OR protected mode.  Returns (in AX)
; the value 0 (86), 20 (186), 30 (286), 40 (386);  negative if protected mode.

		.286p			;enable protected-mode instructions
_text		segment byte public 'code'	; use Microsoft C names
		assume	cs:_text
		public	_cputype
_cputype	proc 	far
		push	bp
		push	sp		;86/186 will push SP-2,
		pop	ax		;286/386 will push SP
		cmp	ax,sp
		jz	not86		;if equal, SP was pushed
		mov	ax,10		;is it 86 or 186
		mov	cl,32		;186 uses count mod32 = 0
		shl	ax,cl		;86 shifts 32 so ax = 0
		jnz	exit		;non-zero: no shift, so 186
		mov	ax,20		;zero: shifted out all bits
		jmp	exit
not86:		pushf			;Test 16 or 23 operand size:
		mov	ax,sp		;pushed 2 or 4 bytes flags?
		popf			;restore SP
		inc	ax		;restore AX by 2 bytes
		inc	ax
		cmp	ax,sp		;did pushf change SP by 2?
		jnz	is32bit		;if not, then 4 bytes of flags
	
is16bit:	sub	sp,6		;Is it 286 or 386 in 16-bit mode?
		mov	bp,sp		;allocate space for GDT ptr
		sgdt	qword ptr [bp]	;(use PWORD PTR for MASM5)
		add	sp,4		;discard 2 words of GDT pointer
		pop	ax		;get third word
		inc	ah		;286 stores -1, 386 0 or 1
		jnz	is386

is286:		mov	ax,30		;set return value
		jmp	testprot
is32bit:	db	66H		;16-bit override in 32-bit mode
is386:		mov	ax,40
testprot:	smsw	cx		;Protected? Machine status -> CX
		ror	cx,1		;protection bit -> carry flag
		jnc	exit		;real mode if no carry
		neg	ax		;protected: return neg value
exit:		pop	bp
		ret
_cputype	endp
_text		ends
		end
