static char rcsid[] = "$Header: d_optable.c,v 1.1 89/03/03 12:53:23 np Exp $";
/* $Log:	d_optable.c,v $
 * Revision 1.1  89/03/03  12:53:23  np
 * Initial revision
 * 
 */

/*
 * Copyright (C) 1985-1989 Nigel Perry
 *
 * This program is distributed without any warranty.
 * The author and and distributors accept no resposibility
 * to anyone for the consequence of using this program or
 * whether it serves any particular purpose or works at all,
 * unless they say so in writing.
 *
 * Everyone is granted permission to copy, modify and
 * redistribute this program, but only provided that:
 *
 * 1) They do so without financial or material gain.
 *
 * 2) The copyright notice and this notice are preserved on
 *    all copies.
 *
 * 3) The original source is preserved in any redistribution.
 *
 * I hope you find this program useful!
 *
 */

#include <stdio.h>
#include "cset.h"
#include "cset.d"

#define next continue

/* Pretty print an _optable - or try to, boring ol' stdio!

   Adapted from d.optab - written in the REAL language B Plus!

   args:
      withelp - true is want long form with short desc
      table   - the table to be printed, 0 => _optable
      hidden  - if true, the 'hidden' options are also printed
 */

d_optable(withelp, table, hidden) int withelp, hidden; _opt_entry *table;
{  extern _opt_entry _optable[];
   _opt_entry *p;
   int c, n, flip, column;
   char *left, *right;

   /* set default table */
   if( table == (_opt_entry *)0 ) table = _optable;

   p = table;
   flip = c = n = 0;
   /* count command and option names */
   while(p->_opt_pat) if((p++)->_opt_types == COMM_KWD) c++; else n++;
   if(c > 1) /* only list command names if > 1 */
   {  fputs("Command Names:", stderr);
      p = table;
      while(p->_opt_pat)
      {  if(p->_opt_types == COMM_KWD)
	 {  if(withelp)
	    {  fprintf(stderr, "\n%*s%s%*s%s", TAB1, "", p->_opt_pat,
		  TAB3 - (strlen(p->_opt_pat) + TAB1), "",
		  p->_opt_help == NOHELP ? "(see manual)" : p->_opt_help);
	    }
	    else
	   {  fprintf(stderr, "%sc%*s%s", flip ? (char *)0 : "\n",
		  flip ? (TAB2 - column) : TAB1, "", p->_opt_pat);
	       if(flip = !flip) column = TAB1 + strlen(p->_opt_pat);
	    }
	 }
	 p++;
      }
      fputc('\n', stderr);
      if(!n) return;
   }
   fputs("Options:", stderr);
   flip = 0;
   p = table; p--;
   while( (++p)->_opt_pat )
   {  if(p->_opt_types == COMM_KWD) next;
      /* if HIDE and not hidden don't print it! */
      if( (p->_opt_types & HIDE_KWD) && !hidden) next;
      _opt_adorn(p->_opt_types, &left, &right);
      if(withelp)
      {  fprintf( stderr, "\n%*s%s%s%s%*s%s", TAB1, "", left, p->_opt_pat,
		  right,
		  TAB3 - (TAB1+strlen(left)+strlen(p->_opt_pat)+strlen(right)),
		  "", p->_opt_help == NOHELP ? "(see manual)" : p->_opt_help);
      }
      else
      {  fprintf( stderr, "%s%*s", flip ? "" : "\n",
		  flip ? (TAB2 - column) : TAB1, "");
	 flip = !flip;
	 fprintf(stderr, "%s%s%s", left, p->_opt_pat, right);
	 if(flip)
	    column = TAB1 + strlen(left) + strlen(p->_opt_pat) + strlen(right);
      }
   }
   fputc('\n', stderr);
}

/* return strings to 'adorn' options */
_opt_adorn(p, left, right) char **left, **right;
{  static char *dpb[] = { (char *)0, "", "+", "[+]", "-", "[-]",
			  "(+|-)", "[+|-]" };
   static char *s_val = { "=X" };
   static char *m_val = { "=X,...,X" };
   int c;
   if(p == COMM_KWD)
      *left = *right = "";
   else if(c = p & (DASH_KWD | PLUS_KWD | BLNK_KWD))
   {  *left = dpb[c >> 8];
      *right = "";
   }
   else if(p  == SVAL_KWD)
   {  *left = "";
      s_val[1] = 's'; /* construct '=s' */
      *right = s_val;
   }
   else /* numeric */
   {  switch(p & 0xFF) /* find base */
      {  case 0: c = 'n'; break;
	 case 8: c = 'o'; break;
	 case 10: c = 'd'; break;
	 case 16: c = 'x'; break;
	 default: /* somebody is being ackward... */
	    c = p & 0xFF;
	    c += c < 10 ? '0' : ('A' - 10);
      }
      *left = "";
      if(p & MVAL_BIT)
      {  m_val[1] = m_val[7] = c;
	 *right = m_val;
      }
      else
      {  s_val[1] = c;
	 *right = s_val;
      }
   }
}
