/* $Header: cset.h,v 1.1 89/03/03 12:53:23 np Exp $
 * $Log:	cset.h,v $
 * Revision 1.1  89/03/03  12:53:23  np
 * Initial revision
 * 
 */

/*
 * Copyright (C) 1985-1989 Nigel Perry
 *
 * This program is distributed without any warranty.
 * The author and and distributors accept no resposibility
 * to anyone for the consequence of using this program or
 * whether it serves any particular purpose or works at all,
 * unless they say so in writing.
 *
 * Everyone is granted permission to copy, modify and
 * redistribute this program, but only provided that:
 *
 * 1) They do so without financial or material gain.
 *
 * 2) The copyright notice and this notice are preserved on
 *    all copies.
 *
 * 3) The original source is preserved in any redistribution.
 *
 * I hope you find this program useful!
 *
 */

/* a type definition for the options table */
typedef struct { char *_opt_pat; int _opt_types; char *_opt_help } _opt_entry;
#define OPTIONS _opt_entry _optable[] =
/* the end of list marker for above defn */
#define OPT_END { (char *)0, 0, (char *)0 }
/* end of list marker including details of an info file */
#define OPT_HELP(act, str) { (char *)0, act, str }
/* empty help message constant */
#define NOHELP (char *)0
/* 'actions' for OPT_HELP, must be != 0 */
#define OPT_LIST 1
#define OPT_EXEC 2

/* the option types */
#define BLNK_KWD 0x00100 /*  keyword                                     */
#define PLUS_KWD 0x00200 /* +keyword                                     */
#define DASH_KWD 0x00400 /* -keyword                                     */
#define COMM_KWD 0x00800 /*  keyword - only recognised if command (first)*/
#define SVAL_KWD 0x01000 /*  keyword=string                              */
#define NVAL_KWD 0x02000 /*  keyword=number - 0ddd => oct, 0xddd => hex  */
#define MVAL_KWD 0x06000 /*  keyword=number,...,number                   */
#define DVAL_KWD 0x0200a /*  keyword=decimal                             */
#define MDVL_KWD 0x0600a /*  keyword=decimal,...,decimal                 */
#define OVAL_KWD 0x02008 /*  keyword=octal                               */
#define MOVL_KWD 0x06008 /*  keyword=octal,...,octal                     */
#define HVAL_KWD 0x02010 /*  keyword=hex                                 */
#define MHVL_KWD 0x06010 /*  keyword=hex,...,hex                         */
#define HIDE_KWD 0x10000 /*  Hidden keyword - not shown by d_optable()   */
#define PRIV_KWD 0x30000 /*  Priviledged keyword - only for su's         */

/* _cset() returns a pointer to an array of... */
typedef struct { int _opt_num;
		 char _opt_type;
		 union { int nval; /* numeric value */
			 int *mval; /* ptr to vec of values */
			 char *sval; /* string value */
		       } _opt;
	      } _opt_desc;

extern _opt_desc *_cset();

/* defn for environ var to control use of keyword arguments */
#define AS_ENVAR "ArgStyle"
#define AS_KWD   "keyword"    /* arg style is keyword */
#define AS_ORG   "original"   /* arg style as supplied */
