static char rcsid[] = "$Header";
/* $Log:	abbrev.c,v $
 * Revision 1.1  89/03/03  12:53:21  np
 * Initial revision
 * 
 */

/*
 * Copyright (C) 1985-1989 Nigel Perry
 *
 * This program is distributed without any warranty.
 * The author and and distributors accept no resposibility
 * to anyone for the consequence of using this program or
 * whether it serves any particular purpose or works at all,
 * unless they say so in writing.
 *
 * Everyone is granted permission to copy, modify and
 * redistribute this program, but only provided that:
 *
 * 1) They do so without financial or material gain.
 *
 * 2) The copyright notice and this notice are preserved on
 *    all copies.
 *
 * 3) The original source is preserved in any redistribution.
 *
 * I hope you find this program useful!
 *
 */

#define repeat while(1)  /* try to make C look high level! */

#define REQUIRED 32
#define OPTIONAL 1

/* check if string is a valid abbreviation of pattern
 *
 * In a pattern:
 *   a thru z and _ are optional
 *   other characters must be present
 *
 * Return:
 *  -1 : no match
 *  n = REQUIRED * (number of required matches) + OPTIONAL * (number of optional characters matched)
 *
 * e.g
 *	Pattern		String		Return
 *	LineFeed	lf		2 * REQUIRED
 *	Longform	lf		1 * REQUIRED + 1 * OPTIONAL
 * => lf is a better match for LineFeed
 *
 * The higher the result the better the match.
 *
 */

int abbrev(pat, str) register char *pat, *str;
{  register char c, pc;
   register int score, sc;

   score = 0;
   c = *str++;
   if(c >= 'a' && c <= 'z') c += 'A' - 'a';
   repeat
      if( (pc = *pat++) == '\0' )		/* this SHOULD be a case... */
	 return( c == '\0' ? score : -1 );
      else if(pc == '_') /* optional */
      {  if(c != '_') continue;			/* try next pattern character */
	 if( (sc = abbrev(pat, str)) >= 0 ) return(score + OPTIONAL + sc);
	 /* rest of match failed, try next pattern char */
      }
      else if(pc >= 'a' && pc <= 'z')		/* = case 'a' :: 'z', B rules! */
      {  if( (c - 'A' + 'a') != pc ) continue;	/* no match, try next pat */
	 if( (sc = abbrev(pat, str)) >= 0 ) return(score + OPTIONAL + sc);
      }
      else /* must match */
      {  if(c != pc) return(-1);
	 score += REQUIRED;
	 c = *str++;				/* get next str char */
	 if(c >= 'a' && c <= 'z') c += 'A' - 'a';
      }
}
