/*
	<complex.h> -- definitions for complex arithmetic routines

	last edit:	86/01/04	D A Gwyn

	SCCS ID:	@(#)complex.h	1.1 (modified for public version)
*/

/* "complex number" data type: */

typedef struct
	{
	double		re;		/* real part */
	double		im;		/* imaginary part */
	}	complex;

/* "The future is now": */

#ifdef __STDC__	/* X3J11 */
#define	_CxGenPtr	void *		/* generic pointer type */
#else		/* K&R */
#define	_CxGenPtr	char *		/* generic pointer type */
#endif

/* functions that are correctly done as macros: */

#define	CxAllo()		((complex *)malloc( sizeof (complex) ))
#define	CxFree( cp )		free( (_CxGenPtr)(cp) )
#define	CxNeg( cp )		CxScal( cp, -1.0 )
#define	CxReal( cp )		(cp)->re
#define	CxImag( cp )		(cp)->im

extern void		free();
extern _CxGenPtr	malloc();

/* library functions: */

extern double	CxAmpl(), CxPhas();
extern complex	*CxAdd(), *CxConj(), *CxCons(), *CxCopy(), *CxDiv(),
		*CxMul(), *CxPhsr(), *CxScal(), *CxSqrt(), *CxSub();
