/*$SCOMMAND:  SET SIGNALS NICELY AND CALL COMMAND.
!l  Rev. 2.00, 06-Jan-85, R$:	Add sigvec handling.
!l  Rev. 1.00, 27-Nov-84, R$:	Genesis.
*/

/*
!d  DESCRIPTION:
!d		doneok = scommand(text, bgflag)
!d  This routine is a wrapper around command for those who can't/won't
!d  learn about signals.  It basically duplicates the csh/sh actions for
!d  command execution:  if being done in the foreground, the parent ignores
!d  interrupts until the child is done; if it's a background command, the
!d  kid is told to ignore interrupts.
*/

/* LINTLIBRARY */
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>


/* Linked in later. */
extern int	 errno;
extern int	 cmndno;

int
scommand(p, bg)
    char	*p;
    int		 bg;
{
    struct sigvec	 H;
    struct sigvec	 Old;
    int			 D;
    int			 S;
    union wait		 W;

    /* If in background, kid ignores interrupts; foreground gets default. */
    H.sv_handler = bg ? SIG_IGN : SIG_DFL;
    H.sv_mask = 0;
    H.sv_onstack = 0;
    (void)sigvec(SIGINT, &H, &Old);

    /* Run command in background. */
    S = command(p, 1);

    /* If in foreground, wait for kid with interrupts ignored. */
    if (!bg)
    {
	H.sv_handler = SIG_IGN;
	(void)sigvec(SIGINT, &H, (struct sigvec *)0);
	while ((D = wait(&W)) != S)
	    if (D < 0 && errno == ECHILD)
		break;
	cmndno = W.w_status;
	S = cmndno == 0;
    }

    /* Restore old signal value, FOH. */
    (void)sigvec(SIGINT, &Old, (struct sigvec *)0);
    return(S);
}
