
#! /bin/sh
# This is a shell archive.  Remove anything before this line, then unpack
# it by saving it into a file and typing "sh file".  To overwrite existing
# files, type "sh file -c".  You can also feed this as standard input via
# unshar, or by typing "sh <file", e.g..  If this archive is complete, you
# will see the following message at the end:
#		"End of archive 2 (of 2)."
# Contents:  cdecl.c
# Wrapped by rsalz@fig.bbn.com on Mon May  9 20:40:48 1988
PATH=/bin:/usr/bin:/usr/ucb ; export PATH
if test -f 'cdecl.c' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'cdecl.c'\"
else
echo shar: Extracting \"'cdecl.c'\" \(25555 characters\)
sed "s/^X//" >'cdecl.c' <<'END_OF_FILE'
X/*
X * cdecl - ANSI C and C++ declaration composer & decoder
X *
X *	originally written
X *		Graham Ross
X *		once at tektronix!tekmdp!grahamr
X *		now at Context, Inc.
X *
X *	modified to provide hints for unsupported types
X *	added argument lists for functions
X *	added 'explain cast' grammar
X *	added #ifdef for 'create program' feature
X *		???? (sorry, I lost your name and login)
X *
X *	conversion to ANSI C
X *		David Wolverton
X *		ihnp4!houxs!daw
X *
X *	merged D. Wolverton's ANSI C version w/ ????'s version
X *	added function prototypes
X *	added C++ declarations
X *	made type combination checking table driven
X *	added checks for void variable combinations
X *	made 'create program' feature a runtime option
X *	added file parsing as well as just stdin
X *	added help message at beginning
X *	added prompts when on a TTY or in interactive mode
X *	added getopt() usage
X *	added -a, -r, -p, -c, -d, -D, -V, -i and -+ options
X *	delinted
X *	added #defines for those without getopt or void
X *	added 'set options' command
X *	added 'quit/exit' command
X *	added synonyms
X *		Tony Hansen
X *		attmail!tony, ihnp4!pegasus!hansen
X *
X *	added extern, register, static
X *	added links to explain, cast, declare
X *	separately developed ANSI C support
X *		Merlyn LeRoy
X *		merlyn@rose3.rosemount.com
X *
X *	merged versions from LeRoy
X *	added tmpfile() support
X *	allow more parts to be missing during explanations
X *		Tony Hansen
X *		attmail!tony, ihnp4!pegasus!hansen
X */
X
char cdeclsccsid[] = "@(#)cdecl.c	2.4 3/31/88";
X
X#include <stdio.h>
X#include <ctype.h>
X#if __STDC__ || defined(DOS)
X# include <stdlib.h>
X# include <stddef.h>
X# include <string.h>
X# include <stdarg.h>
X#else
X# ifndef NOVARARGS
X#  include <varargs.h>
X# endif /* ndef NOVARARGS */
char *malloc();
void free(), exit(), perror();
X# ifdef BSD
X#  include <strings.h>
X   extern int errno;
X#  define strrchr rindex
X#  define NOTMPFILE
X# else
X#  include <string.h>
X#  include <errno.h>
X# endif /* BSD */
X# ifdef NOVOID
X#  define void int
X# endif /* NOVOID */
X#endif /* __STDC__ || DOS */
X
X#define	MB_SHORT	0001
X#define	MB_LONG		0002
X#define	MB_UNSIGNED	0004
X#define MB_INT		0010
X#define MB_CHAR		0020
X#define MB_FLOAT	0040
X#define MB_DOUBLE	0100
X#define MB_VOID		0200
X#define	MB_SIGNED	0400
X
X#define NullCP ((char*)NULL)
X#ifdef dodebug
X# define Debug(x) do { if (DebugFlag) (void) fprintf x; } while (0)
X#else
X# define Debug(x) /* nothing */
X#endif
X
X#if __STDC__
X  char *ds(char *), *cat(char *, ...), *visible(int);
X  int getopt(int,char **,char *);
X  int main(int, char **);
X  int yywrap(void);
X  int dostdin(void);
X  void mbcheck(void), dohelp(void), usage(void);
X  void prompt(void), doprompt(void), noprompt(void);
X  void unsupp(char *, char *);
X  void notsupported(char *, char *, char *);
X  void yyerror(char *);
X  void doset(char *);
X  void dodeclare(char*, char*, char*, char*, char*);
X  void docast(char*, char*, char*, char*);
X  void dodexplain(char*, char*, char*, char*);
X  void docexplain(char*, char*, char*, char*);
X  void setprogname(char *);
X  int dotmpfile(int, char**), dofileargs(int, char**);
X#else
X  char *ds(), *cat(), *visible();
X  int getopt();
X  void mbcheck(), dohelp(), usage();
X  void prompt(), doprompt(), noprompt();
X  void unsupp(), notsupported();
X  void yyerror();
X  void doset(), dodeclare(), docast(), dodexplain(), docexplain();
X  void setprogname();
X  int dotmpfile(), dofileargs();
X#endif /* __STDC__ */
X  FILE *tmpfile();
X
X/* variables used during parsing */
unsigned modbits = 0;
int arbdims = 1;
char *savedname = 0;
char unknown_name[] = "unknown_name";
char prev = 0;		/* the current type of the variable being examined */
X			/*    values	type				   */
X			/*	p	pointer				   */
X			/*	r	reference			   */
X			/*	f	function			   */
X			/*	a	array (of arbitrary dimensions)    */
X			/*	A	array with dimensions		   */
X			/*	n	name				   */
X			/*	v	void				   */
X			/*	s	struct | class			   */
X			/*	t	simple type (int, long, etc.)	   */
X
X/* options */
int RitchieFlag = 0;		/* -r, assume Ritchie PDP C language */
int MkProgramFlag = 0;		/* -c, output {} and ; after declarations */
int PreANSIFlag = 0;		/* -p, assume pre-ANSI C language */
int CplusplusFlag = 0;		/* -+, assume C++ language */
int OnATty = 0;			/* stdin is coming from a terminal */
int Interactive = 0;		/* -i, overrides OnATty */
int KeywordName = 0;		/* $0 is a keyword (declare, explain, cast) */
char *progname = "cdecl";	/* $0 */
X
X#if dodebug
int DebugFlag = 0;		/* -d, output debugging trace info */
X#endif
X
X#ifdef doyydebug		/* compile in yacc trace statements */
X#define YYDEBUG 1
X#endif /* doyydebug */
X
X#include "cdgram.c"
X#include "cdlex.c"
X
X/* definitions (and abbreviations) for type combinations cross check table */
X#define ALWAYS	0	/* combo always okay */
X#define _	ALWAYS
X#define NEVER	1	/* combo never allowed */
X#define X	NEVER
X#define RITCHIE	2	/* combo not allowed in Ritchie compiler */
X#define R	RITCHIE
X#define PREANSI	3	/* combo not allowed in Pre-ANSI compiler */
X#define P	PREANSI
X#define ANSI	4	/* combo not allowed anymore in ANSI compiler */
X#define A	ANSI
X
X/* This is an lower left triangular array. If we needed */
X/* to save 9 bytes, the "long" row can be removed. */
char crosscheck[9][9] = {
X    /*			L, I, S, C, V, U, S, F, D, */
X    /* long */		_, _, _, _, _, _, _, _, _,
X    /* int */		_, _, _, _, _, _, _, _, _,
X    /* short */		X, _, _, _, _, _, _, _, _,
X    /* char */		X, X, X, _, _, _, _, _, _,
X    /* void */		X, X, X, X, _, _, _, _, _,
X    /* unsigned */	R, _, R, R, X, _, _, _, _,
X    /* signed */	P, P, P, P, X, X, _, _, _,
X    /* float */		A, X, X, X, X, X, X, _, _,
X    /* double */	P, X, X, X, X, X, X, X, _
X};
X
X/* the names and bits checked for each row in the above array */
struct
X    {
X    char *name;
X    int bit;
X    } crosstypes[9] =
X	{
X	    { "long",		MB_LONG		},
X	    { "int",		MB_INT		},
X	    { "short",		MB_SHORT	},
X	    { "char",		MB_CHAR		},
X	    { "void",		MB_VOID		},
X	    { "unsigned",	MB_UNSIGNED	},
X	    { "signed",		MB_SIGNED	},
X	    { "float",		MB_FLOAT	},
X	    { "double",		MB_DOUBLE	}
X	};
X
X/* Run through the crosscheck array looking */
X/* for unsupported combinations of types. */
void mbcheck()
X{
X    register int i, j, restrict;
X    char *t1, *t2;
X
X    /* Loop through the types */
X    /* (skip the "long" row) */
X    for (i = 1; i < 9; i++)
X	{
X	/* if this type is in use */
X	if ((modbits & crosstypes[i].bit) != 0)
X	    {
X	    /* check for other types also in use */
X	    for (j = 0; j < i; j++)
X		{
X		/* this type is not in use */
X		if (!(modbits & crosstypes[j].bit))
X		    continue;
X		/* check the type of restriction */
X		restrict = crosscheck[i][j];
X		if (restrict == ALWAYS)
X		    continue;
X		t1 = crosstypes[i].name;
X		t2 = crosstypes[j].name;
X		if (restrict == NEVER)
X		    {
X		    notsupported("", t1, t2);
X		    }
X		else if (restrict == RITCHIE)
X		    {
X		    if (RitchieFlag)
X			notsupported(" (Ritchie Compiler)", t1, t2);
X		    }
X		else if (restrict == PREANSI)
X		    {
X		    if (PreANSIFlag || RitchieFlag)
X			notsupported(" (Pre-ANSI Compiler)", t1, t2);
X		    }
X		else if (restrict == ANSI)
X		    {
X		    if (!RitchieFlag && !PreANSIFlag)
X			notsupported(" (ANSI Compiler)", t1, t2);
X		    }
X		else
X		    {
X		    (void) fprintf (stderr,
X			"%s: Internal error in crosscheck[%d,%d]=%d!\n",
X			progname, i, j, restrict);
X		    exit(1); /* NOTREACHED */
X		    }
X		}
X	    }
X	}
X}
X
X/* undefine these as they are no longer needed */
X#undef _
X#undef ALWAYS
X#undef X
X#undef NEVER
X#undef R
X#undef RITCHIE
X#undef P
X#undef PREANSI
X#undef A
X#undef ANSI
X
X/* Write out a message about something */
X/* being unsupported, possibly with a hint. */
void unsupp(s,hint)
char *s,*hint;
X{
X    notsupported("", s, NullCP);
X    if (hint)
X	(void) fprintf(stderr, "\t(maybe you mean \"%s\")\n", hint);
X}
X
X/* Write out a message about something */
X/* being unsupported on a particular compiler. */
void notsupported(compiler, type1, type2)
char *compiler, *type1, *type2;
X{
X    if (type2)
X	(void) fprintf(stderr,
X	    "Warning: Unsupported in%s C%s -- '%s' with '%s'\n",
X	    compiler, CplusplusFlag ? "++" : "", type1, type2);
X    else
X	(void) fprintf(stderr,
X	    "Warning: Unsupported in%s C%s -- '%s'\n",
X	    compiler, CplusplusFlag ? "++" : "", type1);
X}
X
X/* Called by the yacc grammar */
void yyerror(s)
char *s;
X{
X    (void) printf("%s\n",s);
X    Debug((stdout, "yychar=%d\n", yychar));
X}
X
X/* Called by the yacc grammar */
int yywrap()
X{
X    return 1;
X}
X
X/*
X * Support for dynamic strings:
X * cat() creates a string from the concatenation
X * of a null terminated list of input strings.
X * The input strings are free()'d by cat()
X * (so they better have been malloc()'d).
X *
X * the different methods of <stdarg.h> and
X * <vararg.h> are handled within these macros
X */
X#if __STDC__
X#  define VA_DCL(type,var)		(type var,...)
X#  define VA_START(list,var,type)	((va_start(list,var)) , (var))
X#else
X#if defined(DOS)
X#  define VA_DCL(type,var)		(var,...) type var;
X#  define VA_START(list,var,type)	((va_start(list,var)) , (var))
X#else
X#ifndef NOVARARGS
X# define VA_DCL(type,var)		(va_alist) va_dcl
X# define VA_START(list,var,type)	((va_start(list)) , va_arg(list,type))
X#else
X   /*
X    *	it is assumed here that machines which don't have either
X    *	<varargs.h> or <stdarg.h> will put its arguments on
X    *	the stack in the "usual" way and consequently can grab
X    *	the arguments using the "take the address of the first
X    *	parameter and increment by sizeof" trick.
X    */
X# define VA_DCL(type,var)		(var) type var;
X# define VA_START(list,var,type)	(list = (va_list)&(var) , (var))
X# define va_arg(list,type)		((type *)(list += sizeof(type)))[-1]
X# define va_end(p)			/* nothing */
typedef char *va_list;
X#endif /* NOVARARGS */
X#endif /* DOS */
X#endif /* __STDC__ */
X
X/* VARARGS */
char *cat
VA_DCL(char*, s1)
X{
X    register char *newstr;
X    register unsigned len = 1;
X    char *str;
X    va_list args;
X
X    /* find the length which needs to be allocated */
X    str = VA_START(args, s1, char*);
X    for ( ; str; str = va_arg(args, char*))
X	len += strlen(str);
X    va_end(args);
X
X    /* allocate it */
X    newstr = malloc(len);
X    if (newstr == 0)
X	{
X	(void) fprintf (stderr, "%s: out of malloc space within cat()!\n",
X	    progname);
X	exit(1);
X	}
X    newstr[0] = '\0';
X
X    /* copy in the strings */
X    str = VA_START(args, s1, char*);
X    for ( ; str; str = va_arg(args, char*))
X	{
X	(void) strcat(newstr,str);
X	free(str);
X	}
X    va_end(args);
X
X    Debug((stderr, "\tcat created '%s'\n", newstr));
X    return newstr;
X}
X
X/*
X * ds() makes a malloc()'d string from one that's not.
X */
char *ds(s)
char *s;
X{
X    register char *p = malloc((unsigned)(strlen(s)+1));
X
X    if (p)
X	(void) strcpy(p,s);
X    else
X	{
X	(void) fprintf (stderr, "%s: malloc() failed!\n", progname);
X	exit(1);
X	}
X    return p;
X}
X
X/* return a visible representation of a character */
char *visible(c)
int c;
X{
X    static char buf[5];
X
X    c &= 0377;
X    if (isprint(c))
X	{
X	buf[0] = c;
X	buf[1] = '\0';
X	}
X    else
X	(void) sprintf(buf,"\\%03o",c);
X    return buf;
X}
X
X#ifdef NOTMPFILE
X/* provide a conservative version of tmpfile() */
X/* for those systems without it. */
X/* tmpfile() returns a FILE* of a file opened */
X/* for read&write. It is supposed to be */
X/* automatically removed when it gets closed, */
X/* but here we provide a separate rmtmpfile() */
X/* function to perform that function. */
X/* Also provide several possible file names to */
X/* try for opening. */
static char *file4tmpfile = 0;
X
XFILE *tmpfile()
X{
X    static char *listtmpfiles[] =
X	{
X	"/usr/tmp/cdeclXXXXXX",
X	"/tmp/cdeclXXXXXX",
X	"/cdeclXXXXXX",
X	"cdeclXXXXXX",
X	0
X	};
X
X    char **listp = listtmpfiles;
X    for ( ; *listp; listp++)
X	{
X	FILE *retfp;
X	(void) mktemp(*listp);
X	retfp = fopen(*listp, "w+");
X	if (!retfp)
X	    continue;
X	file4tmpfile = *listp;
X	return retfp;
X	}
X
X    return 0;
X}
X
void rmtmpfile()
X{
X    if (file4tmpfile)
X	(void) unlink(file4tmpfile);
X}
X#else
X/* provide a mock rmtmpfile() for normal systems */
X# define rmtmpfile()	/* nothing */
X#endif /* NOTMPFILE */
X
X#ifndef NOGETOPT
extern int optind;
X#else
X/* This is a miniature version of getopt() which will */
X/* do just barely enough for us to get by below. */
X/* Options are not allowed to be bunched up together. */
X/* Option arguments are not supported. */
int optind = 1;
X
int getopt(argc,argv,optstring)
char **argv;
char *optstring;
X{
X    int ret;
X    char *p;
X
X    if ((argv[optind][0] != '-')
X#ifdef DOS
X	&& (argv[optind][0] != '/')
X#endif /* DOS */
X	)
X	return EOF;
X
X    ret = argv[optind][1];
X    optind++;
X
X    for (p = optstring; *p; p++)
X	if (*p == ret)
X	    return ret;
X
X    (void) fprintf (stderr, "%s: illegal option -- %s\n",
X	progname, visible(ret));
X
X    return '?';
X}
X#endif
X
X/* the help messages */
struct helpstruct
X    {
X	char *text;	/* generic text */
X	char *cpptext;	/* C++ specific text */
X    } helptext[] =
X    {	/* up-to 23 lines of help text so it fits on (24x80) screens */
X/*  1 */{ "[] means optional; {} means 1 or more; <> means defined elsewhere", 0 },
X/*  2 */{ "  commands are separated by ';' and newlines", 0 },
X/*  3 */{ "command:", 0 },
X/*  4 */{ "  declare <name> as <english>", 0 },
X/*  5 */{ "  cast <name> into <english>", 0 },
X/*  6 */{ "  explain <gibberish>", 0 },
X/*  7 */{ "  set or set options", 0 },
X/*  8 */{ "  help, ?", 0 },
X/*  9 */{ "  quit or exit", 0 },
X/* 10 */{ "english:", 0 },
X/* 11 */{ "  function [( <decl-list> )] returning <english>", 0 },
X/* 12 */{ "  array [<number>] of <english>", 0 },
X/* 13 */{ "  [{ const | volatile | noalias }] pointer to <english>",
X	  "  [{const|volatile}] {pointer|reference} to [member of class <name>] <english>" },
X/* 14 */{ "  <type>", 0 },
X/* 15 */{ "type:", 0 },
X/* 16 */{ "  {[<storage-class>] [{<modifier>}] [<C-type>]}", 0 },
X/* 17 */{ "  { struct | union | enum } <name>",
X	  "  {struct|class|union|enum} <name>" },
X/* 18 */{ "decllist: a comma separated list of <name>, <english> or <name> as <english>", 0 },
X/* 19 */{ "name: a C identifier", 0 },
X/* 20 */{ "gibberish: a C declaration, like 'int *x', or cast, like '(int *)x'", 0 },
X/* 21 */{ "storage-class: extern, static, auto, register", 0 },
X/* 22 */{ "C-type: int, char, float, double, or void", 0 },
X/* 23 */{ "modifier: short, long, signed, unsigned, const, volatile, or noalias",
X	  "modifier: short, long, signed, unsigned, const, or volatile" },
X	{ 0, 0 }
X    };
X
X/* Print out the help text */
void dohelp()
X{
X    register struct helpstruct *p;
X    register char *fmt = CplusplusFlag ? " %s\n" : "\t%s\n";
X
X    for (p = helptext; p->text; p++)
X	if (CplusplusFlag && p->cpptext)
X	    (void) printf(fmt, p->cpptext);
X	else
X	    (void) printf(fmt, p->text);
X}
X
X/* Tell how to invoke cdecl. */
void usage()
X{
X    (void) fprintf (stderr, "Usage: %s [-r|-p|-a|-+] [-ci%s%s] [files...]\n",
X	progname,
X#ifdef dodebug
X	"d",
X#else
X	"",
X#endif /* dodebug */
X#ifdef doyydebug
X	"D"
X#else
X	""
X#endif /* doyydebug */
X	);
X    (void) fprintf (stderr, "\t-r Check against Ritchie PDP C Compiler\n");
X    (void) fprintf (stderr, "\t-p Check against Pre-ANSI C Compiler\n");
X    (void) fprintf (stderr, "\t-a Check against ANSI C Compiler%s\n",
X	CplusplusFlag ? "" : " (the default)");
X    (void) fprintf (stderr, "\t-+ Check against C++ Compiler%s\n",
X	CplusplusFlag ? " (the default)" : "");
X    (void) fprintf (stderr, "\t-c Create compilable output (include ; and {})\n");
X    (void) fprintf (stderr, "\t-i Force interactive mode\n");
X#ifdef dodebug
X    (void) fprintf (stderr, "\t-d Turn on debugging mode\n");
X#endif /* dodebug */
X#ifdef doyydebug
X    (void) fprintf (stderr, "\t-D Turn on YACC debugging mode\n");
X#endif /* doyydebug */
X    exit(1);
X    /* NOTREACHED */
X}
X
X/* Manage the prompts. */
static int prompting = 1;
X
void doprompt() { prompting = 1; }
void noprompt() { prompting = 0; }
X
void prompt()
X{
X    if ((OnATty || Interactive) && prompting) {
X	(void) printf("%s> ", progname);
X	(void) fflush(stdout);
X    }
X}
X
X/* Save away the name of the program from argv[0] */
void setprogname(argv0)
char *argv0;
X{
X#ifdef DOS
X    char *dot;
X#endif /* DOS */
X
X    progname = strrchr(argv0, '/');
X
X#ifdef DOS
X    if (!progname)
X	progname = strrchr(argv0, '\\');
X#endif /* DOS */
X
X    if (progname)
X	progname++;
X    else
X	progname = argv0;
X
X#ifdef DOS
X    dot = strchr(progname, '.');
X    if (dot)
X	*dot = '\0';
X    for (dot = progname; *dot; dot++)
X	*dot = tolower(*dot);
X#endif /* DOS */
X}
X
X/* Run down the list of keywords to see if the */
X/* program is being called named as one of them */
X/* or the first argument is one of them. */
int namedkeyword(argn)
char *argn;
X{
X    static char *cmdlist[] =
X	{
X	"explain", "declare", "cast", "help", "?", "set", 0
X	};
X
X    /* first check the program name */
X    char **cmdptr = cmdlist;
X    for ( ; *cmdptr; cmdptr++)
X	if (strcmp(*cmdptr, progname) == 0)
X	    {
X	    KeywordName = 1;
X	    return 1;
X	    }
X
X    /* now check $1 */
X    for (cmdptr = cmdlist; *cmdptr; cmdptr++)
X	if (strcmp(*cmdptr, argn) == 0)
X	    return 1;
X
X    /* nope, must be file name arguments */
X    return 0;
X}
X
X/* Read from standard input, turning */
X/* on prompting if necessary. */
int dostdin()
X{
X    int ret;
X    OnATty = isatty(0);
X    if (OnATty || Interactive)
X	{
X	(void) printf("Type `help' or `?' for help\n");
X	prompt();
X	}
X
X    yyin = stdin;
X    ret = yyparse();
X    OnATty = 0;
X    return ret;
X}
X
X/* Write the arguments into a file */
X/* and treat that file as the input. */
int dotmpfile(argc, argv)
int argc;
char **argv;
X{
X    int ret = 0;
X    FILE *tmpfp = tmpfile();
X    if (!tmpfp)
X	{
X	int sverrno = errno;
X	(void) fprintf (stderr, "%s: cannot open temp file\n",
X	    progname);
X	errno = sverrno;
X	perror(progname);
X	return 1;
X	}
X
X    if (KeywordName)
X	if (fputs(progname, tmpfp) == EOF)
X	    {
X	    int sverrno;
X	errwrite:
X	    sverrno = errno;
X	    (void) fprintf (stderr, "%s: error writing to temp file\n",
X		progname);
X	    errno = sverrno;
X	    perror(progname);
X	    (void) fclose(tmpfp);
X	    rmtmpfile();
X	    return 1;
X	    }
X
X    for ( ; optind < argc; optind++)
X	if (fprintf(tmpfp, " %s", argv[optind]) == EOF)
X	    goto errwrite;
X
X    if (putc('\n', tmpfp) == EOF)
X	goto errwrite;
X
X    rewind(tmpfp);
X    yyin = tmpfp;
X    ret += yyparse();
X    (void) fclose(tmpfp);
X    rmtmpfile();
X
X    return ret;
X}
X
X/* Read each of the named files for input. */
int dofileargs(argc, argv)
int argc;
char **argv;
X{
X    FILE *ifp;
X    int ret = 0;
X
X    for ( ; optind < argc; optind++)
X	if (strcmp(argv[optind], "-") == 0)
X	    ret += dostdin();
X
X	else if ((ifp = fopen(argv[optind], "r")) == NULL)
X	    {
X	    int sverrno = errno;
X	    (void) fprintf (stderr, "%s: cannot open %s\n",
X		progname, argv[optind]);
X	    errno = sverrno;
X	    perror(argv[optind]);
X	    ret++;
X	    }
X
X	else
X	    {
X	    yyin = ifp;
X	    ret += yyparse();
X	    }
X
X    return ret;
X}
X
X/* print out a cast */
void docast(name, left, right, type)
char *name, *left, *right, *type;
X{
X    int lenl = strlen(left), lenr = strlen(right);
X
X    if (prev == 'f')
X	    unsupp("Cast into function",
X		    "cast into pointer to function");
X    else if (prev=='A' || prev=='a')
X	    unsupp("Cast into array","cast into pointer");
X    (void) printf("(%s%*s%s)%s\n",
X	    type, lenl+lenr?lenl+1:0,
X	    left, right, name ? name : "expression");
X    free(left);
X    free(right);
X    free(type);
X    if (name)
X        free(name);
X}
X
X/* print out a declaration */
void dodeclare(name, storage, left, right, type)
char *name, *storage, *left, *right, *type;
X{
X    if (prev == 'v')
X	    unsupp("Variable of type void",
X		    "variable of type pointer to void");
X
X    if (*storage == 'r')
X	switch (prev)
X	    {
X	    case 'f': unsupp("Register function", NullCP); break;
X	    case 'A':
X	    case 'a': unsupp("Register array", NullCP); break;
X	    case 's': unsupp("Register struct/class", NullCP); break;
X	    }
X
X    if (*storage)
X        (void) printf("%s ", storage);
X    (void) printf("%s %s%s%s",
X        type, left,
X	name ? name : (prev == 'f') ? "f" : "var", right);
X    if (MkProgramFlag) {
X	    if ((prev == 'f') && (*storage != 'e'))
X		    (void) printf(" { }\n");
X	    else
X		    (void) printf(";\n");
X    } else {
X	    (void) printf("\n");
X    }
X    free(storage);
X    free(left);
X    free(right);
X    free(type);
X    if (name)
X        free(name);
X}
X
void dodexplain(storage, constvol, type, decl)
char *storage, *constvol, *type, *decl;
X{
X    if (type && (strcmp(type, "void") == 0))
X	if (prev == 'n')
X	    unsupp("Variable of type void",
X		   "variable of type pointer to void");
X	else if (prev == 'a')
X	    unsupp("array of type void",
X		   "array of type pointer to void");
X	else if (prev == 'r')
X	    unsupp("reference to type void",
X		   "pointer to void");
X
X    if (*storage == 'r')
X	switch (prev)
X	    {
X	    case 'f': unsupp("Register function", NullCP); break;
X	    case 'A':
X	    case 'a': unsupp("Register array", NullCP); break;
X	    case 's': unsupp("Register struct/union/enum/class", NullCP); break;
X	    }
X
X    (void) printf("declare %s as ", savedname);
X    if (*storage)
X        (void) printf("%s ", storage);
X    (void) printf("%s", decl);
X    if (*constvol)
X	    (void) printf("%s ", constvol);
X    (void) printf("%s\n", type ? type : "int");
X}
X
void docexplain(constvol, type, cast, name)
char *constvol, *type, *cast, *name;
X{
X    if (strcmp(type, "void") == 0)
X	if (prev == 'a')
X	    unsupp("array of type void",
X		   "array of type pointer to void");
X	else if (prev == 'r')
X	    unsupp("reference to type void",
X		   "pointer to void");
X    (void) printf("cast %s into %s", name, cast);
X    if (strlen(constvol) > 0)
X	    (void) printf("%s ", constvol);
X    (void) printf("%s\n",type);
X}
X
X/* Do the appropriate things for the "set" command. */
void doset(opt)
char *opt;
X{
X    if (strcmp(opt, "create") == 0)
X	{ MkProgramFlag = 1; }
X    else if (strcmp(opt, "nocreate") == 0)
X	{ MkProgramFlag = 0; }
X    else if (strcmp(opt, "interactive") == 0)
X	{ Interactive = 1; }
X    else if (strcmp(opt, "nointeractive") == 0)
X	{ Interactive = 0; OnATty = 0; }
X    else if (strcmp(opt, "ritchie") == 0)
X	{ CplusplusFlag=0; RitchieFlag=1; PreANSIFlag=0; }
X    else if (strcmp(opt, "preansi") == 0)
X	{ CplusplusFlag=0; RitchieFlag=0; PreANSIFlag=1; }
X    else if (strcmp(opt, "ansi") == 0)
X	{ CplusplusFlag=0; RitchieFlag=0; PreANSIFlag=0; }
X    else if (strcmp(opt, "cplusplus") == 0)
X	{ CplusplusFlag=1; RitchieFlag=0; PreANSIFlag=0; }
X#ifdef dodebug
X    else if (strcmp(opt, "debug") == 0)
X	{ DebugFlag = 1; }
X    else if (strcmp(opt, "nodebug") == 0)
X	{ DebugFlag = 0; }
X#endif /* dodebug */
X#ifdef doyydebug
X    else if (strcmp(opt, "yydebug") == 0)
X	{ yydebug = 1; }
X    else if (strcmp(opt, "noyydebug") == 0)
X	{ yydebug = 0; }
X#endif /* doyydebug */
X    else
X	{
X	if ((strcmp(opt, unknown_name) != 0) &&
X	    (strcmp(opt, "options") != 0))
X	    (void) printf("Unknown set option: '%s'\n", opt);
X
X	(void) printf("Valid set options (and command line equivalents) are:\n");
X	(void) printf("\toptions\n");
X	(void) printf("\tcreate (-c), nocreate\n");
X	(void) printf("\tinteractive (-i), nointeractive\n");
X	(void) printf("\tritchie (-r), preansi (-p), ansi (-a) or cplusplus (-+)\n");
X#ifdef dodebug
X	(void) printf("\tdebug (-d), nodebug\n");
X#endif /* dodebug */
X#ifdef doyydebug
X	(void) printf("\tyydebug (-D), noyydebug\n");
X#endif /* doyydebug */
X
X	(void) printf("\nCurrent set values are:\n");
X	(void) printf("\t%screate\n", MkProgramFlag ? "   " : " no");
X	(void) printf("\t%sinteractive\n",
X	    (OnATty || Interactive) ? "   " : " no");
X	if (RitchieFlag)
X	    (void) printf("\t   ritchie\n");
X	else
X	    (void) printf("\t(noritchie)\n");
X	if (PreANSIFlag)
X	    (void) printf("\t   preansi\n");
X	else
X	    (void) printf("\t(nopreansi)\n");
X	if (!RitchieFlag && !PreANSIFlag && !CplusplusFlag)
X	    (void) printf("\t   ansi\n");
X	else
X	    (void) printf("\t(noansi)\n");
X	if (CplusplusFlag)
X	    (void) printf("\t   cplusplus\n");
X	else
X	    (void) printf("\t(nocplusplus)\n");
X#ifdef dodebug
X	(void) printf("\t%sdebug\n", DebugFlag ? "   " : " no");
X#endif /* dodebug */
X#ifdef doyydebug
X	(void) printf("\t%syydebug\n", yydebug ? "   " : " no");
X#endif /* doyydebug */
X	}
X}
X
void versions()
X{
X    (void) printf("Version:\n\t%s\n\t%s\n\t%s\n",
X	cdeclsccsid, cdgramsccsid, cdlexsccsid);
X    exit(0);
X}
X
int main(argc, argv)
char **argv;
X{
X    int c, ret = 0;
X
X    setprogname(argv[0]);
X#ifdef DOS
X    if (strcmp(progname, "cppdecl") == 0)
X#else
X    if (strcmp(progname, "c++decl") == 0)
X#endif /* DOS */
X	CplusplusFlag = 1;
X
X    while ((c = getopt(argc, argv, "cirpa+dDV")) != EOF)
X	switch (c)
X	    {
X	    case 'c': MkProgramFlag=1; break;
X	    case 'i': Interactive=1; break;
X
X	    /* The following are mutually exclusive. */
X	    /* Only the last one set prevails. */
X	    case 'r': CplusplusFlag=0; RitchieFlag=1; PreANSIFlag=0; break;
X	    case 'p': CplusplusFlag=0; RitchieFlag=0; PreANSIFlag=1; break;
X	    case 'a': CplusplusFlag=0; RitchieFlag=0; PreANSIFlag=0; break;
X	    case '+': CplusplusFlag=1; RitchieFlag=0; PreANSIFlag=0; break;
X
X#ifdef dodebug
X	    case 'd': DebugFlag=1; break;
X#endif /* dodebug */
X#ifdef doyydebug
X	    case 'D': yydebug=1; break;
X#endif /* doyydebug */
X	    case 'V': versions(); break;
X	    case '?': usage(); break;
X	    }
X
X    /* Run down the list of arguments, parsing each one. */
X
X    /* Use standard input if no file names or "-" is found. */
X    if (optind == argc)
X	ret += dostdin();
X
X    /* If called as explain, declare or cast, or first */
X    /* argument is one of those, use the command line */
X    /* as the input. */
X    else if (namedkeyword(argv[optind]))
X	ret += dotmpfile(argc, argv);
X
X    else
X	ret += dofileargs(argc, argv);
X
X    exit(ret);
X    /* NOTREACHED */
X}
END_OF_FILE
if test 25555 -ne `wc -c <'cdecl.c'`; then
    echo shar: \"'cdecl.c'\" unpacked with wrong size!
fi
# end of 'cdecl.c'
fi
echo shar: End of archive 2 \(of 2\).
cp /dev/null ark2isdone
MISSING=""
for I in 1 2 ; do
    if test ! -f ark${I}isdone ; then
	MISSING="${MISSING} ${I}"
    fi
done
if test "${MISSING}" = "" ; then
    echo You have unpacked both archives.
    rm -f ark[1-9]isdone
else
    echo You still need to unpack the following archives:
    echo "        " ${MISSING}
fi
##  End of shell archive.

#! /bin/sh
# This is a shell archive.  Remove anything before this line, then unpack
# it by saving it into a file and typing "sh file".  To overwrite existing
# files, type "sh file -c".  You can also feed this as standard input via
# unshar, or by typing "sh <file", e.g..  If this archive is complete, you
# will see the following message at the end:
#		"End of archive 1 (of 2)."
# Contents:  MANIFEST cdecl.1 cdgram.y cdlex.l makefile testset
#   testset++
# Wrapped by rsalz@fig.bbn.com on Mon May  9 20:40:46 1988
PATH=/bin:/usr/bin:/usr/ucb ; export PATH
if test -f 'MANIFEST' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'MANIFEST'\"
else
echo shar: Extracting \"'MANIFEST'\" \(362 characters\)
sed "s/^X//" >'MANIFEST' <<'END_OF_FILE'
X   File Name		Archive #	Description
X-----------------------------------------------------------
X MANIFEST                   1	This shipping list
X cdecl.1                    1	
X cdecl.c                    2	
X cdgram.y                   1	
X cdlex.l                    1	
X makefile                   1	
X testset                    1	
X testset++                  1	
END_OF_FILE
if test 362 -ne `wc -c <'MANIFEST'`; then
    echo shar: \"'MANIFEST'\" unpacked with wrong size!
fi
# end of 'MANIFEST'
fi
if test -f 'cdecl.1' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'cdecl.1'\"
else
echo shar: Extracting \"'cdecl.1'\" \(9817 characters\)
sed "s/^X//" >'cdecl.1' <<'END_OF_FILE'
X'\" @(#)cdecl.1	2.4 3/30/88
X.TH CDECL 1
X.SH NAME
cdecl, c++decl \- Compose C and C++ type declarations
X.SH SYNOPSIS
X.B cdecl
X[\-a | \-+ | \-p | \-r]
X[\-cidDV]
X.br
X.RS .5i
X.RI [[ files
X\&...] |
X.B explain
X\&... |
X.B declare
X\&... |
X.B cast
X\&... |
X.B set
X\&... |
X.B help
X\&... |
X.B ?
X\&... ]
X.RE
X.br
X.B c++decl
X[\-a | \-+ | \-p | \-r]
X[\-cidDV]
X.br
X.RS .5i
X.RI [[ files
X\&...] |
X.B explain
X\&... |
X.B declare
X\&... |
X.B cast
X\&... |
X.B set
X\&... |
X.B help
X\&... |
X.B ?
X\&... ]
X.RE
X.br
X.B explain
X\&...
X.br
X.B declare
X\&...
X.br
X.B cast
X\&...
X.SH DESCRIPTION
X.I Cdecl
X(and
X.I c++decl )
is a program for encoding and decoding C (C++) type-declarations.
The C language (the default for 
X.I cdecl ,
or with the
X.B \-a
option) is based on the (draft proposed) X3J11 ANSI
Standard;
optionally, the C language may be based on the pre-ANSI definition defined by
Kernighan & Ritchie's 
X.I "The C Programming Language"
book (the
X.B \-p
option is used), or
the C language defined by the Ritchie PDP-11 C compiler (the
X.B \-r
option is used).
The C++ language (the default for
X.I c++decl ,
or with the
X.B \-+
option) is based on Stroustrup's
X.IR "The C++ Programming Language" ,
plus the version 2.0 additions to the language.
X.PP
X.I Cdecl
reads the named files for statements in the language described below.
A transformation is made from that language to C (C++) or pseudo-English.
The results of this transformation are written on standard output.
If no files are named, or a filename of ``\-'' is encountered, standard input
will be read.
If standard input is coming from a terminal, (or the
X.B \-i
option is used), a prompt will be written to the terminal before each line.
If
X.I cdecl
is invoked as 
X.IR explain ,
X.IR declare
or
X.IR cast ,
or the first argument is one of the commands discussed below, the argument
list will be interpreted according to the grammar shown below instead of as
file names.
X.PP
You can use
X.I cdecl
as you create a C program with an editor like vi(1) or emacs(1).
You simply type in the pseudo-English version of the declaration and apply
X.I cdecl
as a filter to the line.
X(In vi(1), type ``!!cdecl<cr>''.)
X.PP
If the 
X.I "create program"
option
X.B \-c
is used, the output will include semi-colons after variable declarations and
curly brace pairs after function declarations.
X.PP
The
X.B \-V
option will print out the version numbers of the files used to create the
process.
If the source is compiled with debugging information turned on, the
X.B \-d
option will enable it to be output.
If the source is compiled with YACC debugging information turned on, the
X.B \-D
option will enable it to be output.
X.SH "COMMAND LANGUAGE"
There are six statements in the language.
The
X.I "declare"
statement composes a C type-declaration from a verbose description.
The
X.I "cast"
statement composes a C type-cast as might appear in an expression.
The
X.I "explain"
statement decodes a C type-declaration or cast, producing a verbose
description.
The
X.I "help"
X(or
X.IR ? )
statement provides a help message.
The
X.I "quit"
X(or
X.IR "exit" )
statement (or the end of file) exits the program.
The
X.I "set"
statement allows the command line options to be set interactively.
Each statement is separated by a semi-colon or a newline.
X.PP
The following grammar describes the language.
In the grammar, words in "<>" are non-terminals,
bare lower-case words are terminals that stand for themselves.
Bare upper-case words are other lexical tokens:
NOTHING means the empty string;
NAME means a C identifier;
NUMBER means a string of decimal digits; and
NL means the new-line or semi-colon characters.
X.PP
Some synonyms are permitted during a declaration:
character \(-> char,
constant \(-> const,
enumeration \(-> enum,
func \(-> function,
integer \(-> int,
ptr \(-> pointer,
ref \(-> reference,
ret \(-> returning,
structure \(-> struct,
and
vector \(-> array.
X.PP
X.nf
X.ft CW
X.ta .5i 1.5i
X	<program>	::= NOTHING
X		| <program> <stmt> NL
X	<stmt>	::= NOTHING
X		| declare NAME as <adecl>
X		| declare <adecl>
X		| cast NAME into <adecl>
X		| cast <adecl>
X		| explain <optstorage> <ptrmodlist> <type> <cdecl>
X		| explain <storage> <ptrmodlist> <cdecl>
X		| explain ( <ptrmodlist> <type> <cast> ) optional-NAME
X		| set <options>
X		| help | ?
X		| quit
X		| exit
X	<adecl>	::= array of <adecl>
X		| array NUMBER of <adecl>
X		| function returning <adecl>
X		| function ( <adecl-list> ) returning <adecl>
X		| <ptrmodlist> pointer to <adecl>
X		| <ptrmodlist> pointer to member of class NAME <adecl>
X		| <ptrmodlist> reference to <adecl>
X		| <ptrmodlist> <type>
X	<cdecl>	::= <cdecl1>
X		| * <ptrmodlist> <cdecl>
X		| NAME :: * <cdecl>
X		| & <ptrmodlist> <cdecl>
X	<cdecl1>	::= <cdecl1> ( )
X		| <cdecl1> ( <castlist> )
X		| <cdecl1> [ ]
X		| <cdecl1> [ NUMBER ]
X		| ( <cdecl> )
X		| NAME
X	<cast>	::= NOTHING
X		| ( )
X		| ( <cast> ) ( )
X		| ( <cast> ) ( <castlist> )
X		| ( <cast> )
X		| NAME :: * <cast>
X		| * <cast>
X		| & <cast>
X		| <cast> [ ]
X		| <cast> [ NUMBER ]
X	<type>	::= <typename> | <modlist>
X		| <modlist> <typename>
X		| struct NAME | union NAME | enum NAME | class NAME
X	<castlist>	::= <castlist> , <castlist>
X		| <ptrmodlist> <type> <cast>
X		| <name>
X	<adecllist>	::= <adecllist> , <adecllist>
X		| NOTHING
X		| <name>
X		| <adecl>
X		| <name> as <adecl>
X	<typename>	::= int | char | double | float | void
X	<modlist>	::= <modifier> | <modlist> <modifier>
X	<modifier>	::= short | long | unsigned | signed | <ptrmod>
X	<ptrmodlist>	::= <ptrmod> <ptrmodlist> | NOTHING
X	<ptrmod>	::= const | volatile | noalias
X	<storage>	::= auto | extern | register | auto
X	<optstorage>	::= NOTHING | <storage>
X	<options>	::= NOTHING | <options>
X		| create | nocreate
X		| interactive | nointeractive
X		| ritchie | preansi | ansi | cplusplus
X		| debug | nodebug | yydebug | noyydebug
X.ft P
X.fi
X.SH EXAMPLES
X.de Ex
X.    PP
X.    RS .5i
X..
X.de Ee
X.    RE
X.    PP
X..
To declare an array of pointers to functions like malloc(3), do
X.Ex
declare fptab as array of pointer to function returning pointer to char
X.Ee
The result of this command is
X.Ex
char *(*fptab[])()
X.Ee
When you see this declaration in someone else's code, you
can make sense out of it by doing
X.Ex
explain char *(*fptab[])()
X.Ee
The proper declaration for signal(2), ignoring function prototypes, is easily
described in
X.IR cdecl 's
language:
X.Ex
declare signal as function returning pointer to function returning void
X.Ee
which produces
X.Ex
void (*signal())()
X.Ee
The function declaration that results has two sets of empty parentheses.
The author of such a function might wonder where to put the parameters:
X.Ex
declare signal as function (arg1,arg2) returning pointer to function returning
void
X.Ee
provides the following solution (when run with the
X.I \-c
option):
X.Ex
void (*signal(arg1,arg2))()
X{
X}
X.Ee
If we want to add in the function prototypes, the function prototype for a
function such as _exit(2) would be declared with:
X.Ex
declare _exit as function (retvalue as int) returning void
X.Ee
giving
X.Ex
void _exit(int retvalue)
X{
X}
X.Ee
As a more complex example using function prototypes, signal(2) could be fully
defined as:
X.Ex
declare signal as function(x as int, y as pointer to function(int)
returning void) returning pointer to function(int) returning void
X.Ee
giving (with \-c)
X.Ex
void (*signal(int x, void (*y)(int )))(int )
X{
X}
X.Ee
X.I Cdecl
can help figure out the where to put the "const" and "volatile" modifiers
in declarations, thus
X.Ex
declare foo as pointer to const int
X.Ee
gives
X.Ex
const int *foo
X.Ee
while
X.Ex
declare foo as const pointer to int
X.Ee
gives
X.Ex
int * const foo
X.Ee
X.I C++decl
can help with declaring references, thus
X.Ex
declare x as reference to pointer to character
X.Ee
gives
X.Ex
char *&x
X.Ee
X.I C++decl
can help with pointers to member of classes, thus
declaring a pointer to an integer member of a class X with
X.Ex
declare foo as pointer to member of class X int
X.Ee
gives
X.Ex
int X::*foo
X.Ee
and
X.Ex
declare foo as pointer to member of class X function (arg1, arg2) returning
pointer to class Y
X.Ee
gives
X.Ex
class Y *(X::*foo)(arg1, arg2)
X.Ee
X.SH DIAGNOSTICS
The declare, cast and explain statements try to point out constructions that
are not supported in C.
In some cases, a guess is made as to what was really intended.
In these cases, the C result is a toy declaration whose semantics will work
only in Algol-68.
The list of unsupported C constructs is dependent on which version of the C
language is being used (see the ANSI, pre-ANSI, and Ritchie options).
The set of supported C++ constructs is a superset of the ANSI set, with the
exception of the
X.B noalias
keyword.
X.SH "SEE ALSO"
X(draft proposed) ANSI National Standard X3J11
X.sp
X\(sc8.4 of the C Reference Manual within
X.I "The C Programming Language"
by B. Kernighan & D. Ritchie.
X.sp
X\(sc8 of the C++ Reference Manual within
X.I "The C++ Programming Language"
by B. Stroustrup.
X.SH CAVEATS
The pseudo-English syntax is excessively verbose.
X.PP
There is a wealth of semantic checking that isn't being done.
X.PP
X.I Cdecl's
scope is intentionally small.
It doesn't help you figure out initializations.
It expects storage classes to be at the beginning of a declaration,
followed by the the const, volatile and noalias modifiers, followed by the
type of the variable.
X.I Cdecl
doesn't know anything about variable length argument lists.
X(This includes the ``\f(CW,...\fP'' syntax.)
X.PP
X.I Cdecl
thinks all the declarations you utter are going to be used as external
definitions.
Some declaration contexts in C allow more flexibility than this.
An example of this is:
X.Ex
declare argv as array of array of char
X.Ee
where
X.I cdecl
responds with
X.Ex
X.nf
Warning: Unsupported in C -- 'Inner array of unspecified size'
X        (maybe you mean "array of pointer")
char argv[][]
X.fi
X.Ee
X.PP
Tentative support for the
X.I noalias
keyword has been put in because it is in the current ANSI specifications.
END_OF_FILE
if test 9817 -ne `wc -c <'cdecl.1'`; then
    echo shar: \"'cdecl.1'\" unpacked with wrong size!
fi
# end of 'cdecl.1'
fi
if test -f 'cdgram.y' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'cdgram.y'\"
else
echo shar: Extracting \"'cdgram.y'\" \(22746 characters\)
sed "s/^X//" >'cdgram.y' <<'END_OF_FILE'
X%{
X/* Yacc grammar for ANSI and C++ cdecl. */
X/* The output of this file is included */
X/* into the C file cdecl.c. */
char cdgramsccsid[] = "@(#)cdgram.y	2.2 3/30/88";
X%}
X
X%union {
X	char *dynstr;
X	struct {
X		char *left;
X		char *right;
X		char *type;
X	} halves;
X}
X
X%token ARRAY AS CAST COMMA DECLARE DOUBLECOLON EXPLAIN FUNCTION
X%token HELP INTO OF MEMBER POINTER REFERENCE RETURNING SET TO
X%token <dynstr> CHAR CLASS CONSTVOLATILE DOUBLE ENUM FLOAT INT LONG NAME
X%token <dynstr> NUMBER SHORT SIGNED STRUCT UNION UNSIGNED VOID
X%token <dynstr> AUTO EXTERN REGISTER STATIC
X%type <dynstr> adecllist adims c_type cast castlist cdecl cdecl1 cdims
X%type <dynstr> constvol_list ClassStruct mod_list mod_list1 modifier
X%type <dynstr> opt_constvol_list optNAME opt_storage storage StrClaUniEnum
X%type <dynstr> tname type
X%type <halves> adecl
X
X%start prog
X
X%%
prog		: /* empty */
X		| prog stmt
X			{
X			prompt();
X			prev = 0;
X			}
X		;
X
stmt		: HELP NL
X			{
X			Debug((stderr, "stmt: help\n"));
X			dohelp();
X			}
X
X		| DECLARE NAME AS opt_storage adecl NL
X			{
X			Debug((stderr, "stmt: DECLARE NAME AS opt_storage adecl\n"));
X			Debug((stderr, "\tNAME='%s'\n", $2));
X			Debug((stderr, "\topt_storage='%s'\n", $4));
X			Debug((stderr, "\tacdecl.left='%s'\n", $5.left));
X			Debug((stderr, "\tacdecl.right='%s'\n", $5.right));
X			Debug((stderr, "\tacdecl.type='%s'\n", $5.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			dodeclare($2, $4, $5.left, $5.right, $5.type);
X			}
X
X		| DECLARE opt_storage adecl NL
X			{
X			Debug((stderr, "stmt: DECLARE opt_storage adecl\n"));
X			Debug((stderr, "\topt_storage='%s'\n", $2));
X			Debug((stderr, "\tacdecl.left='%s'\n", $3.left));
X			Debug((stderr, "\tacdecl.right='%s'\n", $3.right));
X			Debug((stderr, "\tacdecl.type='%s'\n", $3.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			dodeclare(NullCP, $2, $3.left, $3.right, $3.type);
X			}
X
X		| CAST NAME INTO adecl NL
X			{
X			Debug((stderr, "stmt: CAST NAME AS adecl\n"));
X			Debug((stderr, "\tNAME='%s'\n", $2));
X			Debug((stderr, "\tacdecl.left='%s'\n", $4.left));
X			Debug((stderr, "\tacdecl.right='%s'\n", $4.right));
X			Debug((stderr, "\tacdecl.type='%s'\n", $4.type));
X			docast($2, $4.left, $4.right, $4.type);
X			}
X
X		| CAST adecl NL
X			{
X			Debug((stderr, "stmt: CAST adecl\n"));
X			Debug((stderr, "\tacdecl.left='%s'\n", $2.left));
X			Debug((stderr, "\tacdecl.right='%s'\n", $2.right));
X			Debug((stderr, "\tacdecl.type='%s'\n", $2.type));
X			docast(NullCP, $2.left, $2.right, $2.type);
X			}
X
X		| EXPLAIN opt_storage opt_constvol_list type cdecl NL
X			{
X			Debug((stderr, "stmt: EXPLAIN opt_storage opt_constvol_list type cdecl\n"));
X			Debug((stderr, "\topt_storage='%s'\n", $2));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $3));
X			Debug((stderr, "\ttype='%s'\n", $4));
X			Debug((stderr, "\tcdecl='%s'\n", $5));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			dodexplain($2, $3, $4, $5);
X			}
X
X		| EXPLAIN storage opt_constvol_list cdecl NL
X			{
X			Debug((stderr, "stmt: EXPLAIN storage opt_constvol_list cdecl\n"));
X			Debug((stderr, "\tstorage='%s'\n", $2));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $3));
X			Debug((stderr, "\tcdecl='%s'\n", $4));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			dodexplain($2, $3, NullCP, $4);
X			}
X
X		| EXPLAIN opt_storage constvol_list cdecl NL
X			{
X			Debug((stderr, "stmt: EXPLAIN opt_storage constvol_list cdecl\n"));
X			Debug((stderr, "\topt_storage='%s'\n", $2));
X			Debug((stderr, "\tconstvol_list='%s'\n", $3));
X			Debug((stderr, "\tcdecl='%s'\n", $4));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			dodexplain($2, $3, NullCP, $4);
X			}
X
X		| EXPLAIN '(' opt_constvol_list type cast ')' optNAME NL
X			{
X			Debug((stderr, "stmt: EXPLAIN ( opt_constvol_list type cast ) optNAME\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $3));
X			Debug((stderr, "\ttype='%s'\n", $4));
X			Debug((stderr, "\tcast='%s'\n", $5));
X			Debug((stderr, "\tNAME='%s'\n", $7));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			docexplain($3, $4, $5, $7);
X			}
X
X		| SET optNAME NL
X			{
X			Debug((stderr, "stmt: SET optNAME\n"));
X			Debug((stderr, "\toptNAME='%s'\n", $2));
X			doset($2);
X			}
X
X		| NL
X		| error NL
X			{
X			yyerrok;
X			}
X		;
X
NL		: '\n'
X			{
X			doprompt();
X			}
X		| ';'
X			{
X			noprompt();
X			}
X		;
X
optNAME		: NAME
X			{
X			Debug((stderr, "optNAME: NAME\n"));
X			Debug((stderr, "\tNAME='%s'\n", $1));
X			$$ = $1;
X			}
X
X		| /* empty */
X			{
X			Debug((stderr, "optNAME: EMPTY\n"));
X			$$ = ds(unknown_name);
X			}
X		;
X
cdecl		: cdecl1
X		| '*' opt_constvol_list cdecl
X			{
X			Debug((stderr, "cdecl: * opt_constvol_list cdecl\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $2));
X			Debug((stderr, "\tcdecl='%s'\n", $3));
X			$$ = cat($3,$2,ds(strlen($2)?" pointer to ":"pointer to "),NullCP);
X			prev = 'p';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| NAME DOUBLECOLON '*' cdecl
X			{
X			Debug((stderr, "cdecl: NAME DOUBLECOLON '*' cdecl\n"));
X			Debug((stderr, "\tNAME='%s'\n", $1));
X			Debug((stderr, "\tcdecl='%s'\n", $4));
X			if (!CplusplusFlag)
X				unsupp("pointer to member of class", NullCP);
X			$$ = cat($4,ds("pointer to member of class "),$1,ds(" "),NullCP);
X			prev = 'p';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '&' opt_constvol_list cdecl
X			{
X			Debug((stderr, "cdecl: & opt_constvol_list cdecl\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $2));
X			Debug((stderr, "\tcdecl='%s'\n", $3));
X			if (!CplusplusFlag)
X				unsupp("reference", NullCP);
X			$$ = cat($3,$2,ds(strlen($2)?" reference to ":"reference to "),NullCP);
X			prev = 'r';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X		;
X
cdecl1		: cdecl1 '(' ')'
X			{
X			Debug((stderr, "cdecl1: cdecl1()\n"));
X			Debug((stderr, "\tcdecl1='%s'\n", $1));
X			$$ = cat($1,ds("function returning "),NullCP);
X			prev = 'f';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| cdecl1 '(' castlist ')'
X			{
X			Debug((stderr, "cdecl1: cdecl1(castlist)\n"));
X			Debug((stderr, "\tcdecl1='%s'\n", $1));
X			Debug((stderr, "\tcastlist='%s'\n", $3));
X			$$ = cat($1, ds("function ("),
X				  $3, ds(") returning "), NullCP);
X			prev = 'f';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| cdecl1 cdims
X			{
X			Debug((stderr, "cdecl1: cdecl1 cdims\n"));
X			Debug((stderr, "\tcdecl1='%s'\n", $1));
X			Debug((stderr, "\tcdims='%s'\n", $2));
X			$$ = cat($1,ds("array "),$2,NullCP);
X			prev = 'a';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '(' cdecl ')'
X			{
X			Debug((stderr, "cdecl1: (cdecl)\n"));
X			Debug((stderr, "\tcdecl='%s'\n", $2));
X			$$ = $2;
X			/* prev = prev; */
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| NAME
X			{
X			Debug((stderr, "cdecl1: NAME\n"));
X			Debug((stderr, "\tNAME='%s'\n", $1));
X			savedname = $1;
X			$$ = ds("");
X			prev = 'n';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X		;
X
castlist	: castlist COMMA castlist
X			{
X			Debug((stderr, "castlist: castlist1, castlist2\n"));
X			Debug((stderr, "\tcastlist1='%s'\n", $1));
X			Debug((stderr, "\tcastlist2='%s'\n", $3));
X			$$ = cat($1, ds(", "), $3, NullCP);
X			}
X
X		| opt_constvol_list type cast
X			{
X			Debug((stderr, "castlist: opt_constvol_list type cast\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $1));
X			Debug((stderr, "\ttype='%s'\n", $2));
X			Debug((stderr, "\tcast='%s'\n", $3));
X			$$ = cat($3, $1, ds(strlen($1) ? " " : ""), $2, NullCP);
X			}
X
X		| NAME
X			{
X			$$ = $1;
X			}
X		;
X
adecllist	: /* empty */
X			{
X			Debug((stderr, "adecllist: EMPTY\n"));
X			$$ = ds("");
X			}
X
X		| adecllist COMMA adecllist
X			{
X			Debug((stderr, "adecllist: adecllist1, adecllist2\n"));
X			Debug((stderr, "\tadecllist1='%s'\n", $1));
X			Debug((stderr, "\tadecllist2='%s'\n", $3));
X			$$ = cat($1, ds(", "), $3, NullCP);
X			}
X
X		| NAME
X			{
X			Debug((stderr, "adecllist: NAME\n"));
X			Debug((stderr, "\tNAME='%s'\n", $1));
X			$$ = $1;
X			}
X
X		| adecl
X			{
X			Debug((stderr, "adecllist: adecl\n"));
X			Debug((stderr, "\tadecl.left='%s'\n", $1.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $1.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $1.type));
X			$$ = cat($1.type, ds(" "), $1.left, $1.right, NullCP);
X			}
X
X		| NAME AS adecl
X			{
X			Debug((stderr, "adecllist: NAME AS adecl\n"));
X			Debug((stderr, "\tNAME='%s'\n", $1));
X			Debug((stderr, "\tadecl.left='%s'\n", $3.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $3.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $3.type));
X			$$ = cat($3.type, ds(" "), $3.left, $1, $3.right, NullCP);
X			}
X		;
X
cast		: /* empty */
X			{
X			Debug((stderr, "cast: EMPTY\n"));
X			$$ = ds("");
X			/* prev = prev; */
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '(' ')'
X			{
X			Debug((stderr, "cast: ()\n"));
X			$$ = ds("function returning ");
X			prev = 'f';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '(' cast ')' '(' ')'
X			{
X			Debug((stderr, "cast: (cast)()\n"));
X			Debug((stderr, "\tcast='%s'\n", $2));
X			$$ = cat($2,ds("function returning "),NullCP);
X			prev = 'f';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '(' cast ')' '(' castlist ')'
X			{
X			Debug((stderr, "cast: (cast)(castlist)\n"));
X			Debug((stderr, "\tcast='%s'\n", $2));
X			Debug((stderr, "\tcastlist='%s'\n", $5));
X			$$ = cat($2,ds("function ("),$5,ds(") returning "),NullCP);
X			prev = 'f';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '(' cast ')'
X			{
X			Debug((stderr, "cast: (cast)\n"));
X			Debug((stderr, "\tcast='%s'\n", $2));
X			$$ = $2;
X			/* prev = prev; */
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| NAME DOUBLECOLON '*' cast
X			{
X			Debug((stderr, "cast: NAME::*cast\n"));
X			Debug((stderr, "\tcast='%s'\n", $4));
X			if (!CplusplusFlag)
X				unsupp("pointer to member of class", NullCP);
X			$$ = cat($4,ds("pointer to member of class "),$1,ds(" "),NullCP);
X			prev = 'p';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '*' cast
X			{
X			Debug((stderr, "cast: *cast\n"));
X			Debug((stderr, "\tcast='%s'\n", $2));
X			$$ = cat($2,ds("pointer to "),NullCP);
X			prev = 'p';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| '&' cast
X			{
X			Debug((stderr, "cast: &cast\n"));
X			Debug((stderr, "\tcast='%s'\n", $2));
X			if (!CplusplusFlag)
X				unsupp("reference", NullCP);
X			$$ = cat($2,ds("reference to "),NullCP);
X			prev = 'r';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| cast cdims
X			{
X			Debug((stderr, "cast: cast cdims\n"));
X			Debug((stderr, "\tcast='%s'\n", $1));
X			Debug((stderr, "\tcdims='%s'\n", $2));
X			$$ = cat($1,ds("array "),$2,NullCP);
X			prev = 'a';
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X		;
X
cdims		: '[' ']'
X			{
X			Debug((stderr, "cdims: []\n"));
X			$$ = ds("of ");
X			}
X
X		| '[' NUMBER ']'
X			{
X			Debug((stderr, "cdims: [NUMBER]\n"));
X			Debug((stderr, "\tNUMBER='%s'\n", $2));
X			$$ = cat($2,ds(" of "),NullCP);
X			}
X		;
X
adecl		: FUNCTION RETURNING adecl
X			{
X			Debug((stderr, "adecl: FUNCTION RETURNING adecl\n"));
X			Debug((stderr, "\tadecl.left='%s'\n", $3.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $3.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $3.type));
X			if (prev == 'f')
X				unsupp("Function returning function",
X				       "function returning pointer to function");
X			else if (prev=='A' || prev=='a')
X				unsupp("Function returning array",
X				       "function returning pointer");
X			$$.left = $3.left;
X			$$.right = cat(ds("()"),$3.right,NullCP);
X			$$.type = $3.type;
X			prev = 'f';
X			Debug((stderr, "\n\tadecl now =\n"));
X			Debug((stderr, "\t\tadecl.left='%s'\n", $$.left));
X			Debug((stderr, "\t\tadecl.right='%s'\n", $$.right));
X			Debug((stderr, "\t\tadecl.type='%s'\n", $$.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| FUNCTION '(' adecllist ')' RETURNING adecl
X			{
X			Debug((stderr, "adecl: FUNCTION (adecllist) RETURNING adecl\n"));
X			Debug((stderr, "\tadecllist='%s'\n", $3));
X			Debug((stderr, "\tadecl.left='%s'\n", $6.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $6.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $6.type));
X			if (prev == 'f')
X				unsupp("Function returning function",
X				       "function returning pointer to function");
X			else if (prev=='A' || prev=='a')
X				unsupp("Function returning array",
X				       "function returning pointer");
X			$$.left = $6.left;
X			$$.right = cat(ds("("),$3,ds(")"),$6.right,NullCP);
X			$$.type = $6.type;
X			prev = 'f';
X			Debug((stderr, "\n\tadecl now =\n"));
X			Debug((stderr, "\t\tadecl.left='%s'\n", $$.left));
X			Debug((stderr, "\t\tadecl.right='%s'\n", $$.right));
X			Debug((stderr, "\t\tadecl.type='%s'\n", $$.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| ARRAY adims OF adecl
X			{
X			Debug((stderr, "adecl: ARRAY adims OF adecl\n"));
X			Debug((stderr, "\tadims='%s'\n", $2));
X			Debug((stderr, "\tadecl.left='%s'\n", $4.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $4.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $4.type));
X			if (prev == 'f')
X				unsupp("Array of function",
X				       "array of pointer to function");
X			else if (prev == 'a')
X				unsupp("Inner array of unspecified size",
X				       "array of pointer");
X			else if (prev == 'v')
X				unsupp("Array of void",
X				       "pointer to void");
X			if (arbdims)
X				prev = 'a';
X			else
X				prev = 'A';
X			$$.left = $4.left;
X			$$.right = cat($2,$4.right,NullCP);
X			$$.type = $4.type;
X			Debug((stderr, "\n\tadecl now =\n"));
X			Debug((stderr, "\t\tadecl.left='%s'\n", $$.left));
X			Debug((stderr, "\t\tadecl.right='%s'\n", $$.right));
X			Debug((stderr, "\t\tadecl.type='%s'\n", $$.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| opt_constvol_list POINTER TO adecl
X			{
X			char *op = "", *cp = "", *sp = "";
X
X			Debug((stderr, "adecl: opt_constvol_list POINTER TO adecl\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $1));
X			Debug((stderr, "\tadecl.left='%s'\n", $4.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $4.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $4.type));
X			if (prev == 'a')
X				unsupp("Pointer to array of unspecified dimension",
X				       "pointer to object");
X			if (prev=='a' || prev=='A' || prev=='f') {
X				op = "(";
X				cp = ")";
X			}
X			if (strlen($1) != 0)
X				sp = " ";
X			$$.left = cat($4.left,ds(op),ds("*"),
X				       ds(sp),$1,ds(sp),NullCP);
X			$$.right = cat(ds(cp),$4.right,NullCP);
X			$$.type = $4.type;
X			prev = 'p';
X			Debug((stderr, "\n\tadecl now =\n"));
X			Debug((stderr, "\t\tadecl.left='%s'\n", $$.left));
X			Debug((stderr, "\t\tadecl.right='%s'\n", $$.right));
X			Debug((stderr, "\t\tadecl.type='%s'\n", $$.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| opt_constvol_list POINTER TO MEMBER OF ClassStruct NAME adecl
X			{
X			char *op = "", *cp = "", *sp = "";
X
X			Debug((stderr, "adecl: opt_constvol_list POINTER TO MEMBER OF ClassStruct NAME adecl\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $1));
X			Debug((stderr, "\tClassStruct='%s'\n", $6));
X			Debug((stderr, "\tNAME='%s'\n", $7));
X			Debug((stderr, "\tadecl.left='%s'\n", $8.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $8.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $8.type));
X			if (!CplusplusFlag)
X				unsupp("pointer to member of class", NullCP);
X			if (prev == 'a')
X				unsupp("Pointer to array of unspecified dimension",
X				       "pointer to object");
X			if (prev=='a' || prev=='A' || prev=='f') {
X				op = "(";
X				cp = ")";
X			}
X			if (strlen($1) != 0)
X				sp = " ";
X			$$.left = cat($8.left,ds(op),$7,ds("::*"),
X				      ds(sp),$1,ds(sp),NullCP);
X			$$.right = cat(ds(cp),$8.right,NullCP);
X			$$.type = $8.type;
X			prev = 'p';
X			Debug((stderr, "\n\tadecl now =\n"));
X			Debug((stderr, "\t\tadecl.left='%s'\n", $$.left));
X			Debug((stderr, "\t\tadecl.right='%s'\n", $$.right));
X			Debug((stderr, "\t\tadecl.type='%s'\n", $$.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| opt_constvol_list REFERENCE TO adecl
X			{
X			char *op = "", *cp = "", *sp = "";
X
X			Debug((stderr, "adecl: opt_constvol_list REFERENCE TO adecl\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $1));
X			Debug((stderr, "\tadecl.left='%s'\n", $4.left));
X			Debug((stderr, "\tadecl.right='%s'\n", $4.right));
X			Debug((stderr, "\tadecl.type='%s'\n", $4.type));
X			if (!CplusplusFlag)
X				unsupp("reference", NullCP);
X			if (prev == 'v')
X				unsupp("Reference to void",
X				       "pointer to void");
X			else if (prev == 'a')
X				unsupp("Reference to array of unspecified dimension",
X				       "reference to object");
X			if (prev=='a' || prev=='A' || prev=='f') {
X				op = "(";
X				cp = ")";
X			}
X			if (strlen($1) != 0)
X				sp = " ";
X			$$.left = cat($4.left,ds(op),ds("&"),
X				       ds(sp),$1,ds(sp),NullCP);
X			$$.right = cat(ds(cp),$4.right,NullCP);
X			$$.type = $4.type;
X			prev = 'r';
X			Debug((stderr, "\n\tadecl now =\n"));
X			Debug((stderr, "\t\tadecl.left='%s'\n", $$.left));
X			Debug((stderr, "\t\tadecl.right='%s'\n", $$.right));
X			Debug((stderr, "\t\tadecl.type='%s'\n", $$.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X
X		| opt_constvol_list type
X			{
X			Debug((stderr, "adecl: opt_constvol_list type\n"));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $1));
X			Debug((stderr, "\ttype='%s'\n", $2));
X			$$.left = ds("");
X			$$.right = ds("");
X			$$.type = cat($1,ds(strlen($1)?" ":""),$2,NullCP);
X			if (strcmp($2, "void") == 0)
X			    prev = 'v';
X			else if ((strncmp($2, "struct", 6) == 0) ||
X			         (strncmp($2, "class", 5) == 0))
X			    prev = 's';
X			else
X			    prev = 't';
X			Debug((stderr, "\n\tadecl now =\n"));
X			Debug((stderr, "\t\tadecl.left='%s'\n", $$.left));
X			Debug((stderr, "\t\tadecl.right='%s'\n", $$.right));
X			Debug((stderr, "\t\tadecl.type='%s'\n", $$.type));
X			Debug((stderr, "\tprev = '%s'\n", visible(prev)));
X			}
X		;
X
adims		: /* empty */
X			{
X			Debug((stderr, "adims: EMPTY\n"));
X			arbdims = 1;
X			$$ = ds("[]");
X			}
X
X		| NUMBER
X			{
X			Debug((stderr, "adims: NUMBER\n"));
X			Debug((stderr, "\tNUMBER='%s'\n", $1));
X			arbdims = 0;
X			$$ = cat(ds("["),$1,ds("]"),NullCP);
X			}
X		;
X
type		: tinit c_type
X			{
X			Debug((stderr, "type: tinit c_type\n"));
X			Debug((stderr, "\ttinit=''\n"));
X			Debug((stderr, "\tc_type='%s'\n", $2));
X			mbcheck();
X			$$ = $2;
X			}
X		;
X
tinit		: /* empty */
X			{
X			Debug((stderr, "tinit: EMPTY\n"));
X			modbits = 0;
X			}
X		;
X
c_type		: mod_list
X			{
X			Debug((stderr, "c_type: mod_list\n"));
X			Debug((stderr, "\tmod_list='%s'\n", $1));
X			$$ = $1;
X			}
X
X		| tname
X			{
X			Debug((stderr, "c_type: tname\n"));
X			Debug((stderr, "\ttname='%s'\n", $1));
X			$$ = $1;
X			}
X
X		| mod_list tname
X			{
X			Debug((stderr, "c_type: mod_list tname\n"));
X			Debug((stderr, "\tmod_list='%s'\n", $1));
X			Debug((stderr, "\ttname='%s'\n", $2));
X			$$ = cat($1,ds(" "),$2,NullCP);
X			}
X
X		| StrClaUniEnum NAME
X			{
X			Debug((stderr, "c_type: StrClaUniEnum NAME\n"));
X			Debug((stderr, "\tStrClaUniEnum='%s'\n", $1));
X			Debug((stderr, "\tNAME='%s'\n", $2));
X			$$ = cat($1,ds(" "),$2,NullCP);
X			}
X		;
X
StrClaUniEnum	: ClassStruct
X		| ENUM
X		| UNION
X			{
X			$$ = $1;
X			}
X		;
X
ClassStruct	: STRUCT
X		| CLASS
X			{
X			$$ = $1;
X			}
X		;
X
tname		: INT
X			{
X			Debug((stderr, "tname: INT\n"));
X			Debug((stderr, "\tINT='%s'\n", $1));
X			modbits |= MB_INT; $$ = $1;
X			}
X
X		| CHAR
X			{
X			Debug((stderr, "tname: CHAR\n"));
X			Debug((stderr, "\tCHAR='%s'\n", $1));
X			modbits |= MB_CHAR; $$ = $1;
X			}
X
X		| FLOAT
X			{
X			Debug((stderr, "tname: FLOAT\n"));
X			Debug((stderr, "\tFLOAT='%s'\n", $1));
X			modbits |= MB_FLOAT; $$ = $1;
X			}
X
X		| DOUBLE
X			{
X			Debug((stderr, "tname: DOUBLE\n"));
X			Debug((stderr, "\tDOUBLE='%s'\n", $1));
X			modbits |= MB_DOUBLE; $$ = $1;
X			}
X
X		| VOID
X			{
X			Debug((stderr, "tname: VOID\n"));
X			Debug((stderr, "\tVOID='%s'\n", $1));
X			modbits |= MB_VOID; $$ = $1;
X			}
X		;
X
mod_list	: modifier mod_list1
X			{
X			Debug((stderr, "mod_list: modifier mod_list1\n"));
X			Debug((stderr, "\tmodifier='%s'\n", $1));
X			Debug((stderr, "\tmod_list1='%s'\n", $2));
X			$$ = cat($1,ds(" "),$2,NullCP);
X			}
X
X		| modifier
X			{
X			Debug((stderr, "mod_list: modifier\n"));
X			Debug((stderr, "\tmodifier='%s'\n", $1));
X			$$ = $1;
X			}
X		;
X
mod_list1	: mod_list
X			{
X			Debug((stderr, "mod_list1: mod_list\n"));
X			Debug((stderr, "\tmod_list='%s'\n", $1));
X			$$ = $1;
X			}
X
X		| CONSTVOLATILE
X			{
X			Debug((stderr, "mod_list1: CONSTVOLATILE\n"));
X			Debug((stderr, "\tCONSTVOLATILE='%s'\n", $1));
X			if (PreANSIFlag)
X				notsupported(" (Pre-ANSI Compiler)", $1, NullCP);
X			else if (RitchieFlag)
X				notsupported(" (Ritchie Compiler)", $1, NullCP);
X			else if ((strcmp($1, "noalias") == 0) && CplusplusFlag)
X				unsupp($1, NullCP);
X			$$ = $1;
X			}
X		;
X
modifier	: UNSIGNED
X			{
X			Debug((stderr, "modifier: UNSIGNED\n"));
X			Debug((stderr, "\tUNSIGNED='%s'\n", $1));
X			modbits |= MB_UNSIGNED; $$ = $1;
X			}
X
X		| SIGNED
X			{
X			Debug((stderr, "modifier: SIGNED\n"));
X			Debug((stderr, "\tSIGNED='%s'\n", $1));
X			modbits |= MB_SIGNED; $$ = $1;
X			}
X
X		| LONG
X			{
X			Debug((stderr, "modifier: LONG\n"));
X			Debug((stderr, "\tLONG='%s'\n", $1));
X			modbits |= MB_LONG; $$ = $1;
X			}
X
X		| SHORT
X			{
X			Debug((stderr, "modifier: SHORT\n"));
X			Debug((stderr, "\tSHORT='%s'\n", $1));
X			modbits |= MB_SHORT; $$ = $1;
X			}
X		;
X
opt_constvol_list: CONSTVOLATILE opt_constvol_list
X			{
X			Debug((stderr, "opt_constvol_list: CONSTVOLATILE opt_constvol_list\n"));
X			Debug((stderr, "\tCONSTVOLATILE='%s'\n", $1));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $2));
X			if (PreANSIFlag)
X				notsupported(" (Pre-ANSI Compiler)", $1, NullCP);
X			else if (RitchieFlag)
X				notsupported(" (Ritchie Compiler)", $1, NullCP);
X			else if ((strcmp($1, "noalias") == 0) && CplusplusFlag)
X				unsupp($1, NullCP);
X			$$ = cat($1,ds(strlen($2) ? " " : ""),$2,NullCP);
X			}
X
X		| /* empty */
X			{
X			Debug((stderr, "opt_constvol_list: EMPTY\n"));
X			$$ = ds("");
X			}
X		;
X
constvol_list: CONSTVOLATILE opt_constvol_list
X			{
X			Debug((stderr, "constvol_list: CONSTVOLATILE opt_constvol_list\n"));
X			Debug((stderr, "\tCONSTVOLATILE='%s'\n", $1));
X			Debug((stderr, "\topt_constvol_list='%s'\n", $2));
X			if (PreANSIFlag)
X				notsupported(" (Pre-ANSI Compiler)", $1, NullCP);
X			else if (RitchieFlag)
X				notsupported(" (Ritchie Compiler)", $1, NullCP);
X			else if ((strcmp($1, "noalias") == 0) && CplusplusFlag)
X				unsupp($1, NullCP);
X			$$ = cat($1,ds(strlen($2) ? " " : ""),$2,NullCP);
X			}
X		;
X
storage		: AUTO
X		| EXTERN
X		| REGISTER
X		| STATIC
X			{
X			Debug((stderr, "storage: AUTO,EXTERN,STATIC,REGISTER (%s)\n", $1));
X			$$ = $1;
X			}
X		;
X
opt_storage	: storage
X			{
X			Debug((stderr, "opt_storage: storage=%s\n", $1));
X			$$ = $1;
X			}
X
X		| /* empty */
X			{
X			Debug((stderr, "opt_storage: EMPTY\n"));
X			$$ = ds("");
X			}
X		;
X%%
END_OF_FILE
if test 22746 -ne `wc -c <'cdgram.y'`; then
    echo shar: \"'cdgram.y'\" unpacked with wrong size!
fi
# end of 'cdgram.y'
fi
if test -f 'cdlex.l' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'cdlex.l'\"
else
echo shar: Extracting \"'cdlex.l'\" \(2380 characters\)
sed "s/^X//" >'cdlex.l' <<'END_OF_FILE'
X%{
X/* Lexical analyzer description for ANSI and C++ cdecl. */
X/* The output of this file is included */
X/* into the C file cdecl.c. */
char cdlexsccsid[] = "@(#)cdlex.l	2.2 3/30/88";
X%}
X
N	[0-9]
A	[A-Z_a-z]
AN	[0-9A-Z_a-z]
X
X%%
array		return ARRAY;
as		return AS;
cast		return CAST;
declare		return DECLARE;
exit		return 0;
explain		return EXPLAIN;
function	return FUNCTION;
func		return FUNCTION;
help		return HELP;
into		return INTO;
member		return MEMBER;
of		return OF;
pointer		return POINTER;
ptr		return POINTER;
quit		return 0;
reference	return REFERENCE;
ref		return REFERENCE;
returning	return RETURNING;
ret		return RETURNING;
set		return SET;
to		return TO;
vector		return ARRAY;
X::		return DOUBLECOLON;
X[?]		return HELP;
X[,]		return COMMA;
X
auto		{ yylval.dynstr = ds(yytext);	return AUTO; }
character	{ yylval.dynstr = ds("char");	return CHAR; }
char		{ yylval.dynstr = ds(yytext);	return CHAR; }
class		{ yylval.dynstr = ds(yytext);	return CLASS; }
constant	{ yylval.dynstr = ds("const");	return CONSTVOLATILE; }
const		{ yylval.dynstr = ds(yytext);	return CONSTVOLATILE; }
double		{ yylval.dynstr = ds(yytext);	return DOUBLE; }
enumeration	{ yylval.dynstr = ds("enum");	return ENUM; }
enum		{ yylval.dynstr = ds(yytext);	return ENUM; }
extern		{ yylval.dynstr = ds(yytext);	return EXTERN; }
float		{ yylval.dynstr = ds(yytext);	return FLOAT; }
integer		{ yylval.dynstr = ds("int");	return INT; }
int		{ yylval.dynstr = ds(yytext);	return INT; }
long		{ yylval.dynstr = ds(yytext);	return LONG; }
noalias		{ yylval.dynstr = ds(yytext);	return CONSTVOLATILE; }
register	{ yylval.dynstr = ds(yytext);	return REGISTER; }
short		{ yylval.dynstr = ds(yytext);	return SHORT; }
signed		{ yylval.dynstr = ds(yytext);	return SIGNED; }
static		{ yylval.dynstr = ds(yytext);	return STATIC; }
structure	{ yylval.dynstr = ds("struct");	return STRUCT; }
struct		{ yylval.dynstr = ds(yytext);	return STRUCT; }
union		{ yylval.dynstr = ds(yytext);	return UNION; }
unsigned	{ yylval.dynstr = ds(yytext);	return UNSIGNED; }
void		{ yylval.dynstr = ds(yytext);	return VOID; }
volatile	{ yylval.dynstr = ds(yytext);	return CONSTVOLATILE; }
X
X{A}{AN}*	{ yylval.dynstr = ds(yytext);	return NAME; }
X{N}+		{ yylval.dynstr = ds(yytext);	return NUMBER; }
X
X[#].*		;
X[\t ]		;
X[&*[\]();\n]	return *yytext;
X.		{
X			(void) printf("bad character '%s'\n",visible(*yytext));
X			return *yytext;
X		}
X%%
END_OF_FILE
if test 2380 -ne `wc -c <'cdlex.l'`; then
    echo shar: \"'cdlex.l'\" unpacked with wrong size!
fi
# end of 'cdlex.l'
fi
if test -f 'makefile' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'makefile'\"
else
echo shar: Extracting \"'makefile'\" \(1340 characters\)
sed "s/^X//" >'makefile' <<'END_OF_FILE'
X# @(#)makefile	2.2 1/20/88
X# the following can be added to CFLAGS for various things
X#
X# add -DNOVOID		If your compiler can not handle the void keyword.
X# add -DBSD		For BSD4.[23] UNIX Systems.
X# add -DDOS		For MS-DOS/PC-DOS Systems, Micro-Soft C 4.0, Turbo C
X#				Use the ANSI option.
X# add -DNOGETOPT	If your library doesn't have getopt().
X#				Another routine will be used in its place.
X# add -DNOVARARGS	If you have neither <stdarg.h> (ANSI C) or
X#				<varargs.h> (pre-ANSI C).
X#				Another method will be compiled instead.
X# add -Ddodebug		To compile in debugging trace statements.
X# add -Ddoyydebug	To compile in yacc trace statements.
X
CFLAGS= -g -Ddodebug -Ddoyydebug
CC= cc
ALLFILES= makefile cdgram.y cdlex.l cdecl.c cdecl.1 testset testset++
BIN= /usr/lubin
X
cdecl: c++decl test
X
c++decl: cdgram.c cdlex.c cdecl.c
X	$(CC) $(CFLAGS) -o cdecl cdecl.c
X	-ln cdecl c++decl
X
cdlex.c: cdlex.l
X	lex cdlex.l && mv lex.yy.c cdlex.c
X
cdgram.c: cdgram.y
X	yacc cdgram.y && mv y.tab.c cdgram.c
X
test:
X	./cdecl < testset
X	./c++decl < testset++
X
install: c++decl
X	mv cdecl $(BIN)/cdecl
X	ln $(BIN)/cdecl $(BIN)/c++decl
X
clean:
X	rm -f cdgram.c cdlex.c cdecl y.output c++decl
X
clobber: clean
X	rm -f $(BIN)/cdecl $(BIN)/c++decl
X
cdecl.cpio: $(ALLFILES)
X	ls $(ALLFILES) | cpio -ocv > cdecl.cpio
X
cdecl.shar: $(ALLFILES)
X	shar $(ALLFILES) > cdecl.shar
END_OF_FILE
if test 1340 -ne `wc -c <'makefile'`; then
    echo shar: \"'makefile'\" unpacked with wrong size!
fi
# end of 'makefile'
fi
if test -f 'testset' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'testset'\"
else
echo shar: Extracting \"'testset'\" \(1038 characters\)
sed "s/^X//" >'testset' <<'END_OF_FILE'
help
set options
X# test some declarations
declare x as ptr to character
declare x as func(w as ptr to char, y as int) ret ptr to int
declare x as func(ptr to char) ret ptr to int
declare x as func(int) ret ptr to int
declare x as func(ptr to char, int) ret ptr to int
declare x as function (args) returning pointer to int
X# test some explain functions
explain char *x
explain int *x()
explain int *x(args)
explain int *x(char *)
explain int *x(char *, int )
explain int *x(char *, int, float)
explain int *x(int )
X# test some casts
cast x into ptr to char
cast x into ptr to func ret int
cast x into ptr to func() ret int
cast x into ptr to func(args) ret int
cast x into ptr to func(x as ptr to char, y as int) ret int
cast x into ptr to func(ptr to char) ret int
cast x into ptr to func(ptr to char, int) ret int
cast x into ptr to func(ptr to char, int, float) ret int
X# test explaining some casts
explain (char *)x
explain (int (*)())x
explain (int (*)(char *))x
explain (int (*)(char *, int))x
explain (int (*)(char *, int, float))x
END_OF_FILE
if test 1038 -ne `wc -c <'testset'`; then
    echo shar: \"'testset'\" unpacked with wrong size!
fi
# end of 'testset'
fi
if test -f 'testset++' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'testset++'\"
else
echo shar: Extracting \"'testset++'\" \(1337 characters\)
sed "s/^X//" >'testset++' <<'END_OF_FILE'
help
set options
X# test some declarations
declare x as ptr to character
declare x as reference to character
declare foo as pointer to member of class X int
declare foo as pointer to member of class X function (arg1, arg2) returning pointer to class Y
declare x as func(w as ptr to char, y as int) ret ptr to int
declare x as func(ptr to char) ret ptr to int
declare x as func(int) ret ptr to int
declare x as func(ptr to char, int) ret ptr to int
declare x as function (args) returning pointer to int
X# test some explain functions
explain char *x
explain int X::*foo
explain class Y *(X::*foo)(arg1, arg2)
explain int *x()
explain int *x(args)
explain int *x(char *)
explain int *x(char *, int )
explain int *x(char *, int, float)
explain int *x(int )
X# test some casts
cast x into ptr to char
cast x into ptr to member of class X int
cast x into ptr to func ret int
cast x into ptr to func() ret int
cast x into ptr to func(args) ret int
cast x into ptr to func(x as ptr to char, y as int) ret int
cast x into ptr to func(ptr to char) ret int
cast x into ptr to func(ptr to char, int) ret int
cast x into ptr to func(ptr to char, int, float) ret int
X# test explaining some casts
explain (char *)x
explain (int X::*)x
explain (int (*)())x
explain (int (*)(char *))x
explain (int (*)(char *, int))x
explain (int (*)(char *, int, float))x
END_OF_FILE
if test 1337 -ne `wc -c <'testset++'`; then
    echo shar: \"'testset++'\" unpacked with wrong size!
fi
# end of 'testset++'
fi
echo shar: End of archive 1 \(of 2\).
cp /dev/null ark1isdone
MISSING=""
for I in 1 2 ; do
    if test ! -f ark${I}isdone ; then
	MISSING="${MISSING} ${I}"
    fi
done
if test "${MISSING}" = "" ; then
    echo You have unpacked both archives.
    rm -f ark[1-9]isdone
else
    echo You still need to unpack the following archives:
    echo "        " ${MISSING}
fi
##  End of shell archive.
exit 0

