.TH pbm 5 "18 February 1988"
.SH NAME
pbm - portable bitmap file format
.SH DESCRIPTION
The portable bitmap format is a lowest common denominator.
It was originally designed to make it reasonable to mail bitmaps
between different types of machines using the typical stupid network
mailers we have today.
Now it serves as the common language of a large family of bitmap
conversion filters.
The definition is as follows:
.IP - 2
A width, formatted as ASCII characters in decimal.
.IP - 2
Whitespace (blanks, TABs, CRs, LFs).
.IP - 2
A height, again in ASCII decimal.
.IP - 2
Whitespace.
.IP - 2
Width * height bits, each either '1' or '0', starting at the top-left
corner of the bitmap, proceding in normal English reading order.
.IP - 2
The character '1' means black, '0' means white.
.IP - 2
Whitespace in the bits section is ignored.
.IP - 2
Characters from a "#" to the next end-of-line are ignored (comments).
.IP - 2
No line may be longer than 70 characters.
.PP
Here is an example of a small bitmap in this format:
.PP
.nf
# feep.pbm
24 7
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0
0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0
0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0
0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0
0 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
.fi
.PP
Programs that read this format should be as lenient as possible,
accepting anything that looks remotely like a bitmap.
For instance, the above example does not actually conform to the
standard, since it has whitespace before the width; neverthless,
it should be accepted.
.SH "SEE ALSO"
cbmtopbm(1), icontopbm(1), macptopbm(1), rasttopbm(1), xbmtopbm(1), xwdtopbm(1),
pbmtoicon(1), pbmtocbm(1), pbmtops(1), pbmtoptx(1), pbmtorast(1),
pbmtoxbm(1), pbmtox10bm(1), pbmtoascii(1), pbminvert(1), pbmfliplr(1),
pbmfliptb(1), pbmcatlr(1), pbmcattb(1), pbmcrop(1), pbmtrnspos(1), pbmcut(1),
pbmpaste(1), pbmenlarge(1)
.SH AUTHOR
Copyright (C) 1988 by Jef Poskanzer.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.
