/* pbmtoxbm.c - read a portable bitmap and produce an X11 bitmap file
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, rucols, padright, row, col;
    char name[100], *cp;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [pbmfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	strcpy( name, argv[1] );

#ifdef	OS_SYSV
	if ( ( cp = strchr( name, '.' ) ) != 0 )
#else	OS_SYSV
	if ( ( cp = index( name, '.' ) ) != 0 )
#endif	OS_SYSV
	    *cp = '\0';
	}
    else
	{
	ifd = stdin;
	strcpy( name, "noname" );
	}

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    /* Round cols up to the nearest multiple of 8. */
    rucols = ( cols + 7 ) / 8;
    rucols = rucols * 8;
    padright = rucols - cols;

    printf( "#define %s_width %d\n", name, cols );
    printf( "#define %s_height %d\n", name, rows );
    printf( "static char %s_bits[] = {\n", name );

    putinit( );
    for ( row = 0; row < rows; row++ )
	{
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
	for ( col = 0; col < padright; col++ )
	    putbit( 0 );
        }
    putrest( );

    exit( 0 );
    }


int item, bitsperitem, bitshift, itemsperline, firstitem;

putinit( )
    {
    itemsperline = 0;
    bitsperitem = 0;
    item = 0;
    bitshift = 0;
    firstitem = 1;
    }

putbit( b )
bit b;
    {
    if ( bitsperitem == 8 )
	putitem( );
    bitsperitem++;
    if ( b )
	item += 1 << bitshift;
    bitshift++;
    }

putrest( )
    {
    if ( bitsperitem > 0 )
	putitem( );
    printf( "};\n" );
    }

putitem( )
    {
    if ( firstitem )
	firstitem = 0;
    else
	printf( "," );
    if ( itemsperline == 15 )
	{
	putchar( '\n' );
	itemsperline = 0;
	}
    if ( itemsperline == 0 )
	printf( " " );
    itemsperline++;
    printf( "0x%02x", item );
    bitsperitem = 0;
    item = 0;
    bitshift = 0;
    }
