/* pbmtoicon.c - read a portable bitmap and produce a Sun icon file
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, rucols, padleft, padright, row, col;
    char ch;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [pbmfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    /* Round cols up to the nearest multiple of 16. */
    rucols = ( cols + 15 ) / 16;
    rucols = rucols * 16;
    padleft = ( rucols - cols ) / 2;
    padright = rucols - cols - padleft;

    printf( "/* Format_version=1, Width=%d, Height=%d", rucols, rows );
    printf( ", Depth=1, Valid_bits_per_item=16\n */\n" );

    putinit( );
    for ( row = 0; row < rows; row++ )
	{
	for ( col = 0; col < padleft; col++ )
	    putbit( 0 );
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
	for ( col = 0; col < padright; col++ )
	    putbit( 0 );
        }
    putrest( );

    exit( 0 );
    }


int item, bitsperitem, bitshift, itemsperline, firstitem;

putinit( )
    {
    itemsperline = 0;
    bitsperitem = 0;
    item = 0;
    bitshift = 15;
    firstitem = 1;
    }

putbit( b )
bit b;
    {
    if ( bitsperitem == 16 )
	putitem( );
    bitsperitem++;
    if ( b )
	item += 1 << bitshift;
    bitshift--;
    }

putrest( )
    {
    if ( bitsperitem > 0 )
	putitem( );
    putchar( '\n' );
    }

putitem( )
    {
    if ( firstitem )
	firstitem = 0;
    else
	putchar( ',' );
    if ( itemsperline == 8 )
	{
	putchar( '\n' );
	itemsperline = 0;
	}
    if ( itemsperline == 0 )
	putchar( '\t' );
    itemsperline++;
    printf( "0x%04x", item );
    bitsperitem = 0;
    item = 0;
    bitshift = 15;
    }
